/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.exceptions.TooManyIconsException;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

@Deprecated
public final class IconFactory {
    private static final String ICON_ID_PREFIX = "com.mapbox.icons.icon_";
    private static IconFactory instance;
    private Context context;
    private Icon defaultMarker;
    private int nextId = 0;
    private BitmapFactory.Options options;

    private IconFactory(Context context) {
        this.context = context;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 17) {
            context = new DisplayMetrics();
            windowManager.getDefaultDisplay().getRealMetrics((DisplayMetrics)context);
        } else {
            context = null;
        }
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        windowManager = new BitmapFactory.Options();
        this.options = windowManager;
        windowManager.inScaled = true;
        this.options.inDensity = 160;
        this.options.inTargetDensity = displayMetrics.densityDpi;
        if (context != null) {
            this.options.inScreenDensity = context.densityDpi;
        }
    }

    private Icon fromInputStream(InputStream inputStream) {
        return this.fromBitmap(BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)this.options));
    }

    public static IconFactory getInstance(Context object) {
        synchronized (IconFactory.class) {
            if (instance == null) {
                IconFactory iconFactory;
                instance = iconFactory = new IconFactory(object.getApplicationContext());
            }
            object = instance;
            return object;
        }
    }

    public static Icon recreate(String string2, Bitmap bitmap) {
        return new Icon(string2, bitmap);
    }

    public Icon defaultMarker() {
        if (this.defaultMarker == null) {
            this.defaultMarker = this.fromResource(R.drawable.mapbox_marker_icon_default);
        }
        return this.defaultMarker;
    }

    public Icon fromAsset(String object) {
        try {
            object = this.context.getAssets().open((String)object);
            return this.fromInputStream((InputStream)object);
        }
        catch (IOException iOException) {
            MapStrictMode.strictModeViolation(iOException);
            return null;
        }
    }

    public Icon fromBitmap(Bitmap bitmap) {
        if (this.nextId >= 0) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ICON_ID_PREFIX);
            this.nextId = n = this.nextId + 1;
            stringBuilder.append(n);
            return new Icon(stringBuilder.toString(), bitmap);
        }
        throw new TooManyIconsException();
    }

    public Icon fromFile(String object) {
        try {
            object = this.context.openFileInput((String)object);
            return this.fromInputStream((InputStream)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            MapStrictMode.strictModeViolation(fileNotFoundException);
            return null;
        }
    }

    public Icon fromPath(String string2) {
        return this.fromBitmap(BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)this.options));
    }

    public Icon fromResource(int n) {
        Drawable drawable2 = BitmapUtils.getDrawableFromRes(this.context, n);
        if (drawable2 instanceof BitmapDrawable) {
            return this.fromBitmap(((BitmapDrawable)drawable2).getBitmap());
        }
        throw new IllegalArgumentException("Failed to decode image. The resource provided must be a Bitmap.");
    }
}

