/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.attribution;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.widget.TextView;
import com.mapbox.mapboxsdk.attribution.AttributionLayout;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class AttributionMeasure {
    private Bitmap logo;
    private Bitmap logoSmall;
    private float margin;
    private boolean shorterText;
    private Bitmap snapshot;
    private TextView textView;
    private TextView textViewShort;

    AttributionMeasure(Bitmap bitmap, Bitmap bitmap2, Bitmap bitmap3, TextView textView, TextView textView2, float f) {
        this.snapshot = bitmap;
        this.logo = bitmap2;
        this.logoSmall = bitmap3;
        this.textView = textView;
        this.textViewShort = textView2;
        this.margin = f;
    }

    private static PointF calculateAnchor(Bitmap bitmap, TextView textView, float f) {
        return new PointF((float)(bitmap.getWidth() - textView.getMeasuredWidth()) - f, (float)bitmap.getHeight() - f - (float)textView.getMeasuredHeight());
    }

    private float getLogoContainerWidth() {
        return (float)this.logo.getWidth() + this.margin * 2.0f;
    }

    private float getLogoSmallContainerWidth() {
        return (float)this.logoSmall.getWidth() + this.margin * 2.0f;
    }

    private float getMaxSize() {
        return this.snapshot.getWidth() * 8 / 10;
    }

    private float getMaxSizeShort() {
        return this.snapshot.getWidth();
    }

    private float getTextViewContainerWidth() {
        return (float)this.textView.getMeasuredWidth() + this.margin;
    }

    private float getTextViewShortContainerWidth() {
        return (float)this.textViewShort.getMeasuredWidth() + this.margin;
    }

    public TextView getTextView() {
        TextView textView = this.shorterText ? this.textViewShort : this.textView;
        return textView;
    }

    public AttributionLayout measure() {
        AttributionLayout attributionLayout = new Chain(new FullLogoLongTextCommand(), new FullLogoShortTextCommand(), new SmallLogoLongTextCommand(), new SmallLogoShortTextCommand(), new LongTextCommand(), new ShortTextCommand(), new NoTextCommand()).start(this);
        this.shorterText = attributionLayout.isShortText();
        return attributionLayout;
    }

    public static class Builder {
        private Bitmap logo;
        private Bitmap logoSmall;
        private float marginPadding;
        private Bitmap snapshot;
        private TextView textView;
        private TextView textViewShort;

        public AttributionMeasure build() {
            return new AttributionMeasure(this.snapshot, this.logo, this.logoSmall, this.textView, this.textViewShort, this.marginPadding);
        }

        public Builder setLogo(Bitmap bitmap) {
            this.logo = bitmap;
            return this;
        }

        public Builder setLogoSmall(Bitmap bitmap) {
            this.logoSmall = bitmap;
            return this;
        }

        public Builder setMarginPadding(float f) {
            this.marginPadding = f;
            return this;
        }

        public Builder setSnapshot(Bitmap bitmap) {
            this.snapshot = bitmap;
            return this;
        }

        public Builder setTextView(TextView textView) {
            this.textView = textView;
            return this;
        }

        public Builder setTextViewShort(TextView textView) {
            this.textViewShort = textView;
            return this;
        }
    }

    private class Chain {
        public List<Command> commands;

        Chain(Command ... commandArray) {
            this.commands = Arrays.asList(commandArray);
        }

        public AttributionLayout start(AttributionMeasure attributionMeasure) {
            Iterator<Command> iterator2 = this.commands.iterator();
            AttributionLayout attributionLayout = null;
            while (iterator2.hasNext()) {
                AttributionLayout attributionLayout2;
                attributionLayout = attributionLayout2 = iterator2.next().execute(attributionMeasure);
                if (attributionLayout2 == null) continue;
                attributionLayout = attributionLayout2;
                break;
            }
            return attributionLayout;
        }
    }

    public static interface Command {
        public AttributionLayout execute(AttributionMeasure var1);
    }

    private static class FullLogoLongTextCommand
    implements Command {
        private FullLogoLongTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure attributionMeasure) {
            boolean bl = attributionMeasure.getLogoContainerWidth() + attributionMeasure.getTextViewContainerWidth() <= attributionMeasure.getMaxSize();
            if (bl) {
                PointF pointF = AttributionMeasure.calculateAnchor(attributionMeasure.snapshot, attributionMeasure.textView, attributionMeasure.margin);
                return new AttributionLayout(attributionMeasure.logo, pointF, false);
            }
            return null;
        }
    }

    private static class FullLogoShortTextCommand
    implements Command {
        private FullLogoShortTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure attributionMeasure) {
            boolean bl = attributionMeasure.getLogoContainerWidth() + attributionMeasure.getTextViewShortContainerWidth() <= attributionMeasure.getMaxSizeShort();
            if (bl) {
                PointF pointF = AttributionMeasure.calculateAnchor(attributionMeasure.snapshot, attributionMeasure.textViewShort, attributionMeasure.margin);
                return new AttributionLayout(attributionMeasure.logo, pointF, true);
            }
            return null;
        }
    }

    private static class LongTextCommand
    implements Command {
        private LongTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure attributionMeasure) {
            boolean bl = attributionMeasure.getTextViewContainerWidth() + attributionMeasure.margin <= attributionMeasure.getMaxSize();
            if (bl) {
                return new AttributionLayout(null, AttributionMeasure.calculateAnchor(attributionMeasure.snapshot, attributionMeasure.textView, attributionMeasure.margin), false);
            }
            return null;
        }
    }

    private static class NoTextCommand
    implements Command {
        private NoTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure attributionMeasure) {
            return new AttributionLayout(null, null, false);
        }
    }

    private static class ShortTextCommand
    implements Command {
        private ShortTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure attributionMeasure) {
            boolean bl = attributionMeasure.getTextViewShortContainerWidth() + attributionMeasure.margin <= attributionMeasure.getMaxSizeShort();
            if (bl) {
                return new AttributionLayout(null, AttributionMeasure.calculateAnchor(attributionMeasure.snapshot, attributionMeasure.textViewShort, attributionMeasure.margin), true);
            }
            return null;
        }
    }

    private static class SmallLogoLongTextCommand
    implements Command {
        private SmallLogoLongTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure attributionMeasure) {
            boolean bl = attributionMeasure.getLogoSmallContainerWidth() + attributionMeasure.getTextViewContainerWidth() <= attributionMeasure.getMaxSize();
            if (bl) {
                PointF pointF = AttributionMeasure.calculateAnchor(attributionMeasure.snapshot, attributionMeasure.textView, attributionMeasure.margin);
                return new AttributionLayout(attributionMeasure.logoSmall, pointF, false);
            }
            return null;
        }
    }

    private static class SmallLogoShortTextCommand
    implements Command {
        private SmallLogoShortTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure attributionMeasure) {
            boolean bl = attributionMeasure.getLogoContainerWidth() + attributionMeasure.getTextViewShortContainerWidth() <= attributionMeasure.getMaxSizeShort();
            if (bl) {
                PointF pointF = AttributionMeasure.calculateAnchor(attributionMeasure.snapshot, attributionMeasure.textViewShort, attributionMeasure.margin);
                return new AttributionLayout(attributionMeasure.logoSmall, pointF, true);
            }
            return null;
        }
    }
}

