/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.attribution;

import android.content.Context;
import android.os.Build;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.URLSpan;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.attribution.Attribution;
import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import java.util.Set;

public class AttributionParser {
    private static final String IMPROVE_THIS_MAP = "Improve this map";
    private final String attributionData;
    private final Set<Attribution> attributions = new LinkedHashSet<Attribution>();
    private final WeakReference<Context> context;
    private final boolean withCopyrightSign;
    private final boolean withImproveMap;
    private final boolean withMapboxAttribution;
    private final boolean withTelemetryAttribution;

    AttributionParser(WeakReference<Context> weakReference, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.context = weakReference;
        this.attributionData = string2;
        this.withImproveMap = bl;
        this.withCopyrightSign = bl2;
        this.withTelemetryAttribution = bl3;
        this.withMapboxAttribution = bl4;
    }

    private void addAdditionalAttributions() {
        if (this.withTelemetryAttribution) {
            Object object = (Context)this.context.get();
            Set<Attribution> set = this.attributions;
            object = object != null ? object.getString(R.string.mapbox_telemetrySettings) : "Telemetry Settings";
            set.add(new Attribution((String)object, "https://www.mapbox.com/telemetry/"));
        }
    }

    private static Spanned fromHtml(String string2) {
        string2 = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)string2, (int)0) : Html.fromHtml((String)string2);
        return string2;
    }

    private boolean isImproveThisMapAnchor(String string2) {
        return string2.equals(IMPROVE_THIS_MAP);
    }

    private boolean isUrlValid(String string2) {
        boolean bl = this.isValidForImproveThisMap(string2) && this.isValidForMapbox(string2);
        return bl;
    }

    private boolean isValidForImproveThisMap(String string2) {
        boolean bl = this.withImproveMap || !Attribution.IMPROVE_MAP_URLS.contains(string2);
        return bl;
    }

    private boolean isValidForMapbox(String string2) {
        boolean bl = this.withMapboxAttribution || !string2.equals("https://www.mapbox.com/about/maps/");
        return bl;
    }

    private String parseAnchorValue(SpannableStringBuilder spannableStringBuilder, URLSpan object) {
        int n = spannableStringBuilder.getSpanStart(object);
        int n2 = spannableStringBuilder.getSpanEnd(object);
        object = new char[n2 - n];
        spannableStringBuilder.getChars(n, n2, (char[])object, 0);
        return this.stripCopyright(String.valueOf((char[])object));
    }

    private void parseAttributions() {
        SpannableStringBuilder spannableStringBuilder = (SpannableStringBuilder)AttributionParser.fromHtml(this.attributionData);
        int n = spannableStringBuilder.length();
        URLSpan[] uRLSpanArray = (URLSpan[])spannableStringBuilder.getSpans(0, n, URLSpan.class);
        n = uRLSpanArray.length;
        for (int i = 0; i < n; ++i) {
            this.parseUrlSpan(spannableStringBuilder, uRLSpanArray[i]);
        }
    }

    private void parseUrlSpan(SpannableStringBuilder object, URLSpan object2) {
        String string2 = object2.getURL();
        if (this.isUrlValid(string2)) {
            object2 = this.parseAnchorValue((SpannableStringBuilder)object, (URLSpan)object2);
            object = object2;
            if (this.isImproveThisMapAnchor((String)object2)) {
                object = this.translateImproveThisMapAnchor((String)object2);
            }
            this.attributions.add(new Attribution((String)object, string2));
        }
    }

    private String stripCopyright(String string2) {
        String string3 = string2;
        if (!this.withCopyrightSign) {
            string3 = string2;
            if (string2.startsWith("\u00a9 ")) {
                string3 = string2.substring(2, string2.length());
            }
        }
        return string3;
    }

    private String translateImproveThisMapAnchor(String string2) {
        Context context = (Context)this.context.get();
        if (context != null) {
            string2 = context.getString(R.string.mapbox_telemetryImproveMap);
        }
        return string2;
    }

    public String createAttributionString() {
        return this.createAttributionString(false);
    }

    /*
     * WARNING - void declaration
     */
    public String createAttributionString(boolean bl) {
        void var2_4;
        if (this.withCopyrightSign) {
            String object2 = "";
        } else {
            String string2 = "\u00a9 ";
        }
        StringBuilder stringBuilder = new StringBuilder((String)var2_4);
        int n = 0;
        for (Attribution attribution : this.attributions) {
            void var2_9;
            int n2 = n + 1;
            if (!bl) {
                String string3 = attribution.getTitle();
            } else {
                String string4 = attribution.getTitleAbbreviated();
            }
            stringBuilder.append((String)var2_9);
            n = n2;
            if (n2 == this.attributions.size()) continue;
            stringBuilder.append(" / ");
            n = n2;
        }
        return stringBuilder.toString();
    }

    public Set<Attribution> getAttributions() {
        return this.attributions;
    }

    protected void parse() {
        this.parseAttributions();
        this.addAdditionalAttributions();
    }

    public static class Options {
        private String[] attributionDataStringArray;
        private final WeakReference<Context> context;
        private boolean withCopyrightSign = true;
        private boolean withImproveMap = true;
        private boolean withMapboxAttribution = true;
        private boolean withTelemetryAttribution = false;

        public Options(Context context) {
            this.context = new WeakReference<Context>(context);
        }

        private String parseAttribution(String[] stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                if (string2.isEmpty()) continue;
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }

        public AttributionParser build() {
            Object object = this.attributionDataStringArray;
            if (object != null) {
                object = this.parseAttribution((String[])object);
                object = new AttributionParser(this.context, (String)object, this.withImproveMap, this.withCopyrightSign, this.withTelemetryAttribution, this.withMapboxAttribution);
                ((AttributionParser)object).parse();
                return object;
            }
            throw new IllegalStateException("Using builder without providing attribution data");
        }

        public Options withAttributionData(String ... stringArray) {
            this.attributionDataStringArray = stringArray;
            return this;
        }

        public Options withCopyrightSign(boolean bl) {
            this.withCopyrightSign = bl;
            return this;
        }

        public Options withImproveMap(boolean bl) {
            this.withImproveMap = bl;
            return this;
        }

        public Options withMapboxAttribution(boolean bl) {
            this.withMapboxAttribution = bl;
            return this;
        }

        public Options withTelemetryAttribution(boolean bl) {
            this.withTelemetryAttribution = bl;
            return this;
        }
    }
}

