/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.camera;

import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.utils.MathUtils;
import java.util.Arrays;

public final class CameraPosition
implements Parcelable {
    public static final Parcelable.Creator<CameraPosition> CREATOR;
    public static final CameraPosition DEFAULT;
    public final double bearing;
    public final double[] padding;
    public final LatLng target;
    public final double tilt;
    public final double zoom;

    static {
        DEFAULT = new CameraPosition(new LatLng(), 0.0, 0.0, 0.0, new double[]{0.0, 0.0, 0.0, 0.0});
        CREATOR = new Parcelable.Creator<CameraPosition>(){

            public CameraPosition createFromParcel(Parcel parcel) {
                double[] dArray;
                double d = parcel.readDouble();
                LatLng latLng = (LatLng)parcel.readParcelable(LatLng.class.getClassLoader());
                double d2 = parcel.readDouble();
                double d3 = parcel.readDouble();
                int n = parcel.readInt();
                if (n > 0) {
                    double[] dArray2 = new double[n];
                    int n2 = 0;
                    while (true) {
                        dArray = dArray2;
                        if (n2 < n) {
                            dArray2[n2] = parcel.readDouble();
                            ++n2;
                            continue;
                        }
                        break;
                    }
                } else {
                    dArray = null;
                }
                return new CameraPosition(latLng, d3, d2, d, dArray);
            }

            public CameraPosition[] newArray(int n) {
                return new CameraPosition[n];
            }
        };
    }

    @Deprecated
    CameraPosition(LatLng latLng, double d, double d2, double d3) {
        this(latLng, d, d2, d3, null);
    }

    CameraPosition(LatLng latLng, double d, double d2, double d3, double[] dArray) {
        this.target = latLng;
        this.bearing = d3;
        this.tilt = d2;
        this.zoom = d;
        this.padding = dArray;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            CameraPosition cameraPosition = (CameraPosition)object;
            object = this.target;
            if (object != null && !((LatLng)object).equals(cameraPosition.target)) {
                return false;
            }
            if (this.zoom != cameraPosition.zoom) {
                return false;
            }
            if (this.tilt != cameraPosition.tilt) {
                return false;
            }
            if (this.bearing != cameraPosition.bearing) {
                return false;
            }
            return Arrays.equals(this.padding, cameraPosition.padding);
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.bearing);
        int n = (int)(l ^ l >>> 32);
        LatLng latLng = this.target;
        int n2 = latLng != null ? latLng.hashCode() : 0;
        l = Double.doubleToLongBits(this.tilt);
        int n3 = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zoom);
        return (((n * 31 + n2) * 31 + n3) * 31 + (int)(l ^ l >>> 32)) * 31 + Arrays.hashCode(this.padding);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Target: ");
        stringBuilder.append(this.target);
        stringBuilder.append(", Zoom:");
        stringBuilder.append(this.zoom);
        stringBuilder.append(", Bearing:");
        stringBuilder.append(this.bearing);
        stringBuilder.append(", Tilt:");
        stringBuilder.append(this.tilt);
        stringBuilder.append(", Padding:");
        stringBuilder.append(Arrays.toString(this.padding));
        return stringBuilder.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeDouble(this.bearing);
        parcel.writeParcelable((Parcelable)this.target, n);
        parcel.writeDouble(this.tilt);
        parcel.writeDouble(this.zoom);
        double[] dArray = this.padding;
        if (dArray != null) {
            parcel.writeInt(dArray.length);
            dArray = this.padding;
            int n2 = dArray.length;
            for (n = 0; n < n2; ++n) {
                parcel.writeDouble(dArray[n]);
            }
        } else {
            parcel.writeInt(-1);
        }
    }

    public static final class Builder {
        private double bearing = -1.0;
        private double[] padding = null;
        private LatLng target = null;
        private double tilt = -1.0;
        private double zoom = -1.0;

        public Builder() {
        }

        public Builder(TypedArray typedArray) {
            if (typedArray != null) {
                this.bearing = typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraBearing, 0.0f);
                this.target = new LatLng(typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraTargetLat, 0.0f), typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraTargetLng, 0.0f));
                this.tilt = typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraTilt, 0.0f);
                this.zoom = typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraZoom, 0.0f);
            }
        }

        public Builder(CameraPosition cameraPosition) {
            if (cameraPosition != null) {
                this.bearing = cameraPosition.bearing;
                this.target = cameraPosition.target;
                this.tilt = cameraPosition.tilt;
                this.zoom = cameraPosition.zoom;
                this.padding = cameraPosition.padding;
            }
        }

        public Builder(CameraUpdateFactory.CameraPositionUpdate cameraPositionUpdate) {
            if (cameraPositionUpdate != null) {
                this.bearing = cameraPositionUpdate.getBearing();
                this.target = cameraPositionUpdate.getTarget();
                this.tilt = cameraPositionUpdate.getTilt();
                this.zoom = cameraPositionUpdate.getZoom();
                this.padding = cameraPositionUpdate.getPadding();
            }
        }

        public Builder(CameraUpdateFactory.ZoomUpdate zoomUpdate) {
            if (zoomUpdate != null) {
                this.zoom = zoomUpdate.getZoom();
            }
        }

        public Builder bearing(double d) {
            double d2;
            while (true) {
                if (!(d >= 360.0)) break;
                d -= 360.0;
            }
            for (d2 = d; d2 < 0.0; d2 += 360.0) {
            }
            this.bearing = d2;
            return this;
        }

        public CameraPosition build() {
            return new CameraPosition(this.target, this.zoom, this.tilt, this.bearing, this.padding);
        }

        public Builder padding(double d, double d2, double d3, double d4) {
            this.padding = new double[]{d, d2, d3, d4};
            return this;
        }

        public Builder padding(double[] dArray) {
            this.padding = dArray;
            return this;
        }

        public Builder target(LatLng latLng) {
            this.target = latLng;
            return this;
        }

        public Builder tilt(double d) {
            this.tilt = MathUtils.clamp(d, 0.0, 60.0);
            return this;
        }

        public Builder zoom(double d) {
            this.zoom = d;
            return this;
        }
    }
}

