/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.exceptions.InvalidLatLngBoundsException;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngSpan;
import java.util.ArrayList;
import java.util.List;

public class LatLngBounds
implements Parcelable {
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new Parcelable.Creator<LatLngBounds>(){

        public LatLngBounds createFromParcel(Parcel parcel) {
            return LatLngBounds.readFromParcel(parcel);
        }

        public LatLngBounds[] newArray(int n) {
            return new LatLngBounds[n];
        }
    };
    private final double latitudeNorth;
    private final double latitudeSouth;
    private final double longitudeEast;
    private final double longitudeWest;

    LatLngBounds(double d, double d2, double d3, double d4) {
        this.latitudeNorth = d;
        this.longitudeEast = d2;
        this.latitudeSouth = d3;
        this.longitudeWest = d4;
    }

    private static void checkParams(double d, double d2, double d3, double d4) {
        if (!Double.isNaN(d) && !Double.isNaN(d3)) {
            if (!Double.isNaN(d2) && !Double.isNaN(d4)) {
                if (!Double.isInfinite(d2) && !Double.isInfinite(d4)) {
                    if (!(d > 90.0 || d < -90.0 || d3 > 90.0 || d3 < -90.0)) {
                        if (!(d < d3)) {
                            if (!(d2 < d4)) {
                                return;
                            }
                            throw new IllegalArgumentException("lonEast cannot be less than lonWest");
                        }
                        throw new IllegalArgumentException("latNorth cannot be less than latSouth");
                    }
                    throw new IllegalArgumentException("latitude must be between -90 and 90");
                }
                throw new IllegalArgumentException("longitude must not be infinite");
            }
            throw new IllegalArgumentException("longitude must not be NaN");
        }
        throw new IllegalArgumentException("latitude must not be NaN");
    }

    private boolean containsLatitude(double d) {
        boolean bl = d <= this.latitudeNorth && d >= this.latitudeSouth;
        return bl;
    }

    private boolean containsLongitude(double d) {
        boolean bl = d <= this.longitudeEast && d >= this.longitudeWest;
        return bl;
    }

    public static LatLngBounds from(double d, double d2, double d3, double d4) {
        LatLngBounds.checkParams(d, d2, d3, d4);
        return new LatLngBounds(d, d2, d3, d4);
    }

    public static LatLngBounds from(int n, int n2, int n3) {
        return new LatLngBounds(LatLngBounds.lat_(n, n3), LatLngBounds.lon_(n, n2 + 1), LatLngBounds.lat_(n, n3 + 1), LatLngBounds.lon_(n, n2));
    }

    static LatLngBounds fromLatLngs(List<? extends LatLng> object) {
        object = object.iterator();
        double d = Double.MAX_VALUE;
        double d2 = 90.0;
        double d3 = -90.0;
        double d4 = -1.7976931348623157E308;
        while (object.hasNext()) {
            LatLng latLng = (LatLng)object.next();
            double d5 = latLng.getLatitude();
            double d6 = latLng.getLongitude();
            d2 = Math.min(d2, d5);
            d = Math.min(d, d6);
            d3 = Math.max(d3, d5);
            d4 = Math.max(d4, d6);
        }
        return new LatLngBounds(d3, d4, d2, d);
    }

    private LatLngBounds intersectNoParamCheck(double d, double d2, double d3, double d4) {
        d4 = Math.max(this.longitudeWest, d4);
        if ((d2 = Math.min(this.longitudeEast, d2)) >= d4) {
            d3 = Math.max(this.latitudeSouth, d3);
            if ((d = Math.min(this.latitudeNorth, d)) >= d3) {
                return new LatLngBounds(d, d2, d3, d4);
            }
        }
        return null;
    }

    private static double lat_(int n, int n2) {
        double d = Math.PI - (double)n2 * (Math.PI * 2) / Math.pow(2.0, n);
        return Math.toDegrees(Math.atan((Math.exp(d) - Math.exp(-d)) * 0.5));
    }

    private static double lon_(int n, int n2) {
        return (double)n2 / Math.pow(2.0, n) * 360.0 - 180.0;
    }

    private static LatLngBounds readFromParcel(Parcel parcel) {
        return new LatLngBounds(parcel.readDouble(), parcel.readDouble(), parcel.readDouble(), parcel.readDouble());
    }

    private LatLngBounds unionNoParamCheck(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = this.latitudeNorth;
        if (!(d6 < d)) {
            d = d6;
        }
        d6 = d5 = this.longitudeEast;
        if (d5 < d2) {
            d6 = d2;
        }
        d2 = d5 = this.latitudeSouth;
        if (d5 > d3) {
            d2 = d3;
        }
        d3 = d5 = this.longitudeWest;
        if (d5 > d4) {
            d3 = d4;
        }
        return new LatLngBounds(d, d6, d2, d3);
    }

    public static LatLngBounds world() {
        return LatLngBounds.from(90.0, 180.0, -90.0, -180.0);
    }

    public boolean contains(LatLng latLng) {
        boolean bl = this.containsLatitude(latLng.getLatitude()) && this.containsLongitude(latLng.getLongitude());
        return bl;
    }

    public boolean contains(LatLngBounds latLngBounds) {
        boolean bl = this.contains(latLngBounds.getNorthEast()) && this.contains(latLngBounds.getSouthWest());
        return bl;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object instanceof LatLngBounds) {
            if (this.latitudeNorth != ((LatLngBounds)(object = (LatLngBounds)object)).getLatNorth() || this.latitudeSouth != ((LatLngBounds)object).getLatSouth() || this.longitudeEast != ((LatLngBounds)object).getLonEast() || this.longitudeWest != ((LatLngBounds)object).getLonWest()) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public LatLng getCenter() {
        return new LatLng((this.latitudeNorth + this.latitudeSouth) / 2.0, (this.longitudeEast + this.longitudeWest) / 2.0);
    }

    public double getLatNorth() {
        return this.latitudeNorth;
    }

    public double getLatSouth() {
        return this.latitudeSouth;
    }

    public double getLatitudeSpan() {
        return Math.abs(this.latitudeNorth - this.latitudeSouth);
    }

    public double getLonEast() {
        return this.longitudeEast;
    }

    public double getLonWest() {
        return this.longitudeWest;
    }

    public double getLongitudeSpan() {
        return Math.abs(this.longitudeEast - this.longitudeWest);
    }

    public LatLng getNorthEast() {
        return new LatLng(this.latitudeNorth, this.longitudeEast);
    }

    public LatLng getNorthWest() {
        return new LatLng(this.latitudeNorth, this.longitudeWest);
    }

    public LatLng getSouthEast() {
        return new LatLng(this.latitudeSouth, this.longitudeEast);
    }

    public LatLng getSouthWest() {
        return new LatLng(this.latitudeSouth, this.longitudeWest);
    }

    public LatLngSpan getSpan() {
        return new LatLngSpan(this.getLatitudeSpan(), this.getLongitudeSpan());
    }

    public int hashCode() {
        return (int)(this.latitudeNorth + 90.0 + (this.latitudeSouth + 90.0) * 1000.0 + (this.longitudeEast + 180.0) * 1000000.0 + (this.longitudeWest + 180.0) * 1.0E9);
    }

    public LatLngBounds include(LatLng latLng) {
        return new Builder().include(this.getNorthEast()).include(this.getSouthWest()).include(latLng).build();
    }

    public LatLngBounds intersect(double d, double d2, double d3, double d4) {
        LatLngBounds.checkParams(d, d2, d3, d4);
        return this.intersectNoParamCheck(d, d2, d3, d4);
    }

    public LatLngBounds intersect(LatLngBounds latLngBounds) {
        return this.intersectNoParamCheck(latLngBounds.getLatNorth(), latLngBounds.getLonEast(), latLngBounds.getLatSouth(), latLngBounds.getLonWest());
    }

    public boolean isEmptySpan() {
        boolean bl = this.getLongitudeSpan() == 0.0 || this.getLatitudeSpan() == 0.0;
        return bl;
    }

    public LatLng[] toLatLngs() {
        return new LatLng[]{this.getNorthEast(), this.getSouthWest()};
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("N:");
        stringBuilder.append(this.latitudeNorth);
        stringBuilder.append("; E:");
        stringBuilder.append(this.longitudeEast);
        stringBuilder.append("; S:");
        stringBuilder.append(this.latitudeSouth);
        stringBuilder.append("; W:");
        stringBuilder.append(this.longitudeWest);
        return stringBuilder.toString();
    }

    public LatLngBounds union(double d, double d2, double d3, double d4) {
        LatLngBounds.checkParams(d, d2, d3, d4);
        return this.unionNoParamCheck(d, d2, d3, d4);
    }

    public LatLngBounds union(LatLngBounds latLngBounds) {
        return this.unionNoParamCheck(latLngBounds.getLatNorth(), latLngBounds.getLonEast(), latLngBounds.getLatSouth(), latLngBounds.getLonWest());
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeDouble(this.latitudeNorth);
        parcel.writeDouble(this.longitudeEast);
        parcel.writeDouble(this.latitudeSouth);
        parcel.writeDouble(this.longitudeWest);
    }

    public static final class Builder {
        private final List<LatLng> latLngList = new ArrayList<LatLng>();

        public LatLngBounds build() {
            if (this.latLngList.size() >= 2) {
                return LatLngBounds.fromLatLngs(this.latLngList);
            }
            throw new InvalidLatLngBoundsException(this.latLngList.size());
        }

        public Builder include(LatLng latLng) {
            this.latLngList.add(latLng);
            return this;
        }

        public Builder includes(List<LatLng> list) {
            this.latLngList.addAll(list);
            return this;
        }
    }
}

