/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.os.Parcel;
import android.os.Parcelable;

public class ProjectedMeters
implements Parcelable {
    public static final Parcelable.Creator<ProjectedMeters> CREATOR = new Parcelable.Creator<ProjectedMeters>(){

        public ProjectedMeters createFromParcel(Parcel parcel) {
            return new ProjectedMeters(parcel);
        }

        public ProjectedMeters[] newArray(int n) {
            return new ProjectedMeters[n];
        }
    };
    private double easting;
    private double northing;

    public ProjectedMeters(double d, double d2) {
        this.northing = d;
        this.easting = d2;
    }

    private ProjectedMeters(Parcel parcel) {
        this.northing = parcel.readDouble();
        this.easting = parcel.readDouble();
    }

    public ProjectedMeters(ProjectedMeters projectedMeters) {
        this.northing = projectedMeters.northing;
        this.easting = projectedMeters.easting;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (ProjectedMeters)object;
            if (Double.compare(((ProjectedMeters)object).easting, this.easting) != 0 || Double.compare(((ProjectedMeters)object).northing, this.northing) != 0) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.easting);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.northing);
        return n * 31 + (int)(l ^ l >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ProjectedMeters [northing=");
        stringBuilder.append(this.northing);
        stringBuilder.append(", easting=");
        stringBuilder.append(this.easting);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeDouble(this.northing);
        parcel.writeDouble(this.easting);
    }
}

