/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.graphics.Bitmap;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LayerSourceProvider;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.LocationComponentPositionManager;
import com.mapbox.mapboxsdk.location.LocationLayerRenderer;
import com.mapbox.mapboxsdk.location.LocationPropertyFactory;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import com.mapbox.mapboxsdk.utils.ColorUtils;

class IndicatorLocationLayerRenderer
implements LocationLayerRenderer {
    private float lastAccuracy = 0.0f;
    private double lastBearing = 0.0;
    private LatLng lastLatLng;
    private Layer layer;
    private final LayerSourceProvider layerSourceProvider;
    private Style style;

    IndicatorLocationLayerRenderer(LayerSourceProvider layerSourceProvider) {
        this.layerSourceProvider = layerSourceProvider;
    }

    private void setImages(int n, boolean bl) {
        String string2;
        String string3;
        String string4;
        block6: {
            String string5;
            block7: {
                block3: {
                    block4: {
                        block5: {
                            string5 = "mapbox-location-shadow-icon";
                            string4 = "mapbox-location-stale-icon";
                            string3 = "";
                            if (n == 4) break block3;
                            if (n == 8) break block4;
                            if (n == 18) break block5;
                            string4 = string2 = "";
                            break block6;
                        }
                        if (!bl) {
                            string4 = "mapbox-location-icon";
                        }
                        string2 = bl ? "mapbox-location-background-stale-icon" : "mapbox-location-stroke-icon";
                        break block7;
                    }
                    if (!bl) {
                        string4 = "mapbox-location-icon";
                    }
                    string2 = bl ? "mapbox-location-background-stale-icon" : "mapbox-location-stroke-icon";
                    this.setAccuracyRadius(Float.valueOf(0.0f));
                    break block6;
                }
                if (!bl) {
                    string4 = "mapbox-location-icon";
                }
                string2 = bl ? "mapbox-location-bearing-stale-icon" : "mapbox-location-bearing-icon";
            }
            string3 = string4;
            string4 = string2;
            string2 = string5;
        }
        this.layer.setProperties(LocationPropertyFactory.topImage(string3), LocationPropertyFactory.bearingImage(string4), LocationPropertyFactory.shadowImage(string2));
    }

    private void setLayerBearing(double d) {
        this.layer.setProperties(LocationPropertyFactory.bearing(d));
        this.lastBearing = d;
    }

    private void setLayerLocation(LatLng latLng) {
        double d = latLng.getLatitude();
        double d2 = latLng.getLongitude();
        this.layer.setProperties(LocationPropertyFactory.location(new Double[]{d, d2, 0.0}));
        this.lastLatLng = latLng;
    }

    private void setLayerVisibility(boolean bl) {
        Layer layer = this.layer;
        String string2 = bl ? "visible" : "none";
        layer.setProperties(LocationPropertyFactory.visibility(string2));
    }

    @Override
    public void addBitmaps(int n, Bitmap bitmap, Bitmap bitmap2, Bitmap bitmap3, Bitmap bitmap4, Bitmap bitmap5, Bitmap bitmap6) {
        if (bitmap != null) {
            this.style.addImage("mapbox-location-shadow-icon", bitmap);
        } else {
            this.style.removeImage("mapbox-location-shadow-icon");
        }
        this.style.addImage("mapbox-location-icon", bitmap5);
        this.style.addImage("mapbox-location-stale-icon", bitmap6);
        if (n == 4) {
            float f = (float)(bitmap4.getWidth() - bitmap2.getWidth()) / 2.0f;
            float f2 = (float)(bitmap4.getHeight() - bitmap2.getHeight()) / 2.0f;
            this.style.addImage("mapbox-location-bearing-icon", BitmapUtils.mergeBitmap(bitmap4, bitmap2, f, f2));
            f = (float)(bitmap4.getWidth() - bitmap3.getWidth()) / 2.0f;
            f2 = (float)(bitmap4.getHeight() - bitmap3.getHeight()) / 2.0f;
            this.style.addImage("mapbox-location-bearing-stale-icon", BitmapUtils.mergeBitmap(bitmap4, bitmap3, f, f2));
        } else {
            this.style.addImage("mapbox-location-stroke-icon", bitmap2);
            this.style.addImage("mapbox-location-background-stale-icon", bitmap3);
            this.style.addImage("mapbox-location-bearing-icon", bitmap4);
        }
    }

    @Override
    public void addLayers(LocationComponentPositionManager locationComponentPositionManager) {
        locationComponentPositionManager.addLayerToMap(this.layer);
    }

    @Override
    public void adjustPulsingCircleLayerVisibility(boolean bl) {
    }

    @Override
    public void cameraBearingUpdated(double d) {
    }

    @Override
    public void cameraTiltUpdated(double d) {
    }

    @Override
    public void hide() {
        this.setLayerVisibility(false);
    }

    @Override
    public void initializeComponents(Style object) {
        this.style = object;
        this.layer = this.layerSourceProvider.generateLocationComponentLayer();
        object = this.lastLatLng;
        if (object != null) {
            this.setLatLng((LatLng)object);
        }
        this.setLayerBearing(this.lastBearing);
        this.setAccuracyRadius(Float.valueOf(this.lastAccuracy));
    }

    @Override
    public void removeLayers() {
        this.style.removeLayer(this.layer);
    }

    @Override
    public void setAccuracyRadius(Float f) {
        this.layer.setProperties(LocationPropertyFactory.accuracyRadius(f));
        this.lastAccuracy = f.floatValue();
    }

    @Override
    public void setCompassBearing(Float f) {
        this.setLayerBearing(f.floatValue());
    }

    @Override
    public void setGpsBearing(Float f) {
        this.setLayerBearing(f.floatValue());
    }

    @Override
    public void setLatLng(LatLng latLng) {
        this.setLayerLocation(latLng);
    }

    @Override
    public void setLocationStale(boolean bl, int n) {
        this.setImages(n, bl);
    }

    @Override
    public void show(int n, boolean bl) {
        this.setImages(n, bl);
        this.setLayerVisibility(true);
    }

    @Override
    public void styleAccuracy(float f, int n) {
        Object object = ColorUtils.colorToRgbaArray(n);
        object[3] = f;
        object = Expression.rgba(Float.valueOf(object[0]), Float.valueOf(object[1]), Float.valueOf(object[2]), Float.valueOf(object[3]));
        this.layer.setProperties(LocationPropertyFactory.accuracyRadiusColor((Expression)object), LocationPropertyFactory.accuracyRadiusBorderColor((Expression)object));
    }

    @Override
    public void stylePulsingCircle(LocationComponentOptions locationComponentOptions) {
    }

    @Override
    public void styleScaling(Expression expression) {
        this.layer.setProperties(LocationPropertyFactory.shadowImageSize(expression), LocationPropertyFactory.bearingImageSize(expression), LocationPropertyFactory.topImageSize(expression));
    }

    @Override
    public void updateIconIds(String string2, String string3, String string4, String string5, String string6) {
    }

    @Override
    public void updatePulsingUi(float f, Float f2) {
    }
}

