/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.location.Location;
import android.view.MotionEvent;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.AnimatorListenerHolder;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.MapboxAnimator;
import com.mapbox.mapboxsdk.location.OnCameraMoveInvalidateListener;
import com.mapbox.mapboxsdk.location.OnCameraTrackingChangedListener;
import com.mapbox.mapboxsdk.location.OnLocationCameraTransitionListener;
import com.mapbox.mapboxsdk.location.Utils;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Transform;
import java.util.HashSet;
import java.util.Set;

final class LocationCameraController {
    private int cameraMode;
    private final MapboxAnimator.AnimationsValueChangeListener<Float> compassBearingValueListener;
    private final MapboxAnimator.AnimationsValueChangeListener<Float> gpsBearingValueListener;
    private final AndroidGesturesManager initialGesturesManager;
    private final OnCameraTrackingChangedListener internalCameraTrackingChangedListener;
    private final AndroidGesturesManager internalGesturesManager;
    private boolean isEnabled;
    private boolean isTransitioning;
    private LatLng lastLocation;
    private final MapboxAnimator.AnimationsValueChangeListener<LatLng> latLngValueListener = new MapboxAnimator.AnimationsValueChangeListener<LatLng>(){

        @Override
        public void onNewAnimationValue(LatLng latLng) {
            LocationCameraController.this.setLatLng(latLng);
        }
    };
    private final MapboxMap mapboxMap;
    private final MoveGestureDetector moveGestureDetector;
    private final OnCameraMoveInvalidateListener onCameraMoveInvalidateListener;
    private MapboxMap.OnCameraMoveListener onCameraMoveListener;
    private MapboxMap.OnFlingListener onFlingListener;
    MapboxMap.OnMoveListener onMoveListener;
    private MapboxMap.OnRotateListener onRotateListener;
    private LocationComponentOptions options;
    private final MapboxAnimator.AnimationsValueChangeListener<double[]> paddingValueListener;
    private final MapboxAnimator.AnimationsValueChangeListener<Float> tiltValueListener;
    private final Transform transform;
    private final MapboxAnimator.AnimationsValueChangeListener<Float> zoomValueListener;

    LocationCameraController(Context object, MapboxMap mapboxMap, Transform transform, OnCameraTrackingChangedListener onCameraTrackingChangedListener, LocationComponentOptions locationComponentOptions, OnCameraMoveInvalidateListener onCameraMoveInvalidateListener) {
        this.gpsBearingValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

            @Override
            public void onNewAnimationValue(Float f) {
                boolean bl = LocationCameraController.this.cameraMode == 36 && ((LocationCameraController)LocationCameraController.this).mapboxMap.getCameraPosition().bearing == 0.0;
                if (!bl) {
                    LocationCameraController.this.setBearing(f.floatValue());
                }
            }
        };
        this.compassBearingValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

            @Override
            public void onNewAnimationValue(Float f) {
                if (LocationCameraController.this.cameraMode == 32 || LocationCameraController.this.cameraMode == 16) {
                    LocationCameraController.this.setBearing(f.floatValue());
                }
            }
        };
        this.zoomValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

            @Override
            public void onNewAnimationValue(Float f) {
                LocationCameraController.this.setZoom(f.floatValue());
            }
        };
        this.paddingValueListener = new MapboxAnimator.AnimationsValueChangeListener<double[]>(){

            @Override
            public void onNewAnimationValue(double[] dArray) {
                LocationCameraController.this.setPadding(dArray);
            }
        };
        this.tiltValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

            @Override
            public void onNewAnimationValue(Float f) {
                LocationCameraController.this.setTilt(f.floatValue());
            }
        };
        this.onCameraMoveListener = new MapboxMap.OnCameraMoveListener(){

            @Override
            public void onCameraMove() {
                if (LocationCameraController.this.isLocationTracking() && LocationCameraController.this.lastLocation != null && LocationCameraController.this.options.trackingGesturesManagement()) {
                    PointF pointF = LocationCameraController.this.mapboxMap.getProjection().toScreenLocation(LocationCameraController.this.lastLocation);
                    LocationCameraController.this.mapboxMap.getUiSettings().setFocalPoint(pointF);
                }
            }
        };
        this.onMoveListener = new MapboxMap.OnMoveListener(){
            private boolean interrupt;

            private void applyMultiFingerMoveThreshold(MoveGestureDetector moveGestureDetector) {
                if (moveGestureDetector.getMoveThreshold() != LocationCameraController.this.options.trackingMultiFingerMoveThreshold()) {
                    moveGestureDetector.setMoveThreshold(LocationCameraController.this.options.trackingMultiFingerMoveThreshold());
                    this.interrupt = true;
                }
            }

            private void applyMultiFingerThresholdArea(MoveGestureDetector moveGestureDetector) {
                RectF rectF = moveGestureDetector.getMoveThresholdRect();
                if (rectF != null && !rectF.equals((Object)LocationCameraController.this.options.trackingMultiFingerProtectedMoveArea())) {
                    moveGestureDetector.setMoveThresholdRect(LocationCameraController.this.options.trackingMultiFingerProtectedMoveArea());
                    this.interrupt = true;
                } else if (rectF == null && LocationCameraController.this.options.trackingMultiFingerProtectedMoveArea() != null) {
                    moveGestureDetector.setMoveThresholdRect(LocationCameraController.this.options.trackingMultiFingerProtectedMoveArea());
                    this.interrupt = true;
                }
            }

            private void applySingleFingerMoveThreshold(MoveGestureDetector moveGestureDetector) {
                if (moveGestureDetector.getMoveThreshold() != LocationCameraController.this.options.trackingInitialMoveThreshold()) {
                    moveGestureDetector.setMoveThreshold(LocationCameraController.this.options.trackingInitialMoveThreshold());
                    this.interrupt = true;
                }
            }

            @Override
            public void onMove(MoveGestureDetector moveGestureDetector) {
                if (this.interrupt) {
                    moveGestureDetector.interrupt();
                    return;
                }
                if (LocationCameraController.this.isLocationTracking() || LocationCameraController.this.isBearingTracking()) {
                    LocationCameraController.this.setCameraMode(8);
                    moveGestureDetector.interrupt();
                }
            }

            @Override
            public void onMoveBegin(MoveGestureDetector moveGestureDetector) {
                if (LocationCameraController.this.options.trackingGesturesManagement() && LocationCameraController.this.isLocationTracking()) {
                    if (moveGestureDetector.getPointersCount() > 1) {
                        this.applyMultiFingerThresholdArea(moveGestureDetector);
                        this.applyMultiFingerMoveThreshold(moveGestureDetector);
                    } else {
                        this.applySingleFingerMoveThreshold(moveGestureDetector);
                    }
                } else {
                    LocationCameraController.this.setCameraMode(8);
                }
            }

            @Override
            public void onMoveEnd(MoveGestureDetector moveGestureDetector) {
                if (LocationCameraController.this.options.trackingGesturesManagement() && !this.interrupt && LocationCameraController.this.isLocationTracking()) {
                    moveGestureDetector.setMoveThreshold(LocationCameraController.this.options.trackingInitialMoveThreshold());
                    moveGestureDetector.setMoveThresholdRect(null);
                }
                this.interrupt = false;
            }
        };
        this.onRotateListener = new MapboxMap.OnRotateListener(){

            @Override
            public void onRotate(RotateGestureDetector rotateGestureDetector) {
            }

            @Override
            public void onRotateBegin(RotateGestureDetector rotateGestureDetector) {
                if (LocationCameraController.this.isBearingTracking()) {
                    LocationCameraController.this.setCameraMode(8);
                }
            }

            @Override
            public void onRotateEnd(RotateGestureDetector rotateGestureDetector) {
            }
        };
        this.onFlingListener = new MapboxMap.OnFlingListener(){

            @Override
            public void onFling() {
                LocationCameraController.this.setCameraMode(8);
            }
        };
        this.mapboxMap = mapboxMap;
        this.transform = transform;
        this.initialGesturesManager = mapboxMap.getGesturesManager();
        object = new LocationGesturesManager((Context)object);
        this.internalGesturesManager = object;
        this.moveGestureDetector = ((AndroidGesturesManager)object).getMoveGestureDetector();
        mapboxMap.addOnRotateListener(this.onRotateListener);
        mapboxMap.addOnFlingListener(this.onFlingListener);
        mapboxMap.addOnMoveListener(this.onMoveListener);
        mapboxMap.addOnCameraMoveListener(this.onCameraMoveListener);
        this.internalCameraTrackingChangedListener = onCameraTrackingChangedListener;
        this.onCameraMoveInvalidateListener = onCameraMoveInvalidateListener;
        this.initializeOptions(locationComponentOptions);
    }

    LocationCameraController(MapboxMap mapboxMap, Transform transform, MoveGestureDetector moveGestureDetector, OnCameraTrackingChangedListener onCameraTrackingChangedListener, OnCameraMoveInvalidateListener onCameraMoveInvalidateListener, AndroidGesturesManager androidGesturesManager, AndroidGesturesManager androidGesturesManager2) {
        this.gpsBearingValueListener = new /* invalid duplicate definition of identical inner class */;
        this.compassBearingValueListener = new /* invalid duplicate definition of identical inner class */;
        this.zoomValueListener = new /* invalid duplicate definition of identical inner class */;
        this.paddingValueListener = new /* invalid duplicate definition of identical inner class */;
        this.tiltValueListener = new /* invalid duplicate definition of identical inner class */;
        this.onCameraMoveListener = new /* invalid duplicate definition of identical inner class */;
        this.onMoveListener = new /* invalid duplicate definition of identical inner class */;
        this.onRotateListener = new /* invalid duplicate definition of identical inner class */;
        this.onFlingListener = new /* invalid duplicate definition of identical inner class */;
        this.mapboxMap = mapboxMap;
        mapboxMap.addOnCameraMoveListener(this.onCameraMoveListener);
        this.transform = transform;
        this.moveGestureDetector = moveGestureDetector;
        this.internalCameraTrackingChangedListener = onCameraTrackingChangedListener;
        this.onCameraMoveInvalidateListener = onCameraMoveInvalidateListener;
        this.internalGesturesManager = androidGesturesManager2;
        this.initialGesturesManager = androidGesturesManager;
    }

    static /* synthetic */ boolean access$002(LocationCameraController locationCameraController, boolean bl) {
        locationCameraController.isTransitioning = bl;
        return bl;
    }

    private void adjustGesturesThresholds() {
        if (this.options.trackingGesturesManagement()) {
            if (this.isLocationTracking()) {
                this.moveGestureDetector.setMoveThreshold(this.options.trackingInitialMoveThreshold());
            } else {
                this.moveGestureDetector.setMoveThreshold(0.0f);
                this.moveGestureDetector.setMoveThresholdRect(null);
            }
        }
    }

    private boolean isBearingTracking() {
        int n = this.cameraMode;
        boolean bl = n == 16 || n == 32 || n == 22 || n == 34 || n == 36;
        return bl;
    }

    private boolean isLocationBearingTracking() {
        int n = this.cameraMode;
        boolean bl = n == 34 || n == 36 || n == 22;
        return bl;
    }

    private boolean isLocationTracking() {
        int n = this.cameraMode;
        boolean bl = n == 24 || n == 32 || n == 34 || n == 36;
        return bl;
    }

    private void notifyCameraTrackingChangeListener(boolean bl) {
        this.internalCameraTrackingChangedListener.onCameraTrackingChanged(this.cameraMode);
        if (bl && !this.isLocationTracking()) {
            this.mapboxMap.getUiSettings().setFocalPoint(null);
            this.internalCameraTrackingChangedListener.onCameraTrackingDismissed();
        }
    }

    private void setBearing(float f) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapboxMap, CameraUpdateFactory.bearingTo(f), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setLatLng(LatLng latLng) {
        if (this.isTransitioning) {
            return;
        }
        this.lastLocation = latLng;
        this.transform.moveCamera(this.mapboxMap, CameraUpdateFactory.newLatLng(latLng), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setPadding(double[] dArray) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapboxMap, CameraUpdateFactory.paddingTo(dArray), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setTilt(float f) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapboxMap, CameraUpdateFactory.tiltTo(f), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setZoom(float f) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapboxMap, CameraUpdateFactory.zoomTo(f), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void transitionToCurrentLocation(boolean bl, Location object, long l, Double object2, Double object3, Double d, final OnLocationCameraTransitionListener onLocationCameraTransitionListener) {
        if (!bl && this.isLocationTracking() && object != null && this.isEnabled) {
            this.isTransitioning = true;
            LatLng latLng = new LatLng((Location)object);
            CameraPosition.Builder builder = new CameraPosition.Builder().target(latLng);
            if (object2 != null) {
                builder.zoom((Double)object2);
            }
            if (d != null) {
                builder.tilt(d);
            }
            if (object3 != null) {
                builder.bearing((Double)object3);
            } else if (this.isLocationBearingTracking()) {
                double d2 = this.cameraMode == 36 ? 0.0 : (double)object.getBearing();
                builder.bearing(d2);
            }
            object = CameraUpdateFactory.newCameraPosition(builder.build());
            object3 = new MapboxMap.CancelableCallback(){

                @Override
                public void onCancel() {
                    LocationCameraController.access$002(LocationCameraController.this, false);
                    OnLocationCameraTransitionListener onLocationCameraTransitionListener2 = onLocationCameraTransitionListener;
                    if (onLocationCameraTransitionListener2 != null) {
                        onLocationCameraTransitionListener2.onLocationCameraTransitionCanceled(LocationCameraController.this.cameraMode);
                    }
                }

                @Override
                public void onFinish() {
                    LocationCameraController.access$002(LocationCameraController.this, false);
                    OnLocationCameraTransitionListener onLocationCameraTransitionListener2 = onLocationCameraTransitionListener;
                    if (onLocationCameraTransitionListener2 != null) {
                        onLocationCameraTransitionListener2.onLocationCameraTransitionFinished(LocationCameraController.this.cameraMode);
                    }
                }
            };
            object2 = this.mapboxMap.getCameraPosition();
            if (Utils.immediateAnimation(this.mapboxMap.getProjection(), ((CameraPosition)object2).target, latLng)) {
                this.transform.moveCamera(this.mapboxMap, (CameraUpdate)object, (MapboxMap.CancelableCallback)object3);
            } else {
                this.transform.animateCamera(this.mapboxMap, (CameraUpdate)object, (int)l, (MapboxMap.CancelableCallback)object3);
            }
        } else if (onLocationCameraTransitionListener != null) {
            onLocationCameraTransitionListener.onLocationCameraTransitionFinished(this.cameraMode);
        }
    }

    Set<AnimatorListenerHolder> getAnimationListeners() {
        HashSet<AnimatorListenerHolder> hashSet = new HashSet<AnimatorListenerHolder>();
        if (this.isLocationTracking()) {
            hashSet.add(new AnimatorListenerHolder(1, this.latLngValueListener));
        }
        if (this.isLocationBearingTracking()) {
            hashSet.add(new AnimatorListenerHolder(4, this.gpsBearingValueListener));
        }
        if (this.isConsumingCompass()) {
            hashSet.add(new AnimatorListenerHolder(5, this.compassBearingValueListener));
        }
        hashSet.add(new AnimatorListenerHolder(7, this.zoomValueListener));
        hashSet.add(new AnimatorListenerHolder(8, this.tiltValueListener));
        hashSet.add(new AnimatorListenerHolder(10, this.paddingValueListener));
        return hashSet;
    }

    int getCameraMode() {
        return this.cameraMode;
    }

    void initializeOptions(LocationComponentOptions object) {
        this.options = object;
        if (((LocationComponentOptions)object).trackingGesturesManagement()) {
            AndroidGesturesManager androidGesturesManager;
            object = this.mapboxMap.getGesturesManager();
            if (object != (androidGesturesManager = this.internalGesturesManager)) {
                this.mapboxMap.setGesturesManager(androidGesturesManager, true, true);
            }
            this.adjustGesturesThresholds();
        } else {
            AndroidGesturesManager androidGesturesManager = this.mapboxMap.getGesturesManager();
            if (androidGesturesManager != (object = this.initialGesturesManager)) {
                this.mapboxMap.setGesturesManager((AndroidGesturesManager)object, true, true);
            }
        }
    }

    boolean isConsumingCompass() {
        int n = this.cameraMode;
        boolean bl = n == 32 || n == 16;
        return bl;
    }

    boolean isTransitioning() {
        return this.isTransitioning;
    }

    void setCameraMode(int n) {
        this.setCameraMode(n, null, 750L, null, null, null, null);
    }

    void setCameraMode(int n, Location location, long l, Double d, Double d2, Double d3, OnLocationCameraTransitionListener onLocationCameraTransitionListener) {
        if (this.cameraMode == n) {
            if (onLocationCameraTransitionListener != null) {
                onLocationCameraTransitionListener.onLocationCameraTransitionFinished(n);
            }
            return;
        }
        boolean bl = this.isLocationTracking();
        this.cameraMode = n;
        this.mapboxMap.setUserAnimationInProgress(this.isLocationTracking());
        if (n != 8) {
            this.mapboxMap.cancelTransitions();
        }
        this.adjustGesturesThresholds();
        this.notifyCameraTrackingChangeListener(bl);
        this.transitionToCurrentLocation(bl, location, l, d, d2, d3, onLocationCameraTransitionListener);
    }

    void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    private class LocationGesturesManager
    extends AndroidGesturesManager {
        LocationGesturesManager(Context context) {
            super(context);
        }

        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            if (motionEvent != null && motionEvent.getActionMasked() == 1) {
                LocationCameraController.this.adjustGesturesThresholds();
            }
            return super.onTouchEvent(motionEvent);
        }
    }
}

