/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.animation.Interpolator;
import com.mapbox.mapboxsdk.R;
import java.util.Arrays;
import java.util.Objects;

public class LocationComponentOptions
implements Parcelable {
    private static final float ACCURACY_ALPHA_DEFAULT = 0.15f;
    private static final float CIRCLE_PULSING_ALPHA_DEFAULT = 1.0f;
    private static final long CIRCLE_PULSING_DURATION_DEFAULT_MS = 2300L;
    public static final float CIRCLE_PULSING_MAX_RADIUS_DEFAULT = 35.0f;
    public static final Parcelable.Creator<LocationComponentOptions> CREATOR;
    private static final float MAX_ZOOM_ICON_SCALE_DEFAULT = 1.0f;
    private static final float MIN_ZOOM_ICON_SCALE_DEFAULT = 0.6f;
    private static final int[] PADDING_DEFAULT;
    private static final long STALE_STATE_DELAY_MS = 30000L;
    private static final float TRACKING_ANIMATION_DURATION_MULTIPLIER_DEFAULT = 1.1f;
    private float accuracyAlpha;
    private boolean accuracyAnimationEnabled;
    private int accuracyColor;
    private int backgroundDrawable;
    private int backgroundDrawableStale;
    private String backgroundName;
    private String backgroundStaleName;
    private Integer backgroundStaleTintColor;
    private Integer backgroundTintColor;
    private int bearingDrawable;
    private String bearingName;
    private Integer bearingTintColor;
    private boolean compassAnimationEnabled;
    private float elevation;
    private boolean enableStaleState;
    private int foregroundDrawable;
    private int foregroundDrawableStale;
    private String foregroundName;
    private String foregroundStaleName;
    private Integer foregroundStaleTintColor;
    private Integer foregroundTintColor;
    private int gpsDrawable;
    private String gpsName;
    private String layerAbove;
    private String layerBelow;
    private float maxZoomIconScale;
    private float minZoomIconScale;
    private int[] padding;
    private float pulseAlpha;
    private Integer pulseColor;
    private Boolean pulseEnabled;
    private Boolean pulseFadeEnabled;
    private Interpolator pulseInterpolator;
    private float pulseMaxRadius;
    private float pulseSingleDuration;
    private long staleStateTimeout;
    private float trackingAnimationDurationMultiplier;
    private boolean trackingGesturesManagement;
    private float trackingInitialMoveThreshold;
    private float trackingMultiFingerMoveThreshold;
    private RectF trackingMultiFingerProtectedMoveArea;

    static {
        PADDING_DEFAULT = new int[]{0, 0, 0, 0};
        CREATOR = new Parcelable.Creator<LocationComponentOptions>(){

            public LocationComponentOptions createFromParcel(Parcel parcel) {
                return new LocationComponentOptions(parcel);
            }

            public LocationComponentOptions[] newArray(int n) {
                return new LocationComponentOptions[n];
            }
        };
    }

    public LocationComponentOptions(float f, int n, int n2, String string2, int n3, String string3, int n4, String string4, int n5, String string5, int n6, String string6, int n7, String string7, Integer n8, Integer n9, Integer n10, Integer n11, Integer n12, float f2, boolean bl, long l, int[] nArray, float f3, float f4, boolean bl2, float f5, float f6, RectF rectF, String string8, String string9, float f7, boolean bl3, boolean bl4, Boolean bl5, Boolean bl6, Integer n13, float f8, float f9, float f10, Interpolator interpolator2) {
        this.accuracyAlpha = f;
        this.accuracyColor = n;
        this.backgroundDrawableStale = n2;
        this.backgroundStaleName = string2;
        this.foregroundDrawableStale = n3;
        this.foregroundStaleName = string3;
        this.gpsDrawable = n4;
        this.gpsName = string4;
        this.foregroundDrawable = n5;
        this.foregroundName = string5;
        this.backgroundDrawable = n6;
        this.backgroundName = string6;
        this.bearingDrawable = n7;
        this.bearingName = string7;
        this.bearingTintColor = n8;
        this.foregroundTintColor = n9;
        this.backgroundTintColor = n10;
        this.foregroundStaleTintColor = n11;
        this.backgroundStaleTintColor = n12;
        this.elevation = f2;
        this.enableStaleState = bl;
        this.staleStateTimeout = l;
        Objects.requireNonNull(nArray, "Null padding");
        this.padding = nArray;
        this.maxZoomIconScale = f3;
        this.minZoomIconScale = f4;
        this.trackingGesturesManagement = bl2;
        this.trackingInitialMoveThreshold = f5;
        this.trackingMultiFingerMoveThreshold = f6;
        this.trackingMultiFingerProtectedMoveArea = rectF;
        this.layerAbove = string8;
        this.layerBelow = string9;
        this.trackingAnimationDurationMultiplier = f7;
        this.compassAnimationEnabled = bl3;
        this.accuracyAnimationEnabled = bl4;
        this.pulseEnabled = bl5;
        this.pulseFadeEnabled = bl6;
        this.pulseColor = n13;
        this.pulseSingleDuration = f8;
        this.pulseMaxRadius = f9;
        this.pulseAlpha = f10;
        this.pulseInterpolator = interpolator2;
    }

    protected LocationComponentOptions(Parcel parcel) {
        this.accuracyAlpha = parcel.readFloat();
        this.accuracyColor = parcel.readInt();
        this.backgroundDrawableStale = parcel.readInt();
        this.backgroundStaleName = parcel.readString();
        this.foregroundDrawableStale = parcel.readInt();
        this.foregroundStaleName = parcel.readString();
        this.gpsDrawable = parcel.readInt();
        this.gpsName = parcel.readString();
        this.foregroundDrawable = parcel.readInt();
        this.foregroundName = parcel.readString();
        this.backgroundDrawable = parcel.readInt();
        this.backgroundName = parcel.readString();
        this.bearingDrawable = parcel.readInt();
        this.bearingName = parcel.readString();
        this.bearingTintColor = (Integer)parcel.readValue(Integer.class.getClassLoader());
        this.foregroundTintColor = (Integer)parcel.readValue(Integer.class.getClassLoader());
        this.backgroundTintColor = (Integer)parcel.readValue(Integer.class.getClassLoader());
        this.foregroundStaleTintColor = (Integer)parcel.readValue(Integer.class.getClassLoader());
        this.backgroundStaleTintColor = (Integer)parcel.readValue(Integer.class.getClassLoader());
        this.elevation = parcel.readFloat();
        byte by = parcel.readByte();
        boolean bl = true;
        boolean bl2 = by != 0;
        this.enableStaleState = bl2;
        this.staleStateTimeout = parcel.readLong();
        this.padding = parcel.createIntArray();
        this.maxZoomIconScale = parcel.readFloat();
        this.minZoomIconScale = parcel.readFloat();
        bl2 = parcel.readByte() != 0;
        this.trackingGesturesManagement = bl2;
        this.trackingInitialMoveThreshold = parcel.readFloat();
        this.trackingMultiFingerMoveThreshold = parcel.readFloat();
        this.trackingMultiFingerProtectedMoveArea = (RectF)parcel.readParcelable(RectF.class.getClassLoader());
        this.layerAbove = parcel.readString();
        this.layerBelow = parcel.readString();
        this.trackingAnimationDurationMultiplier = parcel.readFloat();
        bl2 = parcel.readByte() != 0;
        this.compassAnimationEnabled = bl2;
        bl2 = parcel.readByte() != 0 ? bl : false;
        this.accuracyAnimationEnabled = bl2;
        this.pulseEnabled = (Boolean)parcel.readValue(Boolean.class.getClassLoader());
        this.pulseFadeEnabled = (Boolean)parcel.readValue(Boolean.class.getClassLoader());
        this.pulseColor = (Integer)parcel.readValue(Integer.class.getClassLoader());
        this.pulseSingleDuration = parcel.readFloat();
        this.pulseMaxRadius = parcel.readFloat();
        this.pulseAlpha = parcel.readFloat();
    }

    public static Builder builder(Context context) {
        return LocationComponentOptions.createFromAttributes(context, R.style.mapbox_LocationComponent).toBuilder();
    }

    public static LocationComponentOptions createFromAttributes(Context context, int n) {
        TypedArray typedArray = context.obtainStyledAttributes(n, R.styleable.mapbox_LocationComponent);
        Builder builder = new Builder().enableStaleState(true).staleStateTimeout(30000L).maxZoomIconScale(1.0f).minZoomIconScale(0.6f).padding(PADDING_DEFAULT);
        builder.foregroundDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_foregroundDrawable, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_foregroundTintColor)) {
            builder.foregroundTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_foregroundTintColor, -1));
        }
        builder.backgroundDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_backgroundDrawable, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_backgroundTintColor)) {
            builder.backgroundTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_backgroundTintColor, -1));
        }
        builder.foregroundDrawableStale(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_foregroundDrawableStale, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_foregroundStaleTintColor)) {
            builder.foregroundStaleTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_foregroundStaleTintColor, -1));
        }
        builder.backgroundDrawableStale(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_backgroundDrawableStale, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_backgroundStaleTintColor)) {
            builder.backgroundStaleTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_backgroundStaleTintColor, -1));
        }
        builder.bearingDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_bearingDrawable, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_bearingTintColor)) {
            builder.bearingTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_bearingTintColor, -1));
        }
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_enableStaleState)) {
            builder.enableStaleState(typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_enableStaleState, true));
        }
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_staleStateTimeout)) {
            builder.staleStateTimeout(typedArray.getInteger(R.styleable.mapbox_LocationComponent_mapbox_staleStateTimeout, 30000));
        }
        builder.gpsDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_gpsDrawable, -1));
        float f = typedArray.getDimension(R.styleable.mapbox_LocationComponent_mapbox_elevation, 0.0f);
        builder.accuracyColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_accuracyColor, -1));
        builder.accuracyAlpha(typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_accuracyAlpha, 0.15f));
        builder.elevation(f);
        builder.trackingGesturesManagement(typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_trackingGesturesManagement, false));
        builder.trackingInitialMoveThreshold(typedArray.getDimension(R.styleable.mapbox_LocationComponent_mapbox_trackingInitialMoveThreshold, context.getResources().getDimension(R.dimen.mapbox_locationComponentTrackingInitialMoveThreshold)));
        builder.trackingMultiFingerMoveThreshold(typedArray.getDimension(R.styleable.mapbox_LocationComponent_mapbox_trackingMultiFingerMoveThreshold, context.getResources().getDimension(R.dimen.mapbox_locationComponentTrackingMultiFingerMoveThreshold)));
        builder.padding(new int[]{typedArray.getInt(R.styleable.mapbox_LocationComponent_mapbox_iconPaddingLeft, 0), typedArray.getInt(R.styleable.mapbox_LocationComponent_mapbox_iconPaddingTop, 0), typedArray.getInt(R.styleable.mapbox_LocationComponent_mapbox_iconPaddingRight, 0), typedArray.getInt(R.styleable.mapbox_LocationComponent_mapbox_iconPaddingBottom, 0)});
        builder.layerAbove(typedArray.getString(R.styleable.mapbox_LocationComponent_mapbox_layer_above));
        builder.layerBelow(typedArray.getString(R.styleable.mapbox_LocationComponent_mapbox_layer_below));
        f = typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_minZoomIconScale, 0.6f);
        float f2 = typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_maxZoomIconScale, 1.0f);
        builder.minZoomIconScale(f);
        builder.maxZoomIconScale(f2);
        builder.trackingAnimationDurationMultiplier(typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_trackingAnimationDurationMultiplier, 1.1f));
        Builder.access$002(builder, typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_compassAnimationEnabled, true));
        Builder.access$102(builder, typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_accuracyAnimationEnabled, true));
        Builder.access$202(builder, typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_pulsingLocationCircleEnabled, false));
        Builder.access$302(builder, typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_pulsingLocationCircleFadeEnabled, true));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_pulsingLocationCircleColor)) {
            builder.pulseColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_pulsingLocationCircleColor, -1));
        }
        Builder.access$402(builder, typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_pulsingLocationCircleDuration, 2300.0f));
        Builder.access$502(builder, typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_pulsingLocationCircleRadius, 35.0f));
        Builder.access$602(builder, typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_pulsingLocationCircleAlpha, 1.0f));
        typedArray.recycle();
        return builder.build();
    }

    public float accuracyAlpha() {
        return this.accuracyAlpha;
    }

    public boolean accuracyAnimationEnabled() {
        return this.accuracyAnimationEnabled;
    }

    public int accuracyColor() {
        return this.accuracyColor;
    }

    public int backgroundDrawable() {
        return this.backgroundDrawable;
    }

    public int backgroundDrawableStale() {
        return this.backgroundDrawableStale;
    }

    public String backgroundName() {
        return this.backgroundName;
    }

    public String backgroundStaleName() {
        return this.backgroundStaleName;
    }

    public Integer backgroundStaleTintColor() {
        return this.backgroundStaleTintColor;
    }

    public Integer backgroundTintColor() {
        return this.backgroundTintColor;
    }

    public int bearingDrawable() {
        return this.bearingDrawable;
    }

    public String bearingName() {
        return this.bearingName;
    }

    public Integer bearingTintColor() {
        return this.bearingTintColor;
    }

    public boolean compassAnimationEnabled() {
        return this.compassAnimationEnabled;
    }

    public int describeContents() {
        return 0;
    }

    public float elevation() {
        return this.elevation;
    }

    public boolean enableStaleState() {
        return this.enableStaleState;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (LocationComponentOptions)object;
            if (Float.compare(((LocationComponentOptions)object).accuracyAlpha, this.accuracyAlpha) != 0) {
                return false;
            }
            if (this.accuracyColor != ((LocationComponentOptions)object).accuracyColor) {
                return false;
            }
            if (this.backgroundDrawableStale != ((LocationComponentOptions)object).backgroundDrawableStale) {
                return false;
            }
            if (this.foregroundDrawableStale != ((LocationComponentOptions)object).foregroundDrawableStale) {
                return false;
            }
            if (this.gpsDrawable != ((LocationComponentOptions)object).gpsDrawable) {
                return false;
            }
            if (this.foregroundDrawable != ((LocationComponentOptions)object).foregroundDrawable) {
                return false;
            }
            if (this.backgroundDrawable != ((LocationComponentOptions)object).backgroundDrawable) {
                return false;
            }
            if (this.bearingDrawable != ((LocationComponentOptions)object).bearingDrawable) {
                return false;
            }
            if (Float.compare(((LocationComponentOptions)object).elevation, this.elevation) != 0) {
                return false;
            }
            if (this.enableStaleState != ((LocationComponentOptions)object).enableStaleState) {
                return false;
            }
            if (this.staleStateTimeout != ((LocationComponentOptions)object).staleStateTimeout) {
                return false;
            }
            if (Float.compare(((LocationComponentOptions)object).maxZoomIconScale, this.maxZoomIconScale) != 0) {
                return false;
            }
            if (Float.compare(((LocationComponentOptions)object).minZoomIconScale, this.minZoomIconScale) != 0) {
                return false;
            }
            if (this.trackingGesturesManagement != ((LocationComponentOptions)object).trackingGesturesManagement) {
                return false;
            }
            if (Float.compare(((LocationComponentOptions)object).trackingInitialMoveThreshold, this.trackingInitialMoveThreshold) != 0) {
                return false;
            }
            if (Float.compare(((LocationComponentOptions)object).trackingMultiFingerMoveThreshold, this.trackingMultiFingerMoveThreshold) != 0) {
                return false;
            }
            if (Float.compare(((LocationComponentOptions)object).trackingAnimationDurationMultiplier, this.trackingAnimationDurationMultiplier) != 0) {
                return false;
            }
            Object object2 = this.trackingMultiFingerProtectedMoveArea;
            if (object2 != null ? !object2.equals((Object)((LocationComponentOptions)object).trackingMultiFingerProtectedMoveArea) : ((LocationComponentOptions)object).trackingMultiFingerProtectedMoveArea != null) {
                return false;
            }
            if (this.compassAnimationEnabled != ((LocationComponentOptions)object).compassAnimationEnabled) {
                return false;
            }
            if (this.accuracyAnimationEnabled != ((LocationComponentOptions)object).accuracyAnimationEnabled) {
                return false;
            }
            object2 = this.backgroundStaleName;
            if (object2 != null ? !((String)object2).equals(((LocationComponentOptions)object).backgroundStaleName) : ((LocationComponentOptions)object).backgroundStaleName != null) {
                return false;
            }
            object2 = this.foregroundStaleName;
            if (object2 != null ? !((String)object2).equals(((LocationComponentOptions)object).foregroundStaleName) : ((LocationComponentOptions)object).foregroundStaleName != null) {
                return false;
            }
            object2 = this.gpsName;
            if (object2 != null ? !((String)object2).equals(((LocationComponentOptions)object).gpsName) : ((LocationComponentOptions)object).gpsName != null) {
                return false;
            }
            object2 = this.foregroundName;
            if (object2 != null ? !((String)object2).equals(((LocationComponentOptions)object).foregroundName) : ((LocationComponentOptions)object).foregroundName != null) {
                return false;
            }
            object2 = this.backgroundName;
            if (object2 != null ? !((String)object2).equals(((LocationComponentOptions)object).backgroundName) : ((LocationComponentOptions)object).backgroundName != null) {
                return false;
            }
            object2 = this.bearingName;
            if (object2 != null ? !((String)object2).equals(((LocationComponentOptions)object).bearingName) : ((LocationComponentOptions)object).bearingName != null) {
                return false;
            }
            object2 = this.bearingTintColor;
            if (object2 != null ? !((Integer)object2).equals(((LocationComponentOptions)object).bearingTintColor) : ((LocationComponentOptions)object).bearingTintColor != null) {
                return false;
            }
            object2 = this.foregroundTintColor;
            if (object2 != null ? !((Integer)object2).equals(((LocationComponentOptions)object).foregroundTintColor) : ((LocationComponentOptions)object).foregroundTintColor != null) {
                return false;
            }
            object2 = this.backgroundTintColor;
            if (object2 != null ? !((Integer)object2).equals(((LocationComponentOptions)object).backgroundTintColor) : ((LocationComponentOptions)object).backgroundTintColor != null) {
                return false;
            }
            object2 = this.foregroundStaleTintColor;
            if (object2 != null ? !((Integer)object2).equals(((LocationComponentOptions)object).foregroundStaleTintColor) : ((LocationComponentOptions)object).foregroundStaleTintColor != null) {
                return false;
            }
            object2 = this.backgroundStaleTintColor;
            if (object2 != null ? !((Integer)object2).equals(((LocationComponentOptions)object).backgroundStaleTintColor) : ((LocationComponentOptions)object).backgroundStaleTintColor != null) {
                return false;
            }
            if (!Arrays.equals(this.padding, ((LocationComponentOptions)object).padding)) {
                return false;
            }
            object2 = this.layerAbove;
            if (object2 != null ? !((String)object2).equals(((LocationComponentOptions)object).layerAbove) : ((LocationComponentOptions)object).layerAbove != null) {
                return false;
            }
            if (this.pulseEnabled != ((LocationComponentOptions)object).pulseEnabled) {
                return false;
            }
            if (this.pulseFadeEnabled != ((LocationComponentOptions)object).pulseFadeEnabled) {
                return false;
            }
            object2 = this.pulseColor;
            if (object2 != null ? !((Integer)object2).equals(((LocationComponentOptions)object).pulseColor) : ((LocationComponentOptions)object).pulseColor() != null) {
                return false;
            }
            if (Float.compare(((LocationComponentOptions)object).pulseSingleDuration, this.pulseSingleDuration) != 0) {
                return false;
            }
            if (Float.compare(((LocationComponentOptions)object).pulseMaxRadius, this.pulseMaxRadius) != 0) {
                return false;
            }
            if (Float.compare(((LocationComponentOptions)object).pulseAlpha, this.pulseAlpha) != 0) {
                return false;
            }
            object2 = this.layerBelow;
            object = ((LocationComponentOptions)object).layerBelow;
            if (object2 != null) {
                bl = ((String)object2).equals(object);
            } else if (object != null) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int foregroundDrawable() {
        return this.foregroundDrawable;
    }

    public int foregroundDrawableStale() {
        return this.foregroundDrawableStale;
    }

    public String foregroundName() {
        return this.foregroundName;
    }

    public String foregroundStaleName() {
        return this.foregroundStaleName;
    }

    public Integer foregroundStaleTintColor() {
        return this.foregroundStaleTintColor;
    }

    public Integer foregroundTintColor() {
        return this.foregroundTintColor;
    }

    public int gpsDrawable() {
        return this.gpsDrawable;
    }

    public String gpsName() {
        return this.gpsName;
    }

    public int hashCode() {
        float f = this.accuracyAlpha;
        int n = 0;
        int n2 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        int n3 = this.accuracyColor;
        int n4 = this.backgroundDrawableStale;
        Object object = this.backgroundStaleName;
        int n5 = object != null ? ((String)object).hashCode() : 0;
        int n6 = this.foregroundDrawableStale;
        object = this.foregroundStaleName;
        int n7 = object != null ? ((String)object).hashCode() : 0;
        int n8 = this.gpsDrawable;
        object = this.gpsName;
        int n9 = object != null ? ((String)object).hashCode() : 0;
        int n10 = this.foregroundDrawable;
        object = this.foregroundName;
        int n11 = object != null ? ((String)object).hashCode() : 0;
        int n12 = this.backgroundDrawable;
        object = this.backgroundName;
        int n13 = object != null ? ((String)object).hashCode() : 0;
        int n14 = this.bearingDrawable;
        object = this.bearingName;
        int n15 = object != null ? ((String)object).hashCode() : 0;
        object = this.bearingTintColor;
        int n16 = object != null ? ((Integer)object).hashCode() : 0;
        object = this.foregroundTintColor;
        int n17 = object != null ? ((Integer)object).hashCode() : 0;
        object = this.backgroundTintColor;
        int n18 = object != null ? ((Integer)object).hashCode() : 0;
        object = this.foregroundStaleTintColor;
        int n19 = object != null ? ((Integer)object).hashCode() : 0;
        object = this.backgroundStaleTintColor;
        int n20 = object != null ? ((Integer)object).hashCode() : 0;
        f = this.elevation;
        int n21 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        int n22 = this.enableStaleState;
        long l = this.staleStateTimeout;
        int n23 = (int)(l ^ l >>> 32);
        int n24 = Arrays.hashCode(this.padding);
        f = this.maxZoomIconScale;
        int n25 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        f = this.minZoomIconScale;
        int n26 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        int n27 = this.trackingGesturesManagement;
        f = this.trackingInitialMoveThreshold;
        int n28 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        f = this.trackingMultiFingerMoveThreshold;
        int n29 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        object = this.trackingMultiFingerProtectedMoveArea;
        int n30 = object != null ? object.hashCode() : 0;
        object = this.layerAbove;
        int n31 = object != null ? ((String)object).hashCode() : 0;
        object = this.layerBelow;
        int n32 = object != null ? ((String)object).hashCode() : 0;
        f = this.trackingAnimationDurationMultiplier;
        int n33 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        int n34 = this.compassAnimationEnabled;
        int n35 = this.accuracyAnimationEnabled;
        int n36 = this.pulseEnabled.booleanValue();
        int n37 = this.pulseFadeEnabled.booleanValue();
        object = this.pulseColor;
        int n38 = object != null ? ((Integer)object).hashCode() : 0;
        f = this.pulseSingleDuration;
        int n39 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        f = this.pulseMaxRadius;
        int n40 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        f = this.pulseAlpha;
        if (f != 0.0f) {
            n = Float.floatToIntBits(f);
        }
        return ((((((((((((((((((((((((((((((((((((((n2 * 31 + n3) * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31 + n9) * 31 + n10) * 31 + n11) * 31 + n12) * 31 + n13) * 31 + n14) * 31 + n15) * 31 + n16) * 31 + n17) * 31 + n18) * 31 + n19) * 31 + n20) * 31 + n21) * 31 + n22) * 31 + n23) * 31 + n24) * 31 + n25) * 31 + n26) * 31 + n27) * 31 + n28) * 31 + n29) * 31 + n30) * 31 + n31) * 31 + n32) * 31 + n33) * 31 + n34) * 31 + n35) * 31 + n36) * 31 + n37) * 31 + n38) * 31 + n39) * 31 + n40) * 31 + n;
    }

    public String layerAbove() {
        return this.layerAbove;
    }

    public String layerBelow() {
        return this.layerBelow;
    }

    public float maxZoomIconScale() {
        return this.maxZoomIconScale;
    }

    public float minZoomIconScale() {
        return this.minZoomIconScale;
    }

    public int[] padding() {
        return this.padding;
    }

    public float pulseAlpha() {
        return this.pulseAlpha;
    }

    public Integer pulseColor() {
        return this.pulseColor;
    }

    public Boolean pulseEnabled() {
        return this.pulseEnabled;
    }

    public Boolean pulseFadeEnabled() {
        return this.pulseFadeEnabled;
    }

    public Interpolator pulseInterpolator() {
        return this.pulseInterpolator;
    }

    public float pulseMaxRadius() {
        return this.pulseMaxRadius;
    }

    public float pulseSingleDuration() {
        return this.pulseSingleDuration;
    }

    public long staleStateTimeout() {
        return this.staleStateTimeout;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LocationComponentOptions{accuracyAlpha=");
        stringBuilder.append(this.accuracyAlpha);
        stringBuilder.append(", accuracyColor=");
        stringBuilder.append(this.accuracyColor);
        stringBuilder.append(", backgroundDrawableStale=");
        stringBuilder.append(this.backgroundDrawableStale);
        stringBuilder.append(", backgroundStaleName=");
        stringBuilder.append(this.backgroundStaleName);
        stringBuilder.append(", foregroundDrawableStale=");
        stringBuilder.append(this.foregroundDrawableStale);
        stringBuilder.append(", foregroundStaleName=");
        stringBuilder.append(this.foregroundStaleName);
        stringBuilder.append(", gpsDrawable=");
        stringBuilder.append(this.gpsDrawable);
        stringBuilder.append(", gpsName=");
        stringBuilder.append(this.gpsName);
        stringBuilder.append(", foregroundDrawable=");
        stringBuilder.append(this.foregroundDrawable);
        stringBuilder.append(", foregroundName=");
        stringBuilder.append(this.foregroundName);
        stringBuilder.append(", backgroundDrawable=");
        stringBuilder.append(this.backgroundDrawable);
        stringBuilder.append(", backgroundName=");
        stringBuilder.append(this.backgroundName);
        stringBuilder.append(", bearingDrawable=");
        stringBuilder.append(this.bearingDrawable);
        stringBuilder.append(", bearingName=");
        stringBuilder.append(this.bearingName);
        stringBuilder.append(", bearingTintColor=");
        stringBuilder.append(this.bearingTintColor);
        stringBuilder.append(", foregroundTintColor=");
        stringBuilder.append(this.foregroundTintColor);
        stringBuilder.append(", backgroundTintColor=");
        stringBuilder.append(this.backgroundTintColor);
        stringBuilder.append(", foregroundStaleTintColor=");
        stringBuilder.append(this.foregroundStaleTintColor);
        stringBuilder.append(", backgroundStaleTintColor=");
        stringBuilder.append(this.backgroundStaleTintColor);
        stringBuilder.append(", elevation=");
        stringBuilder.append(this.elevation);
        stringBuilder.append(", enableStaleState=");
        stringBuilder.append(this.enableStaleState);
        stringBuilder.append(", staleStateTimeout=");
        stringBuilder.append(this.staleStateTimeout);
        stringBuilder.append(", padding=");
        stringBuilder.append(Arrays.toString(this.padding));
        stringBuilder.append(", maxZoomIconScale=");
        stringBuilder.append(this.maxZoomIconScale);
        stringBuilder.append(", minZoomIconScale=");
        stringBuilder.append(this.minZoomIconScale);
        stringBuilder.append(", trackingGesturesManagement=");
        stringBuilder.append(this.trackingGesturesManagement);
        stringBuilder.append(", trackingInitialMoveThreshold=");
        stringBuilder.append(this.trackingInitialMoveThreshold);
        stringBuilder.append(", trackingMultiFingerMoveThreshold=");
        stringBuilder.append(this.trackingMultiFingerMoveThreshold);
        stringBuilder.append(", trackingMultiFingerProtectedMoveArea=");
        stringBuilder.append(this.trackingMultiFingerProtectedMoveArea);
        stringBuilder.append(", layerAbove=");
        stringBuilder.append(this.layerAbove);
        stringBuilder.append("layerBelow=");
        stringBuilder.append(this.layerBelow);
        stringBuilder.append("trackingAnimationDurationMultiplier=");
        stringBuilder.append(this.trackingAnimationDurationMultiplier);
        stringBuilder.append("pulseEnabled=");
        stringBuilder.append(this.pulseEnabled);
        stringBuilder.append("pulseFadeEnabled=");
        stringBuilder.append(this.pulseFadeEnabled);
        stringBuilder.append("pulseColor=");
        stringBuilder.append(this.pulseColor);
        stringBuilder.append("pulseSingleDuration=");
        stringBuilder.append(this.pulseSingleDuration);
        stringBuilder.append("pulseMaxRadius=");
        stringBuilder.append(this.pulseMaxRadius);
        stringBuilder.append("pulseAlpha=");
        stringBuilder.append(this.pulseAlpha);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public float trackingAnimationDurationMultiplier() {
        return this.trackingAnimationDurationMultiplier;
    }

    public boolean trackingGesturesManagement() {
        return this.trackingGesturesManagement;
    }

    public float trackingInitialMoveThreshold() {
        return this.trackingInitialMoveThreshold;
    }

    public float trackingMultiFingerMoveThreshold() {
        return this.trackingMultiFingerMoveThreshold;
    }

    public RectF trackingMultiFingerProtectedMoveArea() {
        return this.trackingMultiFingerProtectedMoveArea;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeFloat(this.accuracyAlpha);
        parcel.writeInt(this.accuracyColor);
        parcel.writeInt(this.backgroundDrawableStale);
        parcel.writeString(this.backgroundStaleName);
        parcel.writeInt(this.foregroundDrawableStale);
        parcel.writeString(this.foregroundStaleName);
        parcel.writeInt(this.gpsDrawable);
        parcel.writeString(this.gpsName);
        parcel.writeInt(this.foregroundDrawable);
        parcel.writeString(this.foregroundName);
        parcel.writeInt(this.backgroundDrawable);
        parcel.writeString(this.backgroundName);
        parcel.writeInt(this.bearingDrawable);
        parcel.writeString(this.bearingName);
        parcel.writeValue((Object)this.bearingTintColor);
        parcel.writeValue((Object)this.foregroundTintColor);
        parcel.writeValue((Object)this.backgroundTintColor);
        parcel.writeValue((Object)this.foregroundStaleTintColor);
        parcel.writeValue((Object)this.backgroundStaleTintColor);
        parcel.writeFloat(this.elevation);
        parcel.writeByte((byte)(this.enableStaleState ? 1 : 0));
        parcel.writeLong(this.staleStateTimeout);
        parcel.writeIntArray(this.padding);
        parcel.writeFloat(this.maxZoomIconScale);
        parcel.writeFloat(this.minZoomIconScale);
        parcel.writeByte((byte)(this.trackingGesturesManagement ? 1 : 0));
        parcel.writeFloat(this.trackingInitialMoveThreshold);
        parcel.writeFloat(this.trackingMultiFingerMoveThreshold);
        parcel.writeParcelable((Parcelable)this.trackingMultiFingerProtectedMoveArea, n);
        parcel.writeString(this.layerAbove);
        parcel.writeString(this.layerBelow);
        parcel.writeFloat(this.trackingAnimationDurationMultiplier);
        parcel.writeByte((byte)(this.compassAnimationEnabled ? 1 : 0));
        parcel.writeByte((byte)(this.accuracyAnimationEnabled ? 1 : 0));
        parcel.writeValue((Object)this.pulseEnabled);
        parcel.writeValue((Object)this.pulseFadeEnabled);
        parcel.writeValue((Object)this.pulseColor);
        parcel.writeFloat(this.pulseSingleDuration);
        parcel.writeFloat(this.pulseMaxRadius);
        parcel.writeFloat(this.pulseAlpha);
    }

    public static class Builder {
        private Float accuracyAlpha;
        private Boolean accuracyAnimationEnabled;
        private Integer accuracyColor;
        private Integer backgroundDrawable;
        private Integer backgroundDrawableStale;
        private String backgroundName;
        private String backgroundStaleName;
        private Integer backgroundStaleTintColor;
        private Integer backgroundTintColor;
        private Integer bearingDrawable;
        private String bearingName;
        private Integer bearingTintColor;
        private Boolean compassAnimationEnabled;
        private Float elevation;
        private Boolean enableStaleState;
        private Integer foregroundDrawable;
        private Integer foregroundDrawableStale;
        private String foregroundName;
        private String foregroundStaleName;
        private Integer foregroundStaleTintColor;
        private Integer foregroundTintColor;
        private Integer gpsDrawable;
        private String gpsName;
        private String layerAbove;
        private String layerBelow;
        private Float maxZoomIconScale;
        private Float minZoomIconScale;
        private int[] padding;
        private float pulseAlpha;
        private int pulseColor;
        private Boolean pulseEnabled;
        private Boolean pulseFadeEnabled;
        private Interpolator pulseInterpolator;
        private float pulseMaxRadius;
        private float pulseSingleDuration;
        private Long staleStateTimeout;
        private Float trackingAnimationDurationMultiplier;
        private Boolean trackingGesturesManagement;
        private Float trackingInitialMoveThreshold;
        private Float trackingMultiFingerMoveThreshold;
        private RectF trackingMultiFingerProtectedMoveArea;

        Builder() {
        }

        private Builder(LocationComponentOptions locationComponentOptions) {
            this.accuracyAlpha = Float.valueOf(locationComponentOptions.accuracyAlpha());
            this.accuracyColor = locationComponentOptions.accuracyColor();
            this.backgroundDrawableStale = locationComponentOptions.backgroundDrawableStale();
            this.backgroundStaleName = locationComponentOptions.backgroundStaleName();
            this.foregroundDrawableStale = locationComponentOptions.foregroundDrawableStale();
            this.foregroundStaleName = locationComponentOptions.foregroundStaleName();
            this.gpsDrawable = locationComponentOptions.gpsDrawable();
            this.gpsName = locationComponentOptions.gpsName();
            this.foregroundDrawable = locationComponentOptions.foregroundDrawable();
            this.foregroundName = locationComponentOptions.foregroundName();
            this.backgroundDrawable = locationComponentOptions.backgroundDrawable();
            this.backgroundName = locationComponentOptions.backgroundName();
            this.bearingDrawable = locationComponentOptions.bearingDrawable();
            this.bearingName = locationComponentOptions.bearingName();
            this.bearingTintColor = locationComponentOptions.bearingTintColor();
            this.foregroundTintColor = locationComponentOptions.foregroundTintColor();
            this.backgroundTintColor = locationComponentOptions.backgroundTintColor();
            this.foregroundStaleTintColor = locationComponentOptions.foregroundStaleTintColor();
            this.backgroundStaleTintColor = locationComponentOptions.backgroundStaleTintColor();
            this.elevation = Float.valueOf(locationComponentOptions.elevation());
            this.enableStaleState = locationComponentOptions.enableStaleState();
            this.staleStateTimeout = locationComponentOptions.staleStateTimeout();
            this.padding = locationComponentOptions.padding();
            this.maxZoomIconScale = Float.valueOf(locationComponentOptions.maxZoomIconScale());
            this.minZoomIconScale = Float.valueOf(locationComponentOptions.minZoomIconScale());
            this.trackingGesturesManagement = locationComponentOptions.trackingGesturesManagement();
            this.trackingInitialMoveThreshold = Float.valueOf(locationComponentOptions.trackingInitialMoveThreshold());
            this.trackingMultiFingerMoveThreshold = Float.valueOf(locationComponentOptions.trackingMultiFingerMoveThreshold());
            this.trackingMultiFingerProtectedMoveArea = locationComponentOptions.trackingMultiFingerProtectedMoveArea();
            this.layerAbove = locationComponentOptions.layerAbove();
            this.layerBelow = locationComponentOptions.layerBelow();
            this.trackingAnimationDurationMultiplier = Float.valueOf(locationComponentOptions.trackingAnimationDurationMultiplier());
            this.compassAnimationEnabled = locationComponentOptions.compassAnimationEnabled();
            this.accuracyAnimationEnabled = locationComponentOptions.accuracyAnimationEnabled();
            this.pulseEnabled = locationComponentOptions.pulseEnabled;
            this.pulseFadeEnabled = locationComponentOptions.pulseFadeEnabled;
            this.pulseColor = locationComponentOptions.pulseColor;
            this.pulseSingleDuration = locationComponentOptions.pulseSingleDuration;
            this.pulseMaxRadius = locationComponentOptions.pulseMaxRadius;
            this.pulseAlpha = locationComponentOptions.pulseAlpha;
            this.pulseInterpolator = locationComponentOptions.pulseInterpolator;
        }

        static /* synthetic */ Boolean access$002(Builder builder, Boolean bl) {
            builder.compassAnimationEnabled = bl;
            return bl;
        }

        static /* synthetic */ Boolean access$102(Builder builder, Boolean bl) {
            builder.accuracyAnimationEnabled = bl;
            return bl;
        }

        static /* synthetic */ Boolean access$202(Builder builder, Boolean bl) {
            builder.pulseEnabled = bl;
            return bl;
        }

        static /* synthetic */ Boolean access$302(Builder builder, Boolean bl) {
            builder.pulseFadeEnabled = bl;
            return bl;
        }

        static /* synthetic */ float access$402(Builder builder, float f) {
            builder.pulseSingleDuration = f;
            return f;
        }

        static /* synthetic */ float access$502(Builder builder, float f) {
            builder.pulseMaxRadius = f;
            return f;
        }

        static /* synthetic */ float access$602(Builder builder, float f) {
            builder.pulseAlpha = f;
            return f;
        }

        public Builder accuracyAlpha(float f) {
            this.accuracyAlpha = Float.valueOf(f);
            return this;
        }

        public Builder accuracyAnimationEnabled(boolean bl) {
            this.accuracyAnimationEnabled = bl;
            return this;
        }

        public Builder accuracyColor(int n) {
            this.accuracyColor = n;
            return this;
        }

        LocationComponentOptions autoBuild() {
            Object object = this.accuracyAlpha;
            Object object2 = "";
            if (object == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("");
                ((StringBuilder)object2).append(" accuracyAlpha");
                object2 = ((StringBuilder)object2).toString();
            }
            object = object2;
            if (this.accuracyColor == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" accuracyColor");
                object = ((StringBuilder)object).toString();
            }
            object2 = object;
            if (this.backgroundDrawableStale == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(" backgroundDrawableStale");
                object2 = ((StringBuilder)object2).toString();
            }
            object = object2;
            if (this.foregroundDrawableStale == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" foregroundDrawableStale");
                object = ((StringBuilder)object).toString();
            }
            object2 = object;
            if (this.gpsDrawable == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(" gpsDrawable");
                object2 = ((StringBuilder)object2).toString();
            }
            object = object2;
            if (this.foregroundDrawable == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" foregroundDrawable");
                object = ((StringBuilder)object).toString();
            }
            object2 = object;
            if (this.backgroundDrawable == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(" backgroundDrawable");
                object2 = ((StringBuilder)object2).toString();
            }
            object = object2;
            if (this.bearingDrawable == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" bearingDrawable");
                object = ((StringBuilder)object).toString();
            }
            object2 = object;
            if (this.elevation == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(" elevation");
                object2 = ((StringBuilder)object2).toString();
            }
            object = object2;
            if (this.enableStaleState == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" enableStaleState");
                object = ((StringBuilder)object).toString();
            }
            object2 = object;
            if (this.staleStateTimeout == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(" staleStateTimeout");
                object2 = ((StringBuilder)object2).toString();
            }
            object = object2;
            if (this.padding == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" padding");
                object = ((StringBuilder)object).toString();
            }
            object2 = object;
            if (this.maxZoomIconScale == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(" maxZoomIconScale");
                object2 = ((StringBuilder)object2).toString();
            }
            Object object3 = object2;
            if (this.minZoomIconScale == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" minZoomIconScale");
                object3 = ((StringBuilder)object).toString();
            }
            object = object3;
            if (this.trackingGesturesManagement == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object3);
                ((StringBuilder)object2).append(" trackingGesturesManagement");
                object = ((StringBuilder)object2).toString();
            }
            object2 = object;
            if (this.trackingInitialMoveThreshold == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(" trackingInitialMoveThreshold");
                object2 = ((StringBuilder)object2).toString();
            }
            object = object2;
            if (this.trackingMultiFingerMoveThreshold == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" trackingMultiFingerMoveThreshold");
                object = ((StringBuilder)object).toString();
            }
            object2 = object;
            if (this.trackingAnimationDurationMultiplier == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(" trackingAnimationDurationMultiplier");
                object2 = ((StringBuilder)object2).toString();
            }
            if (((String)object2).isEmpty()) {
                return new LocationComponentOptions(this.accuracyAlpha.floatValue(), this.accuracyColor, this.backgroundDrawableStale, this.backgroundStaleName, this.foregroundDrawableStale, this.foregroundStaleName, this.gpsDrawable, this.gpsName, this.foregroundDrawable, this.foregroundName, this.backgroundDrawable, this.backgroundName, this.bearingDrawable, this.bearingName, this.bearingTintColor, this.foregroundTintColor, this.backgroundTintColor, this.foregroundStaleTintColor, this.backgroundStaleTintColor, this.elevation.floatValue(), this.enableStaleState, this.staleStateTimeout, this.padding, this.maxZoomIconScale.floatValue(), this.minZoomIconScale.floatValue(), this.trackingGesturesManagement, this.trackingInitialMoveThreshold.floatValue(), this.trackingMultiFingerMoveThreshold.floatValue(), this.trackingMultiFingerProtectedMoveArea, this.layerAbove, this.layerBelow, this.trackingAnimationDurationMultiplier.floatValue(), this.compassAnimationEnabled, this.accuracyAnimationEnabled, this.pulseEnabled, this.pulseFadeEnabled, this.pulseColor, this.pulseSingleDuration, this.pulseMaxRadius, this.pulseAlpha, this.pulseInterpolator);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Missing required properties:");
            ((StringBuilder)object).append((String)object2);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }

        public Builder backgroundDrawable(int n) {
            this.backgroundDrawable = n;
            return this;
        }

        public Builder backgroundDrawableStale(int n) {
            this.backgroundDrawableStale = n;
            return this;
        }

        public Builder backgroundName(String string2) {
            this.backgroundName = string2;
            return this;
        }

        public Builder backgroundStaleName(String string2) {
            this.backgroundStaleName = string2;
            return this;
        }

        public Builder backgroundStaleTintColor(Integer n) {
            this.backgroundStaleTintColor = n;
            return this;
        }

        public Builder backgroundTintColor(Integer n) {
            this.backgroundTintColor = n;
            return this;
        }

        public Builder bearingDrawable(int n) {
            this.bearingDrawable = n;
            return this;
        }

        public Builder bearingName(String string2) {
            this.bearingName = string2;
            return this;
        }

        public Builder bearingTintColor(Integer n) {
            this.bearingTintColor = n;
            return this;
        }

        public LocationComponentOptions build() {
            LocationComponentOptions locationComponentOptions = this.autoBuild();
            if (!(locationComponentOptions.accuracyAlpha() < 0.0f) && !(locationComponentOptions.accuracyAlpha() > 1.0f)) {
                if (!(locationComponentOptions.elevation() < 0.0f)) {
                    if (locationComponentOptions.layerAbove() != null && locationComponentOptions.layerBelow() != null) {
                        throw new IllegalArgumentException("You cannot set both layerAbove and layerBelow options. Choose one or the other.");
                    }
                    if (locationComponentOptions.pulseEnabled() == null) {
                        CharSequence charSequence;
                        CharSequence charSequence2 = "";
                        if (locationComponentOptions.pulseFadeEnabled() != null) {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("");
                            ((StringBuilder)charSequence).append(" pulseFadeEnabled");
                            charSequence2 = ((StringBuilder)charSequence).toString();
                        }
                        charSequence = charSequence2;
                        if (locationComponentOptions.pulseColor() != null) {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append((String)charSequence2);
                            ((StringBuilder)charSequence).append(" pulseColor");
                            charSequence = ((StringBuilder)charSequence).toString();
                        }
                        charSequence2 = charSequence;
                        if (locationComponentOptions.pulseSingleDuration() > 0.0f) {
                            charSequence2 = new StringBuilder();
                            ((StringBuilder)charSequence2).append((String)charSequence);
                            ((StringBuilder)charSequence2).append(" pulseSingleDuration");
                            charSequence2 = ((StringBuilder)charSequence2).toString();
                        }
                        CharSequence charSequence3 = charSequence2;
                        if (locationComponentOptions.pulseMaxRadius() > 0.0f) {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append((String)charSequence2);
                            ((StringBuilder)charSequence).append(" pulseMaxRadius");
                            charSequence3 = ((StringBuilder)charSequence).toString();
                        }
                        charSequence = charSequence3;
                        if (locationComponentOptions.pulseAlpha() >= 0.0f) {
                            charSequence = charSequence3;
                            if (locationComponentOptions.pulseAlpha() <= 1.0f) {
                                charSequence = new StringBuilder();
                                ((StringBuilder)charSequence).append((String)charSequence3);
                                ((StringBuilder)charSequence).append(" pulseAlpha");
                                charSequence = ((StringBuilder)charSequence).toString();
                            }
                        }
                        charSequence2 = charSequence;
                        if (locationComponentOptions.pulseInterpolator() != null) {
                            charSequence2 = new StringBuilder();
                            ((StringBuilder)charSequence2).append((String)charSequence);
                            ((StringBuilder)charSequence2).append(" pulseInterpolator");
                            charSequence2 = ((StringBuilder)charSequence2).toString();
                        }
                        if (!((String)charSequence2).isEmpty()) {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("You've set up the following pulsing circle options but have not enabled the pulsing circle via the LocationComponentOptions builder:");
                            ((StringBuilder)charSequence).append((String)charSequence2);
                            ((StringBuilder)charSequence).append(". Enable the pulsing circle if you're going to set pulsing options.");
                            throw new IllegalStateException(((StringBuilder)charSequence).toString());
                        }
                    }
                    return locationComponentOptions;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Invalid shadow size ");
                stringBuilder.append(locationComponentOptions.elevation());
                stringBuilder.append(". Must be >= 0");
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            throw new IllegalArgumentException("Accuracy alpha value must be between 0.0 and 1.0.");
        }

        public Builder compassAnimationEnabled(Boolean bl) {
            this.compassAnimationEnabled = bl;
            return this;
        }

        public Builder elevation(float f) {
            this.elevation = Float.valueOf(f);
            return this;
        }

        public Builder enableStaleState(boolean bl) {
            this.enableStaleState = bl;
            return this;
        }

        public Builder foregroundDrawable(int n) {
            this.foregroundDrawable = n;
            return this;
        }

        public Builder foregroundDrawableStale(int n) {
            this.foregroundDrawableStale = n;
            return this;
        }

        public Builder foregroundName(String string2) {
            this.foregroundName = string2;
            return this;
        }

        public Builder foregroundStaleName(String string2) {
            this.foregroundStaleName = string2;
            return this;
        }

        public Builder foregroundStaleTintColor(Integer n) {
            this.foregroundStaleTintColor = n;
            return this;
        }

        public Builder foregroundTintColor(Integer n) {
            this.foregroundTintColor = n;
            return this;
        }

        public Builder gpsDrawable(int n) {
            this.gpsDrawable = n;
            return this;
        }

        public Builder gpsName(String string2) {
            this.gpsName = string2;
            return this;
        }

        public Builder layerAbove(String string2) {
            this.layerAbove = string2;
            return this;
        }

        public Builder layerBelow(String string2) {
            this.layerBelow = string2;
            return this;
        }

        public Builder maxZoomIconScale(float f) {
            this.maxZoomIconScale = Float.valueOf(f);
            return this;
        }

        public Builder minZoomIconScale(float f) {
            this.minZoomIconScale = Float.valueOf(f);
            return this;
        }

        @Deprecated
        public Builder padding(int[] nArray) {
            Objects.requireNonNull(nArray, "Null padding");
            this.padding = nArray;
            return this;
        }

        public Builder pulseAlpha(float f) {
            this.pulseAlpha = f;
            return this;
        }

        public Builder pulseColor(int n) {
            this.pulseColor = n;
            return this;
        }

        public Builder pulseEnabled(boolean bl) {
            this.pulseEnabled = bl;
            return this;
        }

        public Builder pulseFadeEnabled(boolean bl) {
            this.pulseFadeEnabled = bl;
            return this;
        }

        public Builder pulseInterpolator(Interpolator interpolator2) {
            this.pulseInterpolator = interpolator2;
            return this;
        }

        public Builder pulseMaxRadius(float f) {
            this.pulseMaxRadius = f;
            return this;
        }

        public Builder pulseSingleDuration(float f) {
            this.pulseSingleDuration = f;
            return this;
        }

        public Builder staleStateTimeout(long l) {
            this.staleStateTimeout = l;
            return this;
        }

        public Builder trackingAnimationDurationMultiplier(float f) {
            this.trackingAnimationDurationMultiplier = Float.valueOf(f);
            return this;
        }

        public Builder trackingGesturesManagement(boolean bl) {
            this.trackingGesturesManagement = bl;
            return this;
        }

        public Builder trackingInitialMoveThreshold(float f) {
            this.trackingInitialMoveThreshold = Float.valueOf(f);
            return this;
        }

        public Builder trackingMultiFingerMoveThreshold(float f) {
            this.trackingMultiFingerMoveThreshold = Float.valueOf(f);
            return this;
        }

        public Builder trackingMultiFingerProtectedMoveArea(RectF rectF) {
            this.trackingMultiFingerProtectedMoveArea = rectF;
            return this;
        }
    }
}

