/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.location.Location;
import java.util.Collections;
import java.util.List;

public class LocationUpdate {
    private final Long animationDuration;
    private final List<Location> intermediatePoints;
    private final Location location;

    private LocationUpdate(Location location, List<Location> list, Long l) {
        this.location = location;
        this.intermediatePoints = list;
        this.animationDuration = l;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            LocationUpdate locationUpdate = (LocationUpdate)object;
            if (!this.location.equals(locationUpdate.location)) {
                return false;
            }
            if (!this.intermediatePoints.equals(locationUpdate.intermediatePoints)) {
                return false;
            }
            object = this.animationDuration;
            if (object != null) {
                bl = ((Long)object).equals(locationUpdate.animationDuration);
            } else if (locationUpdate.animationDuration != null) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public Long getAnimationDuration() {
        return this.animationDuration;
    }

    public List<Location> getIntermediatePoints() {
        return this.intermediatePoints;
    }

    public Location getLocation() {
        return this.location;
    }

    public int hashCode() {
        int n = this.location.hashCode();
        int n2 = this.intermediatePoints.hashCode();
        Long l = this.animationDuration;
        int n3 = l != null ? l.hashCode() : 0;
        return (n * 31 + n2) * 31 + n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LocationUpdate{location=");
        stringBuilder.append(this.location);
        stringBuilder.append(", intermediatePoints=");
        stringBuilder.append(this.intermediatePoints);
        stringBuilder.append(", animationDuration=");
        stringBuilder.append(this.animationDuration);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static class Builder {
        private Long animationDuration;
        private List<Location> intermediatePoints = Collections.emptyList();
        private Location location;

        public Builder animationDuration(Long l) {
            this.animationDuration = l;
            return this;
        }

        public LocationUpdate build() {
            Location location = this.location;
            if (location != null) {
                return new LocationUpdate(location, this.intermediatePoints, this.animationDuration);
            }
            throw new IllegalArgumentException("target location has to be provided when constructing the LocationUpdate");
        }

        public Builder intermediatePoints(List<Location> list) {
            this.intermediatePoints = list;
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }
    }
}

