/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.location.Location;
import android.os.Build;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;

public final class Utils {
    private static final String TAG = "Mbgl-com.mapbox.mapboxsdk.location.Utils";

    private Utils() {
    }

    static float calculateZoomLevelRadius(MapboxMap mapboxMap, Location location) {
        if (location == null) {
            return 0.0f;
        }
        double d = mapboxMap.getProjection().getMetersPerPixelAtLatitude(location.getLatitude());
        return (float)((double)location.getAccuracy() * (1.0 / d));
    }

    private static void ensureShadowGradientRadius(Drawable drawable2) {
        if (drawable2 instanceof GradientDrawable) {
            ((GradientDrawable)drawable2).setGradientRadius(1.0f);
        } else if (drawable2 instanceof LayerDrawable) {
            drawable2 = (LayerDrawable)drawable2;
            for (int i = 0; i < drawable2.getNumberOfLayers(); ++i) {
                Drawable drawable3 = drawable2.getDrawable(i);
                if (!(drawable3 instanceof GradientDrawable)) continue;
                ((GradientDrawable)drawable3).setGradientRadius(1.0f);
            }
        }
    }

    static Bitmap generateShadow(Drawable drawable2, float f) {
        int n = drawable2.getIntrinsicWidth();
        int n2 = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        try {
            drawable2.draw(canvas);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().equals("radius must be > 0") && Build.VERSION.SDK_INT < 21) {
                Logger.w(TAG, "Location's shadow gradient drawable has a radius <= 0px, resetting to 1px in order to avoid crashing");
                Utils.ensureShadowGradientRadius(drawable2);
                return Utils.generateShadow(drawable2, f);
            }
            throw illegalArgumentException;
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)Utils.toEven((float)n + f), (int)Utils.toEven((float)n2 + f), (boolean)false);
    }

    static boolean immediateAnimation(Projection projection, LatLng latLng, LatLng latLng2) {
        double d = projection.getMetersPerPixelAtLatitude((latLng.getLatitude() + latLng2.getLatitude()) / 2.0);
        boolean bl = latLng.distanceTo(latLng2) / d > 50000.0;
        return bl;
    }

    public static float normalize(float f) {
        return (f % 360.0f + 360.0f) % 360.0f;
    }

    public static float shortestRotation(float f, float f2) {
        double d = f2 - f;
        if (d > 180.0) {
            f2 = f + 360.0f;
        } else {
            f2 = f;
            if (d < -180.0) {
                f2 = f - 360.0f;
            }
        }
        return f2;
    }

    private static int toEven(float f) {
        int n;
        int n2 = n = (int)(f + 0.5f);
        if (n % 2 == 1) {
            n2 = n - 1;
        }
        return n2;
    }
}

