/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.log;

import android.util.Log;
import com.mapbox.mapboxsdk.log.LoggerDefinition;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class Logger {
    public static final int DEBUG = 3;
    private static final LoggerDefinition DEFAULT;
    public static final int ERROR = 6;
    public static final int INFO = 4;
    public static final int NONE = 99;
    public static final int VERBOSE = 2;
    public static final int WARN = 5;
    private static int logLevel;
    private static volatile LoggerDefinition logger;

    static {
        LoggerDefinition loggerDefinition;
        DEFAULT = loggerDefinition = new LoggerDefinition(){

            @Override
            public void d(String string2, String string3) {
                Log.d((String)string2, (String)string3);
            }

            @Override
            public void d(String string2, String string3, Throwable throwable) {
                Log.d((String)string2, (String)string3, (Throwable)throwable);
            }

            @Override
            public void e(String string2, String string3) {
                Log.e((String)string2, (String)string3);
            }

            @Override
            public void e(String string2, String string3, Throwable throwable) {
                Log.e((String)string2, (String)string3, (Throwable)throwable);
            }

            @Override
            public void i(String string2, String string3) {
                Log.i((String)string2, (String)string3);
            }

            @Override
            public void i(String string2, String string3, Throwable throwable) {
                Log.i((String)string2, (String)string3, (Throwable)throwable);
            }

            @Override
            public void v(String string2, String string3) {
                Log.v((String)string2, (String)string3);
            }

            @Override
            public void v(String string2, String string3, Throwable throwable) {
                Log.v((String)string2, (String)string3, (Throwable)throwable);
            }

            @Override
            public void w(String string2, String string3) {
                Log.w((String)string2, (String)string3);
            }

            @Override
            public void w(String string2, String string3, Throwable throwable) {
                Log.w((String)string2, (String)string3, (Throwable)throwable);
            }
        };
        logger = loggerDefinition;
    }

    public static void d(String string2, String string3) {
        if (logLevel <= 3) {
            logger.d(string2, string3);
        }
    }

    public static void d(String string2, String string3, Throwable throwable) {
        if (logLevel <= 3) {
            logger.d(string2, string3, throwable);
        }
    }

    public static void e(String string2, String string3) {
        if (logLevel <= 6) {
            logger.e(string2, string3);
        }
    }

    public static void e(String string2, String string3, Throwable throwable) {
        if (logLevel <= 6) {
            logger.e(string2, string3, throwable);
        }
    }

    public static void i(String string2, String string3) {
        if (logLevel <= 4) {
            logger.i(string2, string3);
        }
    }

    public static void i(String string2, String string3, Throwable throwable) {
        if (logLevel <= 4) {
            logger.i(string2, string3, throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void log(int n, String string2, String string3) {
        if (n != 2) {
            if (n != 3) {
                if (n != 4) {
                    if (n != 5) {
                        if (n != 6) throw new UnsupportedOperationException();
                        Logger.e(string2, string3);
                        return;
                    } else {
                        Logger.w(string2, string3);
                    }
                    return;
                } else {
                    Logger.i(string2, string3);
                }
                return;
            } else {
                Logger.d(string2, string3);
            }
            return;
        } else {
            Logger.v(string2, string3);
        }
    }

    public static void setLoggerDefinition(LoggerDefinition loggerDefinition) {
        logger = loggerDefinition;
    }

    public static void setVerbosity(int n) {
        logLevel = n;
    }

    public static void v(String string2, String string3) {
        if (logLevel <= 2) {
            logger.v(string2, string3);
        }
    }

    public static void v(String string2, String string3, Throwable throwable) {
        if (logLevel <= 2) {
            logger.v(string2, string3, throwable);
        }
    }

    public static void w(String string2, String string3) {
        if (logLevel <= 5) {
            logger.w(string2, string3);
        }
    }

    public static void w(String string2, String string3, Throwable throwable) {
        if (logLevel <= 5) {
            logger.w(string2, string3, throwable);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

