/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import androidx.collection.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.maps.Annotations;
import com.mapbox.mapboxsdk.maps.NativeMap;
import java.util.ArrayList;
import java.util.List;

class AnnotationContainer
implements Annotations {
    private final LongSparseArray<Annotation> annotations;
    private final NativeMap nativeMap;

    AnnotationContainer(NativeMap nativeMap, LongSparseArray<Annotation> longSparseArray) {
        this.nativeMap = nativeMap;
        this.annotations = longSparseArray;
    }

    private void removeNativeAnnotations(long[] lArray) {
        NativeMap nativeMap = this.nativeMap;
        if (nativeMap != null) {
            nativeMap.removeAnnotations(lArray);
        }
    }

    @Override
    public List<Annotation> obtainAll() {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            LongSparseArray<Annotation> longSparseArray = this.annotations;
            arrayList.add((Annotation)longSparseArray.get(longSparseArray.keyAt(i)));
        }
        return arrayList;
    }

    @Override
    public Annotation obtainBy(long l) {
        return (Annotation)this.annotations.get(l);
    }

    @Override
    public void removeAll() {
        int n = this.annotations.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.annotations.keyAt(i);
        }
        this.removeNativeAnnotations(lArray);
        this.annotations.clear();
    }

    @Override
    public void removeBy(long l) {
        NativeMap nativeMap = this.nativeMap;
        if (nativeMap != null) {
            nativeMap.removeAnnotation(l);
        }
        this.annotations.remove(l);
    }

    @Override
    public void removeBy(Annotation annotation) {
        this.removeBy(annotation.getId());
    }

    @Override
    public void removeBy(List<? extends Annotation> list) {
        int n;
        int n2 = list.size();
        long[] lArray = new long[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            lArray[n] = list.get(n).getId();
        }
        this.removeNativeAnnotations(lArray);
        for (n = n3; n < n2; ++n) {
            long l = lArray[n];
            this.annotations.remove(l);
        }
    }
}

