/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import androidx.collection.LongSparseArray;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.Annotations;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.InfoWindowManager;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Markers;
import com.mapbox.mapboxsdk.maps.Polygons;
import com.mapbox.mapboxsdk.maps.Polylines;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.ShapeAnnotations;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class AnnotationManager {
    private static final long NO_ANNOTATION_ID = -1L;
    private static final String TAG = "Mbgl-AnnotationManager";
    private Annotations annotations;
    private final LongSparseArray<Annotation> annotationsArray;
    private final IconManager iconManager;
    private final InfoWindowManager infoWindowManager = new InfoWindowManager();
    private final MapView mapView;
    private MapboxMap mapboxMap;
    private Markers markers;
    private MapboxMap.OnMarkerClickListener onMarkerClickListener;
    private MapboxMap.OnPolygonClickListener onPolygonClickListener;
    private MapboxMap.OnPolylineClickListener onPolylineClickListener;
    private Polygons polygons;
    private Polylines polylines;
    private final List<Marker> selectedMarkers = new ArrayList<Marker>();
    private ShapeAnnotations shapeAnnotations;

    AnnotationManager(MapView mapView, LongSparseArray<Annotation> longSparseArray, IconManager iconManager, Annotations annotations, Markers markers, Polygons polygons, Polylines polylines, ShapeAnnotations shapeAnnotations) {
        this.mapView = mapView;
        this.annotationsArray = longSparseArray;
        this.iconManager = iconManager;
        this.annotations = annotations;
        this.markers = markers;
        this.polygons = polygons;
        this.polylines = polylines;
        this.shapeAnnotations = shapeAnnotations;
    }

    private MarkerHit getMarkerHitFromTouchArea(PointF pointF) {
        int n = (int)((double)this.iconManager.getHighestIconHeight() * 1.5);
        int n2 = (int)((double)this.iconManager.getHighestIconWidth() * 1.5);
        float f = pointF.x;
        float f2 = n;
        float f3 = pointF.y;
        float f4 = n2;
        pointF = new RectF(f - f2, f3 - f4, pointF.x + f2, pointF.y + f4);
        return new MarkerHit((RectF)pointF, this.getMarkersInRect((RectF)pointF));
    }

    private ShapeAnnotationHit getShapeAnnotationHitFromTap(PointF pointF) {
        float f = Mapbox.getApplicationContext().getResources().getDimension(R.dimen.mapbox_eight_dp);
        return new ShapeAnnotationHit(new RectF(pointF.x - f, pointF.y - f, pointF.x + f, pointF.y + f));
    }

    private boolean handleClickForShapeAnnotation(Annotation annotation) {
        Object object;
        if (annotation instanceof Polygon && (object = this.onPolygonClickListener) != null) {
            object.onPolygonClick((Polygon)annotation);
            return true;
        }
        if (annotation instanceof Polyline && (object = this.onPolylineClickListener) != null) {
            object.onPolylineClick((Polyline)annotation);
            return true;
        }
        return false;
    }

    private boolean isAddedToMap(Annotation annotation) {
        boolean bl = annotation != null && annotation.getId() != -1L && this.annotationsArray.indexOfKey(annotation.getId()) > -1;
        return bl;
    }

    private boolean isClickHandledForMarker(long l) {
        Marker marker = (Marker)this.getAnnotation(l);
        if (!this.onClickMarker(marker)) {
            this.toggleMarkerSelectionState(marker);
        }
        return true;
    }

    private void logNonAdded(Annotation annotation) {
        Logger.w(TAG, String.format("Attempting to update non-added %s with value %s", annotation.getClass().getCanonicalName(), annotation));
    }

    private boolean onClickMarker(Marker marker) {
        MapboxMap.OnMarkerClickListener onMarkerClickListener = this.onMarkerClickListener;
        boolean bl = onMarkerClickListener != null && onMarkerClickListener.onMarkerClick(marker);
        return bl;
    }

    private void toggleMarkerSelectionState(Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            this.selectMarker(marker);
        } else {
            this.deselectMarker(marker);
        }
    }

    Marker addMarker(BaseMarkerOptions baseMarkerOptions, MapboxMap mapboxMap) {
        return this.markers.addBy(baseMarkerOptions, mapboxMap);
    }

    List<Marker> addMarkers(List<? extends BaseMarkerOptions> list, MapboxMap mapboxMap) {
        return this.markers.addBy(list, mapboxMap);
    }

    Polygon addPolygon(PolygonOptions polygonOptions, MapboxMap mapboxMap) {
        return this.polygons.addBy(polygonOptions, mapboxMap);
    }

    List<Polygon> addPolygons(List<PolygonOptions> list, MapboxMap mapboxMap) {
        return this.polygons.addBy(list, mapboxMap);
    }

    Polyline addPolyline(PolylineOptions polylineOptions, MapboxMap mapboxMap) {
        return this.polylines.addBy(polylineOptions, mapboxMap);
    }

    List<Polyline> addPolylines(List<PolylineOptions> list, MapboxMap mapboxMap) {
        return this.polylines.addBy(list, mapboxMap);
    }

    void adjustTopOffsetPixels(MapboxMap mapboxMap) {
        int n = this.annotationsArray.size();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = (Annotation)this.annotationsArray.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(marker.getIcon()));
        }
        for (Marker marker : this.selectedMarkers) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
            marker.showInfoWindow(mapboxMap, this.mapView);
        }
    }

    AnnotationManager bind(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
        return this;
    }

    void deselectMarker(Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            return;
        }
        if (marker.isInfoWindowShown()) {
            marker.hideInfoWindow();
        }
        this.selectedMarkers.remove(marker);
    }

    void deselectMarkers() {
        if (this.selectedMarkers.isEmpty()) {
            return;
        }
        for (Marker marker : this.selectedMarkers) {
            if (marker == null || !marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
        }
        this.selectedMarkers.clear();
    }

    Annotation getAnnotation(long l) {
        return this.annotations.obtainBy(l);
    }

    List<Annotation> getAnnotations() {
        return this.annotations.obtainAll();
    }

    InfoWindowManager getInfoWindowManager() {
        return this.infoWindowManager;
    }

    List<Marker> getMarkers() {
        return this.markers.obtainAll();
    }

    List<Marker> getMarkersInRect(RectF rectF) {
        return this.markers.obtainAllIn(rectF);
    }

    List<Polygon> getPolygons() {
        return this.polygons.obtainAll();
    }

    List<Polyline> getPolylines() {
        return this.polylines.obtainAll();
    }

    List<Marker> getSelectedMarkers() {
        return this.selectedMarkers;
    }

    boolean onTap(PointF object) {
        MarkerHit markerHit = this.getMarkerHitFromTouchArea((PointF)object);
        long l = new MarkerHitResolver(this.mapboxMap).execute(markerHit);
        boolean bl = true;
        if (l != -1L && this.isClickHandledForMarker(l)) {
            return true;
        }
        object = this.getShapeAnnotationHitFromTap((PointF)object);
        if ((object = new ShapeAnnotationHitResolver(this.shapeAnnotations).execute((ShapeAnnotationHit)object)) == null || !this.handleClickForShapeAnnotation((Annotation)object)) {
            bl = false;
        }
        return bl;
    }

    void reloadMarkers() {
        this.markers.reload();
    }

    void removeAnnotation(long l) {
        this.annotations.removeBy(l);
    }

    void removeAnnotation(Annotation annotation) {
        if (annotation instanceof Marker) {
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (this.selectedMarkers.contains(marker)) {
                this.selectedMarkers.remove(marker);
            }
            this.iconManager.iconCleanup(marker.getIcon());
        }
        this.annotations.removeBy(annotation);
    }

    void removeAnnotations() {
        int n = this.annotationsArray.size();
        long[] lArray = new long[n];
        this.selectedMarkers.clear();
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.annotationsArray.keyAt(i);
            Annotation annotation = (Annotation)this.annotationsArray.get(lArray[i]);
            if (!(annotation instanceof Marker)) continue;
            annotation = (Marker)annotation;
            ((Marker)annotation).hideInfoWindow();
            this.iconManager.iconCleanup(((Marker)annotation).getIcon());
        }
        this.annotations.removeAll();
    }

    void removeAnnotations(List<? extends Annotation> list) {
        for (Annotation annotation : list) {
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (this.selectedMarkers.contains(marker)) {
                this.selectedMarkers.remove(marker);
            }
            this.iconManager.iconCleanup(marker.getIcon());
        }
        this.annotations.removeBy(list);
    }

    void selectMarker(Marker marker) {
        if (this.selectedMarkers.contains(marker)) {
            return;
        }
        if (!this.infoWindowManager.isAllowConcurrentMultipleOpenInfoWindows()) {
            this.deselectMarkers();
        }
        if (this.infoWindowManager.isInfoWindowValidForMarker(marker) || this.infoWindowManager.getInfoWindowAdapter() != null) {
            this.infoWindowManager.add(marker.showInfoWindow(this.mapboxMap, this.mapView));
        }
        this.selectedMarkers.add(marker);
    }

    void setOnMarkerClickListener(MapboxMap.OnMarkerClickListener onMarkerClickListener) {
        this.onMarkerClickListener = onMarkerClickListener;
    }

    void setOnPolygonClickListener(MapboxMap.OnPolygonClickListener onPolygonClickListener) {
        this.onPolygonClickListener = onPolygonClickListener;
    }

    void setOnPolylineClickListener(MapboxMap.OnPolylineClickListener onPolylineClickListener) {
        this.onPolylineClickListener = onPolylineClickListener;
    }

    void update() {
        this.infoWindowManager.update();
    }

    void updateMarker(Marker marker, MapboxMap mapboxMap) {
        if (!this.isAddedToMap(marker)) {
            this.logNonAdded(marker);
            return;
        }
        this.markers.update(marker, mapboxMap);
    }

    void updatePolygon(Polygon polygon) {
        if (!this.isAddedToMap(polygon)) {
            this.logNonAdded(polygon);
            return;
        }
        this.polygons.update(polygon);
    }

    void updatePolyline(Polyline polyline) {
        if (!this.isAddedToMap(polyline)) {
            this.logNonAdded(polyline);
            return;
        }
        this.polylines.update(polyline);
    }

    private static class MarkerHit {
        private final List<Marker> markers;
        private final RectF tapRect;

        MarkerHit(RectF rectF, List<Marker> list) {
            this.tapRect = rectF;
            this.markers = list;
        }

        float getTapPointX() {
            return this.tapRect.centerX();
        }

        float getTapPointY() {
            return this.tapRect.centerY();
        }
    }

    private static class MarkerHitResolver {
        private Bitmap bitmap;
        private int bitmapHeight;
        private int bitmapWidth;
        private long closestMarkerId = -1L;
        private RectF highestSurfaceIntersection;
        private RectF hitRectMarker;
        private Rect hitRectView = new Rect();
        private PointF markerLocation;
        private final int minimalTouchSize;
        private final Projection projection;
        private View view;

        MarkerHitResolver(MapboxMap mapboxMap) {
            this.hitRectMarker = new RectF();
            this.highestSurfaceIntersection = new RectF();
            this.projection = mapboxMap.getProjection();
            this.minimalTouchSize = (int)(Mapbox.getApplicationContext().getResources().getDisplayMetrics().density * 32.0f);
        }

        private void hitTestMarker(MarkerHit markerHit, Marker marker, RectF rectF) {
            if (rectF.contains(markerHit.getTapPointX(), markerHit.getTapPointY())) {
                rectF.intersect(markerHit.tapRect);
                if (this.isRectangleHighestSurfaceIntersection(rectF)) {
                    this.highestSurfaceIntersection = new RectF(rectF);
                    this.closestMarkerId = marker.getId();
                }
            }
        }

        private boolean isRectangleHighestSurfaceIntersection(RectF rectF) {
            boolean bl = rectF.width() * rectF.height() > this.highestSurfaceIntersection.width() * this.highestSurfaceIntersection.height();
            return bl;
        }

        private void resolveForMarker(MarkerHit markerHit, Marker marker) {
            int n;
            Bitmap bitmap;
            this.markerLocation = this.projection.toScreenLocation(marker.getPosition());
            this.bitmap = bitmap = marker.getIcon().getBitmap();
            this.bitmapHeight = n = bitmap.getHeight();
            int n2 = this.minimalTouchSize;
            if (n < n2) {
                this.bitmapHeight = n2;
            }
            this.bitmapWidth = n = this.bitmap.getWidth();
            n2 = this.minimalTouchSize;
            if (n < n2) {
                this.bitmapWidth = n2;
            }
            this.hitRectMarker.set(0.0f, 0.0f, (float)this.bitmapWidth, (float)this.bitmapHeight);
            this.hitRectMarker.offsetTo(this.markerLocation.x - (float)(this.bitmapWidth / 2), this.markerLocation.y - (float)(this.bitmapHeight / 2));
            this.hitTestMarker(markerHit, marker, this.hitRectMarker);
        }

        private void resolveForMarkers(MarkerHit markerHit) {
            Iterator iterator2 = markerHit.markers.iterator();
            while (iterator2.hasNext()) {
                this.resolveForMarker(markerHit, (Marker)iterator2.next());
            }
        }

        public long execute(MarkerHit markerHit) {
            this.resolveForMarkers(markerHit);
            return this.closestMarkerId;
        }
    }

    private static class ShapeAnnotationHit {
        private final RectF tapPoint;

        ShapeAnnotationHit(RectF rectF) {
            this.tapPoint = rectF;
        }
    }

    private static class ShapeAnnotationHitResolver {
        private ShapeAnnotations shapeAnnotations;

        ShapeAnnotationHitResolver(ShapeAnnotations shapeAnnotations) {
            this.shapeAnnotations = shapeAnnotations;
        }

        public Annotation execute(ShapeAnnotationHit object) {
            object = (object = this.shapeAnnotations.obtainAllIn(((ShapeAnnotationHit)object).tapPoint)).size() > 0 ? (Annotation)object.get(0) : null;
            return object;
        }
    }
}

