/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.os.Handler;
import android.os.Message;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

class CameraChangeDispatcher
implements MapboxMap.OnCameraMoveStartedListener,
MapboxMap.OnCameraMoveListener,
MapboxMap.OnCameraMoveCanceledListener,
MapboxMap.OnCameraIdleListener {
    private static final int IDLE = 3;
    private static final int MOVE = 1;
    private static final int MOVE_CANCELED = 2;
    private static final int MOVE_STARTED = 0;
    private final CameraChangeHandler handler = new CameraChangeHandler(this);
    private boolean idle = true;
    private int moveStartedReason;
    private final CopyOnWriteArrayList<MapboxMap.OnCameraIdleListener> onCameraIdle;
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveListener> onCameraMove;
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveCanceledListener> onCameraMoveCanceled;
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveStartedListener> onCameraMoveStarted = new CopyOnWriteArrayList();

    CameraChangeDispatcher() {
        this.onCameraMoveCanceled = new CopyOnWriteArrayList();
        this.onCameraMove = new CopyOnWriteArrayList();
        this.onCameraIdle = new CopyOnWriteArrayList();
    }

    private void executeOnCameraIdle() {
        if (this.idle) {
            return;
        }
        this.idle = true;
        if (!this.onCameraIdle.isEmpty()) {
            Iterator<MapboxMap.OnCameraIdleListener> iterator2 = this.onCameraIdle.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onCameraIdle();
            }
        }
    }

    private void executeOnCameraMove() {
        if (!this.onCameraMove.isEmpty() && !this.idle) {
            Iterator<MapboxMap.OnCameraMoveListener> iterator2 = this.onCameraMove.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onCameraMove();
            }
        }
    }

    private void executeOnCameraMoveCancelled() {
        if (!this.onCameraMoveCanceled.isEmpty() && !this.idle) {
            Iterator<MapboxMap.OnCameraMoveCanceledListener> iterator2 = this.onCameraMoveCanceled.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onCameraMoveCanceled();
            }
        }
    }

    private void executeOnCameraMoveStarted() {
        if (!this.idle) {
            return;
        }
        this.idle = false;
        if (!this.onCameraMoveStarted.isEmpty()) {
            Iterator<MapboxMap.OnCameraMoveStartedListener> iterator2 = this.onCameraMoveStarted.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onCameraMoveStarted(this.moveStartedReason);
            }
        }
    }

    void addOnCameraIdleListener(MapboxMap.OnCameraIdleListener onCameraIdleListener) {
        this.onCameraIdle.add(onCameraIdleListener);
    }

    void addOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        this.onCameraMoveCanceled.add(onCameraMoveCanceledListener);
    }

    void addOnCameraMoveListener(MapboxMap.OnCameraMoveListener onCameraMoveListener) {
        this.onCameraMove.add(onCameraMoveListener);
    }

    void addOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener) {
        this.onCameraMoveStarted.add(onCameraMoveStartedListener);
    }

    @Override
    public void onCameraIdle() {
        this.handler.scheduleMessage(3);
    }

    @Override
    public void onCameraMove() {
        this.handler.scheduleMessage(1);
    }

    @Override
    public void onCameraMoveCanceled() {
        this.handler.scheduleMessage(2);
    }

    @Override
    public void onCameraMoveStarted(int n) {
        this.moveStartedReason = n;
        this.handler.scheduleMessage(0);
    }

    void onDestroy() {
        this.handler.removeCallbacksAndMessages(null);
        this.onCameraMoveStarted.clear();
        this.onCameraMoveCanceled.clear();
        this.onCameraMove.clear();
        this.onCameraIdle.clear();
    }

    void removeOnCameraIdleListener(MapboxMap.OnCameraIdleListener onCameraIdleListener) {
        if (this.onCameraIdle.contains(onCameraIdleListener)) {
            this.onCameraIdle.remove(onCameraIdleListener);
        }
    }

    void removeOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        if (this.onCameraMoveCanceled.contains(onCameraMoveCanceledListener)) {
            this.onCameraMoveCanceled.remove(onCameraMoveCanceledListener);
        }
    }

    void removeOnCameraMoveListener(MapboxMap.OnCameraMoveListener onCameraMoveListener) {
        if (this.onCameraMove.contains(onCameraMoveListener)) {
            this.onCameraMove.remove(onCameraMoveListener);
        }
    }

    void removeOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener) {
        if (this.onCameraMoveStarted.contains(onCameraMoveStartedListener)) {
            this.onCameraMoveStarted.remove(onCameraMoveStartedListener);
        }
    }

    private static class CameraChangeHandler
    extends Handler {
        private WeakReference<CameraChangeDispatcher> dispatcherWeakReference;

        CameraChangeHandler(CameraChangeDispatcher cameraChangeDispatcher) {
            this.dispatcherWeakReference = new WeakReference<CameraChangeDispatcher>(cameraChangeDispatcher);
        }

        public void handleMessage(Message message) {
            CameraChangeDispatcher cameraChangeDispatcher = (CameraChangeDispatcher)this.dispatcherWeakReference.get();
            if (cameraChangeDispatcher != null) {
                int n = message.what;
                if (n != 0) {
                    if (n != 1) {
                        if (n != 2) {
                            if (n == 3) {
                                cameraChangeDispatcher.executeOnCameraIdle();
                            }
                        } else {
                            cameraChangeDispatcher.executeOnCameraMoveCancelled();
                        }
                    } else {
                        cameraChangeDispatcher.executeOnCameraMove();
                    }
                } else {
                    cameraChangeDispatcher.executeOnCameraMoveStarted();
                }
            }
        }

        void scheduleMessage(int n) {
            CameraChangeDispatcher cameraChangeDispatcher = (CameraChangeDispatcher)this.dispatcherWeakReference.get();
            if (cameraChangeDispatcher != null) {
                if (n == 0) {
                    boolean bl = !cameraChangeDispatcher.idle && (this.hasMessages(3) || this.hasMessages(2));
                    this.removeMessages(3);
                    this.removeMessages(2);
                    if (bl) {
                        return;
                    }
                }
                cameraChangeDispatcher = new Message();
                ((Message)cameraChangeDispatcher).what = n;
                this.sendMessage((Message)cameraChangeDispatcher);
            }
        }
    }
}

