/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.animation.DecelerateInterpolator;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.MultiFingerTapGestureDetector;
import com.mapbox.android.gestures.R;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.android.gestures.ShoveGestureDetector;
import com.mapbox.android.gestures.StandardGestureDetector;
import com.mapbox.android.gestures.StandardScaleGestureDetector;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.utils.MathUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

final class MapGestureDetector {
    private Handler animationsTimeoutHandler;
    private final AnnotationManager annotationManager;
    private final CameraChangeDispatcher cameraChangeDispatcher;
    private final Runnable cancelAnimatorsRunnable;
    private PointF constantFocalPoint;
    private PointF doubleTapFocalPoint;
    private boolean doubleTapRegistered;
    private AndroidGesturesManager gesturesManager;
    private final CopyOnWriteArrayList<MapboxMap.OnFlingListener> onFlingListenerList;
    private final CopyOnWriteArrayList<MapboxMap.OnMapClickListener> onMapClickListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnMapLongClickListener> onMapLongClickListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnMoveListener> onMoveListenerList;
    private final CopyOnWriteArrayList<MapboxMap.OnRotateListener> onRotateListenerList;
    private final CopyOnWriteArrayList<MapboxMap.OnScaleListener> onScaleListenerList;
    private final CopyOnWriteArrayList<MapboxMap.OnShoveListener> onShoveListenerList;
    private final Projection projection;
    private Animator rotateAnimator;
    private Animator scaleAnimator;
    private final List<Animator> scheduledAnimators;
    private final Transform transform;
    private final UiSettings uiSettings;

    MapGestureDetector(Context context, Transform transform, Projection projection, UiSettings uiSettings, AnnotationManager annotationManager, CameraChangeDispatcher cameraChangeDispatcher) {
        this.onFlingListenerList = new CopyOnWriteArrayList();
        this.onMoveListenerList = new CopyOnWriteArrayList();
        this.onRotateListenerList = new CopyOnWriteArrayList();
        this.onScaleListenerList = new CopyOnWriteArrayList();
        this.onShoveListenerList = new CopyOnWriteArrayList();
        this.doubleTapFocalPoint = new PointF();
        this.scheduledAnimators = new ArrayList<Animator>();
        this.animationsTimeoutHandler = new Handler();
        this.cancelAnimatorsRunnable = new Runnable(){

            @Override
            public void run() {
                MapGestureDetector.this.cancelAnimators();
            }
        };
        this.annotationManager = annotationManager;
        this.transform = transform;
        this.projection = projection;
        this.uiSettings = uiSettings;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
        if (context != null) {
            this.initializeGesturesManager(new AndroidGesturesManager(context), true);
            this.initializeGestureListeners(context, true);
        }
    }

    static /* synthetic */ Animator access$1302(MapGestureDetector mapGestureDetector, Animator animator2) {
        mapGestureDetector.scaleAnimator = animator2;
        return animator2;
    }

    static /* synthetic */ Animator access$1602(MapGestureDetector mapGestureDetector, Animator animator2) {
        mapGestureDetector.rotateAnimator = animator2;
        return animator2;
    }

    static /* synthetic */ PointF access$602(MapGestureDetector mapGestureDetector, PointF pointF) {
        mapGestureDetector.doubleTapFocalPoint = pointF;
        return pointF;
    }

    private void cancelAnimator(Animator animator2) {
        if (animator2 != null && animator2.isStarted()) {
            animator2.cancel();
        }
    }

    private void cancelTransitionsIfRequired() {
        if (this.noGesturesInProgress()) {
            this.transform.cancelTransitions();
        }
    }

    private Animator createScaleAnimator(double d, double d2, final PointF pointF, long l) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{(float)d, (float)(d + d2)});
        valueAnimator.setDuration(l);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                MapGestureDetector.this.transform.setZoom(((Float)valueAnimator.getAnimatedValue()).floatValue(), pointF);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animator2) {
                MapGestureDetector.this.transform.cancelTransitions();
            }

            public void onAnimationEnd(Animator animator2) {
                MapGestureDetector.this.dispatchCameraIdle();
            }

            public void onAnimationStart(Animator animator2) {
                MapGestureDetector.this.transform.cancelTransitions();
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            }
        });
        return valueAnimator;
    }

    private void dispatchCameraIdle() {
        if (this.noGesturesInProgress()) {
            this.transform.invalidateCameraPosition();
            this.cameraChangeDispatcher.onCameraIdle();
        }
    }

    private void doubleTapFinished() {
        if (this.doubleTapRegistered) {
            this.gesturesManager.getMoveGestureDetector().setEnabled(true);
            this.doubleTapRegistered = false;
        }
    }

    private void doubleTapStarted() {
        this.gesturesManager.getMoveGestureDetector().setEnabled(false);
        this.doubleTapRegistered = true;
    }

    private void initializeGestureListeners(Context object, boolean bl) {
        if (bl) {
            StandardGestureListener standardGestureListener = new StandardGestureListener(object.getResources().getDimension(R.dimen.mapbox_defaultScaleSpanSinceStartThreshold));
            MoveGestureListener moveGestureListener = new MoveGestureListener();
            ScaleGestureListener scaleGestureListener = new ScaleGestureListener(object.getResources().getDimension(R.dimen.mapbox_density_constant), object.getResources().getDimension(R.dimen.mapbox_minimum_scale_speed), object.getResources().getDimension(R.dimen.mapbox_minimum_angled_scale_speed), object.getResources().getDimension(R.dimen.mapbox_minimum_scale_velocity));
            RotateGestureListener rotateGestureListener = new RotateGestureListener(object.getResources().getDimension(R.dimen.mapbox_minimum_scale_span_when_rotating), object.getResources().getDimension(R.dimen.mapbox_density_constant), object.getResources().getDimension(R.dimen.mapbox_angular_velocity_multiplier), object.getResources().getDimension(R.dimen.mapbox_minimum_angular_velocity), object.getResources().getDimension(R.dimen.mapbox_defaultScaleSpanSinceStartThreshold));
            ShoveGestureListener shoveGestureListener = new ShoveGestureListener();
            object = new TapGestureListener();
            this.gesturesManager.setStandardGestureListener(standardGestureListener);
            this.gesturesManager.setMoveGestureListener(moveGestureListener);
            this.gesturesManager.setStandardScaleGestureListener(scaleGestureListener);
            this.gesturesManager.setRotateGestureListener(rotateGestureListener);
            this.gesturesManager.setShoveGestureListener(shoveGestureListener);
            this.gesturesManager.setMultiFingerTapGestureListener((MultiFingerTapGestureDetector.OnMultiFingerTapGestureListener)object);
        }
    }

    private void initializeGesturesManager(AndroidGesturesManager androidGesturesManager, boolean bl) {
        if (bl) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(3);
            hashSet.add(1);
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            hashSet2.add(3);
            hashSet2.add(2);
            HashSet<Integer> hashSet3 = new HashSet<Integer>();
            hashSet3.add(1);
            hashSet3.add(6);
            androidGesturesManager.setMutuallyExclusiveGestures(hashSet, hashSet2, hashSet3);
        }
        this.gesturesManager = androidGesturesManager;
        androidGesturesManager.getRotateGestureDetector().setAngleThreshold(3.0f);
    }

    private boolean noGesturesInProgress() {
        boolean bl = !(this.uiSettings.isScrollGesturesEnabled() && this.gesturesManager.getMoveGestureDetector().isInProgress() || this.uiSettings.isZoomGesturesEnabled() && this.gesturesManager.getStandardScaleGestureDetector().isInProgress() || this.uiSettings.isRotateGesturesEnabled() && this.gesturesManager.getRotateGestureDetector().isInProgress() || this.uiSettings.isTiltGesturesEnabled() && this.gesturesManager.getShoveGestureDetector().isInProgress());
        return bl;
    }

    private void scheduleAnimator(Animator animator2) {
        this.scheduledAnimators.add(animator2);
        this.animationsTimeoutHandler.removeCallbacksAndMessages(null);
        this.animationsTimeoutHandler.postDelayed(this.cancelAnimatorsRunnable, 150L);
    }

    private void zoomAnimated(boolean bl, PointF pointF, boolean bl2) {
        this.cancelAnimator(this.scaleAnimator);
        double d = this.transform.getRawZoom();
        double d2 = bl ? 1.0 : -1.0;
        pointF = this.createScaleAnimator(d, d2, pointF, 300L);
        this.scaleAnimator = pointF;
        if (bl2) {
            pointF.start();
        } else {
            this.scheduleAnimator((Animator)pointF);
        }
    }

    void addOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListenerList.add(onFlingListener);
    }

    void addOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListenerList.add(onMapClickListener);
    }

    void addOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListenerList.add(onMapLongClickListener);
    }

    void addOnMoveListener(MapboxMap.OnMoveListener onMoveListener) {
        this.onMoveListenerList.add(onMoveListener);
    }

    void addOnRotateListener(MapboxMap.OnRotateListener onRotateListener) {
        this.onRotateListenerList.add(onRotateListener);
    }

    void addOnScaleListener(MapboxMap.OnScaleListener onScaleListener) {
        this.onScaleListenerList.add(onScaleListener);
    }

    void addShoveListener(MapboxMap.OnShoveListener onShoveListener) {
        this.onShoveListenerList.add(onShoveListener);
    }

    void cancelAnimators() {
        this.animationsTimeoutHandler.removeCallbacksAndMessages(null);
        this.scheduledAnimators.clear();
        this.cancelAnimator(this.scaleAnimator);
        this.cancelAnimator(this.rotateAnimator);
        this.dispatchCameraIdle();
    }

    AndroidGesturesManager getGesturesManager() {
        return this.gesturesManager;
    }

    void notifyOnFlingListeners() {
        Iterator<MapboxMap.OnFlingListener> iterator2 = this.onFlingListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onFling();
        }
    }

    void notifyOnMapClickListeners(PointF pointF) {
        Iterator<MapboxMap.OnMapClickListener> iterator2 = this.onMapClickListenerList.iterator();
        while (iterator2.hasNext() && !iterator2.next().onMapClick(this.projection.fromScreenLocation(pointF))) {
        }
    }

    void notifyOnMapLongClickListeners(PointF pointF) {
        Iterator<MapboxMap.OnMapLongClickListener> iterator2 = this.onMapLongClickListenerList.iterator();
        while (iterator2.hasNext() && !iterator2.next().onMapLongClick(this.projection.fromScreenLocation(pointF))) {
        }
    }

    void notifyOnMoveBeginListeners(MoveGestureDetector moveGestureDetector) {
        Iterator<MapboxMap.OnMoveListener> iterator2 = this.onMoveListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onMoveBegin(moveGestureDetector);
        }
    }

    void notifyOnMoveEndListeners(MoveGestureDetector moveGestureDetector) {
        Iterator<MapboxMap.OnMoveListener> iterator2 = this.onMoveListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onMoveEnd(moveGestureDetector);
        }
    }

    void notifyOnMoveListeners(MoveGestureDetector moveGestureDetector) {
        Iterator<MapboxMap.OnMoveListener> iterator2 = this.onMoveListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onMove(moveGestureDetector);
        }
    }

    void notifyOnRotateBeginListeners(RotateGestureDetector rotateGestureDetector) {
        Iterator<MapboxMap.OnRotateListener> iterator2 = this.onRotateListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onRotateBegin(rotateGestureDetector);
        }
    }

    void notifyOnRotateEndListeners(RotateGestureDetector rotateGestureDetector) {
        Iterator<MapboxMap.OnRotateListener> iterator2 = this.onRotateListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onRotateEnd(rotateGestureDetector);
        }
    }

    void notifyOnRotateListeners(RotateGestureDetector rotateGestureDetector) {
        Iterator<MapboxMap.OnRotateListener> iterator2 = this.onRotateListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onRotate(rotateGestureDetector);
        }
    }

    void notifyOnScaleBeginListeners(StandardScaleGestureDetector standardScaleGestureDetector) {
        Iterator<MapboxMap.OnScaleListener> iterator2 = this.onScaleListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onScaleBegin(standardScaleGestureDetector);
        }
    }

    void notifyOnScaleEndListeners(StandardScaleGestureDetector standardScaleGestureDetector) {
        Iterator<MapboxMap.OnScaleListener> iterator2 = this.onScaleListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onScaleEnd(standardScaleGestureDetector);
        }
    }

    void notifyOnScaleListeners(StandardScaleGestureDetector standardScaleGestureDetector) {
        Iterator<MapboxMap.OnScaleListener> iterator2 = this.onScaleListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onScale(standardScaleGestureDetector);
        }
    }

    void notifyOnShoveBeginListeners(ShoveGestureDetector shoveGestureDetector) {
        Iterator<MapboxMap.OnShoveListener> iterator2 = this.onShoveListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onShoveBegin(shoveGestureDetector);
        }
    }

    void notifyOnShoveEndListeners(ShoveGestureDetector shoveGestureDetector) {
        Iterator<MapboxMap.OnShoveListener> iterator2 = this.onShoveListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onShoveEnd(shoveGestureDetector);
        }
    }

    void notifyOnShoveListeners(ShoveGestureDetector shoveGestureDetector) {
        Iterator<MapboxMap.OnShoveListener> iterator2 = this.onShoveListenerList.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onShove(shoveGestureDetector);
        }
    }

    boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if ((motionEvent.getSource() & 2) == 2) {
            if (motionEvent.getActionMasked() != 8) {
                return false;
            }
            if (!this.uiSettings.isZoomGesturesEnabled()) {
                return false;
            }
            this.transform.cancelTransitions();
            float f = motionEvent.getAxisValue(9);
            this.transform.zoomBy(f, new PointF(motionEvent.getX(), motionEvent.getY()));
            return true;
        }
        return false;
    }

    boolean onTouchEvent(MotionEvent object) {
        if (object == null) {
            return false;
        }
        if (object.getButtonState() != 0 && object.getButtonState() != 1) {
            return false;
        }
        if (object.getActionMasked() == 0) {
            this.cancelAnimators();
            this.transform.setGestureInProgress(true);
        }
        boolean bl = this.gesturesManager.onTouchEvent((MotionEvent)object);
        int n = object.getActionMasked();
        if (n != 1) {
            if (n != 3) {
                if (n == 5) {
                    this.doubleTapFinished();
                }
            } else {
                this.scheduledAnimators.clear();
                this.transform.setGestureInProgress(false);
                this.doubleTapFinished();
            }
        } else {
            this.doubleTapFinished();
            this.transform.setGestureInProgress(false);
            if (!this.scheduledAnimators.isEmpty()) {
                this.animationsTimeoutHandler.removeCallbacksAndMessages(null);
                object = this.scheduledAnimators.iterator();
                while (object.hasNext()) {
                    ((Animator)object.next()).start();
                }
                this.scheduledAnimators.clear();
            }
        }
        return bl;
    }

    void removeOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListenerList.remove(onFlingListener);
    }

    void removeOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListenerList.remove(onMapClickListener);
    }

    void removeOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListenerList.remove(onMapLongClickListener);
    }

    void removeOnMoveListener(MapboxMap.OnMoveListener onMoveListener) {
        this.onMoveListenerList.remove(onMoveListener);
    }

    void removeOnRotateListener(MapboxMap.OnRotateListener onRotateListener) {
        this.onRotateListenerList.remove(onRotateListener);
    }

    void removeOnScaleListener(MapboxMap.OnScaleListener onScaleListener) {
        this.onScaleListenerList.remove(onScaleListener);
    }

    void removeShoveListener(MapboxMap.OnShoveListener onShoveListener) {
        this.onShoveListenerList.remove(onShoveListener);
    }

    void setFocalPoint(PointF pointF) {
        PointF pointF2 = pointF;
        if (pointF == null) {
            pointF2 = pointF;
            if (this.uiSettings.getFocalPoint() != null) {
                pointF2 = this.uiSettings.getFocalPoint();
            }
        }
        this.constantFocalPoint = pointF2;
    }

    void setGesturesManager(Context context, AndroidGesturesManager androidGesturesManager, boolean bl, boolean bl2) {
        this.initializeGesturesManager(androidGesturesManager, bl2);
        this.initializeGestureListeners(context, bl);
    }

    void zoomInAnimated(PointF pointF, boolean bl) {
        this.zoomAnimated(true, pointF, bl);
    }

    void zoomOutAnimated(PointF pointF, boolean bl) {
        this.zoomAnimated(false, pointF, bl);
    }

    private final class MoveGestureListener
    extends MoveGestureDetector.SimpleOnMoveGestureListener {
        private MoveGestureListener() {
        }

        @Override
        public boolean onMove(MoveGestureDetector moveGestureDetector, float f, float f2) {
            if (f != 0.0f || f2 != 0.0f) {
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                if (!MapGestureDetector.this.uiSettings.isHorizontalScrollGesturesEnabled()) {
                    f = 0.0f;
                }
                MapGestureDetector.this.transform.moveBy(-f, -f2, 0L);
                MapGestureDetector.this.notifyOnMoveListeners(moveGestureDetector);
            }
            return true;
        }

        @Override
        public boolean onMoveBegin(MoveGestureDetector moveGestureDetector) {
            if (!MapGestureDetector.this.uiSettings.isScrollGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.cancelTransitionsIfRequired();
            MapGestureDetector.this.notifyOnMoveBeginListeners(moveGestureDetector);
            return true;
        }

        @Override
        public void onMoveEnd(MoveGestureDetector moveGestureDetector, float f, float f2) {
            MapGestureDetector.this.dispatchCameraIdle();
            MapGestureDetector.this.notifyOnMoveEndListeners(moveGestureDetector);
        }
    }

    private final class RotateGestureListener
    extends RotateGestureDetector.SimpleOnRotateGestureListener {
        private final float angularVelocityMultiplier;
        private final float defaultSpanSinceStartThreshold;
        private final float minimumAngularVelocity;
        private final float minimumScaleSpanWhenRotating;
        private final double rotateVelocityRatioThreshold;

        RotateGestureListener(float f, double d, float f2, float f3, float f4) {
            this.minimumScaleSpanWhenRotating = f;
            this.angularVelocityMultiplier = f2;
            this.minimumAngularVelocity = f3;
            this.rotateVelocityRatioThreshold = d * 2.2000000000000003E-4;
            this.defaultSpanSinceStartThreshold = f4;
        }

        private Animator createRotateAnimator(float f, long l, final PointF pointF) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{f, 0.0f});
            valueAnimator.setDuration(l);
            valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    MapGestureDetector.this.transform.setBearing(MapGestureDetector.this.transform.getRawBearing() + (double)((Float)valueAnimator.getAnimatedValue()).floatValue(), pointF.x, pointF.y, 0L);
                }
            });
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animator2) {
                    MapGestureDetector.this.transform.cancelTransitions();
                }

                public void onAnimationEnd(Animator animator2) {
                    MapGestureDetector.this.dispatchCameraIdle();
                }

                public void onAnimationStart(Animator animator2) {
                    MapGestureDetector.this.transform.cancelTransitions();
                    MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                }
            });
            return valueAnimator;
        }

        private PointF getRotateFocalPoint(RotateGestureDetector rotateGestureDetector) {
            if (MapGestureDetector.this.constantFocalPoint != null) {
                return MapGestureDetector.this.constantFocalPoint;
            }
            return rotateGestureDetector.getFocalPoint();
        }

        @Override
        public boolean onRotate(RotateGestureDetector rotateGestureDetector, float f, float f2) {
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            double d = MapGestureDetector.this.transform.getRawBearing();
            double d2 = f;
            PointF pointF = this.getRotateFocalPoint(rotateGestureDetector);
            MapGestureDetector.this.transform.setBearing(d + d2, pointF.x, pointF.y);
            MapGestureDetector.this.notifyOnRotateListeners(rotateGestureDetector);
            return true;
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector rotateGestureDetector) {
            double d;
            if (!MapGestureDetector.this.uiSettings.isRotateGesturesEnabled()) {
                return false;
            }
            float f = Math.abs(rotateGestureDetector.getDeltaSinceLast());
            double d2 = rotateGestureDetector.getCurrentEvent().getEventTime();
            if (d2 == (d = (double)rotateGestureDetector.getPreviousEvent().getEventTime())) {
                return false;
            }
            d = (double)f / (d2 - d);
            f = Math.abs(rotateGestureDetector.getDeltaSinceStart());
            if (!(d < 0.04 || d > 0.07 && f < 5.0f || d > 0.15 && f < 7.0f || d > 0.5 && f < 15.0f)) {
                if (MapGestureDetector.this.uiSettings.isIncreaseScaleThresholdWhenRotating()) {
                    MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().setSpanSinceStartThreshold(this.minimumScaleSpanWhenRotating);
                    MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().interrupt();
                }
                MapGestureDetector.this.cancelTransitionsIfRequired();
                MapGestureDetector.this.notifyOnRotateBeginListeners(rotateGestureDetector);
                return true;
            }
            return false;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector object, float f, float f2, float f3) {
            if (MapGestureDetector.this.uiSettings.isIncreaseScaleThresholdWhenRotating()) {
                MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().setSpanSinceStartThreshold(this.defaultSpanSinceStartThreshold);
            }
            MapGestureDetector.this.notifyOnRotateEndListeners((RotateGestureDetector)object);
            f3 = MathUtils.clamp(f3 * this.angularVelocityMultiplier, -30.0f, 30.0f);
            f = Math.abs(f);
            f2 = Math.abs(f2);
            double d = Math.abs(((RotateGestureDetector)object).getDeltaSinceLast()) / (f + f2);
            if (!(!MapGestureDetector.this.uiSettings.isRotateVelocityAnimationEnabled() || Math.abs(f3) < this.minimumAngularVelocity || MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().isInProgress() && d < this.rotateVelocityRatioThreshold)) {
                long l = (long)((Math.log((double)Math.abs(f3) + 1.0 / Math.pow(Math.E, 2.0)) + 2.0) * 150.0);
                object = this.getRotateFocalPoint((RotateGestureDetector)object);
                MapGestureDetector.access$1602(MapGestureDetector.this, this.createRotateAnimator(f3, l, (PointF)object));
                object = MapGestureDetector.this;
                ((MapGestureDetector)object).scheduleAnimator(((MapGestureDetector)object).rotateAnimator);
                return;
            }
            MapGestureDetector.this.dispatchCameraIdle();
        }
    }

    private final class ScaleGestureListener
    extends StandardScaleGestureDetector.SimpleStandardOnScaleGestureListener {
        private final float minimumAngledGestureSpeed;
        private final float minimumGestureSpeed;
        private final float minimumVelocity;
        private boolean quickZoom;
        private final double scaleVelocityRatioThreshold;
        private double screenHeight;
        private float spanSinceLast;
        private double startZoom;

        ScaleGestureListener(double d, float f, float f2, float f3) {
            this.minimumGestureSpeed = f;
            this.minimumAngledGestureSpeed = f2;
            this.minimumVelocity = f3;
            this.scaleVelocityRatioThreshold = d * 0.004;
        }

        private double calculateScale(double d, boolean bl) {
            double d2;
            d = d2 = MathUtils.clamp(d * 2.5 * 1.0E-4, 0.0, 2.5);
            if (bl) {
                d = -d2;
            }
            return d;
        }

        private PointF getScaleFocalPoint(StandardScaleGestureDetector standardScaleGestureDetector) {
            if (MapGestureDetector.this.constantFocalPoint != null) {
                return MapGestureDetector.this.constantFocalPoint;
            }
            if (this.quickZoom) {
                return new PointF(MapGestureDetector.this.uiSettings.getWidth() / 2.0f, MapGestureDetector.this.uiSettings.getHeight() / 2.0f);
            }
            return standardScaleGestureDetector.getFocalPoint();
        }

        @Override
        public boolean onScale(StandardScaleGestureDetector standardScaleGestureDetector) {
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            PointF pointF = this.getScaleFocalPoint(standardScaleGestureDetector);
            if (this.quickZoom) {
                double d = Math.abs(standardScaleGestureDetector.getCurrentEvent().getY() - ((MapGestureDetector)MapGestureDetector.this).doubleTapFocalPoint.y);
                boolean bl = standardScaleGestureDetector.getCurrentEvent().getY() < ((MapGestureDetector)MapGestureDetector.this).doubleTapFocalPoint.y;
                d = MathUtils.normalize(d, 0.0, this.screenHeight, 0.0, 4.0);
                double d2 = this.startZoom;
                d = bl ? d2 - d : d2 + d;
                d2 = MapGestureDetector.this.uiSettings.getZoomRate();
                MapGestureDetector.this.transform.setZoom(d * d2, pointF);
            } else {
                double d = Math.log(standardScaleGestureDetector.getScaleFactor()) / Math.log(1.5707963267948966);
                double d3 = MapGestureDetector.this.uiSettings.getZoomRate();
                MapGestureDetector.this.transform.zoomBy(d * (double)0.65f * d3, pointF);
            }
            MapGestureDetector.this.notifyOnScaleListeners(standardScaleGestureDetector);
            this.spanSinceLast = Math.abs(standardScaleGestureDetector.getCurrentSpan() - standardScaleGestureDetector.getPreviousSpan());
            return true;
        }

        @Override
        public boolean onScaleBegin(StandardScaleGestureDetector standardScaleGestureDetector) {
            block12: {
                block11: {
                    double d;
                    block10: {
                        boolean bl = standardScaleGestureDetector.getPointersCount() == 1;
                        this.quickZoom = bl;
                        if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled()) {
                            return false;
                        }
                        if (!this.quickZoom) break block10;
                        if (!MapGestureDetector.this.uiSettings.isQuickZoomGesturesEnabled()) {
                            return false;
                        }
                        MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(false);
                        break block11;
                    }
                    if (!(standardScaleGestureDetector.getPreviousSpan() > 0.0f)) break block12;
                    float f = standardScaleGestureDetector.getCurrentSpan();
                    float f2 = standardScaleGestureDetector.getPreviousSpan();
                    double d2 = standardScaleGestureDetector.getCurrentEvent().getEventTime();
                    if (d2 == (d = (double)standardScaleGestureDetector.getPreviousEvent().getEventTime())) {
                        return false;
                    }
                    d = (double)Math.abs(f - f2) / (d2 - d);
                    if (d < (double)this.minimumGestureSpeed) {
                        return false;
                    }
                    if (!MapGestureDetector.this.gesturesManager.getRotateGestureDetector().isInProgress()) {
                        if ((double)Math.abs(MapGestureDetector.this.gesturesManager.getRotateGestureDetector().getDeltaSinceLast()) > 0.4 && d < (double)this.minimumAngledGestureSpeed) {
                            return false;
                        }
                        if (MapGestureDetector.this.uiSettings.isDisableRotateWhenScaling()) {
                            MapGestureDetector.this.gesturesManager.getRotateGestureDetector().setEnabled(false);
                        }
                    }
                }
                this.screenHeight = Resources.getSystem().getDisplayMetrics().heightPixels;
                this.startZoom = MapGestureDetector.this.transform.getRawZoom();
                MapGestureDetector.this.cancelTransitionsIfRequired();
                MapGestureDetector.this.notifyOnScaleBeginListeners(standardScaleGestureDetector);
                this.spanSinceLast = Math.abs(standardScaleGestureDetector.getCurrentSpan() - standardScaleGestureDetector.getPreviousSpan());
                return true;
            }
            return false;
        }

        @Override
        public void onScaleEnd(StandardScaleGestureDetector object, float f, float f2) {
            if (this.quickZoom) {
                MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(true);
            } else {
                MapGestureDetector.this.gesturesManager.getRotateGestureDetector().setEnabled(true);
            }
            MapGestureDetector.this.notifyOnScaleEndListeners((StandardScaleGestureDetector)object);
            f = Math.abs(f) + Math.abs(f2);
            if (MapGestureDetector.this.uiSettings.isScaleVelocityAnimationEnabled() && !(f < this.minimumVelocity) && !((double)(this.spanSinceLast / f) < this.scaleVelocityRatioThreshold)) {
                double d = this.calculateScale(f, ((StandardScaleGestureDetector)object).isScalingOut());
                double d2 = MapGestureDetector.this.transform.getRawZoom();
                PointF pointF = this.getScaleFocalPoint((StandardScaleGestureDetector)object);
                long l = (long)((Math.log(Math.abs(d) + 1.0 / Math.pow(Math.E, 2.0)) + 2.0) * 150.0);
                object = MapGestureDetector.this;
                MapGestureDetector.access$1302((MapGestureDetector)object, ((MapGestureDetector)object).createScaleAnimator(d2, d, pointF, l));
                object = MapGestureDetector.this;
                ((MapGestureDetector)object).scheduleAnimator(((MapGestureDetector)object).scaleAnimator);
                return;
            }
            MapGestureDetector.this.dispatchCameraIdle();
        }
    }

    private final class ShoveGestureListener
    extends ShoveGestureDetector.SimpleOnShoveGestureListener {
        private ShoveGestureListener() {
        }

        @Override
        public boolean onShove(ShoveGestureDetector shoveGestureDetector, float f, float f2) {
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            double d = MathUtils.clamp(MapGestureDetector.this.transform.getTilt() - (double)(f * 0.1f), 0.0, 60.0);
            MapGestureDetector.this.transform.setTilt(d);
            MapGestureDetector.this.notifyOnShoveListeners(shoveGestureDetector);
            return true;
        }

        @Override
        public boolean onShoveBegin(ShoveGestureDetector shoveGestureDetector) {
            if (!MapGestureDetector.this.uiSettings.isTiltGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.cancelTransitionsIfRequired();
            MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(false);
            MapGestureDetector.this.notifyOnShoveBeginListeners(shoveGestureDetector);
            return true;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector shoveGestureDetector, float f, float f2) {
            MapGestureDetector.this.dispatchCameraIdle();
            MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(true);
            MapGestureDetector.this.notifyOnShoveEndListeners(shoveGestureDetector);
        }
    }

    private final class StandardGestureListener
    extends StandardGestureDetector.SimpleStandardOnGestureListener {
        private final float doubleTapMovementThreshold;

        StandardGestureListener(float f) {
            this.doubleTapMovementThreshold = f;
        }

        @Override
        public boolean onDoubleTapEvent(MotionEvent object) {
            if (object.getActionMasked() == 0) {
                MapGestureDetector.access$602(MapGestureDetector.this, new PointF(object.getX(), object.getY()));
                MapGestureDetector.this.doubleTapStarted();
            }
            if (object.getActionMasked() == 1) {
                float f = Math.abs(object.getX() - ((MapGestureDetector)MapGestureDetector.this).doubleTapFocalPoint.x);
                float f2 = Math.abs(object.getY() - ((MapGestureDetector)MapGestureDetector.this).doubleTapFocalPoint.y);
                float f3 = this.doubleTapMovementThreshold;
                if (!(f > f3) && !(f2 > f3) && MapGestureDetector.this.uiSettings.isZoomGesturesEnabled() && MapGestureDetector.this.uiSettings.isDoubleTapGesturesEnabled()) {
                    if (MapGestureDetector.this.constantFocalPoint != null) {
                        object = MapGestureDetector.this;
                        MapGestureDetector.access$602((MapGestureDetector)object, ((MapGestureDetector)object).constantFocalPoint);
                    }
                    object = MapGestureDetector.this;
                    ((MapGestureDetector)object).zoomInAnimated(((MapGestureDetector)object).doubleTapFocalPoint, false);
                    return true;
                }
                return false;
            }
            return super.onDoubleTapEvent((MotionEvent)object);
        }

        @Override
        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }

        @Override
        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            double d;
            float f3;
            if (!MapGestureDetector.this.uiSettings.isScrollGesturesEnabled()) {
                return false;
            }
            if (!MapGestureDetector.this.uiSettings.isFlingVelocityAnimationEnabled()) {
                return false;
            }
            float f4 = f3 = MapGestureDetector.this.uiSettings.getPixelRatio();
            if (f3 < 3.0f) {
                f4 = 3.0f;
            }
            if ((d = Math.hypot(f / f4, f2 / f4)) < 300.0) {
                return false;
            }
            double d2 = MapGestureDetector.this.transform.getTilt();
            d2 = d2 != 0.0 ? (d2 /= 10.0) : 0.0;
            double d3 = d2 + 1.5;
            d2 = (double)f / d3;
            double d4 = f4;
            d2 /= d4;
            d4 = (double)f2 / d3 / d4;
            long l = (long)(d / 7.0 / d3 + 500.0);
            if (!MapGestureDetector.this.uiSettings.isHorizontalScrollGesturesEnabled()) {
                if (Math.abs(Math.toDegrees(Math.atan(d2 / d4))) > 75.0) {
                    return false;
                }
                d2 = 0.0;
            }
            MapGestureDetector.this.transform.cancelTransitions();
            MapGestureDetector.this.notifyOnFlingListeners();
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            MapGestureDetector.this.transform.moveBy(d2, d4, l);
            return true;
        }

        @Override
        public void onLongPress(MotionEvent motionEvent) {
            motionEvent = new PointF(motionEvent.getX(), motionEvent.getY());
            MapGestureDetector.this.notifyOnMapLongClickListeners((PointF)motionEvent);
        }

        @Override
        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            motionEvent = new PointF(motionEvent.getX(), motionEvent.getY());
            if (!MapGestureDetector.this.annotationManager.onTap((PointF)motionEvent)) {
                if (MapGestureDetector.this.uiSettings.isDeselectMarkersOnTap()) {
                    MapGestureDetector.this.annotationManager.deselectMarkers();
                }
                MapGestureDetector.this.notifyOnMapClickListeners((PointF)motionEvent);
            }
            return true;
        }

        @Override
        public boolean onSingleTapUp(MotionEvent motionEvent) {
            MapGestureDetector.this.transform.cancelTransitions();
            return true;
        }
    }

    private final class TapGestureListener
    implements MultiFingerTapGestureDetector.OnMultiFingerTapGestureListener {
        private TapGestureListener() {
        }

        @Override
        public boolean onMultiFingerTap(MultiFingerTapGestureDetector multiFingerTapGestureDetector, int n) {
            if (MapGestureDetector.this.uiSettings.isZoomGesturesEnabled() && n == 2) {
                MapGestureDetector.this.transform.cancelTransitions();
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                multiFingerTapGestureDetector = MapGestureDetector.this.constantFocalPoint != null ? MapGestureDetector.this.constantFocalPoint : multiFingerTapGestureDetector.getFocalPoint();
                MapGestureDetector.this.zoomOutAnimated((PointF)multiFingerTapGestureDetector, false);
                return true;
            }
            return false;
        }
    }
}

