/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.mapbox.mapboxsdk.maps.MapGestureDetector;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;

final class MapKeyListener {
    private TrackballLongPressTimeOut currentTrackballLongPressTimeOut;
    private final MapGestureDetector mapGestureDetector;
    private final Transform transform;
    private final UiSettings uiSettings;

    MapKeyListener(Transform transform, UiSettings uiSettings, MapGestureDetector mapGestureDetector) {
        this.transform = transform;
        this.uiSettings = uiSettings;
        this.mapGestureDetector = mapGestureDetector;
    }

    static /* synthetic */ TrackballLongPressTimeOut access$202(MapKeyListener mapKeyListener, TrackballLongPressTimeOut trackballLongPressTimeOut) {
        mapKeyListener.currentTrackballLongPressTimeOut = trackballLongPressTimeOut;
        return trackballLongPressTimeOut;
    }

    boolean onKeyDown(int n, KeyEvent keyEvent) {
        double d = keyEvent.getRepeatCount() >= 5 ? 50.0 : 10.0;
        if (n != 66) {
            switch (n) {
                default: {
                    return false;
                }
                case 22: {
                    if (!this.uiSettings.isScrollGesturesEnabled()) {
                        return false;
                    }
                    this.transform.cancelTransitions();
                    this.transform.moveBy(-d, 0.0, 0L);
                    return true;
                }
                case 21: {
                    if (!this.uiSettings.isScrollGesturesEnabled()) {
                        return false;
                    }
                    this.transform.cancelTransitions();
                    this.transform.moveBy(d, 0.0, 0L);
                    return true;
                }
                case 20: {
                    if (!this.uiSettings.isScrollGesturesEnabled()) {
                        return false;
                    }
                    this.transform.cancelTransitions();
                    this.transform.moveBy(0.0, -d, 0L);
                    return true;
                }
                case 19: {
                    if (!this.uiSettings.isScrollGesturesEnabled()) {
                        return false;
                    }
                    this.transform.cancelTransitions();
                    this.transform.moveBy(0.0, d, 0L);
                    return true;
                }
                case 23: 
            }
        }
        keyEvent.startTracking();
        return true;
    }

    boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        if (n != 23 && n != 66) {
            return false;
        }
        if (!this.uiSettings.isZoomGesturesEnabled()) {
            return false;
        }
        keyEvent = new PointF(this.uiSettings.getWidth() / 2.0f, this.uiSettings.getHeight() / 2.0f);
        this.mapGestureDetector.zoomOutAnimated((PointF)keyEvent, true);
        return true;
    }

    boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (keyEvent.isCanceled()) {
            return false;
        }
        if (n != 23 && n != 66) {
            return false;
        }
        if (!this.uiSettings.isZoomGesturesEnabled()) {
            return false;
        }
        keyEvent = new PointF(this.uiSettings.getWidth() / 2.0f, this.uiSettings.getHeight() / 2.0f);
        this.mapGestureDetector.zoomInAnimated((PointF)keyEvent, true);
        return true;
    }

    boolean onTrackballEvent(MotionEvent object) {
        int n = object.getActionMasked();
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        return false;
                    }
                    object = this.currentTrackballLongPressTimeOut;
                    if (object != null) {
                        ((TrackballLongPressTimeOut)object).cancel();
                        this.currentTrackballLongPressTimeOut = null;
                    }
                    return true;
                }
                if (!this.uiSettings.isScrollGesturesEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy((double)object.getX() * -10.0, (double)object.getY() * -10.0, 0L);
                return true;
            }
            if (!this.uiSettings.isZoomGesturesEnabled()) {
                return false;
            }
            if (this.currentTrackballLongPressTimeOut != null) {
                object = new PointF(this.uiSettings.getWidth() / 2.0f, this.uiSettings.getHeight() / 2.0f);
                this.mapGestureDetector.zoomInAnimated((PointF)object, true);
            }
            return true;
        }
        object = this.currentTrackballLongPressTimeOut;
        if (object != null) {
            ((TrackballLongPressTimeOut)object).cancel();
            this.currentTrackballLongPressTimeOut = null;
        }
        this.currentTrackballLongPressTimeOut = new TrackballLongPressTimeOut();
        new Handler(Looper.getMainLooper()).postDelayed((Runnable)this.currentTrackballLongPressTimeOut, (long)ViewConfiguration.getLongPressTimeout());
        return true;
    }

    private class TrackballLongPressTimeOut
    implements Runnable {
        private boolean cancelled = false;

        TrackballLongPressTimeOut() {
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                PointF pointF = new PointF(MapKeyListener.this.uiSettings.getWidth() / 2.0f, MapKeyListener.this.uiSettings.getHeight() / 2.0f);
                MapKeyListener.this.mapGestureDetector.zoomOutAnimated(pointF, true);
                MapKeyListener.access$202(MapKeyListener.this, null);
            }
        }
    }
}

