/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.GlyphsRasterizationMode;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import com.mapbox.mapboxsdk.utils.FontUtils;
import java.util.Arrays;

public class MapboxMapOptions
implements Parcelable {
    public static final Parcelable.Creator<MapboxMapOptions> CREATOR = new Parcelable.Creator<MapboxMapOptions>(){

        public MapboxMapOptions createFromParcel(Parcel parcel) {
            return new MapboxMapOptions(parcel);
        }

        public MapboxMapOptions[] newArray(int n) {
            return new MapboxMapOptions[n];
        }
    };
    private static final float FOUR_DP = 4.0f;
    private static final int LIGHT_GRAY = -988703;
    private static final float NINETY_TWO_DP = 92.0f;
    private static final int UNDEFINED_COLOR = -1;
    private String apiBaseUri;
    private boolean attributionEnabled;
    private int attributionGravity;
    private int[] attributionMargins;
    private int attributionTintColor;
    private CameraPosition cameraPosition;
    private boolean compassEnabled;
    private int compassGravity;
    private Drawable compassImage;
    private int compassImageResource;
    private int[] compassMargins;
    private boolean crossSourceCollisions;
    private boolean debugActive;
    private boolean doubleTapGesturesEnabled;
    private boolean fadeCompassFacingNorth;
    private int foregroundLoadColor;
    private GlyphsRasterizationMode glyphsRasterizationMode;
    private boolean horizontalScrollGesturesEnabled;
    private String[] localIdeographFontFamilies;
    private String localIdeographFontFamily;
    private boolean localIdeographFontFamilyEnabled;
    private boolean logoEnabled;
    private int logoGravity;
    private int[] logoMargins;
    private double maxPitch;
    private double maxZoom;
    private double minPitch;
    private double minZoom;
    private float pixelRatio;
    private int prefetchZoomDelta;
    private boolean prefetchesTiles;
    private boolean quickZoomGesturesEnabled;
    private boolean rotateGesturesEnabled;
    private boolean scrollGesturesEnabled;
    private boolean textureMode;
    private boolean tiltGesturesEnabled;
    private boolean translucentTextureSurface;
    private boolean zMediaOverlay;
    private boolean zoomGesturesEnabled;

    @Deprecated
    public MapboxMapOptions() {
        this.compassEnabled = true;
        this.fadeCompassFacingNorth = true;
        this.compassGravity = 8388661;
        this.logoEnabled = true;
        this.logoGravity = 8388691;
        this.attributionTintColor = -1;
        this.attributionEnabled = true;
        this.attributionGravity = 8388691;
        this.minZoom = 0.0;
        this.maxZoom = 25.5;
        this.minPitch = 0.0;
        this.maxPitch = 60.0;
        this.rotateGesturesEnabled = true;
        this.scrollGesturesEnabled = true;
        this.horizontalScrollGesturesEnabled = true;
        this.tiltGesturesEnabled = true;
        this.zoomGesturesEnabled = true;
        this.doubleTapGesturesEnabled = true;
        this.quickZoomGesturesEnabled = true;
        this.prefetchesTiles = true;
        this.prefetchZoomDelta = 4;
        this.zMediaOverlay = false;
        this.localIdeographFontFamilyEnabled = true;
        this.glyphsRasterizationMode = GlyphsRasterizationMode.IDEOGRAPHS_RASTERIZED_LOCALLY;
        this.crossSourceCollisions = true;
    }

    private MapboxMapOptions(Parcel parcel) {
        boolean bl = true;
        this.compassEnabled = true;
        this.fadeCompassFacingNorth = true;
        this.compassGravity = 8388661;
        this.logoEnabled = true;
        this.logoGravity = 8388691;
        this.attributionTintColor = -1;
        this.attributionEnabled = true;
        this.attributionGravity = 8388691;
        this.minZoom = 0.0;
        this.maxZoom = 25.5;
        this.minPitch = 0.0;
        this.maxPitch = 60.0;
        this.rotateGesturesEnabled = true;
        this.scrollGesturesEnabled = true;
        this.horizontalScrollGesturesEnabled = true;
        this.tiltGesturesEnabled = true;
        this.zoomGesturesEnabled = true;
        this.doubleTapGesturesEnabled = true;
        this.quickZoomGesturesEnabled = true;
        this.prefetchesTiles = true;
        this.prefetchZoomDelta = 4;
        this.zMediaOverlay = false;
        this.localIdeographFontFamilyEnabled = true;
        this.glyphsRasterizationMode = GlyphsRasterizationMode.IDEOGRAPHS_RASTERIZED_LOCALLY;
        this.crossSourceCollisions = true;
        this.cameraPosition = (CameraPosition)parcel.readParcelable(CameraPosition.class.getClassLoader());
        boolean bl2 = parcel.readByte() != 0;
        this.debugActive = bl2;
        bl2 = parcel.readByte() != 0;
        this.compassEnabled = bl2;
        this.compassGravity = parcel.readInt();
        this.compassMargins = parcel.createIntArray();
        bl2 = parcel.readByte() != 0;
        this.fadeCompassFacingNorth = bl2;
        Bitmap bitmap = (Bitmap)parcel.readParcelable(this.getClass().getClassLoader());
        if (bitmap != null) {
            this.compassImage = new BitmapDrawable(bitmap);
        }
        this.compassImageResource = parcel.readInt();
        bl2 = parcel.readByte() != 0;
        this.logoEnabled = bl2;
        this.logoGravity = parcel.readInt();
        this.logoMargins = parcel.createIntArray();
        bl2 = parcel.readByte() != 0;
        this.attributionEnabled = bl2;
        this.attributionGravity = parcel.readInt();
        this.attributionMargins = parcel.createIntArray();
        this.attributionTintColor = parcel.readInt();
        this.minZoom = parcel.readDouble();
        this.maxZoom = parcel.readDouble();
        this.minPitch = parcel.readDouble();
        this.maxPitch = parcel.readDouble();
        bl2 = parcel.readByte() != 0;
        this.rotateGesturesEnabled = bl2;
        bl2 = parcel.readByte() != 0;
        this.scrollGesturesEnabled = bl2;
        bl2 = parcel.readByte() != 0;
        this.horizontalScrollGesturesEnabled = bl2;
        bl2 = parcel.readByte() != 0;
        this.tiltGesturesEnabled = bl2;
        bl2 = parcel.readByte() != 0;
        this.zoomGesturesEnabled = bl2;
        bl2 = parcel.readByte() != 0;
        this.doubleTapGesturesEnabled = bl2;
        bl2 = parcel.readByte() != 0;
        this.quickZoomGesturesEnabled = bl2;
        this.apiBaseUri = parcel.readString();
        bl2 = parcel.readByte() != 0;
        this.textureMode = bl2;
        bl2 = parcel.readByte() != 0;
        this.translucentTextureSurface = bl2;
        bl2 = parcel.readByte() != 0;
        this.prefetchesTiles = bl2;
        this.prefetchZoomDelta = parcel.readInt();
        bl2 = parcel.readByte() != 0;
        this.zMediaOverlay = bl2;
        bl2 = parcel.readByte() != 0;
        this.localIdeographFontFamilyEnabled = bl2;
        this.localIdeographFontFamily = parcel.readString();
        this.glyphsRasterizationMode = GlyphsRasterizationMode.valueOf(parcel.readInt());
        this.localIdeographFontFamilies = parcel.createStringArray();
        this.pixelRatio = parcel.readFloat();
        this.foregroundLoadColor = parcel.readInt();
        bl2 = parcel.readByte() != 0 ? bl : false;
        this.crossSourceCollisions = bl2;
    }

    public static MapboxMapOptions createFromAttributes(Context context) {
        return MapboxMapOptions.createFromAttributes(context, null);
    }

    public static MapboxMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.mapbox_MapView, 0, 0);
        return MapboxMapOptions.createFromAttributes(new MapboxMapOptions(), context, (TypedArray)attributeSet);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MapboxMapOptions createFromAttributes(MapboxMapOptions mapboxMapOptions, Context object, TypedArray typedArray) {
        void var2_6;
        float f = object.getResources().getDisplayMetrics().density;
        try {
            Object object2 = new CameraPosition.Builder((TypedArray)var2_6);
            mapboxMapOptions.camera(((CameraPosition.Builder)object2).build());
            mapboxMapOptions.apiBaseUrl(var2_6.getString(R.styleable.mapbox_MapView_mapbox_apiBaseUrl));
            object2 = var2_6.getString(R.styleable.mapbox_MapView_mapbox_apiBaseUri);
            if (!TextUtils.isEmpty((CharSequence)object2)) {
                mapboxMapOptions.apiBaseUri((String)object2);
            }
            mapboxMapOptions.zoomGesturesEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiZoomGestures, true));
            mapboxMapOptions.scrollGesturesEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiScrollGestures, true));
            mapboxMapOptions.horizontalScrollGesturesEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiHorizontalScrollGestures, true));
            mapboxMapOptions.rotateGesturesEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiRotateGestures, true));
            mapboxMapOptions.tiltGesturesEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiTiltGestures, true));
            mapboxMapOptions.doubleTapGesturesEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiDoubleTapGestures, true));
            mapboxMapOptions.quickZoomGesturesEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiQuickZoomGestures, true));
            mapboxMapOptions.maxZoomPreference(var2_6.getFloat(R.styleable.mapbox_MapView_mapbox_cameraZoomMax, 25.5f));
            mapboxMapOptions.minZoomPreference(var2_6.getFloat(R.styleable.mapbox_MapView_mapbox_cameraZoomMin, 0.0f));
            mapboxMapOptions.maxPitchPreference(var2_6.getFloat(R.styleable.mapbox_MapView_mapbox_cameraPitchMax, 60.0f));
            mapboxMapOptions.minPitchPreference(var2_6.getFloat(R.styleable.mapbox_MapView_mapbox_cameraPitchMin, 0.0f));
            mapboxMapOptions.compassEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiCompass, true));
            mapboxMapOptions.compassGravity(var2_6.getInt(R.styleable.mapbox_MapView_mapbox_uiCompassGravity, 8388661));
            int n = R.styleable.mapbox_MapView_mapbox_uiCompassMarginLeft;
            float f2 = 4.0f * f;
            mapboxMapOptions.compassMargins(new int[]{(int)var2_6.getDimension(n, f2), (int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginTop, f2), (int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginRight, f2), (int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginBottom, f2)});
            mapboxMapOptions.compassFadesWhenFacingNorth(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiCompassFadeFacingNorth, true));
            mapboxMapOptions.compassImage(var2_6.getDrawable(R.styleable.mapbox_MapView_mapbox_uiCompassDrawable));
            mapboxMapOptions.compassImageResource(var2_6.getInt(R.styleable.mapbox_MapView_mapbox_uiCompassDrawableRes, R.drawable.mapbox_compass_icon));
            mapboxMapOptions.logoEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiLogo, true));
            mapboxMapOptions.logoGravity(var2_6.getInt(R.styleable.mapbox_MapView_mapbox_uiLogoGravity, 8388691));
            mapboxMapOptions.logoMargins(new int[]{(int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginLeft, f2), (int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginTop, f2), (int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginRight, f2), (int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginBottom, f2)});
            mapboxMapOptions.attributionTintColor(var2_6.getColor(R.styleable.mapbox_MapView_mapbox_uiAttributionTintColor, -1));
            mapboxMapOptions.attributionEnabled(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_uiAttribution, true));
            mapboxMapOptions.attributionGravity(var2_6.getInt(R.styleable.mapbox_MapView_mapbox_uiAttributionGravity, 8388691));
            mapboxMapOptions.attributionMargins(new int[]{(int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginLeft, f * 92.0f), (int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginTop, f2), (int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginRight, f2), (int)var2_6.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginBottom, f2)});
            mapboxMapOptions.textureMode(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_renderTextureMode, false));
            mapboxMapOptions.translucentTextureSurface(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_renderTextureTranslucentSurface, false));
            mapboxMapOptions.setPrefetchesTiles(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_enableTilePrefetch, true));
            mapboxMapOptions.setPrefetchZoomDelta(var2_6.getInt(R.styleable.mapbox_MapView_mapbox_prefetchZoomDelta, 4));
            mapboxMapOptions.renderSurfaceOnTop(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_enableZMediaOverlay, false));
            mapboxMapOptions.localIdeographFontFamilyEnabled = var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_localIdeographEnabled, true);
            n = var2_6.getResourceId(R.styleable.mapbox_MapView_mapbox_localIdeographFontFamilies, 0);
            if (n != 0) {
                mapboxMapOptions.localIdeographFontFamily(object.getResources().getStringArray(n));
            } else {
                void var1_5;
                Object object3 = object2 = var2_6.getString(R.styleable.mapbox_MapView_mapbox_localIdeographFontFamily);
                if (object2 == null) {
                    String string2 = "sans-serif";
                }
                mapboxMapOptions.localIdeographFontFamily((String)var1_5);
            }
            mapboxMapOptions.setRasterizationMode(GlyphsRasterizationMode.valueOf(var2_6.getInt(R.styleable.mapbox_MapView_mapbox_glyphRasterizationMode, 0)));
            mapboxMapOptions.pixelRatio(var2_6.getFloat(R.styleable.mapbox_MapView_mapbox_pixelRatio, 0.0f));
            mapboxMapOptions.foregroundLoadColor(var2_6.getInt(R.styleable.mapbox_MapView_mapbox_foregroundLoadColor, -988703));
            mapboxMapOptions.crossSourceCollisions(var2_6.getBoolean(R.styleable.mapbox_MapView_mapbox_cross_source_collisions, true));
            return mapboxMapOptions;
        }
        finally {
            var2_6.recycle();
        }
    }

    public MapboxMapOptions apiBaseUri(String string2) {
        this.apiBaseUri = string2;
        return this;
    }

    @Deprecated
    public MapboxMapOptions apiBaseUrl(String string2) {
        this.apiBaseUri = string2;
        return this;
    }

    public MapboxMapOptions attributionEnabled(boolean bl) {
        this.attributionEnabled = bl;
        return this;
    }

    public MapboxMapOptions attributionGravity(int n) {
        this.attributionGravity = n;
        return this;
    }

    public MapboxMapOptions attributionMargins(int[] nArray) {
        this.attributionMargins = nArray;
        return this;
    }

    public MapboxMapOptions attributionTintColor(int n) {
        this.attributionTintColor = n;
        return this;
    }

    public MapboxMapOptions camera(CameraPosition cameraPosition) {
        this.cameraPosition = cameraPosition;
        return this;
    }

    public MapboxMapOptions compassEnabled(boolean bl) {
        this.compassEnabled = bl;
        return this;
    }

    public MapboxMapOptions compassFadesWhenFacingNorth(boolean bl) {
        this.fadeCompassFacingNorth = bl;
        return this;
    }

    public MapboxMapOptions compassGravity(int n) {
        this.compassGravity = n;
        return this;
    }

    public MapboxMapOptions compassImage(Drawable drawable2) {
        this.compassImage = drawable2;
        return this;
    }

    public MapboxMapOptions compassImageResource(int n) {
        this.compassImageResource = n;
        return this;
    }

    public MapboxMapOptions compassMargins(int[] nArray) {
        this.compassMargins = nArray;
        return this;
    }

    public MapboxMapOptions crossSourceCollisions(boolean bl) {
        this.crossSourceCollisions = bl;
        return this;
    }

    public MapboxMapOptions debugActive(boolean bl) {
        this.debugActive = bl;
        return this;
    }

    public int describeContents() {
        return 0;
    }

    public MapboxMapOptions doubleTapGesturesEnabled(boolean bl) {
        this.doubleTapGesturesEnabled = bl;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (MapboxMapOptions)object;
            if (this.debugActive != ((MapboxMapOptions)object).debugActive) {
                return false;
            }
            if (this.compassEnabled != ((MapboxMapOptions)object).compassEnabled) {
                return false;
            }
            if (this.fadeCompassFacingNorth != ((MapboxMapOptions)object).fadeCompassFacingNorth) {
                return false;
            }
            Object object2 = this.compassImage;
            if (object2 != null ? !object2.equals(((MapboxMapOptions)object).compassImage) : ((MapboxMapOptions)object).compassImage != null) {
                return false;
            }
            if (this.compassImageResource != ((MapboxMapOptions)object).compassImageResource) {
                return false;
            }
            if (this.compassGravity != ((MapboxMapOptions)object).compassGravity) {
                return false;
            }
            if (this.logoEnabled != ((MapboxMapOptions)object).logoEnabled) {
                return false;
            }
            if (this.logoGravity != ((MapboxMapOptions)object).logoGravity) {
                return false;
            }
            if (this.attributionTintColor != ((MapboxMapOptions)object).attributionTintColor) {
                return false;
            }
            if (this.attributionEnabled != ((MapboxMapOptions)object).attributionEnabled) {
                return false;
            }
            if (this.attributionGravity != ((MapboxMapOptions)object).attributionGravity) {
                return false;
            }
            if (Double.compare(((MapboxMapOptions)object).minZoom, this.minZoom) != 0) {
                return false;
            }
            if (Double.compare(((MapboxMapOptions)object).maxZoom, this.maxZoom) != 0) {
                return false;
            }
            if (Double.compare(((MapboxMapOptions)object).minPitch, this.minPitch) != 0) {
                return false;
            }
            if (Double.compare(((MapboxMapOptions)object).maxPitch, this.maxPitch) != 0) {
                return false;
            }
            if (this.rotateGesturesEnabled != ((MapboxMapOptions)object).rotateGesturesEnabled) {
                return false;
            }
            if (this.scrollGesturesEnabled != ((MapboxMapOptions)object).scrollGesturesEnabled) {
                return false;
            }
            if (this.horizontalScrollGesturesEnabled != ((MapboxMapOptions)object).horizontalScrollGesturesEnabled) {
                return false;
            }
            if (this.tiltGesturesEnabled != ((MapboxMapOptions)object).tiltGesturesEnabled) {
                return false;
            }
            if (this.zoomGesturesEnabled != ((MapboxMapOptions)object).zoomGesturesEnabled) {
                return false;
            }
            if (this.doubleTapGesturesEnabled != ((MapboxMapOptions)object).doubleTapGesturesEnabled) {
                return false;
            }
            if (this.quickZoomGesturesEnabled != ((MapboxMapOptions)object).quickZoomGesturesEnabled) {
                return false;
            }
            object2 = this.cameraPosition;
            if (object2 != null ? !((CameraPosition)object2).equals(((MapboxMapOptions)object).cameraPosition) : ((MapboxMapOptions)object).cameraPosition != null) {
                return false;
            }
            if (!Arrays.equals(this.compassMargins, ((MapboxMapOptions)object).compassMargins)) {
                return false;
            }
            if (!Arrays.equals(this.logoMargins, ((MapboxMapOptions)object).logoMargins)) {
                return false;
            }
            if (!Arrays.equals(this.attributionMargins, ((MapboxMapOptions)object).attributionMargins)) {
                return false;
            }
            object2 = this.apiBaseUri;
            if (object2 != null ? !((String)object2).equals(((MapboxMapOptions)object).apiBaseUri) : ((MapboxMapOptions)object).apiBaseUri != null) {
                return false;
            }
            if (this.prefetchesTiles != ((MapboxMapOptions)object).prefetchesTiles) {
                return false;
            }
            if (this.prefetchZoomDelta != ((MapboxMapOptions)object).prefetchZoomDelta) {
                return false;
            }
            if (this.zMediaOverlay != ((MapboxMapOptions)object).zMediaOverlay) {
                return false;
            }
            if (this.localIdeographFontFamilyEnabled != ((MapboxMapOptions)object).localIdeographFontFamilyEnabled) {
                return false;
            }
            if (!this.localIdeographFontFamily.equals(((MapboxMapOptions)object).localIdeographFontFamily)) {
                return false;
            }
            if (!this.glyphsRasterizationMode.equals((Object)((MapboxMapOptions)object).glyphsRasterizationMode)) {
                return false;
            }
            if (!Arrays.equals(this.localIdeographFontFamilies, ((MapboxMapOptions)object).localIdeographFontFamilies)) {
                return false;
            }
            if (this.pixelRatio != ((MapboxMapOptions)object).pixelRatio) {
                return false;
            }
            boolean bl = ((MapboxMapOptions)object).crossSourceCollisions;
        }
        return false;
    }

    public MapboxMapOptions foregroundLoadColor(int n) {
        this.foregroundLoadColor = n;
        return this;
    }

    public String getApiBaseUri() {
        return this.apiBaseUri;
    }

    @Deprecated
    public String getApiBaseUrl() {
        return this.apiBaseUri;
    }

    public boolean getAttributionEnabled() {
        return this.attributionEnabled;
    }

    public int getAttributionGravity() {
        return this.attributionGravity;
    }

    public int[] getAttributionMargins() {
        return this.attributionMargins;
    }

    public int getAttributionTintColor() {
        return this.attributionTintColor;
    }

    public CameraPosition getCamera() {
        return this.cameraPosition;
    }

    public boolean getCompassEnabled() {
        return this.compassEnabled;
    }

    public boolean getCompassFadeFacingNorth() {
        return this.fadeCompassFacingNorth;
    }

    public int getCompassGravity() {
        return this.compassGravity;
    }

    @Deprecated
    public Drawable getCompassImage() {
        return this.compassImage;
    }

    public int getCompassImageResource() {
        return this.compassImageResource;
    }

    public int[] getCompassMargins() {
        return this.compassMargins;
    }

    public boolean getCrossSourceCollisions() {
        return this.crossSourceCollisions;
    }

    public boolean getDebugActive() {
        return this.debugActive;
    }

    public boolean getDoubleTapGesturesEnabled() {
        return this.doubleTapGesturesEnabled;
    }

    public int getForegroundLoadColor() {
        return this.foregroundLoadColor;
    }

    public GlyphsRasterizationMode getGlyphsRasterizationMode() {
        return this.glyphsRasterizationMode;
    }

    public boolean getHorizontalScrollGesturesEnabled() {
        return this.horizontalScrollGesturesEnabled;
    }

    public String getLocalIdeographFontFamily() {
        String string2 = this.localIdeographFontFamilyEnabled ? this.localIdeographFontFamily : null;
        return string2;
    }

    public boolean getLogoEnabled() {
        return this.logoEnabled;
    }

    public int getLogoGravity() {
        return this.logoGravity;
    }

    public int[] getLogoMargins() {
        return this.logoMargins;
    }

    public double getMaxPitchPreference() {
        return this.maxPitch;
    }

    public double getMaxZoomPreference() {
        return this.maxZoom;
    }

    public double getMinPitchPreference() {
        return this.minPitch;
    }

    public double getMinZoomPreference() {
        return this.minZoom;
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    public int getPrefetchZoomDelta() {
        return this.prefetchZoomDelta;
    }

    @Deprecated
    public boolean getPrefetchesTiles() {
        return this.prefetchesTiles;
    }

    public boolean getQuickZoomGesturesEnabled() {
        return this.quickZoomGesturesEnabled;
    }

    public boolean getRenderSurfaceOnTop() {
        return this.zMediaOverlay;
    }

    public boolean getRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public boolean getScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public boolean getTextureMode() {
        return this.textureMode;
    }

    public boolean getTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public boolean getTranslucentTextureSurface() {
        return this.translucentTextureSurface;
    }

    public boolean getZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public int hashCode() {
        Object object = this.cameraPosition;
        int n = 0;
        int n2 = object != null ? ((CameraPosition)object).hashCode() : 0;
        int n3 = this.debugActive;
        int n4 = this.compassEnabled;
        int n5 = this.fadeCompassFacingNorth;
        int n6 = this.compassGravity;
        object = this.compassImage;
        int n7 = object != null ? object.hashCode() : 0;
        int n8 = this.compassImageResource;
        int n9 = Arrays.hashCode(this.compassMargins);
        int n10 = this.logoEnabled;
        int n11 = this.logoGravity;
        int n12 = Arrays.hashCode(this.logoMargins);
        int n13 = this.attributionTintColor;
        int n14 = this.attributionEnabled;
        int n15 = this.attributionGravity;
        int n16 = Arrays.hashCode(this.attributionMargins);
        long l = Double.doubleToLongBits(this.minZoom);
        int n17 = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.maxZoom);
        int n18 = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.minPitch);
        int n19 = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.maxPitch);
        int n20 = (int)(l ^ l >>> 32);
        int n21 = this.rotateGesturesEnabled;
        int n22 = this.scrollGesturesEnabled;
        int n23 = this.horizontalScrollGesturesEnabled;
        int n24 = this.tiltGesturesEnabled;
        int n25 = this.zoomGesturesEnabled;
        int n26 = this.doubleTapGesturesEnabled;
        int n27 = this.quickZoomGesturesEnabled;
        object = this.apiBaseUri;
        int n28 = object != null ? ((String)object).hashCode() : 0;
        int n29 = this.textureMode;
        int n30 = this.translucentTextureSurface;
        int n31 = this.prefetchesTiles;
        int n32 = this.prefetchZoomDelta;
        int n33 = this.zMediaOverlay;
        int n34 = this.localIdeographFontFamilyEnabled;
        object = this.localIdeographFontFamily;
        if (object != null) {
            n = ((String)object).hashCode();
        }
        return ((((((((((((((((((((((((((((((((((((n2 * 31 + n3) * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31 + n9) * 31 + n10) * 31 + n11) * 31 + n12) * 31 + n13) * 31 + n14) * 31 + n15) * 31 + n16) * 31 + n17) * 31 + n18) * 31 + n19) * 31 + n20) * 31 + n21) * 31 + n22) * 31 + n23) * 31 + n24) * 31 + n25) * 31 + n26) * 31 + n27) * 31 + n28) * 31 + n29) * 31 + n30) * 31 + n31) * 31 + n32) * 31 + n33) * 31 + n34) * 31 + n) * 31 + this.glyphsRasterizationMode.ordinal()) * 31 + Arrays.hashCode(this.localIdeographFontFamilies)) * 31 + (int)this.pixelRatio) * 31 + this.crossSourceCollisions;
    }

    public MapboxMapOptions horizontalScrollGesturesEnabled(boolean bl) {
        this.horizontalScrollGesturesEnabled = bl;
        return this;
    }

    public boolean isLocalIdeographFontFamilyEnabled() {
        return this.localIdeographFontFamilyEnabled;
    }

    public MapboxMapOptions localIdeographFontFamily(String string2) {
        this.localIdeographFontFamily = FontUtils.extractValidFont(string2);
        return this;
    }

    public MapboxMapOptions localIdeographFontFamily(String ... stringArray) {
        this.localIdeographFontFamily = FontUtils.extractValidFont(stringArray);
        return this;
    }

    public MapboxMapOptions localIdeographFontFamilyEnabled(boolean bl) {
        this.localIdeographFontFamilyEnabled = bl;
        return this;
    }

    public MapboxMapOptions logoEnabled(boolean bl) {
        this.logoEnabled = bl;
        return this;
    }

    public MapboxMapOptions logoGravity(int n) {
        this.logoGravity = n;
        return this;
    }

    public MapboxMapOptions logoMargins(int[] nArray) {
        this.logoMargins = nArray;
        return this;
    }

    public MapboxMapOptions maxPitchPreference(double d) {
        this.maxPitch = d;
        return this;
    }

    public MapboxMapOptions maxZoomPreference(double d) {
        this.maxZoom = d;
        return this;
    }

    public MapboxMapOptions minPitchPreference(double d) {
        this.minPitch = d;
        return this;
    }

    public MapboxMapOptions minZoomPreference(double d) {
        this.minZoom = d;
        return this;
    }

    public MapboxMapOptions pixelRatio(float f) {
        this.pixelRatio = f;
        return this;
    }

    public MapboxMapOptions quickZoomGesturesEnabled(boolean bl) {
        this.quickZoomGesturesEnabled = bl;
        return this;
    }

    public void renderSurfaceOnTop(boolean bl) {
        this.zMediaOverlay = bl;
    }

    public MapboxMapOptions rotateGesturesEnabled(boolean bl) {
        this.rotateGesturesEnabled = bl;
        return this;
    }

    public MapboxMapOptions scrollGesturesEnabled(boolean bl) {
        this.scrollGesturesEnabled = bl;
        return this;
    }

    public MapboxMapOptions setPrefetchZoomDelta(int n) {
        this.prefetchZoomDelta = n;
        return this;
    }

    @Deprecated
    public MapboxMapOptions setPrefetchesTiles(boolean bl) {
        this.prefetchesTiles = bl;
        return this;
    }

    public void setRasterizationMode(GlyphsRasterizationMode glyphsRasterizationMode) {
        this.glyphsRasterizationMode = glyphsRasterizationMode;
    }

    public MapboxMapOptions textureMode(boolean bl) {
        this.textureMode = bl;
        return this;
    }

    public MapboxMapOptions tiltGesturesEnabled(boolean bl) {
        this.tiltGesturesEnabled = bl;
        return this;
    }

    public MapboxMapOptions translucentTextureSurface(boolean bl) {
        this.translucentTextureSurface = bl;
        return this;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable((Parcelable)this.cameraPosition, n);
        parcel.writeByte((byte)(this.debugActive ? 1 : 0));
        parcel.writeByte((byte)(this.compassEnabled ? 1 : 0));
        parcel.writeInt(this.compassGravity);
        parcel.writeIntArray(this.compassMargins);
        parcel.writeByte((byte)(this.fadeCompassFacingNorth ? 1 : 0));
        Object object = this.compassImage;
        object = object != null ? BitmapUtils.getBitmapFromDrawable(object) : null;
        parcel.writeParcelable((Parcelable)object, n);
        parcel.writeInt(this.compassImageResource);
        parcel.writeByte((byte)(this.logoEnabled ? 1 : 0));
        parcel.writeInt(this.logoGravity);
        parcel.writeIntArray(this.logoMargins);
        parcel.writeByte((byte)(this.attributionEnabled ? 1 : 0));
        parcel.writeInt(this.attributionGravity);
        parcel.writeIntArray(this.attributionMargins);
        parcel.writeInt(this.attributionTintColor);
        parcel.writeDouble(this.minZoom);
        parcel.writeDouble(this.maxZoom);
        parcel.writeDouble(this.minPitch);
        parcel.writeDouble(this.maxPitch);
        parcel.writeByte((byte)(this.rotateGesturesEnabled ? 1 : 0));
        parcel.writeByte((byte)(this.scrollGesturesEnabled ? 1 : 0));
        parcel.writeByte((byte)(this.horizontalScrollGesturesEnabled ? 1 : 0));
        parcel.writeByte((byte)(this.tiltGesturesEnabled ? 1 : 0));
        parcel.writeByte((byte)(this.zoomGesturesEnabled ? 1 : 0));
        parcel.writeByte((byte)(this.doubleTapGesturesEnabled ? 1 : 0));
        parcel.writeByte((byte)(this.quickZoomGesturesEnabled ? 1 : 0));
        parcel.writeString(this.apiBaseUri);
        parcel.writeByte((byte)(this.textureMode ? 1 : 0));
        parcel.writeByte((byte)(this.translucentTextureSurface ? 1 : 0));
        parcel.writeByte((byte)(this.prefetchesTiles ? 1 : 0));
        parcel.writeInt(this.prefetchZoomDelta);
        parcel.writeByte((byte)(this.zMediaOverlay ? 1 : 0));
        parcel.writeByte((byte)(this.localIdeographFontFamilyEnabled ? 1 : 0));
        parcel.writeString(this.localIdeographFontFamily);
        parcel.writeInt(this.glyphsRasterizationMode.ordinal());
        parcel.writeStringArray(this.localIdeographFontFamilies);
        parcel.writeFloat(this.pixelRatio);
        parcel.writeInt(this.foregroundLoadColor);
        parcel.writeByte((byte)(this.crossSourceCollisions ? 1 : 0));
    }

    public MapboxMapOptions zoomGesturesEnabled(boolean bl) {
        this.zoomGesturesEnabled = bl;
        return this;
    }
}

