/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Handler;
import android.text.TextUtils;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.exceptions.CalledFromWorkerThreadException;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.LatLngBoundsZoom;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.Image;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.Observer;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.CannotAddLayerException;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.light.Light;
import com.mapbox.mapboxsdk.style.sources.CannotAddSourceException;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class NativeMapView
implements NativeMap {
    private static final String TAG = "Mbgl-NativeMapView";
    private boolean destroyed = false;
    private double[] edgeInsets;
    private final FileSource fileSource;
    private final MapRenderer mapRenderer;
    private long nativePtr = 0L;
    private final float pixelRatio;
    private MapboxMap.SnapshotReadyCallback snapshotReadyCallback;
    private StateCallback stateCallback;
    private final Thread thread;
    private ViewCallback viewCallback;

    static {
        LibraryLoader.load();
    }

    public NativeMapView(Context object, float f, boolean bl, ViewCallback viewCallback, StateCallback stateCallback, MapRenderer mapRenderer) {
        this.mapRenderer = mapRenderer;
        this.viewCallback = viewCallback;
        object = FileSource.getInstance(object);
        this.fileSource = object;
        this.pixelRatio = f;
        this.thread = Thread.currentThread();
        this.stateCallback = stateCallback;
        this.nativeInitialize(this, (FileSource)object, mapRenderer, f, bl);
    }

    public NativeMapView(Context context, boolean bl, ViewCallback viewCallback, StateCallback stateCallback, MapRenderer mapRenderer) {
        this(context, context.getResources().getDisplayMetrics().density, bl, viewCallback, stateCallback, mapRenderer);
    }

    private boolean checkState(String string2) {
        if (this.thread == Thread.currentThread()) {
            if (this.destroyed && !TextUtils.isEmpty((CharSequence)string2)) {
                string2 = String.format("You're calling `%s` after the `MapView` was destroyed, were you invoking it after `onDestroy()`?", string2);
                Logger.e(TAG, string2);
                MapStrictMode.strictModeViolation(string2);
            }
            return this.destroyed;
        }
        throw new CalledFromWorkerThreadException(String.format("Map interactions should happen on the UI thread. Method invoked from wrong thread is %s.", string2));
    }

    private double[] getAnimationPaddingAndClearCachedInsets(double[] dArray) {
        double[] dArray2 = dArray;
        if (dArray == null) {
            dArray2 = this.edgeInsets;
        }
        dArray = null;
        this.edgeInsets = null;
        if (dArray2 != null) {
            dArray = new double[4];
            double d = dArray2[1];
            float f = this.pixelRatio;
            dArray[0] = d / (double)f;
            dArray[1] = dArray2[0] / (double)f;
            dArray[2] = dArray2[3] / (double)f;
            dArray[3] = dArray2[2] / (double)f;
        }
        return dArray;
    }

    private native void nativeAddAnnotationIcon(String var1, int var2, int var3, float var4, byte[] var5);

    private native void nativeAddImage(String var1, Bitmap var2, float var3, boolean var4);

    private native void nativeAddImages(Image[] var1);

    private native void nativeAddLayer(long var1, String var3) throws CannotAddLayerException;

    private native void nativeAddLayerAbove(long var1, String var3) throws CannotAddLayerException;

    private native void nativeAddLayerAt(long var1, int var3) throws CannotAddLayerException;

    private native long[] nativeAddMarkers(Marker[] var1);

    private native long[] nativeAddPolygons(Polygon[] var1);

    private native long[] nativeAddPolylines(Polyline[] var1);

    private native void nativeAddSource(Source var1, long var2) throws CannotAddSourceException;

    private native void nativeCancelTransitions();

    private native void nativeDestroy();

    private native void nativeEaseTo(double var1, double var3, double var5, long var7, double var9, double var11, double[] var13, boolean var14);

    private native void nativeFlyTo(double var1, double var3, double var5, long var7, double var9, double var11, double[] var13);

    private native double nativeGetBearing();

    private native CameraPosition nativeGetCameraForGeometry(Geometry var1, double var2, double var4, double var6, double var8, double var10, double var12);

    private native CameraPosition nativeGetCameraForLatLngBounds(LatLngBounds var1, double var2, double var4, double var6, double var8, double var10, double var12);

    private native CameraPosition nativeGetCameraPosition();

    private native boolean nativeGetDebug();

    private native Bitmap nativeGetImage(String var1);

    private native LatLng nativeGetLatLng();

    private native LatLngBoundsZoom nativeGetLatLngBoundsZoomFromCamera(CameraPosition var1);

    private native Layer nativeGetLayer(String var1);

    private native Layer[] nativeGetLayers();

    private native Light nativeGetLight();

    private native double nativeGetMaxPitch();

    private native double nativeGetMaxZoom();

    private native double nativeGetMetersPerPixelAtLatitude(double var1, double var3);

    private native double nativeGetMinPitch();

    private native double nativeGetMinZoom();

    private native double nativeGetPitch();

    private native boolean nativeGetPrefetchTiles();

    private native int nativeGetPrefetchZoomDelta();

    private native Source nativeGetSource(String var1);

    private native Source[] nativeGetSources();

    private native String nativeGetStyleJson();

    private native String nativeGetStyleUrl();

    private native double nativeGetTopOffsetPixelsForAnnotationSymbol(String var1);

    private native long nativeGetTransitionDelay();

    private native long nativeGetTransitionDuration();

    private native TransitionOptions nativeGetTransitionOptions();

    private native void nativeGetVisibleCoordinateBounds(double[] var1);

    private native double nativeGetZoom();

    private native void nativeInitialize(NativeMapView var1, FileSource var2, MapRenderer var3, float var4, boolean var5);

    private native boolean nativeIsFullyLoaded();

    private native boolean nativeIsUserAnimationInProgress();

    private native void nativeJumpTo(double var1, double var3, double var5, double var7, double var9, double[] var11);

    private native LatLng nativeLatLngForPixel(float var1, float var2);

    private native LatLng nativeLatLngForProjectedMeters(double var1, double var3);

    private native void nativeLatLngsForPixels(double[] var1, double[] var2, float var3);

    private native void nativeMoveBy(double var1, double var3, long var5);

    private native void nativeOnLowMemory();

    private native PointF nativePixelForLatLng(double var1, double var3);

    private native void nativePixelsForLatLngs(double[] var1, double[] var2, float var3);

    private native ProjectedMeters nativeProjectedMetersForLatLng(double var1, double var3);

    private native long[] nativeQueryPointAnnotations(RectF var1);

    private native Feature[] nativeQueryRenderedFeaturesForBox(float var1, float var2, float var3, float var4, String[] var5, Object[] var6);

    private native Feature[] nativeQueryRenderedFeaturesForPoint(float var1, float var2, String[] var3, Object[] var4);

    private native long[] nativeQueryShapeAnnotations(RectF var1);

    private native void nativeRemoveAnnotationIcon(String var1);

    private native void nativeRemoveAnnotations(long[] var1);

    private native void nativeRemoveImage(String var1);

    private native boolean nativeRemoveLayer(long var1);

    private native boolean nativeRemoveLayerAt(int var1);

    private native boolean nativeRemoveSource(Source var1, long var2);

    private native void nativeResetNorth();

    private native void nativeResetPosition();

    private native void nativeResetZoom();

    private native void nativeResizeView(int var1, int var2);

    private native void nativeRotateBy(double var1, double var3, double var5, double var7, long var9);

    private native void nativeSetBearing(double var1, long var3);

    private native void nativeSetBearingXY(double var1, double var3, double var5, long var7);

    private native void nativeSetDebug(boolean var1);

    private native void nativeSetGestureInProgress(boolean var1);

    private native void nativeSetLatLng(double var1, double var3, double[] var5, long var6);

    private native void nativeSetLatLngBounds(LatLngBounds var1);

    private native void nativeSetMaxPitch(double var1);

    private native void nativeSetMaxZoom(double var1);

    private native void nativeSetMinPitch(double var1);

    private native void nativeSetMinZoom(double var1);

    private native void nativeSetPitch(double var1, long var3);

    private native void nativeSetPrefetchTiles(boolean var1);

    private native void nativeSetPrefetchZoomDelta(int var1);

    private native void nativeSetReachability(boolean var1);

    private native void nativeSetStyleJson(String var1);

    private native void nativeSetStyleUrl(String var1);

    private native void nativeSetTransitionDelay(long var1);

    private native void nativeSetTransitionDuration(long var1);

    private native void nativeSetTransitionOptions(TransitionOptions var1);

    private native void nativeSetUserAnimationInProgress(boolean var1);

    private native void nativeSetVisibleCoordinateBounds(LatLng[] var1, RectF var2, double var3, long var5);

    private native void nativeSetZoom(double var1, double var3, double var5, long var7);

    private native void nativeSubscribe(Observer var1, int var2, String[] var3);

    private native void nativeTakeSnapshot();

    private native void nativeTriggerRepaint();

    private native void nativeUnsubscribe(int var1, String[] var2);

    private native void nativeUnsubscribeAll(int var1);

    private native void nativeUpdateMarker(long var1, double var3, double var5, String var7);

    private native void nativeUpdatePolygon(long var1, Polygon var3);

    private native void nativeUpdatePolyline(long var1, Polyline var3);

    private void onCameraDidChange(boolean bl) {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onCameraDidChange(bl);
        }
    }

    private void onCameraIsChanging() {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onCameraIsChanging();
        }
    }

    private void onCameraWillChange(boolean bl) {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onCameraWillChange(bl);
        }
    }

    private boolean onCanRemoveUnusedStyleImage(String string2) {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            return stateCallback.onCanRemoveUnusedStyleImage(string2);
        }
        return true;
    }

    private void onDidBecomeIdle() {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onDidBecomeIdle();
        }
    }

    private void onDidFailLoadingMap(String string2) {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onDidFailLoadingMap(string2);
        }
    }

    private void onDidFailLoadingTile(String string2) {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onDidFailLoadingTile(string2);
        }
    }

    private void onDidFinishLoadingMap() {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onDidFinishLoadingMap();
        }
    }

    private void onDidFinishLoadingStyle() {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onDidFinishLoadingStyle();
        }
    }

    private void onDidFinishRenderingFrame(boolean bl) {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onDidFinishRenderingFrame(bl);
        }
    }

    private void onDidFinishRenderingMap(boolean bl) {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onDidFinishRenderingMap(bl);
        }
    }

    private void onSourceChanged(String string2) {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onSourceChanged(string2);
        }
    }

    private void onStyleImageMissing(String string2) {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onStyleImageMissing(string2);
        }
    }

    private void onWillStartLoadingMap() {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onWillStartLoadingMap();
        }
    }

    private void onWillStartRenderingFrame() {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onWillStartRenderingFrame();
        }
    }

    private void onWillStartRenderingMap() {
        StateCallback stateCallback = this.stateCallback;
        if (stateCallback != null) {
            stateCallback.onWillStartRenderingMap();
        }
    }

    @Override
    public void addAnnotationIcon(String string2, int n, int n2, float f, byte[] byArray) {
        if (this.checkState("addAnnotationIcon")) {
            return;
        }
        this.nativeAddAnnotationIcon(string2, n, n2, f, byArray);
    }

    @Override
    public void addImages(Image[] imageArray) {
        if (this.checkState("addImages")) {
            return;
        }
        this.nativeAddImages(imageArray);
    }

    @Override
    public void addLayer(Layer layer) {
        if (this.checkState("addLayer")) {
            return;
        }
        this.nativeAddLayer(layer.getNativePtr(), null);
    }

    @Override
    public void addLayerAbove(Layer layer, String string2) {
        if (this.checkState("addLayerAbove")) {
            return;
        }
        this.nativeAddLayerAbove(layer.getNativePtr(), string2);
    }

    @Override
    public void addLayerAt(Layer layer, int n) {
        if (this.checkState("addLayerAt")) {
            return;
        }
        this.nativeAddLayerAt(layer.getNativePtr(), n);
    }

    @Override
    public void addLayerBelow(Layer layer, String string2) {
        if (this.checkState("addLayerBelow")) {
            return;
        }
        this.nativeAddLayer(layer.getNativePtr(), string2);
    }

    @Override
    public long addMarker(Marker marker) {
        if (this.checkState("addMarker")) {
            return 0L;
        }
        return this.nativeAddMarkers(new Marker[]{marker})[0];
    }

    @Override
    public long[] addMarkers(List<Marker> list) {
        if (this.checkState("addMarkers")) {
            return new long[0];
        }
        return this.nativeAddMarkers(list.toArray(new Marker[list.size()]));
    }

    @Override
    public long addPolygon(Polygon polygon) {
        if (this.checkState("addPolygon")) {
            return 0L;
        }
        return this.nativeAddPolygons(new Polygon[]{polygon})[0];
    }

    @Override
    public long[] addPolygons(List<Polygon> list) {
        if (this.checkState("addPolygons")) {
            return new long[0];
        }
        return this.nativeAddPolygons(list.toArray(new Polygon[list.size()]));
    }

    @Override
    public long addPolyline(Polyline polyline) {
        if (this.checkState("addPolyline")) {
            return 0L;
        }
        return this.nativeAddPolylines(new Polyline[]{polyline})[0];
    }

    @Override
    public long[] addPolylines(List<Polyline> list) {
        if (this.checkState("addPolylines")) {
            return new long[0];
        }
        return this.nativeAddPolylines(list.toArray(new Polyline[list.size()]));
    }

    @Override
    public void addSnapshotCallback(MapboxMap.SnapshotReadyCallback snapshotReadyCallback) {
        if (this.checkState("addSnapshotCallback")) {
            return;
        }
        this.snapshotReadyCallback = snapshotReadyCallback;
        this.nativeTakeSnapshot();
    }

    @Override
    public void addSource(Source source) {
        if (this.checkState("addSource")) {
            return;
        }
        this.nativeAddSource(source, source.getNativePtr());
    }

    @Override
    public void cancelTransitions() {
        if (this.checkState("cancelTransitions")) {
            return;
        }
        this.nativeCancelTransitions();
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.viewCallback = null;
        this.nativeDestroy();
    }

    @Override
    public void easeTo(LatLng latLng, double d, double d2, double d3, double[] dArray, long l, boolean bl) {
        if (this.checkState("easeTo")) {
            return;
        }
        this.nativeEaseTo(d2, latLng.getLatitude(), latLng.getLongitude(), l, d3, d, this.getAnimationPaddingAndClearCachedInsets(dArray), bl);
    }

    @Override
    public void flyTo(LatLng latLng, double d, double d2, double d3, double[] dArray, long l) {
        if (this.checkState("flyTo")) {
            return;
        }
        this.nativeFlyTo(d2, latLng.getLatitude(), latLng.getLongitude(), l, d3, d, this.getAnimationPaddingAndClearCachedInsets(dArray));
    }

    @Override
    public double getBearing() {
        if (this.checkState("getBearing")) {
            return 0.0;
        }
        return this.nativeGetBearing();
    }

    @Override
    public CameraPosition getCameraForGeometry(Geometry geometry, int[] nArray, double d, double d2) {
        if (this.checkState("getCameraForGeometry")) {
            return null;
        }
        float f = nArray[1];
        float f2 = this.pixelRatio;
        return this.nativeGetCameraForGeometry(geometry, f / f2, (float)nArray[0] / f2, (float)nArray[3] / f2, (float)nArray[2] / f2, d, d2);
    }

    @Override
    public CameraPosition getCameraForLatLngBounds(LatLngBounds latLngBounds, int[] nArray, double d, double d2) {
        if (this.checkState("getCameraForLatLngBounds")) {
            return null;
        }
        float f = nArray[1];
        float f2 = this.pixelRatio;
        return this.nativeGetCameraForLatLngBounds(latLngBounds, f / f2, (float)nArray[0] / f2, (float)nArray[3] / f2, (float)nArray[2] / f2, d, d2);
    }

    @Override
    public CameraPosition getCameraPosition() {
        if (this.checkState("getCameraValues")) {
            return new CameraPosition.Builder().build();
        }
        if (this.edgeInsets != null) {
            return new CameraPosition.Builder(this.nativeGetCameraPosition()).padding(this.edgeInsets).build();
        }
        return this.nativeGetCameraPosition();
    }

    @Override
    public double[] getContentPadding() {
        if (this.checkState("getContentPadding")) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
        double[] dArray = this.edgeInsets;
        if (dArray == null) {
            dArray = this.getCameraPosition().padding;
        }
        return dArray;
    }

    @Override
    public boolean getDebug() {
        if (this.checkState("getDebug")) {
            return false;
        }
        return this.nativeGetDebug();
    }

    @Override
    public RectF getDensityDependantRectangle(RectF rectF) {
        return new RectF(rectF.left / this.pixelRatio, rectF.top / this.pixelRatio, rectF.right / this.pixelRatio, rectF.bottom / this.pixelRatio);
    }

    @Override
    public Bitmap getImage(String string2) {
        if (this.checkState("getImage")) {
            return null;
        }
        return this.nativeGetImage(string2);
    }

    @Override
    public LatLng getLatLng() {
        if (this.checkState("")) {
            return new LatLng();
        }
        return this.nativeGetLatLng();
    }

    @Override
    public LatLngBoundsZoom getLatLngBoundsZoomFromCamera(CameraPosition cameraPosition) {
        if (this.checkState("getLatLngBoundsZoomFromCamera")) {
            return LatLngBoundsZoom.from(0, 0, 0);
        }
        return this.nativeGetLatLngBoundsZoomFromCamera(cameraPosition);
    }

    @Override
    public Layer getLayer(String string2) {
        if (this.checkState("getLayer")) {
            return null;
        }
        return this.nativeGetLayer(string2);
    }

    @Override
    public List<Layer> getLayers() {
        if (this.checkState("getLayers")) {
            return new ArrayList<Layer>();
        }
        return Arrays.asList(this.nativeGetLayers());
    }

    @Override
    public Light getLight() {
        if (this.checkState("getLight")) {
            return null;
        }
        return this.nativeGetLight();
    }

    @Override
    public double getMaxPitch() {
        if (this.checkState("getMaxPitch")) {
            return 0.0;
        }
        return this.nativeGetMaxPitch();
    }

    @Override
    public double getMaxZoom() {
        if (this.checkState("getMaxZoom")) {
            return 0.0;
        }
        return this.nativeGetMaxZoom();
    }

    @Override
    public double getMetersPerPixelAtLatitude(double d) {
        if (this.checkState("getMetersPerPixelAtLatitude")) {
            return 0.0;
        }
        return this.nativeGetMetersPerPixelAtLatitude(d, this.getZoom());
    }

    @Override
    public double getMinPitch() {
        if (this.checkState("getMinPitch")) {
            return 0.0;
        }
        return this.nativeGetMinPitch();
    }

    @Override
    public double getMinZoom() {
        if (this.checkState("getMinZoom")) {
            return 0.0;
        }
        return this.nativeGetMinZoom();
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public double getPitch() {
        if (this.checkState("getPitch")) {
            return 0.0;
        }
        return this.nativeGetPitch();
    }

    @Override
    public float getPixelRatio() {
        return this.pixelRatio;
    }

    @Override
    public boolean getPrefetchTiles() {
        if (this.checkState("getPrefetchTiles")) {
            return false;
        }
        return this.nativeGetPrefetchTiles();
    }

    @Override
    public int getPrefetchZoomDelta() {
        if (this.checkState("nativeGetPrefetchZoomDelta")) {
            return 0;
        }
        return this.nativeGetPrefetchZoomDelta();
    }

    @Override
    public Source getSource(String string2) {
        if (this.checkState("getSource")) {
            return null;
        }
        return this.nativeGetSource(string2);
    }

    @Override
    public List<Source> getSources() {
        if (this.checkState("getSources")) {
            return new ArrayList<Source>();
        }
        return Arrays.asList(this.nativeGetSources());
    }

    @Override
    public String getStyleJson() {
        if (this.checkState("getStyleJson")) {
            return "";
        }
        return this.nativeGetStyleJson();
    }

    @Override
    public String getStyleUri() {
        if (this.checkState("getStyleUri")) {
            return "";
        }
        return this.nativeGetStyleUrl();
    }

    @Override
    public double getTopOffsetPixelsForAnnotationSymbol(String string2) {
        if (this.checkState("getTopOffsetPixelsForAnnotationSymbol")) {
            return 0.0;
        }
        return this.nativeGetTopOffsetPixelsForAnnotationSymbol(string2);
    }

    @Override
    public TransitionOptions getTransitionOptions() {
        return this.nativeGetTransitionOptions();
    }

    @Override
    public void getVisibleCoordinateBounds(double[] dArray) {
        if (!this.checkState("getVisibleCoordinateBounds")) {
            this.nativeGetVisibleCoordinateBounds(dArray);
        }
    }

    @Override
    public double getZoom() {
        if (this.checkState("getZoom")) {
            return 0.0;
        }
        return this.nativeGetZoom();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isFullyLoaded() {
        if (this.checkState("isFullyLoaded")) {
            return false;
        }
        return this.nativeIsFullyLoaded();
    }

    @Override
    public boolean isUserAnimationInProgress() {
        if (this.checkState("isUserAnimationInProgress")) {
            return false;
        }
        return this.nativeIsUserAnimationInProgress();
    }

    @Override
    public void jumpTo(LatLng latLng, double d, double d2, double d3, double[] dArray) {
        if (this.checkState("jumpTo")) {
            return;
        }
        this.nativeJumpTo(d3, latLng.getLatitude(), latLng.getLongitude(), d2, d, this.getAnimationPaddingAndClearCachedInsets(dArray));
    }

    @Override
    public LatLng latLngForPixel(PointF pointF) {
        if (this.checkState("latLngForPixel")) {
            return new LatLng();
        }
        return this.nativeLatLngForPixel(pointF.x / this.pixelRatio, pointF.y / this.pixelRatio);
    }

    @Override
    public LatLng latLngForProjectedMeters(ProjectedMeters projectedMeters) {
        if (this.checkState("latLngForProjectedMeters")) {
            return new LatLng();
        }
        return this.nativeLatLngForProjectedMeters(projectedMeters.getNorthing(), projectedMeters.getEasting());
    }

    @Override
    public void latLngsForPixels(double[] dArray, double[] dArray2) {
        if (!this.checkState("latLngsForPixels")) {
            this.nativeLatLngsForPixels(dArray, dArray2, this.pixelRatio);
        }
    }

    @Override
    public void moveBy(double d, double d2, long l) {
        if (this.checkState("moveBy")) {
            return;
        }
        try {
            float f = this.pixelRatio;
            this.nativeMoveBy(d / (double)f, d2 / (double)f, l);
        }
        catch (Error error) {
            Logger.d(TAG, "Error when executing NativeMapView#moveBy", error);
        }
    }

    @Override
    public void onLowMemory() {
        if (this.checkState("onLowMemory")) {
            return;
        }
        this.nativeOnLowMemory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onSnapshotReady(Bitmap bitmap) {
        if (this.checkState("OnSnapshotReady")) {
            return;
        }
        try {
            MapboxMap.SnapshotReadyCallback snapshotReadyCallback = this.snapshotReadyCallback;
            if (snapshotReadyCallback == null) return;
            if (bitmap == null) return;
            ViewCallback viewCallback = this.viewCallback;
            if (viewCallback == null) {
                snapshotReadyCallback.onSnapshotReady(bitmap);
                return;
            }
            snapshotReadyCallback = viewCallback.getViewContent();
            if (snapshotReadyCallback == null) return;
            this.snapshotReadyCallback.onSnapshotReady(BitmapUtils.mergeBitmap(bitmap, (Bitmap)snapshotReadyCallback));
            return;
        }
        catch (Throwable throwable) {
            Logger.e(TAG, "Exception in onSnapshotReady", throwable);
            throw throwable;
        }
    }

    @Override
    public PointF pixelForLatLng(LatLng latLng) {
        if (this.checkState("pixelForLatLng")) {
            return new PointF();
        }
        latLng = this.nativePixelForLatLng(latLng.getLatitude(), latLng.getLongitude());
        latLng.set(((PointF)latLng).x * this.pixelRatio, ((PointF)latLng).y * this.pixelRatio);
        return latLng;
    }

    @Override
    public void pixelsForLatLngs(double[] dArray, double[] dArray2) {
        if (!this.checkState("pixelsForLatLngs")) {
            this.nativePixelsForLatLngs(dArray, dArray2, this.pixelRatio);
        }
    }

    @Override
    public ProjectedMeters projectedMetersForLatLng(LatLng latLng) {
        if (this.checkState("projectedMetersForLatLng")) {
            return null;
        }
        return this.nativeProjectedMetersForLatLng(latLng.getLatitude(), latLng.getLongitude());
    }

    @Override
    public long[] queryPointAnnotations(RectF rectF) {
        if (this.checkState("queryPointAnnotations")) {
            return new long[0];
        }
        return this.nativeQueryPointAnnotations(rectF);
    }

    @Override
    public List<Feature> queryRenderedFeatures(PointF object, String[] stringArray, Expression expression) {
        if (this.checkState("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        float f = object.x / this.pixelRatio;
        float f2 = object.y / this.pixelRatio;
        object = expression != null ? expression.toArray() : null;
        object = this.nativeQueryRenderedFeaturesForPoint(f, f2, stringArray, (Object[])object);
        object = object != null ? Arrays.asList(object) : new ArrayList();
        return object;
    }

    @Override
    public List<Feature> queryRenderedFeatures(RectF object, String[] stringArray, Expression expression) {
        if (this.checkState("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        float f = object.left / this.pixelRatio;
        float f2 = object.top / this.pixelRatio;
        float f3 = object.right / this.pixelRatio;
        float f4 = object.bottom / this.pixelRatio;
        object = expression != null ? expression.toArray() : null;
        object = this.nativeQueryRenderedFeaturesForBox(f, f2, f3, f4, stringArray, (Object[])object);
        object = object != null ? Arrays.asList(object) : new ArrayList();
        return object;
    }

    @Override
    public long[] queryShapeAnnotations(RectF rectF) {
        if (this.checkState("queryShapeAnnotations")) {
            return new long[0];
        }
        return this.nativeQueryShapeAnnotations(rectF);
    }

    @Override
    public void removeAnnotation(long l) {
        if (this.checkState("removeAnnotation")) {
            return;
        }
        this.removeAnnotations(new long[]{l});
    }

    @Override
    public void removeAnnotationIcon(String string2) {
        if (this.checkState("removeAnnotationIcon")) {
            return;
        }
        this.nativeRemoveAnnotationIcon(string2);
    }

    @Override
    public void removeAnnotations(long[] lArray) {
        if (this.checkState("removeAnnotations")) {
            return;
        }
        this.nativeRemoveAnnotations(lArray);
    }

    @Override
    public void removeImage(String string2) {
        if (this.checkState("removeImage")) {
            return;
        }
        this.nativeRemoveImage(string2);
    }

    @Override
    public boolean removeLayer(Layer layer) {
        if (this.checkState("removeLayer")) {
            return false;
        }
        return this.nativeRemoveLayer(layer.getNativePtr());
    }

    @Override
    public boolean removeLayer(String object) {
        if (this.checkState("removeLayer")) {
            return false;
        }
        if ((object = this.getLayer((String)object)) != null) {
            return this.removeLayer((Layer)object);
        }
        return false;
    }

    @Override
    public boolean removeLayerAt(int n) {
        if (this.checkState("removeLayerAt")) {
            return false;
        }
        return this.nativeRemoveLayerAt(n);
    }

    @Override
    public boolean removeSource(Source source) {
        if (this.checkState("removeSource")) {
            return false;
        }
        return this.nativeRemoveSource(source, source.getNativePtr());
    }

    @Override
    public boolean removeSource(String object) {
        if (this.checkState("removeSource")) {
            return false;
        }
        if ((object = this.getSource((String)object)) != null) {
            return this.removeSource((Source)object);
        }
        return false;
    }

    @Override
    public void resetNorth() {
        if (this.checkState("resetNorth")) {
            return;
        }
        this.nativeResetNorth();
    }

    @Override
    public void resetPosition() {
        if (this.checkState("resetPosition")) {
            return;
        }
        this.nativeResetPosition();
    }

    @Override
    public void resetZoom() {
        if (this.checkState("resetZoom")) {
            return;
        }
        this.nativeResetZoom();
    }

    @Override
    public void resizeView(int n, int n2) {
        if (this.checkState("resizeView")) {
            return;
        }
        int n3 = (int)Math.ceil((float)n / this.pixelRatio);
        int n4 = (int)Math.ceil((float)n2 / this.pixelRatio);
        if (n3 >= 0) {
            if (n4 >= 0) {
                n = n3;
                if (n3 > 65535) {
                    Logger.e(TAG, String.format("Device returned an out of range width size, capping value at 65535 instead of %s", n3));
                    n = 65535;
                }
                n2 = n4;
                if (n4 > 65535) {
                    Logger.e(TAG, String.format("Device returned an out of range height size, capping value at 65535 instead of %s", n4));
                    n2 = 65535;
                }
                this.nativeResizeView(n, n2);
                return;
            }
            throw new IllegalArgumentException("height cannot be negative.");
        }
        throw new IllegalArgumentException("width cannot be negative.");
    }

    @Override
    public void rotateBy(double d, double d2, double d3, double d4, long l) {
        if (this.checkState("rotateBy")) {
            return;
        }
        float f = this.pixelRatio;
        this.nativeRotateBy(d / (double)f, d2 / (double)f, d3, d4, l);
    }

    @Override
    public void setApiBaseUrl(String string2) {
        if (this.checkState("setApiBaseUrl")) {
            return;
        }
        this.fileSource.setApiBaseUrl(string2);
    }

    @Override
    public void setBearing(double d, double d2, double d3, long l) {
        if (this.checkState("setBearing")) {
            return;
        }
        float f = this.pixelRatio;
        this.nativeSetBearingXY(d, d2 / (double)f, d3 / (double)f, l);
    }

    @Override
    public void setBearing(double d, long l) {
        if (this.checkState("setBearing")) {
            return;
        }
        this.nativeSetBearing(d, l);
    }

    @Override
    public void setContentPadding(double[] dArray) {
        if (this.checkState("setContentPadding")) {
            return;
        }
        this.edgeInsets = dArray;
    }

    @Override
    public void setDebug(boolean bl) {
        if (this.checkState("setDebug")) {
            return;
        }
        this.nativeSetDebug(bl);
    }

    @Override
    public void setGestureInProgress(boolean bl) {
        if (this.checkState("setGestureInProgress")) {
            return;
        }
        this.nativeSetGestureInProgress(bl);
    }

    @Override
    public void setLatLng(LatLng latLng, long l) {
        if (this.checkState("setLatLng")) {
            return;
        }
        this.nativeSetLatLng(latLng.getLatitude(), latLng.getLongitude(), this.getAnimationPaddingAndClearCachedInsets(null), l);
    }

    @Override
    public void setLatLngBounds(LatLngBounds latLngBounds) {
        if (this.checkState("setLatLngBounds")) {
            return;
        }
        this.nativeSetLatLngBounds(latLngBounds);
    }

    @Override
    public void setMaxPitch(double d) {
        if (this.checkState("setMaxPitch")) {
            return;
        }
        this.nativeSetMaxPitch(d);
    }

    @Override
    public void setMaxZoom(double d) {
        if (this.checkState("setMaxZoom")) {
            return;
        }
        this.nativeSetMaxZoom(d);
    }

    @Override
    public void setMinPitch(double d) {
        if (this.checkState("setMinPitch")) {
            return;
        }
        this.nativeSetMinPitch(d);
    }

    @Override
    public void setMinZoom(double d) {
        if (this.checkState("setMinZoom")) {
            return;
        }
        this.nativeSetMinZoom(d);
    }

    @Override
    public void setOnFpsChangedListener(final MapboxMap.OnFpsChangedListener onFpsChangedListener) {
        final Handler handler = new Handler();
        this.mapRenderer.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (onFpsChangedListener != null) {
                    NativeMapView.this.mapRenderer.setOnFpsChangedListener(new MapboxMap.OnFpsChangedListener(){

                        @Override
                        public void onFpsChanged(final double d) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    onFpsChangedListener.onFpsChanged(d);
                                }
                            });
                        }
                    });
                } else {
                    NativeMapView.this.mapRenderer.setOnFpsChangedListener(null);
                }
            }
        });
    }

    @Override
    public void setPitch(double d, long l) {
        if (this.checkState("setPitch")) {
            return;
        }
        this.nativeSetPitch(d, l);
    }

    @Override
    public void setPrefetchTiles(boolean bl) {
        if (this.checkState("setPrefetchTiles")) {
            return;
        }
        this.nativeSetPrefetchTiles(bl);
    }

    @Override
    public void setPrefetchZoomDelta(int n) {
        if (this.checkState("nativeSetPrefetchZoomDelta")) {
            return;
        }
        this.nativeSetPrefetchZoomDelta(n);
    }

    @Override
    public void setReachability(boolean bl) {
        if (this.checkState("setReachability")) {
            return;
        }
        this.nativeSetReachability(bl);
    }

    @Override
    public void setStyleJson(String string2) {
        if (this.checkState("setStyleJson")) {
            return;
        }
        this.nativeSetStyleJson(string2);
    }

    @Override
    public void setStyleUri(String string2) {
        if (this.checkState("setStyleUri")) {
            return;
        }
        this.nativeSetStyleUrl(string2);
    }

    @Override
    public void setTransitionOptions(TransitionOptions transitionOptions) {
        this.nativeSetTransitionOptions(transitionOptions);
    }

    @Override
    public void setUserAnimationInProgress(boolean bl) {
        if (this.checkState("setUserAnimationInProgress")) {
            return;
        }
        this.nativeSetUserAnimationInProgress(bl);
    }

    @Override
    public void setVisibleCoordinateBounds(LatLng[] latLngArray, RectF rectF, double d, long l) {
        if (this.checkState("setVisibleCoordinateBounds")) {
            return;
        }
        this.nativeSetVisibleCoordinateBounds(latLngArray, rectF, d, l);
    }

    @Override
    public void setZoom(double d, PointF pointF, long l) {
        if (this.checkState("setZoom")) {
            return;
        }
        this.nativeSetZoom(d, pointF.x / this.pixelRatio, pointF.y / this.pixelRatio, l);
    }

    @Override
    public void subscribe(Observer observer, List<String> list) {
        if (this.checkState("subscribe")) {
            return;
        }
        this.nativeSubscribe(observer, observer.getId(), list.toArray(new String[list.size()]));
    }

    @Override
    public void triggerRepaint() {
        this.nativeTriggerRepaint();
    }

    @Override
    public void unsubscribe(Observer observer) {
        if (this.checkState("unsubscribe all")) {
            return;
        }
        this.nativeUnsubscribeAll(observer.getId());
    }

    @Override
    public void unsubscribe(Observer observer, List<String> list) {
        if (this.checkState("unsubscribe")) {
            return;
        }
        this.nativeUnsubscribe(observer.getId(), list.toArray(new String[list.size()]));
    }

    @Override
    public void updateMarker(Marker marker) {
        if (this.checkState("updateMarker")) {
            return;
        }
        LatLng latLng = marker.getPosition();
        Icon icon = marker.getIcon();
        this.nativeUpdateMarker(marker.getId(), latLng.getLatitude(), latLng.getLongitude(), icon.getId());
    }

    @Override
    public void updatePolygon(Polygon polygon) {
        if (this.checkState("updatePolygon")) {
            return;
        }
        this.nativeUpdatePolygon(polygon.getId(), polygon);
    }

    @Override
    public void updatePolyline(Polyline polyline) {
        if (this.checkState("updatePolyline")) {
            return;
        }
        this.nativeUpdatePolyline(polyline.getId(), polyline);
    }

    static interface StateCallback
    extends StyleCallback {
        public void onCameraDidChange(boolean var1);

        public void onCameraIsChanging();

        public void onCameraWillChange(boolean var1);

        public boolean onCanRemoveUnusedStyleImage(String var1);

        public void onDidBecomeIdle();

        public void onDidFailLoadingMap(String var1);

        public void onDidFailLoadingTile(String var1);

        public void onDidFinishLoadingMap();

        public void onDidFinishRenderingFrame(boolean var1);

        public void onDidFinishRenderingMap(boolean var1);

        public void onSourceChanged(String var1);

        public void onStyleImageMissing(String var1);

        public void onWillStartRenderingFrame();

        public void onWillStartRenderingMap();
    }

    static interface StyleCallback {
        public void onDidFinishLoadingStyle();

        public void onWillStartLoadingMap();
    }

    public static interface ViewCallback {
        public Bitmap getViewContent();
    }
}

