/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import androidx.collection.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BasePointCollection;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.Polygons;
import java.util.ArrayList;
import java.util.List;

class PolygonContainer
implements Polygons {
    private final LongSparseArray<Annotation> annotations;
    private final NativeMap nativeMap;

    PolygonContainer(NativeMap nativeMap, LongSparseArray<Annotation> longSparseArray) {
        this.nativeMap = nativeMap;
        this.annotations = longSparseArray;
    }

    @Override
    public Polygon addBy(PolygonOptions object, MapboxMap mapboxMap) {
        if (!((BasePointCollection)(object = ((PolygonOptions)object).getPolygon())).getPoints().isEmpty()) {
            NativeMap nativeMap = this.nativeMap;
            long l = nativeMap != null ? nativeMap.addPolygon((Polygon)object) : 0L;
            ((Annotation)object).setId(l);
            ((Annotation)object).setMapboxMap(mapboxMap);
            this.annotations.put(l, object);
        }
        return object;
    }

    @Override
    public List<Polygon> addBy(List<PolygonOptions> object, MapboxMap mapboxMap) {
        int n = object.size();
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>(n);
        if (this.nativeMap != null && n > 0) {
            Object object2;
            object = object.iterator();
            while (object.hasNext()) {
                object2 = ((PolygonOptions)object.next()).getPolygon();
                if (((BasePointCollection)object2).getPoints().isEmpty()) continue;
                arrayList.add((Polygon)object2);
            }
            object2 = this.nativeMap.addPolygons(arrayList);
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = (Polygon)arrayList.get(n);
                ((Annotation)object).setMapboxMap(mapboxMap);
                ((Annotation)object).setId((long)object2[n]);
                this.annotations.put((long)object2[n], object);
            }
        }
        return arrayList;
    }

    @Override
    public List<Polygon> obtainAll() {
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Object object = this.annotations;
            if (!((object = (Annotation)object.get(object.keyAt(i))) instanceof Polygon)) continue;
            arrayList.add((Polygon)object);
        }
        return arrayList;
    }

    @Override
    public void update(Polygon polygon) {
        this.nativeMap.updatePolygon(polygon);
        LongSparseArray<Annotation> longSparseArray = this.annotations;
        longSparseArray.setValueAt(longSparseArray.indexOfKey(polygon.getId()), (Object)polygon);
    }
}

