/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import androidx.collection.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BasePointCollection;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.Polylines;
import java.util.ArrayList;
import java.util.List;

class PolylineContainer
implements Polylines {
    private final LongSparseArray<Annotation> annotations;
    private final NativeMap nativeMap;

    PolylineContainer(NativeMap nativeMap, LongSparseArray<Annotation> longSparseArray) {
        this.nativeMap = nativeMap;
        this.annotations = longSparseArray;
    }

    @Override
    public Polyline addBy(PolylineOptions object, MapboxMap mapboxMap) {
        Polyline polyline = ((PolylineOptions)object).getPolyline();
        if (!polyline.getPoints().isEmpty()) {
            object = this.nativeMap;
            long l = object != null ? object.addPolyline(polyline) : 0L;
            polyline.setMapboxMap(mapboxMap);
            polyline.setId(l);
            this.annotations.put(l, (Object)polyline);
        }
        return polyline;
    }

    @Override
    public List<Polyline> addBy(List<PolylineOptions> object, MapboxMap mapboxMap) {
        int n = object.size();
        ArrayList<Polyline> arrayList = new ArrayList<Polyline>(n);
        if (this.nativeMap != null && n > 0) {
            Object object2;
            object = object.iterator();
            while (object.hasNext()) {
                object2 = ((PolylineOptions)object.next()).getPolyline();
                if (((BasePointCollection)object2).getPoints().isEmpty()) continue;
                arrayList.add((Polyline)object2);
            }
            object2 = this.nativeMap.addPolylines(arrayList);
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = (Polyline)arrayList.get(n);
                ((Annotation)object).setMapboxMap(mapboxMap);
                ((Annotation)object).setId((long)object2[n]);
                this.annotations.put((long)object2[n], object);
            }
        }
        return arrayList;
    }

    @Override
    public List<Polyline> obtainAll() {
        ArrayList<Polyline> arrayList = new ArrayList<Polyline>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Object object = this.annotations;
            if (!((object = (Annotation)object.get(object.keyAt(i))) instanceof Polyline)) continue;
            arrayList.add((Polyline)object);
        }
        return arrayList;
    }

    @Override
    public void update(Polyline polyline) {
        this.nativeMap.updatePolyline(polyline);
        LongSparseArray<Annotation> longSparseArray = this.annotations;
        longSparseArray.setValueAt(longSparseArray.indexOfKey(polyline.getId()), (Object)polyline);
    }
}

