/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.util.Pair;
import com.mapbox.mapboxsdk.maps.Image;
import com.mapbox.mapboxsdk.maps.ImageContent;
import com.mapbox.mapboxsdk.maps.ImageStretches;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.light.Light;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Style {
    public static final String DARK = "mapbox://styles/mapbox/dark-v10";
    static final String EMPTY_JSON = "{\"version\": 8,\"sources\": {},\"layers\": []}";
    public static final String LIGHT = "mapbox://styles/mapbox/light-v10";
    public static final String MAPBOX_STREETS = "mapbox://styles/mapbox/streets-v11";
    public static final String OUTDOORS = "mapbox://styles/mapbox/outdoors-v11";
    public static final String SATELLITE = "mapbox://styles/mapbox/satellite-v9";
    public static final String SATELLITE_STREETS = "mapbox://styles/mapbox/satellite-streets-v11";
    public static final String TRAFFIC_DAY = "mapbox://styles/mapbox/traffic-day-v2";
    public static final String TRAFFIC_NIGHT = "mapbox://styles/mapbox/traffic-night-v2";
    private final Builder builder;
    private boolean fullyLoaded;
    private final HashMap<String, Bitmap> images;
    private final HashMap<String, Layer> layers;
    private final NativeMap nativeMap;
    private final HashMap<String, Source> sources = new HashMap();

    private Style(Builder builder, NativeMap nativeMap) {
        this.layers = new HashMap();
        this.images = new HashMap();
        this.builder = builder;
        this.nativeMap = nativeMap;
    }

    public static Image toImage(Builder.ImageWrapper object) {
        Object object2 = ((Builder.ImageWrapper)object).bitmap;
        Object object3 = object2.getConfig();
        Object object4 = Bitmap.Config.ARGB_8888;
        int n = 0;
        Bitmap bitmap = object2;
        if (object3 != object4) {
            bitmap = object2.copy(Bitmap.Config.ARGB_8888, false);
        }
        object3 = ByteBuffer.allocate(bitmap.getByteCount());
        bitmap.copyPixelsToBuffer((Buffer)object3);
        float f = (float)bitmap.getDensity() / 160.0f;
        if (((Builder.ImageWrapper)object).getStretchX() != null && ((Builder.ImageWrapper)object).getStretchY() != null) {
            int n2;
            object2 = new float[((Builder.ImageWrapper)object).getStretchX().size() * 2];
            for (n2 = 0; n2 < ((Builder.ImageWrapper)object).getStretchX().size(); ++n2) {
                int n3 = n2 * 2;
                object2[n3] = (Bitmap)((Builder.ImageWrapper)object).getStretchX().get(n2).getFirst();
                object2[n3 + 1] = (Bitmap)((Builder.ImageWrapper)object).getStretchX().get(n2).getSecond();
            }
            object4 = new float[((Builder.ImageWrapper)object).getStretchY().size() * 2];
            for (n2 = n; n2 < ((Builder.ImageWrapper)object).getStretchY().size(); ++n2) {
                n = n2 * 2;
                object4[n] = (Bitmap.Config)((Builder.ImageWrapper)object).getStretchY().get(n2).getFirst();
                object4[n + 1] = (Bitmap.Config)((Builder.ImageWrapper)object).getStretchY().get(n2).getSecond();
            }
            object3 = object3.array();
            String string2 = ((Builder.ImageWrapper)object).id;
            n2 = bitmap.getWidth();
            n = bitmap.getHeight();
            boolean bl = ((Builder.ImageWrapper)object).sdf;
            object = ((Builder.ImageWrapper)object).getContent() == null ? null : (Object)((Builder.ImageWrapper)object).getContent().getContentArray();
            return new Image((byte[])object3, f, string2, n2, n, bl, (float[])object2, (float[])object4, (float[])object);
        }
        return new Image(object3.array(), f, ((Builder.ImageWrapper)object).id, bitmap.getWidth(), bitmap.getHeight(), ((Builder.ImageWrapper)object).sdf);
    }

    private void validateState(String string2) {
        if (this.fullyLoaded) {
            return;
        }
        throw new IllegalStateException(String.format("Calling %s when a newer style is loading/has loaded.", string2));
    }

    public void addImage(String string2, Bitmap bitmap) {
        this.addImage(string2, bitmap, false);
    }

    public void addImage(String string2, Bitmap bitmap, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        this.addImage(string2, bitmap, false, list, list2, imageContent);
    }

    public void addImage(String string2, Bitmap bitmap, boolean bl) {
        this.validateState("addImage");
        this.nativeMap.addImages(new Image[]{Style.toImage(new Builder.ImageWrapper(string2, bitmap, bl))});
    }

    public void addImage(String string2, Bitmap bitmap, boolean bl, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        this.validateState("addImage");
        this.nativeMap.addImages(new Image[]{Style.toImage(new Builder.ImageWrapper(string2, bitmap, bl, list, list2, imageContent))});
    }

    public void addImage(String string2, Drawable drawable2) {
        if ((drawable2 = BitmapUtils.getBitmapFromDrawable(drawable2)) != null) {
            this.addImage(string2, (Bitmap)drawable2, false);
            return;
        }
        throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
    }

    public void addImage(String string2, Drawable drawable2, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        if ((drawable2 = BitmapUtils.getBitmapFromDrawable(drawable2)) != null) {
            this.addImage(string2, (Bitmap)drawable2, false, list, list2, imageContent);
            return;
        }
        throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
    }

    public void addImageAsync(String string2, Bitmap bitmap) {
        this.addImageAsync(string2, bitmap, false);
    }

    public void addImageAsync(String string2, Bitmap bitmap, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        this.addImageAsync(string2, bitmap, false, list, list2, imageContent);
    }

    public void addImageAsync(String string2, Bitmap bitmap, boolean bl) {
        this.validateState("addImage");
        new BitmapImageConversionTask(this.nativeMap).execute(new Builder.ImageWrapper[]{new Builder.ImageWrapper(string2, bitmap, bl)});
    }

    public void addImageAsync(String string2, Bitmap bitmap, boolean bl, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        this.validateState("addImage");
        new BitmapImageConversionTask(this.nativeMap).execute(new Builder.ImageWrapper[]{new Builder.ImageWrapper(string2, bitmap, bl, list, list2, imageContent)});
    }

    public void addImageAsync(String string2, Drawable drawable2) {
        if ((drawable2 = BitmapUtils.getBitmapFromDrawable(drawable2)) != null) {
            this.addImageAsync(string2, (Bitmap)drawable2, false);
            return;
        }
        throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
    }

    public void addImageAsync(String string2, Drawable drawable2, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        if ((drawable2 = BitmapUtils.getBitmapFromDrawable(drawable2)) != null) {
            this.addImageAsync(string2, (Bitmap)drawable2, false, list, list2, imageContent);
            return;
        }
        throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
    }

    public void addImages(HashMap<String, Bitmap> hashMap) {
        this.addImages(hashMap, false);
    }

    public void addImages(HashMap<String, Bitmap> hashMap, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        this.addImages(hashMap, false, list, list2, imageContent);
    }

    public void addImages(HashMap<String, Bitmap> imageWrapperArray, boolean bl) {
        this.validateState("addImage");
        Image[] imageArray = new Image[imageWrapperArray.size()];
        imageWrapperArray = Builder.ImageWrapper.convertToImageArray(imageWrapperArray, bl);
        int n = imageWrapperArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            imageArray[n2] = Style.toImage(imageWrapperArray[i]);
            ++n2;
        }
        this.nativeMap.addImages(imageArray);
    }

    public void addImages(HashMap<String, Bitmap> imageWrapperArray, boolean bl, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        this.validateState("addImage");
        Image[] imageArray = new Image[imageWrapperArray.size()];
        imageWrapperArray = Builder.ImageWrapper.convertToImageArray(imageWrapperArray, bl, list, list2, imageContent);
        int n = imageWrapperArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            imageArray[n2] = Style.toImage(imageWrapperArray[i]);
            ++n2;
        }
        this.nativeMap.addImages(imageArray);
    }

    public void addImages(Image[] imageArray) {
        this.validateState("addImages");
        this.nativeMap.addImages(imageArray);
    }

    public void addImagesAsync(HashMap<String, Bitmap> hashMap) {
        this.addImagesAsync(hashMap, false);
    }

    public void addImagesAsync(HashMap<String, Bitmap> hashMap, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        this.addImagesAsync(hashMap, false, list, list2, imageContent);
    }

    public void addImagesAsync(HashMap<String, Bitmap> hashMap, boolean bl) {
        this.validateState("addImages");
        new BitmapImageConversionTask(this.nativeMap).execute(Builder.ImageWrapper.convertToImageArray(hashMap, bl));
    }

    public void addImagesAsync(HashMap<String, Bitmap> hashMap, boolean bl, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
        this.validateState("addImages");
        new BitmapImageConversionTask(this.nativeMap).execute(Builder.ImageWrapper.convertToImageArray(hashMap, bl, list, list2, imageContent));
    }

    public void addLayer(Layer layer) {
        this.validateState("addLayer");
        this.nativeMap.addLayer(layer);
        this.layers.put(layer.getId(), layer);
    }

    public void addLayerAbove(Layer layer, String string2) {
        this.validateState("addLayerAbove");
        this.nativeMap.addLayerAbove(layer, string2);
        this.layers.put(layer.getId(), layer);
    }

    public void addLayerAt(Layer layer, int n) {
        this.validateState("addLayerAbove");
        this.nativeMap.addLayerAt(layer, n);
        this.layers.put(layer.getId(), layer);
    }

    public void addLayerBelow(Layer layer, String string2) {
        this.validateState("addLayerBelow");
        this.nativeMap.addLayerBelow(layer, string2);
        this.layers.put(layer.getId(), layer);
    }

    public void addSource(Source source) {
        this.validateState("addSource");
        this.nativeMap.addSource(source);
        this.sources.put(source.getId(), source);
    }

    void clear() {
        this.fullyLoaded = false;
        for (Layer layer : this.layers.values()) {
            if (layer == null) continue;
            layer.setDetached();
        }
        for (Source source : this.sources.values()) {
            if (source == null) continue;
            source.setDetached();
        }
        for (Map.Entry<String, Bitmap> entry : this.images.entrySet()) {
            this.nativeMap.removeImage(entry.getKey());
            entry.getValue().recycle();
        }
        this.sources.clear();
        this.layers.clear();
        this.images.clear();
    }

    public Bitmap getImage(String string2) {
        this.validateState("getImage");
        return this.nativeMap.getImage(string2);
    }

    public String getJson() {
        this.validateState("getJson");
        return this.nativeMap.getStyleJson();
    }

    public Layer getLayer(String string2) {
        Layer layer;
        this.validateState("getLayer");
        Layer layer2 = layer = this.layers.get(string2);
        if (layer == null) {
            layer2 = this.nativeMap.getLayer(string2);
        }
        return layer2;
    }

    public <T extends Layer> T getLayerAs(String string2) {
        this.validateState("getLayerAs");
        return (T)this.nativeMap.getLayer(string2);
    }

    public List<Layer> getLayers() {
        this.validateState("getLayers");
        return this.nativeMap.getLayers();
    }

    public Light getLight() {
        this.validateState("getLight");
        return this.nativeMap.getLight();
    }

    public Source getSource(String string2) {
        Source source;
        this.validateState("getSource");
        Source source2 = source = this.sources.get(string2);
        if (source == null) {
            source2 = this.nativeMap.getSource(string2);
        }
        return source2;
    }

    public <T extends Source> T getSourceAs(String string2) {
        this.validateState("getSourceAs");
        if (this.sources.containsKey(string2)) {
            return (T)this.sources.get(string2);
        }
        return (T)this.nativeMap.getSource(string2);
    }

    public List<Source> getSources() {
        this.validateState("getSources");
        return this.nativeMap.getSources();
    }

    public TransitionOptions getTransition() {
        this.validateState("getTransition");
        return this.nativeMap.getTransitionOptions();
    }

    public String getUri() {
        this.validateState("getUri");
        return this.nativeMap.getStyleUri();
    }

    @Deprecated
    public String getUrl() {
        this.validateState("getUrl");
        return this.nativeMap.getStyleUri();
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    void onDidFinishLoadingStyle() {
        if (!this.fullyLoaded) {
            this.fullyLoaded = true;
            Object object2 = this.builder.sources.iterator();
            while (object2.hasNext()) {
                this.addSource((Source)object2.next());
            }
            for (Object object2 : this.builder.layers) {
                if (object2 instanceof Builder.LayerAtWrapper) {
                    this.addLayerAt(((Builder.LayerWrapper)object2).layer, ((Builder.LayerAtWrapper)object2).index);
                    continue;
                }
                if (object2 instanceof Builder.LayerAboveWrapper) {
                    this.addLayerAbove(((Builder.LayerWrapper)object2).layer, ((Builder.LayerAboveWrapper)object2).aboveLayer);
                    continue;
                }
                if (object2 instanceof Builder.LayerBelowWrapper) {
                    this.addLayerBelow(((Builder.LayerWrapper)object2).layer, ((Builder.LayerBelowWrapper)object2).belowLayer);
                    continue;
                }
                this.addLayerBelow(((Builder.LayerWrapper)object2).layer, "com.mapbox.annotations.points");
            }
            for (Object object2 : this.builder.images) {
                this.addImage(((Builder.ImageWrapper)object2).id, ((Builder.ImageWrapper)object2).bitmap, ((Builder.ImageWrapper)object2).sdf);
            }
            if (this.builder.transitionOptions != null) {
                this.setTransition(this.builder.transitionOptions);
            }
        }
    }

    public void removeImage(String string2) {
        this.validateState("removeImage");
        this.nativeMap.removeImage(string2);
    }

    public boolean removeLayer(Layer layer) {
        this.validateState("removeLayer");
        this.layers.remove(layer.getId());
        return this.nativeMap.removeLayer(layer);
    }

    public boolean removeLayer(String string2) {
        this.validateState("removeLayer");
        this.layers.remove(string2);
        return this.nativeMap.removeLayer(string2);
    }

    public boolean removeLayerAt(int n) {
        this.validateState("removeLayerAt");
        return this.nativeMap.removeLayerAt(n);
    }

    public boolean removeSource(Source source) {
        this.validateState("removeSource");
        this.sources.remove(source.getId());
        return this.nativeMap.removeSource(source);
    }

    public boolean removeSource(String string2) {
        this.validateState("removeSource");
        this.sources.remove(string2);
        return this.nativeMap.removeSource(string2);
    }

    public void setTransition(TransitionOptions transitionOptions) {
        this.validateState("setTransition");
        this.nativeMap.setTransitionOptions(transitionOptions);
    }

    private static class BitmapImageConversionTask
    extends AsyncTask<Builder.ImageWrapper, Void, Image[]> {
        private WeakReference<NativeMap> nativeMap;

        BitmapImageConversionTask(NativeMap nativeMap) {
            this.nativeMap = new WeakReference<NativeMap>(nativeMap);
        }

        protected Image[] doInBackground(Builder.ImageWrapper ... imageWrapperArray) {
            ArrayList<Image> arrayList = new ArrayList<Image>();
            int n = imageWrapperArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(Style.toImage(imageWrapperArray[i]));
            }
            return arrayList.toArray(new Image[arrayList.size()]);
        }

        protected void onPostExecute(Image[] imageArray) {
            super.onPostExecute((Object)imageArray);
            NativeMap nativeMap = (NativeMap)this.nativeMap.get();
            if (nativeMap != null && !nativeMap.isDestroyed()) {
                nativeMap.addImages(imageArray);
            }
        }
    }

    public static class Builder {
        private final List<ImageWrapper> images;
        private final List<LayerWrapper> layers;
        private final List<Source> sources = new ArrayList<Source>();
        private String styleJson;
        private String styleUri;
        private TransitionOptions transitionOptions;

        public Builder() {
            this.layers = new ArrayList<LayerWrapper>();
            this.images = new ArrayList<ImageWrapper>();
        }

        Style build(NativeMap nativeMap) {
            return new Style(this, nativeMap);
        }

        public Builder fromJson(String string2) {
            this.styleJson = string2;
            return this;
        }

        public Builder fromUri(String string2) {
            this.styleUri = string2;
            return this;
        }

        @Deprecated
        public Builder fromUrl(String string2) {
            this.styleUri = string2;
            return this;
        }

        public List<ImageWrapper> getImages() {
            return this.images;
        }

        public String getJson() {
            return this.styleJson;
        }

        public List<LayerWrapper> getLayers() {
            return this.layers;
        }

        public List<Source> getSources() {
            return this.sources;
        }

        TransitionOptions getTransitionOptions() {
            return this.transitionOptions;
        }

        public String getUri() {
            return this.styleUri;
        }

        public Builder withBitmapImages(boolean bl, Pair<String, Bitmap> ... pairArray) {
            for (Pair<String, Bitmap> pair : pairArray) {
                this.withImage((String)pair.first, (Bitmap)pair.second, bl);
            }
            return this;
        }

        public Builder withBitmapImages(Pair<String, Bitmap> ... pairArray) {
            for (Pair<String, Bitmap> pair : pairArray) {
                this.withImage((String)pair.first, (Bitmap)pair.second, false);
            }
            return this;
        }

        public Builder withDrawableImages(boolean bl, Pair<String, Drawable> ... pairArray) {
            for (Pair<String, Drawable> pair : pairArray) {
                Bitmap bitmap = BitmapUtils.getBitmapFromDrawable((Drawable)pair.second);
                if (bitmap != null) {
                    this.withImage((String)pair.first, bitmap, bl);
                    continue;
                }
                throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
            }
            return this;
        }

        public Builder withDrawableImages(Pair<String, Drawable> ... pairArray) {
            return this.withDrawableImages(false, pairArray);
        }

        public Builder withImage(String string2, Bitmap bitmap) {
            return this.withImage(string2, bitmap, false);
        }

        public Builder withImage(String string2, Bitmap bitmap, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
            return this.withImage(string2, bitmap, false, list, list2, imageContent);
        }

        public Builder withImage(String string2, Bitmap bitmap, boolean bl) {
            this.images.add(new ImageWrapper(string2, bitmap, bl));
            return this;
        }

        public Builder withImage(String string2, Bitmap bitmap, boolean bl, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
            this.images.add(new ImageWrapper(string2, bitmap, bl, list, list2, imageContent));
            return this;
        }

        public Builder withImage(String string2, Drawable drawable2) {
            if ((drawable2 = BitmapUtils.getBitmapFromDrawable(drawable2)) != null) {
                return this.withImage(string2, (Bitmap)drawable2, false);
            }
            throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
        }

        public Builder withImage(String string2, Drawable drawable2, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
            if ((drawable2 = BitmapUtils.getBitmapFromDrawable(drawable2)) != null) {
                return this.withImage(string2, (Bitmap)drawable2, false, list, list2, imageContent);
            }
            throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
        }

        public Builder withImage(String string2, Drawable drawable2, boolean bl) {
            if ((drawable2 = BitmapUtils.getBitmapFromDrawable(drawable2)) != null) {
                return this.withImage(string2, (Bitmap)drawable2, bl);
            }
            throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
        }

        public Builder withImage(String string2, Drawable drawable2, boolean bl, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
            if ((drawable2 = BitmapUtils.getBitmapFromDrawable(drawable2)) != null) {
                return this.withImage(string2, (Bitmap)drawable2, bl, list, list2, imageContent);
            }
            throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
        }

        public Builder withLayer(Layer layer) {
            this.layers.add(new LayerWrapper(layer));
            return this;
        }

        public Builder withLayerAbove(Layer layer, String string2) {
            this.layers.add(new LayerAboveWrapper(layer, string2));
            return this;
        }

        public Builder withLayerAt(Layer layer, int n) {
            this.layers.add(new LayerAtWrapper(layer, n));
            return this;
        }

        public Builder withLayerBelow(Layer layer, String string2) {
            this.layers.add(new LayerBelowWrapper(layer, string2));
            return this;
        }

        public Builder withLayers(Layer ... layerArray) {
            for (Layer layer : layerArray) {
                this.layers.add(new LayerWrapper(layer));
            }
            return this;
        }

        public Builder withSource(Source source) {
            this.sources.add(source);
            return this;
        }

        public Builder withSources(Source ... sourceArray) {
            this.sources.addAll(Arrays.asList(sourceArray));
            return this;
        }

        public Builder withTransition(TransitionOptions transitionOptions) {
            this.transitionOptions = transitionOptions;
            return this;
        }

        public static class ImageWrapper {
            Bitmap bitmap;
            ImageContent content;
            String id;
            boolean sdf;
            List<ImageStretches> stretchX;
            List<ImageStretches> stretchY;

            public ImageWrapper(String string2, Bitmap bitmap, boolean bl) {
                this(string2, bitmap, bl, null, null, null);
            }

            public ImageWrapper(String string2, Bitmap bitmap, boolean bl, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
                this.id = string2;
                this.bitmap = bitmap;
                this.sdf = bl;
                this.stretchX = list;
                this.stretchY = list2;
                this.content = imageContent;
            }

            public static ImageWrapper[] convertToImageArray(HashMap<String, Bitmap> hashMap, boolean bl) {
                ImageWrapper[] imageWrapperArray = new ImageWrapper[hashMap.size()];
                ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
                for (int i = 0; i < hashMap.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    imageWrapperArray[i] = new ImageWrapper(string2, hashMap.get(string2), bl);
                }
                return imageWrapperArray;
            }

            public static ImageWrapper[] convertToImageArray(HashMap<String, Bitmap> hashMap, boolean bl, List<ImageStretches> list, List<ImageStretches> list2, ImageContent imageContent) {
                ImageWrapper[] imageWrapperArray = new ImageWrapper[hashMap.size()];
                ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
                for (int i = 0; i < hashMap.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    imageWrapperArray[i] = new ImageWrapper(string2, hashMap.get(string2), bl, list, list2, imageContent);
                }
                return imageWrapperArray;
            }

            public Bitmap getBitmap() {
                return this.bitmap;
            }

            public ImageContent getContent() {
                return this.content;
            }

            public String getId() {
                return this.id;
            }

            public List<ImageStretches> getStretchX() {
                return this.stretchX;
            }

            public List<ImageStretches> getStretchY() {
                return this.stretchY;
            }

            public boolean isSdf() {
                return this.sdf;
            }
        }

        public class LayerAboveWrapper
        extends LayerWrapper {
            String aboveLayer;

            LayerAboveWrapper(Layer layer, String string2) {
                super(layer);
                this.aboveLayer = string2;
            }

            public String getAboveLayer() {
                return this.aboveLayer;
            }
        }

        public class LayerAtWrapper
        extends LayerWrapper {
            int index;

            LayerAtWrapper(Layer layer, int n) {
                super(layer);
                this.index = n;
            }

            public int getIndex() {
                return this.index;
            }
        }

        public class LayerBelowWrapper
        extends LayerWrapper {
            String belowLayer;

            LayerBelowWrapper(Layer layer, String string2) {
                super(layer);
                this.belowLayer = string2;
            }

            public String getBelowLayer() {
                return this.belowLayer;
            }
        }

        public class LayerWrapper {
            Layer layer;

            LayerWrapper(Layer layer) {
                this.layer = layer;
            }

            public Layer getLayer() {
                return this.layer;
            }
        }
    }

    public static interface OnStyleLoaded {
        public void onStyleLoaded(Style var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StyleUrl {
    }
}

