/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.os.Handler;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMap;

public final class Transform
implements MapView.OnCameraDidChangeListener {
    private static final String TAG = "Mbgl-Transform";
    private MapboxMap.CancelableCallback cameraCancelableCallback;
    private CameraChangeDispatcher cameraChangeDispatcher;
    private CameraPosition cameraPosition;
    private final Handler handler = new Handler();
    private final MapView mapView;
    private final MapView.OnCameraDidChangeListener moveByChangeListener = new MapView.OnCameraDidChangeListener(){

        @Override
        public void onCameraDidChange(boolean bl) {
            if (bl) {
                Transform.this.cameraChangeDispatcher.onCameraIdle();
                Transform.this.mapView.removeOnCameraDidChangeListener(this);
            }
        }
    };
    private final NativeMap nativeMap;

    Transform(MapView mapView, NativeMap nativeMap, CameraChangeDispatcher cameraChangeDispatcher) {
        this.mapView = mapView;
        this.nativeMap = nativeMap;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
    }

    private boolean isValidCameraPosition(CameraPosition cameraPosition) {
        boolean bl = cameraPosition != null && !cameraPosition.equals(this.cameraPosition);
        return bl;
    }

    public final void animateCamera(MapboxMap object, CameraUpdate cameraUpdate, int n, MapboxMap.CancelableCallback cancelableCallback) {
        if (this.isValidCameraPosition((CameraPosition)(object = cameraUpdate.getCameraPosition((MapboxMap)object)))) {
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            if (cancelableCallback != null) {
                this.cameraCancelableCallback = cancelableCallback;
            }
            this.mapView.addOnCameraDidChangeListener(this);
            this.nativeMap.flyTo(((CameraPosition)object).target, ((CameraPosition)object).zoom, ((CameraPosition)object).bearing, ((CameraPosition)object).tilt, ((CameraPosition)object).padding, n);
        } else if (cancelableCallback != null) {
            cancelableCallback.onFinish();
        }
    }

    void cancelTransitions() {
        this.cameraChangeDispatcher.onCameraMoveCanceled();
        final MapboxMap.CancelableCallback cancelableCallback = this.cameraCancelableCallback;
        if (cancelableCallback != null) {
            this.cameraChangeDispatcher.onCameraIdle();
            this.cameraCancelableCallback = null;
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    cancelableCallback.onCancel();
                }
            });
        }
        this.nativeMap.cancelTransitions();
        this.cameraChangeDispatcher.onCameraIdle();
    }

    final void easeCamera(MapboxMap object, CameraUpdate cameraUpdate, int n, boolean bl, MapboxMap.CancelableCallback cancelableCallback) {
        if (this.isValidCameraPosition((CameraPosition)(object = cameraUpdate.getCameraPosition((MapboxMap)object)))) {
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            if (cancelableCallback != null) {
                this.cameraCancelableCallback = cancelableCallback;
            }
            this.mapView.addOnCameraDidChangeListener(this);
            this.nativeMap.easeTo(((CameraPosition)object).target, ((CameraPosition)object).zoom, ((CameraPosition)object).bearing, ((CameraPosition)object).tilt, ((CameraPosition)object).padding, n, bl);
        } else if (cancelableCallback != null) {
            cancelableCallback.onFinish();
        }
    }

    double getBearing() {
        double d;
        double d2 = -this.nativeMap.getBearing();
        while (true) {
            if (!(d2 > 360.0)) break;
            d2 -= 360.0;
        }
        for (d = d2; d < 0.0; d += 360.0) {
        }
        return d;
    }

    public final CameraPosition getCameraPosition() {
        if (this.cameraPosition == null) {
            this.cameraPosition = this.invalidateCameraPosition();
        }
        return this.cameraPosition;
    }

    LatLng getCenterCoordinate() {
        return this.nativeMap.getLatLng();
    }

    LatLng getLatLng() {
        return this.nativeMap.getLatLng();
    }

    double getMaxPitch() {
        return this.nativeMap.getMaxPitch();
    }

    double getMaxZoom() {
        return this.nativeMap.getMaxZoom();
    }

    double getMinPitch() {
        return this.nativeMap.getMinPitch();
    }

    double getMinZoom() {
        return this.nativeMap.getMinZoom();
    }

    double getRawBearing() {
        return this.nativeMap.getBearing();
    }

    double getRawZoom() {
        return this.nativeMap.getZoom();
    }

    double getTilt() {
        return this.nativeMap.getPitch();
    }

    void initialise(MapboxMap mapboxMap, MapboxMapOptions mapboxMapOptions) {
        CameraPosition cameraPosition = mapboxMapOptions.getCamera();
        if (cameraPosition != null && !cameraPosition.equals(CameraPosition.DEFAULT)) {
            this.moveCamera(mapboxMap, CameraUpdateFactory.newCameraPosition(cameraPosition), null);
        }
        this.setMinZoom(mapboxMapOptions.getMinZoomPreference());
        this.setMaxZoom(mapboxMapOptions.getMaxZoomPreference());
        this.setMinPitch(mapboxMapOptions.getMinPitchPreference());
        this.setMaxPitch(mapboxMapOptions.getMaxPitchPreference());
    }

    CameraPosition invalidateCameraPosition() {
        Object object = this.nativeMap;
        if (object != null) {
            CameraPosition cameraPosition = object.getCameraPosition();
            object = this.cameraPosition;
            if (object != null && !((CameraPosition)object).equals(cameraPosition)) {
                this.cameraChangeDispatcher.onCameraMove();
            }
            this.cameraPosition = cameraPosition;
        }
        return this.cameraPosition;
    }

    void moveBy(double d, double d2, long l) {
        if (l > 0L) {
            this.mapView.addOnCameraDidChangeListener(this.moveByChangeListener);
        }
        this.nativeMap.moveBy(d, d2, l);
    }

    public final void moveCamera(MapboxMap object, CameraUpdate cameraUpdate, final MapboxMap.CancelableCallback cancelableCallback) {
        if (this.isValidCameraPosition((CameraPosition)(object = cameraUpdate.getCameraPosition((MapboxMap)object)))) {
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            this.nativeMap.jumpTo(((CameraPosition)object).target, ((CameraPosition)object).zoom, ((CameraPosition)object).tilt, ((CameraPosition)object).bearing, ((CameraPosition)object).padding);
            this.invalidateCameraPosition();
            this.cameraChangeDispatcher.onCameraIdle();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    MapboxMap.CancelableCallback cancelableCallback2 = cancelableCallback;
                    if (cancelableCallback2 != null) {
                        cancelableCallback2.onFinish();
                    }
                }
            });
        } else if (cancelableCallback != null) {
            cancelableCallback.onFinish();
        }
    }

    @Override
    public void onCameraDidChange(boolean bl) {
        if (bl) {
            this.invalidateCameraPosition();
            final MapboxMap.CancelableCallback cancelableCallback = this.cameraCancelableCallback;
            if (cancelableCallback != null) {
                this.cameraCancelableCallback = null;
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        cancelableCallback.onFinish();
                    }
                });
            }
            this.cameraChangeDispatcher.onCameraIdle();
            this.mapView.removeOnCameraDidChangeListener(this);
        }
    }

    void resetNorth() {
        this.cancelTransitions();
        this.nativeMap.resetNorth();
    }

    void setBearing(double d) {
        this.nativeMap.setBearing(d, 0L);
    }

    void setBearing(double d, float f, float f2) {
        this.nativeMap.setBearing(d, f, f2, 0L);
    }

    void setBearing(double d, float f, float f2, long l) {
        this.nativeMap.setBearing(d, f, f2, l);
    }

    void setCenterCoordinate(LatLng latLng) {
        this.nativeMap.setLatLng(latLng, 0L);
    }

    void setGestureInProgress(boolean bl) {
        this.nativeMap.setGestureInProgress(bl);
        if (!bl) {
            this.invalidateCameraPosition();
        }
    }

    void setMaxPitch(double d) {
        if (!(d < 0.0) && !(d > 60.0)) {
            this.nativeMap.setMaxPitch(d);
            return;
        }
        Logger.e(TAG, String.format("Not setting maxPitchPreference, value is in unsupported range: %s", d));
    }

    void setMaxZoom(double d) {
        if (!(d < 0.0) && !(d > 25.5)) {
            this.nativeMap.setMaxZoom(d);
            return;
        }
        Logger.e(TAG, String.format("Not setting maxZoomPreference, value is in unsupported range: %s", d));
    }

    void setMinPitch(double d) {
        if (!(d < 0.0) && !(d > 60.0)) {
            this.nativeMap.setMinPitch(d);
            return;
        }
        Logger.e(TAG, String.format("Not setting minPitchPreference, value is in unsupported range: %s", d));
    }

    void setMinZoom(double d) {
        if (!(d < 0.0) && !(d > 25.5)) {
            this.nativeMap.setMinZoom(d);
            return;
        }
        Logger.e(TAG, String.format("Not setting minZoomPreference, value is in unsupported range: %s", d));
    }

    void setTilt(Double d) {
        this.nativeMap.setPitch(d, 0L);
    }

    void setZoom(double d, PointF pointF) {
        this.nativeMap.setZoom(d, pointF, 0L);
    }

    void zoomBy(double d, PointF pointF) {
        this.setZoom(this.nativeMap.getZoom() + d, pointF);
    }
}

