/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.AttributionDialogManager;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public final class UiSettings {
    private AttributionDialogManager attributionDialogManager;
    private final int[] attributionsMargins;
    ImageView attributionsView;
    private double clockwiseBearing;
    private final int[] compassMargins = new int[4];
    CompassView compassView;
    private boolean deselectMarkersOnTap = true;
    private boolean disableRotateWhenScaling = true;
    private boolean doubleTapGesturesEnabled = true;
    private boolean flingVelocityAnimationEnabled = true;
    private final FocalPointChangeListener focalPointChangeListener;
    private boolean horizontalScrollGesturesEnabled = true;
    private boolean increaseRotateThresholdWhenScaling = true;
    private boolean increaseScaleThresholdWhenRotating = true;
    boolean isAttributionInitialized = false;
    boolean isCompassInitialized = false;
    boolean isLogoInitialized = false;
    private final int[] logoMargins;
    ImageView logoView;
    private final MapView mapView;
    private final float pixelRatio;
    private final Projection projection;
    private boolean quickZoomGesturesEnabled = true;
    private boolean rotateGesturesEnabled = true;
    private boolean rotateVelocityAnimationEnabled = true;
    private boolean scaleVelocityAnimationEnabled = true;
    private boolean scrollGesturesEnabled = true;
    private boolean tiltGesturesEnabled = true;
    private PointF userProvidedFocalPoint;
    private boolean zoomGesturesEnabled = true;
    private float zoomRate = 1.0f;

    UiSettings(Projection projection, FocalPointChangeListener focalPointChangeListener, float f, MapView mapView) {
        this.attributionsMargins = new int[4];
        this.logoMargins = new int[4];
        this.projection = projection;
        this.focalPointChangeListener = focalPointChangeListener;
        this.pixelRatio = f;
        this.mapView = mapView;
    }

    private void initialiseAttribution(Context context, MapboxMapOptions mapboxMapOptions) {
        this.isAttributionInitialized = true;
        this.attributionsView = this.mapView.initialiseAttributionView();
        this.setAttributionEnabled(mapboxMapOptions.getAttributionEnabled());
        this.setAttributionGravity(mapboxMapOptions.getAttributionGravity());
        this.setAttributionMargins(context, mapboxMapOptions.getAttributionMargins());
        int n = mapboxMapOptions.getAttributionTintColor();
        if (n == -1) {
            n = ColorUtils.getPrimaryColor(context);
        }
        this.setAttributionTintColor(n);
    }

    private void initialiseCompass(MapboxMapOptions mapboxMapOptions, Resources resources) {
        this.isCompassInitialized = true;
        this.compassView = this.mapView.initialiseCompassView();
        this.setCompassEnabled(mapboxMapOptions.getCompassEnabled());
        this.setCompassGravity(mapboxMapOptions.getCompassGravity());
        int[] nArray = mapboxMapOptions.getCompassMargins();
        if (nArray != null) {
            this.setCompassMargins(nArray[0], nArray[1], nArray[2], nArray[3]);
        } else {
            int n = (int)resources.getDimension(R.dimen.mapbox_four_dp);
            this.setCompassMargins(n, n, n, n);
        }
        this.setCompassFadeFacingNorth(mapboxMapOptions.getCompassFadeFacingNorth());
        if (mapboxMapOptions.getCompassImage() != null) {
            this.setCompassImage(mapboxMapOptions.getCompassImage());
        }
        this.setCompassImageResource(mapboxMapOptions.getCompassImageResource());
    }

    private void initialiseGestures(MapboxMapOptions mapboxMapOptions) {
        this.setZoomGesturesEnabled(mapboxMapOptions.getZoomGesturesEnabled());
        this.setScrollGesturesEnabled(mapboxMapOptions.getScrollGesturesEnabled());
        this.setHorizontalScrollGesturesEnabled(mapboxMapOptions.getHorizontalScrollGesturesEnabled());
        this.setRotateGesturesEnabled(mapboxMapOptions.getRotateGesturesEnabled());
        this.setTiltGesturesEnabled(mapboxMapOptions.getTiltGesturesEnabled());
        this.setDoubleTapGesturesEnabled(mapboxMapOptions.getDoubleTapGesturesEnabled());
        this.setQuickZoomGesturesEnabled(mapboxMapOptions.getQuickZoomGesturesEnabled());
    }

    private void initialiseLogo(MapboxMapOptions mapboxMapOptions, Resources resources) {
        this.isLogoInitialized = true;
        this.logoView = this.mapView.initialiseLogoView();
        this.setLogoEnabled(mapboxMapOptions.getLogoEnabled());
        this.setLogoGravity(mapboxMapOptions.getLogoGravity());
        this.setLogoMargins(resources, mapboxMapOptions.getLogoMargins());
    }

    private void restoreAttribution(Bundle bundle) {
        if (bundle.getBoolean("mapbox_atrrEnabled") && !this.isAttributionInitialized) {
            this.attributionsView = this.mapView.initialiseAttributionView();
            this.isAttributionInitialized = true;
        }
        this.setAttributionEnabled(bundle.getBoolean("mapbox_atrrEnabled"));
        this.setAttributionGravity(bundle.getInt("mapbox_attrGravity"));
        this.setAttributionMargins(bundle.getInt("mapbox_attrMarginLeft"), bundle.getInt("mapbox_attrMarginTop"), bundle.getInt("mapbox_attrMarginRight"), bundle.getInt("mapbox_atrrMarginBottom"));
    }

    private void restoreCompass(Bundle bundle) {
        if (bundle.getBoolean("mapbox_compassEnabled") && !this.isCompassInitialized) {
            this.compassView = this.mapView.initialiseCompassView();
            this.isCompassInitialized = true;
        }
        this.setCompassEnabled(bundle.getBoolean("mapbox_compassEnabled"));
        this.setCompassGravity(bundle.getInt("mapbox_compassGravity"));
        this.setCompassMargins(bundle.getInt("mapbox_compassMarginLeft"), bundle.getInt("mapbox_compassMarginTop"), bundle.getInt("mapbox_compassMarginRight"), bundle.getInt("mapbox_compassMarginBottom"));
        this.setCompassFadeFacingNorth(bundle.getBoolean("mapbox_compassFade"));
        if (bundle.containsKey("mapbox_compassImage")) {
            this.setCompassImage(BitmapUtils.getDrawableFromByteArray(this.mapView.getContext(), bundle.getByteArray("mapbox_compassImage")));
        } else {
            this.setCompassImageResource(bundle.getInt("mapbox_compassImageRes"));
        }
    }

    private void restoreDeselectMarkersOnTap(Bundle bundle) {
        this.setDeselectMarkersOnTap(bundle.getBoolean("mapbox_deselectMarkerOnTap"));
    }

    private void restoreFocalPoint(Bundle bundle) {
        if ((bundle = (PointF)bundle.getParcelable("mapbox_userFocalPoint")) != null) {
            this.setFocalPoint((PointF)bundle);
        }
    }

    private void restoreGestures(Bundle bundle) {
        this.setHorizontalScrollGesturesEnabled(bundle.getBoolean("mapbox_horizontalScrollEnabled"));
        this.setZoomGesturesEnabled(bundle.getBoolean("mapbox_zoomEnabled"));
        this.setScrollGesturesEnabled(bundle.getBoolean("mapbox_scrollEnabled"));
        this.setRotateGesturesEnabled(bundle.getBoolean("mapbox_rotateEnabled"));
        this.setTiltGesturesEnabled(bundle.getBoolean("mapbox_tiltEnabled"));
        this.setDoubleTapGesturesEnabled(bundle.getBoolean("mapbox_doubleTapEnabled"));
        this.setScaleVelocityAnimationEnabled(bundle.getBoolean("mapbox_scaleAnimationEnabled"));
        this.setRotateVelocityAnimationEnabled(bundle.getBoolean("mapbox_rotateAnimationEnabled"));
        this.setFlingVelocityAnimationEnabled(bundle.getBoolean("mapbox_flingAnimationEnabled"));
        this.setIncreaseRotateThresholdWhenScaling(bundle.getBoolean("mapbox_increaseRotateThreshold"));
        this.setDisableRotateWhenScaling(bundle.getBoolean("mapbox_disableRotateWhenScaling"));
        this.setIncreaseScaleThresholdWhenRotating(bundle.getBoolean("mapbox_increaseScaleThreshold"));
        this.setQuickZoomGesturesEnabled(bundle.getBoolean("mapbox_quickZoom"));
        this.setZoomRate(bundle.getFloat("mapbox_zoomRate", 1.0f));
    }

    private void restoreLogo(Bundle bundle) {
        if (bundle.getBoolean("mapbox_logoEnabled") && !this.isLogoInitialized) {
            this.logoView = this.mapView.initialiseLogoView();
            this.isLogoInitialized = true;
        }
        this.setLogoEnabled(bundle.getBoolean("mapbox_logoEnabled"));
        this.setLogoGravity(bundle.getInt("mapbox_logoGravity"));
        this.setLogoMargins(bundle.getInt("mapbox_logoMarginLeft"), bundle.getInt("mapbox_logoMarginTop"), bundle.getInt("mapbox_logoMarginRight"), bundle.getInt("mapbox_logoMarginBottom"));
    }

    private void saveAttribution(Bundle bundle) {
        bundle.putInt("mapbox_attrGravity", this.getAttributionGravity());
        bundle.putInt("mapbox_attrMarginLeft", this.getAttributionMarginLeft());
        bundle.putInt("mapbox_attrMarginTop", this.getAttributionMarginTop());
        bundle.putInt("mapbox_attrMarginRight", this.getAttributionMarginRight());
        bundle.putInt("mapbox_atrrMarginBottom", this.getAttributionMarginBottom());
        bundle.putBoolean("mapbox_atrrEnabled", this.isAttributionEnabled());
    }

    private void saveCompass(Bundle bundle) {
        bundle.putBoolean("mapbox_compassEnabled", this.isCompassEnabled());
        bundle.putInt("mapbox_compassGravity", this.getCompassGravity());
        bundle.putInt("mapbox_compassMarginLeft", this.getCompassMarginLeft());
        bundle.putInt("mapbox_compassMarginTop", this.getCompassMarginTop());
        bundle.putInt("mapbox_compassMarginBottom", this.getCompassMarginBottom());
        bundle.putInt("mapbox_compassMarginRight", this.getCompassMarginRight());
        bundle.putBoolean("mapbox_compassFade", this.isCompassFadeWhenFacingNorth());
        CompassView compassView = this.compassView;
        if (compassView != null && compassView.isLegacyImageDrawableSetter()) {
            bundle.putByteArray("mapbox_compassImage", BitmapUtils.getByteArrayFromDrawable(this.getCompassImage()));
        } else {
            bundle.putInt("mapbox_compassImageRes", this.getCompassImageResource());
        }
    }

    private void saveDeselectMarkersOnTap(Bundle bundle) {
        bundle.putBoolean("mapbox_deselectMarkerOnTap", this.isDeselectMarkersOnTap());
    }

    private void saveFocalPoint(Bundle bundle) {
        bundle.putParcelable("mapbox_userFocalPoint", (Parcelable)this.getFocalPoint());
    }

    private void saveGestures(Bundle bundle) {
        bundle.putBoolean("mapbox_horizontalScrollEnabled", this.isHorizontalScrollGesturesEnabled());
        bundle.putBoolean("mapbox_zoomEnabled", this.isZoomGesturesEnabled());
        bundle.putBoolean("mapbox_scrollEnabled", this.isScrollGesturesEnabled());
        bundle.putBoolean("mapbox_rotateEnabled", this.isRotateGesturesEnabled());
        bundle.putBoolean("mapbox_tiltEnabled", this.isTiltGesturesEnabled());
        bundle.putBoolean("mapbox_doubleTapEnabled", this.isDoubleTapGesturesEnabled());
        bundle.putBoolean("mapbox_scaleAnimationEnabled", this.isScaleVelocityAnimationEnabled());
        bundle.putBoolean("mapbox_rotateAnimationEnabled", this.isRotateVelocityAnimationEnabled());
        bundle.putBoolean("mapbox_flingAnimationEnabled", this.isFlingVelocityAnimationEnabled());
        bundle.putBoolean("mapbox_increaseRotateThreshold", this.isIncreaseRotateThresholdWhenScaling());
        bundle.putBoolean("mapbox_disableRotateWhenScaling", this.isDisableRotateWhenScaling());
        bundle.putBoolean("mapbox_increaseScaleThreshold", this.isIncreaseScaleThresholdWhenRotating());
        bundle.putBoolean("mapbox_quickZoom", this.isQuickZoomGesturesEnabled());
        bundle.putFloat("mapbox_zoomRate", this.getZoomRate());
    }

    private void saveLogo(Bundle bundle) {
        bundle.putInt("mapbox_logoGravity", this.getLogoGravity());
        bundle.putInt("mapbox_logoMarginLeft", this.getLogoMarginLeft());
        bundle.putInt("mapbox_logoMarginTop", this.getLogoMarginTop());
        bundle.putInt("mapbox_logoMarginRight", this.getLogoMarginRight());
        bundle.putInt("mapbox_logoMarginBottom", this.getLogoMarginBottom());
        bundle.putBoolean("mapbox_logoEnabled", this.isLogoEnabled());
    }

    private void setAttributionMargins(Context context, int[] nArray) {
        if (nArray != null) {
            this.setAttributionMargins(nArray[0], nArray[1], nArray[2], nArray[3]);
        } else {
            context = context.getResources();
            int n = (int)context.getDimension(R.dimen.mapbox_four_dp);
            this.setAttributionMargins((int)context.getDimension(R.dimen.mapbox_ninety_two_dp), n, n, n);
        }
    }

    private void setLogoMargins(Resources resources, int[] nArray) {
        if (nArray != null) {
            this.setLogoMargins(nArray[0], nArray[1], nArray[2], nArray[3]);
        } else {
            int n = (int)resources.getDimension(R.dimen.mapbox_four_dp);
            this.setLogoMargins(n, n, n, n);
        }
    }

    private void setWidgetGravity(View view, int n) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.gravity = n;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(View view, int[] object, int n, int n2, int n3, int n4) {
        object[0] = n;
        object[1] = n2;
        object[2] = n3;
        object[3] = n4;
        object = (FrameLayout.LayoutParams)view.getLayoutParams();
        object.setMargins(n, n2, n3, n4);
        if (Build.VERSION.SDK_INT >= 17) {
            object.setMarginStart(n);
            object.setMarginEnd(n3);
        }
        view.setLayoutParams((ViewGroup.LayoutParams)object);
    }

    public boolean areAllGesturesEnabled() {
        boolean bl = this.rotateGesturesEnabled && this.tiltGesturesEnabled && this.zoomGesturesEnabled && this.scrollGesturesEnabled && this.doubleTapGesturesEnabled && this.quickZoomGesturesEnabled;
        return bl;
    }

    public AttributionDialogManager getAttributionDialogManager() {
        return this.attributionDialogManager;
    }

    public int getAttributionGravity() {
        ImageView imageView = this.attributionsView;
        if (imageView != null) {
            return ((FrameLayout.LayoutParams)imageView.getLayoutParams()).gravity;
        }
        return -1;
    }

    public int getAttributionMarginBottom() {
        return this.attributionsMargins[3];
    }

    public int getAttributionMarginLeft() {
        return this.attributionsMargins[0];
    }

    public int getAttributionMarginRight() {
        return this.attributionsMargins[2];
    }

    public int getAttributionMarginTop() {
        return this.attributionsMargins[1];
    }

    public int getCompassGravity() {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            return ((FrameLayout.LayoutParams)compassView.getLayoutParams()).gravity;
        }
        return -1;
    }

    @Deprecated
    public Drawable getCompassImage() {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            return compassView.getCompassImage();
        }
        return null;
    }

    public int getCompassImageResource() {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            return compassView.getCompassImageResource();
        }
        return R.drawable.mapbox_compass_icon;
    }

    public int getCompassMarginBottom() {
        return this.compassMargins[3];
    }

    public int getCompassMarginLeft() {
        return this.compassMargins[0];
    }

    public int getCompassMarginRight() {
        return this.compassMargins[2];
    }

    public int getCompassMarginTop() {
        return this.compassMargins[1];
    }

    public PointF getFocalPoint() {
        return this.userProvidedFocalPoint;
    }

    public float getHeight() {
        return this.projection.getHeight();
    }

    public int getLogoGravity() {
        ImageView imageView = this.logoView;
        if (imageView != null) {
            return ((FrameLayout.LayoutParams)imageView.getLayoutParams()).gravity;
        }
        return -1;
    }

    public int getLogoMarginBottom() {
        return this.logoMargins[3];
    }

    public int getLogoMarginLeft() {
        return this.logoMargins[0];
    }

    public int getLogoMarginRight() {
        return this.logoMargins[2];
    }

    public int getLogoMarginTop() {
        return this.logoMargins[1];
    }

    float getPixelRatio() {
        return this.pixelRatio;
    }

    public float getWidth() {
        return this.projection.getWidth();
    }

    public float getZoomRate() {
        return this.zoomRate;
    }

    void initialise(Context context, MapboxMapOptions mapboxMapOptions) {
        Resources resources = context.getResources();
        this.initialiseGestures(mapboxMapOptions);
        if (mapboxMapOptions.getCompassEnabled()) {
            this.initialiseCompass(mapboxMapOptions, resources);
        }
        if (mapboxMapOptions.getLogoEnabled()) {
            this.initialiseLogo(mapboxMapOptions, resources);
        }
        if (mapboxMapOptions.getAttributionEnabled()) {
            this.initialiseAttribution(context, mapboxMapOptions);
        }
    }

    public void invalidate() {
        this.setLogoMargins(this.getLogoMarginLeft(), this.getLogoMarginTop(), this.getLogoMarginRight(), this.getLogoMarginBottom());
        this.setCompassEnabled(this.isCompassEnabled());
        this.setCompassMargins(this.getCompassMarginLeft(), this.getCompassMarginTop(), this.getCompassMarginRight(), this.getCompassMarginBottom());
        this.setAttributionMargins(this.getAttributionMarginLeft(), this.getAttributionMarginTop(), this.getAttributionMarginRight(), this.getAttributionMarginBottom());
    }

    public boolean isAttributionEnabled() {
        boolean bl;
        ImageView imageView = this.attributionsView;
        boolean bl2 = bl = false;
        if (imageView != null) {
            bl2 = bl;
            if (imageView.getVisibility() == 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean isCompassEnabled() {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            return compassView.isEnabled();
        }
        return false;
    }

    public boolean isCompassFadeWhenFacingNorth() {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            return compassView.isFadeCompassViewFacingNorth();
        }
        return false;
    }

    public boolean isDeselectMarkersOnTap() {
        return this.deselectMarkersOnTap;
    }

    public boolean isDisableRotateWhenScaling() {
        return this.disableRotateWhenScaling;
    }

    public boolean isDoubleTapGesturesEnabled() {
        return this.doubleTapGesturesEnabled;
    }

    public boolean isFlingVelocityAnimationEnabled() {
        return this.flingVelocityAnimationEnabled;
    }

    public boolean isHorizontalScrollGesturesEnabled() {
        return this.horizontalScrollGesturesEnabled;
    }

    @Deprecated
    public boolean isIncreaseRotateThresholdWhenScaling() {
        return this.increaseRotateThresholdWhenScaling;
    }

    public boolean isIncreaseScaleThresholdWhenRotating() {
        return this.increaseScaleThresholdWhenRotating;
    }

    public boolean isLogoEnabled() {
        boolean bl;
        ImageView imageView = this.logoView;
        boolean bl2 = bl = false;
        if (imageView != null) {
            bl2 = bl;
            if (imageView.getVisibility() == 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean isQuickZoomGesturesEnabled() {
        return this.quickZoomGesturesEnabled;
    }

    public boolean isRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public boolean isRotateVelocityAnimationEnabled() {
        return this.rotateVelocityAnimationEnabled;
    }

    public boolean isScaleVelocityAnimationEnabled() {
        return this.scaleVelocityAnimationEnabled;
    }

    public boolean isScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public boolean isTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public boolean isZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    void onRestoreInstanceState(Bundle bundle) {
        this.restoreGestures(bundle);
        this.restoreCompass(bundle);
        this.restoreLogo(bundle);
        this.restoreAttribution(bundle);
        this.restoreDeselectMarkersOnTap(bundle);
        this.restoreFocalPoint(bundle);
    }

    void onSaveInstanceState(Bundle bundle) {
        this.saveGestures(bundle);
        this.saveCompass(bundle);
        this.saveLogo(bundle);
        this.saveAttribution(bundle);
        this.saveDeselectMarkersOnTap(bundle);
        this.saveFocalPoint(bundle);
    }

    public void setAllGesturesEnabled(boolean bl) {
        this.setScrollGesturesEnabled(bl);
        this.setRotateGesturesEnabled(bl);
        this.setTiltGesturesEnabled(bl);
        this.setZoomGesturesEnabled(bl);
        this.setDoubleTapGesturesEnabled(bl);
        this.setQuickZoomGesturesEnabled(bl);
    }

    public void setAllVelocityAnimationsEnabled(boolean bl) {
        this.setScaleVelocityAnimationEnabled(bl);
        this.setRotateVelocityAnimationEnabled(bl);
        this.setFlingVelocityAnimationEnabled(bl);
    }

    public void setAttributionDialogManager(AttributionDialogManager attributionDialogManager) {
        this.attributionDialogManager = attributionDialogManager;
    }

    public void setAttributionEnabled(boolean bl) {
        ImageView imageView;
        if (bl && !this.isAttributionInitialized) {
            this.initialiseAttribution(this.mapView.getContext(), this.mapView.mapboxMapOptions);
        }
        if ((imageView = this.attributionsView) != null) {
            int n = bl ? 0 : 8;
            imageView.setVisibility(n);
        }
    }

    public void setAttributionGravity(int n) {
        ImageView imageView = this.attributionsView;
        if (imageView != null) {
            this.setWidgetGravity((View)imageView, n);
        }
    }

    public void setAttributionMargins(int n, int n2, int n3, int n4) {
        ImageView imageView = this.attributionsView;
        if (imageView != null) {
            this.setWidgetMargins((View)imageView, this.attributionsMargins, n, n2, n3, n4);
        }
    }

    public void setAttributionTintColor(int n) {
        if (this.attributionsView == null) {
            return;
        }
        if (Color.alpha((int)n) == 0) {
            ImageView imageView = this.attributionsView;
            ColorUtils.setTintList(imageView, ContextCompat.getColor((Context)imageView.getContext(), (int)R.color.mapbox_blue));
        } else {
            ColorUtils.setTintList(this.attributionsView, n);
        }
    }

    public void setCompassEnabled(boolean bl) {
        CompassView compassView;
        if (bl && !this.isCompassInitialized) {
            this.initialiseCompass(this.mapView.mapboxMapOptions, this.mapView.getContext().getResources());
        }
        if ((compassView = this.compassView) != null) {
            compassView.setEnabled(bl);
            this.compassView.update(this.clockwiseBearing);
        }
    }

    public void setCompassFadeFacingNorth(boolean bl) {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            compassView.fadeCompassViewFacingNorth(bl);
        }
    }

    public void setCompassGravity(int n) {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            this.setWidgetGravity((View)compassView, n);
        }
    }

    @Deprecated
    public void setCompassImage(Drawable drawable2) {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            compassView.setCompassImage(drawable2);
        }
    }

    public void setCompassImageResource(int n) {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            compassView.setCompassImageResource(n);
        }
    }

    public void setCompassMargins(int n, int n2, int n3, int n4) {
        CompassView compassView = this.compassView;
        if (compassView != null) {
            this.setWidgetMargins((View)compassView, this.compassMargins, n, n2, n3, n4);
        }
    }

    public void setDeselectMarkersOnTap(boolean bl) {
        this.deselectMarkersOnTap = bl;
    }

    public void setDisableRotateWhenScaling(boolean bl) {
        this.disableRotateWhenScaling = bl;
    }

    public void setDoubleTapGesturesEnabled(boolean bl) {
        this.doubleTapGesturesEnabled = bl;
    }

    public void setFlingVelocityAnimationEnabled(boolean bl) {
        this.flingVelocityAnimationEnabled = bl;
    }

    public void setFocalPoint(PointF pointF) {
        this.userProvidedFocalPoint = pointF;
        this.focalPointChangeListener.onFocalPointChanged(pointF);
    }

    public void setHorizontalScrollGesturesEnabled(boolean bl) {
        this.horizontalScrollGesturesEnabled = bl;
    }

    @Deprecated
    public void setIncreaseRotateThresholdWhenScaling(boolean bl) {
        this.increaseRotateThresholdWhenScaling = bl;
    }

    public void setIncreaseScaleThresholdWhenRotating(boolean bl) {
        this.increaseScaleThresholdWhenRotating = bl;
    }

    public void setLogoEnabled(boolean bl) {
        ImageView imageView;
        if (bl && !this.isLogoInitialized) {
            this.initialiseLogo(this.mapView.mapboxMapOptions, this.mapView.getContext().getResources());
        }
        if ((imageView = this.logoView) != null) {
            int n = bl ? 0 : 8;
            imageView.setVisibility(n);
        }
    }

    public void setLogoGravity(int n) {
        ImageView imageView = this.logoView;
        if (imageView != null) {
            this.setWidgetGravity((View)imageView, n);
        }
    }

    public void setLogoMargins(int n, int n2, int n3, int n4) {
        ImageView imageView = this.logoView;
        if (imageView != null) {
            this.setWidgetMargins((View)imageView, this.logoMargins, n, n2, n3, n4);
        }
    }

    public void setQuickZoomGesturesEnabled(boolean bl) {
        this.quickZoomGesturesEnabled = bl;
    }

    public void setRotateGesturesEnabled(boolean bl) {
        this.rotateGesturesEnabled = bl;
    }

    public void setRotateVelocityAnimationEnabled(boolean bl) {
        this.rotateVelocityAnimationEnabled = bl;
    }

    public void setScaleVelocityAnimationEnabled(boolean bl) {
        this.scaleVelocityAnimationEnabled = bl;
    }

    public void setScrollGesturesEnabled(boolean bl) {
        this.scrollGesturesEnabled = bl;
    }

    public void setTiltGesturesEnabled(boolean bl) {
        this.tiltGesturesEnabled = bl;
    }

    public void setZoomGesturesEnabled(boolean bl) {
        this.zoomGesturesEnabled = bl;
    }

    public void setZoomRate(float f) {
        this.zoomRate = f;
    }

    void update(CameraPosition object) {
        double d;
        this.clockwiseBearing = d = -((CameraPosition)object).bearing;
        object = this.compassView;
        if (object != null) {
            ((CompassView)object).update(d);
        }
    }
}

