/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer.egl;

import android.opengl.GLException;
import java.io.IOException;
import java.io.Writer;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGL11;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EGLLogWrapper
implements EGL11 {
    private int argCount;
    private boolean checkError;
    private EGL10 egl10;
    private Writer log;
    private boolean logArgumentNames;

    public EGLLogWrapper(EGL eGL, int n, Writer writer) {
        this.egl10 = (EGL10)eGL;
        this.log = writer;
        boolean bl = false;
        boolean bl2 = (n & 4) != 0;
        this.logArgumentNames = bl2;
        bl2 = bl;
        if ((n & 1) != 0) {
            bl2 = true;
        }
        this.checkError = bl2;
    }

    private void arg(String string2, int n) {
        this.arg(string2, Integer.toString(n));
    }

    private void arg(String string2, Object object) {
        this.arg(string2, this.toString(object));
    }

    private void arg(String string2, String string3) {
        int n = this.argCount;
        this.argCount = n + 1;
        if (n > 0) {
            this.log(", ");
        }
        if (this.logArgumentNames) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("=");
            this.log(stringBuilder.toString());
        }
        this.log(string3);
    }

    private void arg(String string2, EGLContext eGLContext) {
        if (eGLContext == EGL10.EGL_NO_CONTEXT) {
            this.arg(string2, "EGL10.EGL_NO_CONTEXT");
        } else {
            this.arg(string2, this.toString(eGLContext));
        }
    }

    private void arg(String string2, EGLDisplay eGLDisplay) {
        if (eGLDisplay == EGL10.EGL_DEFAULT_DISPLAY) {
            this.arg(string2, "EGL10.EGL_DEFAULT_DISPLAY");
        } else if (eGLDisplay == EGL_NO_DISPLAY) {
            this.arg(string2, "EGL10.EGL_NO_DISPLAY");
        } else {
            this.arg(string2, this.toString(eGLDisplay));
        }
    }

    private void arg(String string2, EGLSurface eGLSurface) {
        if (eGLSurface == EGL10.EGL_NO_SURFACE) {
            this.arg(string2, "EGL10.EGL_NO_SURFACE");
        } else {
            this.arg(string2, this.toString(eGLSurface));
        }
    }

    private void arg(String string2, int[] nArray) {
        if (nArray == null) {
            this.arg(string2, "null");
        } else {
            this.arg(string2, this.toString(nArray.length, nArray, 0));
        }
    }

    private void arg(String string2, Object[] objectArray) {
        if (objectArray == null) {
            this.arg(string2, "null");
        } else {
            this.arg(string2, this.toString(objectArray.length, objectArray, 0));
        }
    }

    private void begin(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append('(');
        this.log(stringBuilder.toString());
        this.argCount = 0;
    }

    private void checkError() {
        int n = this.egl10.eglGetError();
        if (n != 12288) {
            CharSequence charSequence = new StringBuilder();
            charSequence.append("eglError: ");
            charSequence.append(EGLLogWrapper.getErrorString(n));
            charSequence = charSequence.toString();
            this.logLine((String)charSequence);
            if (this.checkError) {
                throw new GLException(n, (String)charSequence);
            }
        }
    }

    private void end() {
        this.log(");\n");
        this.flush();
    }

    private void flush() {
        try {
            this.log.flush();
        }
        catch (IOException iOException) {
            this.log = null;
        }
    }

    public static String getErrorString(int n) {
        switch (n) {
            default: {
                return EGLLogWrapper.getHex(n);
            }
            case 12302: {
                return "EGL_CONTEXT_LOST";
            }
            case 12301: {
                return "EGL_BAD_SURFACE";
            }
            case 12300: {
                return "EGL_BAD_PARAMETER";
            }
            case 12299: {
                return "EGL_BAD_NATIVE_WINDOW";
            }
            case 12298: {
                return "EGL_BAD_NATIVE_PIXMAP";
            }
            case 12297: {
                return "EGL_BAD_MATCH";
            }
            case 12296: {
                return "EGL_BAD_DISPLAY";
            }
            case 12295: {
                return "EGL_BAD_CURRENT_SURFACE";
            }
            case 12294: {
                return "EGL_BAD_CONTEXT";
            }
            case 12293: {
                return "EGL_BAD_CONFIG";
            }
            case 12292: {
                return "EGL_BAD_ATTRIBUTE";
            }
            case 12291: {
                return "EGL_BAD_ALLOC";
            }
            case 12290: {
                return "EGL_BAD_ACCESS";
            }
            case 12289: {
                return "EGL_NOT_INITIALIZED";
            }
            case 12288: 
        }
        return "EGL_SUCCESS";
    }

    private static String getHex(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0x");
        stringBuilder.append(Integer.toHexString(n));
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void log(String string2) {
        try {
            this.log.write(string2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void logLine(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append('\n');
        this.log(stringBuilder.toString());
    }

    private void returns(int n) {
        this.returns(Integer.toString(n));
    }

    private void returns(Object object) {
        this.returns(this.toString(object));
    }

    private void returns(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" returns ");
        stringBuilder.append(string2);
        stringBuilder.append(";\n");
        this.log(stringBuilder.toString());
        this.flush();
    }

    private void returns(boolean bl) {
        this.returns(Boolean.toString(bl));
    }

    private String toString(int n, int[] nArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        int n3 = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n4 = n2 + i;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(" [");
            stringBuilder2.append(n4);
            stringBuilder2.append("] = ");
            stringBuilder.append(stringBuilder2.toString());
            if (n4 >= 0 && n4 < n3) {
                stringBuilder.append(nArray[n4]);
            } else {
                stringBuilder.append("out of bounds");
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toString(int n, Object[] objectArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        int n3 = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int n4 = n2 + i;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(" [");
            stringBuilder2.append(n4);
            stringBuilder2.append("] = ");
            stringBuilder.append(stringBuilder2.toString());
            if (n4 >= 0 && n4 < n3) {
                stringBuilder.append(objectArray[n4]);
            } else {
                stringBuilder.append("out of bounds");
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public boolean eglChooseConfig(EGLDisplay eGLDisplay, int[] nArray, EGLConfig[] eGLConfigArray, int n, int[] nArray2) {
        this.begin("eglChooseConfig");
        this.arg("display", eGLDisplay);
        this.arg("attrib_list", nArray);
        this.arg("config_size", n);
        this.end();
        boolean bl = this.egl10.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, n, nArray2);
        this.arg("configs", eGLConfigArray);
        this.arg("num_config", nArray2);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public boolean eglCopyBuffers(EGLDisplay eGLDisplay, EGLSurface eGLSurface, Object object) {
        this.begin("eglCopyBuffers");
        this.arg("display", eGLDisplay);
        this.arg("surface", eGLSurface);
        this.arg("native_pixmap", object);
        this.end();
        boolean bl = this.egl10.eglCopyBuffers(eGLDisplay, eGLSurface, object);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public EGLContext eglCreateContext(EGLDisplay eGLDisplay, EGLConfig eGLConfig, EGLContext eGLContext, int[] nArray) {
        this.begin("eglCreateContext");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("share_context", eGLContext);
        this.arg("attrib_list", nArray);
        this.end();
        eGLDisplay = this.egl10.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray);
        this.returns(eGLDisplay);
        this.checkError();
        return eGLDisplay;
    }

    public EGLSurface eglCreatePbufferSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int[] nArray) {
        this.begin("eglCreatePbufferSurface");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("attrib_list", nArray);
        this.end();
        eGLDisplay = this.egl10.eglCreatePbufferSurface(eGLDisplay, eGLConfig, nArray);
        this.returns(eGLDisplay);
        this.checkError();
        return eGLDisplay;
    }

    public EGLSurface eglCreatePixmapSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        this.begin("eglCreatePixmapSurface");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("native_pixmap", object);
        this.arg("attrib_list", nArray);
        this.end();
        eGLDisplay = this.egl10.eglCreatePixmapSurface(eGLDisplay, eGLConfig, object, nArray);
        this.returns(eGLDisplay);
        this.checkError();
        return eGLDisplay;
    }

    public EGLSurface eglCreateWindowSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        this.begin("eglCreateWindowSurface");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("native_window", object);
        this.arg("attrib_list", nArray);
        this.end();
        eGLDisplay = this.egl10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, nArray);
        this.returns(eGLDisplay);
        this.checkError();
        return eGLDisplay;
    }

    public boolean eglDestroyContext(EGLDisplay eGLDisplay, EGLContext eGLContext) {
        this.begin("eglDestroyContext");
        this.arg("display", eGLDisplay);
        this.arg("context", eGLContext);
        this.end();
        boolean bl = this.egl10.eglDestroyContext(eGLDisplay, eGLContext);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public boolean eglDestroySurface(EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
        this.begin("eglDestroySurface");
        this.arg("display", eGLDisplay);
        this.arg("surface", eGLSurface);
        this.end();
        boolean bl = this.egl10.eglDestroySurface(eGLDisplay, eGLSurface);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public boolean eglGetConfigAttrib(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int[] nArray) {
        this.begin("eglGetConfigAttrib");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("attribute", n);
        this.end();
        boolean bl = this.egl10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, nArray);
        this.arg("value", nArray);
        this.returns(bl);
        this.checkError();
        return false;
    }

    public boolean eglGetConfigs(EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray, int n, int[] nArray) {
        this.begin("eglGetConfigs");
        this.arg("display", eGLDisplay);
        this.arg("config_size", n);
        this.end();
        boolean bl = this.egl10.eglGetConfigs(eGLDisplay, eGLConfigArray, n, nArray);
        this.arg("configs", eGLConfigArray);
        this.arg("num_config", nArray);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public EGLContext eglGetCurrentContext() {
        this.begin("eglGetCurrentContext");
        this.end();
        EGLContext eGLContext = this.egl10.eglGetCurrentContext();
        this.returns(eGLContext);
        this.checkError();
        return eGLContext;
    }

    public EGLDisplay eglGetCurrentDisplay() {
        this.begin("eglGetCurrentDisplay");
        this.end();
        EGLDisplay eGLDisplay = this.egl10.eglGetCurrentDisplay();
        this.returns(eGLDisplay);
        this.checkError();
        return eGLDisplay;
    }

    public EGLSurface eglGetCurrentSurface(int n) {
        this.begin("eglGetCurrentSurface");
        this.arg("readdraw", n);
        this.end();
        EGLSurface eGLSurface = this.egl10.eglGetCurrentSurface(n);
        this.returns(eGLSurface);
        this.checkError();
        return eGLSurface;
    }

    public EGLDisplay eglGetDisplay(Object object) {
        this.begin("eglGetDisplay");
        this.arg("native_display", object);
        this.end();
        object = this.egl10.eglGetDisplay(object);
        this.returns(object);
        this.checkError();
        return object;
    }

    public int eglGetError() {
        this.begin("eglGetError");
        this.end();
        int n = this.egl10.eglGetError();
        this.returns(EGLLogWrapper.getErrorString(n));
        return n;
    }

    public boolean eglInitialize(EGLDisplay eGLDisplay, int[] nArray) {
        this.begin("eglInitialize");
        this.arg("display", eGLDisplay);
        this.end();
        boolean bl = this.egl10.eglInitialize(eGLDisplay, nArray);
        this.returns(bl);
        this.arg("major_minor", nArray);
        this.checkError();
        return bl;
    }

    public boolean eglMakeCurrent(EGLDisplay eGLDisplay, EGLSurface eGLSurface, EGLSurface eGLSurface2, EGLContext eGLContext) {
        this.begin("eglMakeCurrent");
        this.arg("display", eGLDisplay);
        this.arg("draw", eGLSurface);
        this.arg("read", eGLSurface2);
        this.arg("context", eGLContext);
        this.end();
        boolean bl = this.egl10.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface2, eGLContext);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public boolean eglQueryContext(EGLDisplay eGLDisplay, EGLContext eGLContext, int n, int[] nArray) {
        this.begin("eglQueryContext");
        this.arg("display", eGLDisplay);
        this.arg("context", eGLContext);
        this.arg("attribute", n);
        this.end();
        boolean bl = this.egl10.eglQueryContext(eGLDisplay, eGLContext, n, nArray);
        this.returns(nArray[0]);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public String eglQueryString(EGLDisplay object, int n) {
        this.begin("eglQueryString");
        this.arg("display", (EGLDisplay)object);
        this.arg("name", n);
        this.end();
        object = this.egl10.eglQueryString(object, n);
        this.returns((String)object);
        this.checkError();
        return object;
    }

    public boolean eglQuerySurface(EGLDisplay eGLDisplay, EGLSurface eGLSurface, int n, int[] nArray) {
        this.begin("eglQuerySurface");
        this.arg("display", eGLDisplay);
        this.arg("surface", eGLSurface);
        this.arg("attribute", n);
        this.end();
        boolean bl = this.egl10.eglQuerySurface(eGLDisplay, eGLSurface, n, nArray);
        this.returns(nArray[0]);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public boolean eglSwapBuffers(EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
        this.begin("eglSwapBuffers");
        this.arg("display", eGLDisplay);
        this.arg("surface", eGLSurface);
        this.end();
        boolean bl = this.egl10.eglSwapBuffers(eGLDisplay, eGLSurface);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public boolean eglTerminate(EGLDisplay eGLDisplay) {
        this.begin("eglTerminate");
        this.arg("display", eGLDisplay);
        this.end();
        boolean bl = this.egl10.eglTerminate(eGLDisplay);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public boolean eglWaitGL() {
        this.begin("eglWaitGL");
        this.end();
        boolean bl = this.egl10.eglWaitGL();
        this.returns(bl);
        this.checkError();
        return bl;
    }

    public boolean eglWaitNative(int n, Object object) {
        this.begin("eglWaitNative");
        this.arg("engine", n);
        this.arg("bindTarget", object);
        this.end();
        boolean bl = this.egl10.eglWaitNative(n, object);
        this.returns(bl);
        this.checkError();
        return bl;
    }
}

