/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.widgets;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorCompat;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.core.view.ViewPropertyAnimatorListenerAdapter;
import com.mapbox.mapboxsdk.maps.MapboxMap;

public final class CompassView
extends ImageView
implements Runnable {
    private static final long TIME_FADE_ANIMATION = 500L;
    public static final long TIME_MAP_NORTH_ANIMATION = 150L;
    public static final long TIME_WAIT_IDLE = 500L;
    private MapboxMap.OnCompassAnimationListener compassAnimationListener;
    private int compassImageResource;
    private ViewPropertyAnimatorCompat fadeAnimator;
    private boolean fadeCompassViewFacingNorth = true;
    private boolean isAnimating = false;
    private boolean legacyImageDrawableSetter = false;
    private float rotation = 0.0f;

    public CompassView(Context context) {
        super(context);
        this.initialize(context);
    }

    public CompassView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initialize(context);
    }

    public CompassView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.setEnabled(false);
        int n = (int)(context.getResources().getDisplayMetrics().density * 48.0f);
        this.setLayoutParams(new ViewGroup.LayoutParams(n, n));
    }

    private void notifyCompassAnimationListenerWhenAnimating() {
        if (this.isAnimating) {
            this.compassAnimationListener.onCompassAnimation();
        }
    }

    public void fadeCompassViewFacingNorth(boolean bl) {
        this.fadeCompassViewFacingNorth = bl;
    }

    public Drawable getCompassImage() {
        return this.getDrawable();
    }

    public int getCompassImageResource() {
        return this.compassImageResource;
    }

    public void injectCompassAnimationListener(MapboxMap.OnCompassAnimationListener onCompassAnimationListener) {
        this.compassAnimationListener = onCompassAnimationListener;
    }

    public void isAnimating(boolean bl) {
        this.isAnimating = bl;
    }

    public boolean isFacingNorth() {
        boolean bl = (double)Math.abs(this.rotation) >= 359.0 || (double)Math.abs(this.rotation) <= 1.0;
        return bl;
    }

    public boolean isFadeCompassViewFacingNorth() {
        return this.fadeCompassViewFacingNorth;
    }

    public boolean isHidden() {
        boolean bl = this.fadeCompassViewFacingNorth && this.isFacingNorth();
        return bl;
    }

    public boolean isLegacyImageDrawableSetter() {
        return this.legacyImageDrawableSetter;
    }

    public void resetAnimation() {
        ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = this.fadeAnimator;
        if (viewPropertyAnimatorCompat != null) {
            viewPropertyAnimatorCompat.cancel();
        }
        this.fadeAnimator = null;
    }

    @Override
    public void run() {
        if (this.isHidden()) {
            ViewPropertyAnimatorCompat viewPropertyAnimatorCompat;
            this.compassAnimationListener.onCompassAnimationFinished();
            this.resetAnimation();
            this.setLayerType(2, null);
            this.fadeAnimator = viewPropertyAnimatorCompat = ViewCompat.animate((View)this).alpha(0.0f).setDuration(500L);
            viewPropertyAnimatorCompat.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationEnd(View view) {
                    CompassView.this.setLayerType(0, null);
                    CompassView.this.setVisibility(4);
                    CompassView.this.resetAnimation();
                }
            });
        }
    }

    public void setCompassImage(Drawable drawable2) {
        this.legacyImageDrawableSetter = true;
        this.setImageDrawable(drawable2);
    }

    public void setCompassImageResource(int n) {
        this.compassImageResource = n;
        this.setImageResource(n);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl && !this.isHidden()) {
            this.resetAnimation();
            this.setAlpha(1.0f);
            this.setVisibility(0);
            this.update(this.rotation);
        } else {
            this.resetAnimation();
            this.setAlpha(0.0f);
            this.setVisibility(4);
        }
    }

    public void update(double d) {
        this.rotation = (float)d;
        if (!this.isEnabled()) {
            return;
        }
        if (this.isHidden()) {
            if (this.getVisibility() != 4 && this.fadeAnimator == null) {
                this.postDelayed(this, 500L);
            }
            return;
        }
        this.resetAnimation();
        this.setAlpha(1.0f);
        this.setVisibility(0);
        this.notifyCompassAnimationListenerWhenAnimating();
        this.setRotation(this.rotation);
    }
}

