/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.http;

import android.os.Build;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.http.HttpIdentifier;
import com.mapbox.mapboxsdk.http.HttpLogger;
import com.mapbox.mapboxsdk.http.HttpRequest;
import com.mapbox.mapboxsdk.http.HttpRequestUrl;
import com.mapbox.mapboxsdk.http.HttpResponder;
import com.mapbox.mapboxsdk.module.http.HttpRequestUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpRequestImpl
implements HttpRequest {
    static final OkHttpClient DEFAULT_CLIENT;
    static OkHttpClient client;
    private static final String userAgentString;
    private Call call;

    static {
        OkHttpClient okHttpClient;
        userAgentString = HttpRequestUtil.toHumanReadableAscii(String.format("%s %s (%s) Android/%s (%s)", HttpIdentifier.getIdentifier(), "Mapbox/9.7.1", "545884a", Build.VERSION.SDK_INT, Build.CPU_ABI));
        DEFAULT_CLIENT = okHttpClient = new OkHttpClient.Builder().dispatcher(HttpRequestImpl.getDispatcher()).build();
        client = okHttpClient;
    }

    public static void enableLog(boolean bl) {
        HttpLogger.logEnabled = bl;
    }

    public static void enablePrintRequestUrlOnFailure(boolean bl) {
        HttpLogger.logRequestUrl = bl;
    }

    private static Dispatcher getDispatcher() {
        Dispatcher dispatcher = new Dispatcher();
        if (Build.VERSION.SDK_INT >= 21) {
            dispatcher.setMaxRequestsPerHost(20);
        } else {
            dispatcher.setMaxRequestsPerHost(10);
        }
        return dispatcher;
    }

    public static void setOkHttpClient(OkHttpClient okHttpClient) {
        client = okHttpClient != null ? okHttpClient : DEFAULT_CLIENT;
    }

    @Override
    public void cancelRequest() {
        Call call = this.call;
        if (call != null) {
            HttpLogger.log(3, String.format("[HTTP] This request was cancelled (%s). This is expected for tiles that were being prefetched but are no longer needed for the map to render.", call.request().url()));
            this.call.cancel();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeRequest(HttpResponder object, long l, String string2, String string3, String string4, boolean bl) {
        object = new OkHttpCallback((HttpResponder)object);
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)string2);
            if (httpUrl == null) {
                HttpLogger.log(6, String.format("[HTTP] Unable to parse resourceUrl %s", string2));
                return;
            }
            string2 = HttpRequestUrl.buildResourceUrl(httpUrl.host().toLowerCase(MapboxConstants.MAPBOX_LOCALE), string2, httpUrl.querySize(), bl);
            httpUrl = new Request.Builder();
            string2 = httpUrl.url(string2).tag((Object)string2.toLowerCase(MapboxConstants.MAPBOX_LOCALE)).addHeader("User-Agent", userAgentString);
            if (string3.length() > 0) {
                string2.addHeader("If-None-Match", string3);
            } else if (string4.length() > 0) {
                string2.addHeader("If-Modified-Since", string4);
            }
            string2 = string2.build();
            string2 = client.newCall((Request)string2);
            this.call = string2;
            string2.enqueue((Callback)object);
            return;
        }
        catch (Exception exception) {
            ((OkHttpCallback)object).handleFailure(this.call, exception);
        }
    }

    private static class OkHttpCallback
    implements Callback {
        private HttpResponder httpRequest;

        OkHttpCallback(HttpResponder httpResponder) {
            this.httpRequest = httpResponder;
        }

        private int getFailureType(Exception exception) {
            if (!(exception instanceof NoRouteToHostException || exception instanceof UnknownHostException || exception instanceof SocketException || exception instanceof ProtocolException || exception instanceof SSLException)) {
                if (exception instanceof InterruptedIOException) {
                    return 1;
                }
                return 2;
            }
            return 0;
        }

        private void handleFailure(Call call, Exception exception) {
            String string2 = exception.getMessage() != null ? exception.getMessage() : "Error processing the request";
            int n = this.getFailureType(exception);
            if (HttpLogger.logEnabled && call != null && call.request() != null) {
                HttpLogger.logFailure(n, string2, call.request().url().toString());
            }
            this.httpRequest.handleFailure(n, string2);
        }

        public void onFailure(Call call, IOException iOException) {
            this.handleFailure(call, iOException);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onResponse(Call call, Response response) {
            Throwable throwable2222222;
            block7: {
                Object object;
                if (response.isSuccessful()) {
                    HttpLogger.log(2, String.format("[HTTP] Request was successful (code = %s).", response.code()));
                } else {
                    object = !TextUtils.isEmpty((CharSequence)response.message()) ? response.message() : "No additional information";
                    HttpLogger.log(3, String.format("[HTTP] Request with response = %s: %s", response.code(), object));
                }
                object = response.body();
                if (object == null) {
                    HttpLogger.log(6, "[HTTP] Received empty response body");
                    return;
                }
                object = object.bytes();
                {
                    catch (Throwable throwable2222222) {
                        break block7;
                    }
                    catch (IOException iOException) {}
                    {
                        this.onFailure(call, iOException);
                    }
                    response.close();
                    return;
                }
                response.close();
                this.httpRequest.onResponse(response.code(), response.header("ETag"), response.header("Last-Modified"), response.header("Cache-Control"), response.header("Expires"), response.header("Retry-After"), response.header("x-rate-limit-reset"), (byte[])object);
                return;
            }
            response.close();
            throw throwable2222222;
        }
    }
}

