/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.os.Build;
import com.mapbox.mapboxsdk.module.telemetry.MapBaseEvent;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;

class MapLoadEvent
extends MapBaseEvent {
    private static final String EVENT_NAME = "map.load";
    private final float accessibilityFontScale;
    private final int batteryLevel;
    private final String carrier;
    private final String cellularNetworkType;
    private final String model;
    private final String operatingSystem;
    private final String orientation;
    private final boolean pluggedIn;
    private final float resolution;
    private final String sdkIdentifier;
    private final String sdkVersion;
    private final String userId;
    private final boolean wifi;

    MapLoadEvent(String string2, PhoneState phoneState) {
        super(phoneState);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Android - ");
        stringBuilder.append(Build.VERSION.RELEASE);
        this.operatingSystem = stringBuilder.toString();
        this.sdkIdentifier = "mapbox-maps-android";
        this.sdkVersion = "9.7.1";
        this.model = Build.MODEL;
        this.userId = string2;
        this.batteryLevel = phoneState.getBatteryLevel();
        this.pluggedIn = phoneState.isPluggedIn();
        this.cellularNetworkType = phoneState.getCellularNetworkType();
        this.carrier = phoneState.getCarrier();
        this.resolution = phoneState.getResolution();
        this.accessibilityFontScale = phoneState.getAccessibilityFontScale();
        this.wifi = phoneState.isWifi();
        this.orientation = phoneState.getOrientation();
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (MapLoadEvent)object;
            if (Float.compare(((MapLoadEvent)object).resolution, this.resolution) != 0) {
                return false;
            }
            if (Float.compare(((MapLoadEvent)object).accessibilityFontScale, this.accessibilityFontScale) != 0) {
                return false;
            }
            if (this.batteryLevel != ((MapLoadEvent)object).batteryLevel) {
                return false;
            }
            if (this.pluggedIn != ((MapLoadEvent)object).pluggedIn) {
                return false;
            }
            if (this.wifi != ((MapLoadEvent)object).wifi) {
                return false;
            }
            if (!this.operatingSystem.equals(((MapLoadEvent)object).operatingSystem)) {
                return false;
            }
            String string2 = this.model;
            if (string2 != null ? !string2.equals(((MapLoadEvent)object).model) : ((MapLoadEvent)object).model != null) {
                return false;
            }
            string2 = this.userId;
            if (string2 != null ? !string2.equals(((MapLoadEvent)object).userId) : ((MapLoadEvent)object).userId != null) {
                return false;
            }
            string2 = this.carrier;
            if (string2 != null ? !string2.equals(((MapLoadEvent)object).carrier) : ((MapLoadEvent)object).carrier != null) {
                return false;
            }
            string2 = this.cellularNetworkType;
            if (string2 != null ? !string2.equals(((MapLoadEvent)object).cellularNetworkType) : ((MapLoadEvent)object).cellularNetworkType != null) {
                return false;
            }
            string2 = this.orientation;
            object = ((MapLoadEvent)object).orientation;
            if (string2 != null) {
                bl = string2.equals(object);
            } else if (object != null) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    float getAccessibilityFontScale() {
        return this.accessibilityFontScale;
    }

    int getBatteryLevel() {
        return this.batteryLevel;
    }

    String getCarrier() {
        return this.carrier;
    }

    String getCellularNetworkType() {
        return this.cellularNetworkType;
    }

    @Override
    String getEventName() {
        return EVENT_NAME;
    }

    String getModel() {
        return this.model;
    }

    String getOperatingSystem() {
        return this.operatingSystem;
    }

    String getOrientation() {
        return this.orientation;
    }

    float getResolution() {
        return this.resolution;
    }

    String getSdkIdentifier() {
        return "mapbox-maps-android";
    }

    String getSdkVersion() {
        return "9.7.1";
    }

    String getUserId() {
        return this.userId;
    }

    public int hashCode() {
        String string2 = this.operatingSystem;
        int n = 0;
        int n2 = string2 != null ? string2.hashCode() : 0;
        string2 = this.model;
        int n3 = string2 != null ? string2.hashCode() : 0;
        string2 = this.userId;
        int n4 = string2 != null ? string2.hashCode() : 0;
        string2 = this.carrier;
        int n5 = string2 != null ? string2.hashCode() : 0;
        string2 = this.cellularNetworkType;
        int n6 = string2 != null ? string2.hashCode() : 0;
        string2 = this.orientation;
        int n7 = string2 != null ? string2.hashCode() : 0;
        float f = this.resolution;
        int n8 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        f = this.accessibilityFontScale;
        if (f != 0.0f) {
            n = Float.floatToIntBits(f);
        }
        return (((((((((((n2 * 31 - 1350324393) * 31 + 54065413) * 31 + n3) * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31 + n) * 31 + this.batteryLevel) * 31 + this.pluggedIn) * 31 + this.wifi;
    }

    boolean isPluggedIn() {
        return this.pluggedIn;
    }

    boolean isWifi() {
        return this.wifi;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MapLoadEvent{, operatingSystem='");
        stringBuilder.append(this.operatingSystem);
        stringBuilder.append('\'');
        stringBuilder.append(", sdkIdentifier='");
        stringBuilder.append("mapbox-maps-android");
        stringBuilder.append('\'');
        stringBuilder.append(", sdkVersion='");
        stringBuilder.append("9.7.1");
        stringBuilder.append('\'');
        stringBuilder.append(", model='");
        stringBuilder.append(this.model);
        stringBuilder.append('\'');
        stringBuilder.append(", userId='");
        stringBuilder.append(this.userId);
        stringBuilder.append('\'');
        stringBuilder.append(", carrier='");
        stringBuilder.append(this.carrier);
        stringBuilder.append('\'');
        stringBuilder.append(", cellularNetworkType='");
        stringBuilder.append(this.cellularNetworkType);
        stringBuilder.append('\'');
        stringBuilder.append(", orientation='");
        stringBuilder.append(this.orientation);
        stringBuilder.append('\'');
        stringBuilder.append(", resolution=");
        stringBuilder.append(this.resolution);
        stringBuilder.append(", accessibilityFontScale=");
        stringBuilder.append(this.accessibilityFontScale);
        stringBuilder.append(", batteryLevel=");
        stringBuilder.append(this.batteryLevel);
        stringBuilder.append(", pluggedIn=");
        stringBuilder.append(this.pluggedIn);
        stringBuilder.append(", wifi=");
        stringBuilder.append(this.wifi);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

