/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineRegionError;
import com.mapbox.mapboxsdk.offline.OfflineRegionStatus;
import com.mapbox.mapboxsdk.storage.FileSource;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class OfflineRegion {
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_INACTIVE = 0;
    private final Context context;
    private OfflineRegionDefinition definition;
    private boolean deliverInactiveMessages = false;
    private FileSource fileSource;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private long id;
    private boolean isDeleted;
    private byte[] metadata;
    private long nativePtr;
    private int state = 0;

    static {
        LibraryLoader.load();
    }

    private OfflineRegion(long l, FileSource fileSource, long l2, OfflineRegionDefinition offlineRegionDefinition, byte[] byArray) {
        this.context = Mapbox.getApplicationContext();
        this.fileSource = fileSource;
        this.id = l2;
        this.definition = offlineRegionDefinition;
        this.metadata = byArray;
        this.initialize(l, fileSource);
    }

    static /* synthetic */ boolean access$302(OfflineRegion offlineRegion, boolean bl) {
        offlineRegion.isDeleted = bl;
        return bl;
    }

    static /* synthetic */ byte[] access$402(OfflineRegion offlineRegion, byte[] byArray) {
        offlineRegion.metadata = byArray;
        return byArray;
    }

    private native void deleteOfflineRegion(OfflineRegionDeleteCallback var1);

    private boolean deliverMessages() {
        if (this.state == 1) {
            return true;
        }
        return this.isDeliveringInactiveMessages();
    }

    private native void getOfflineRegionStatus(OfflineRegionStatusCallback var1);

    private native void initialize(long var1, FileSource var3);

    private native void invalidateOfflineRegion(OfflineRegionInvalidateCallback var1);

    private native void setOfflineRegionDownloadState(int var1);

    private native void setOfflineRegionObserver(OfflineRegionObserver var1);

    private native void updateOfflineRegionMetadata(byte[] var1, OfflineRegionUpdateMetadataCallback var2);

    public void delete(final OfflineRegionDeleteCallback offlineRegionDeleteCallback) {
        if (!this.isDeleted) {
            this.isDeleted = true;
            this.fileSource.activate();
            this.deleteOfflineRegion(new OfflineRegionDeleteCallback(){

                @Override
                public void onDelete() {
                    OfflineRegion.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            OfflineRegion.this.fileSource.deactivate();
                            offlineRegionDeleteCallback.onDelete();
                            OfflineRegion.this.finalize();
                        }
                    });
                }

                @Override
                public void onError(final String string2) {
                    OfflineRegion.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            OfflineRegion.access$302(OfflineRegion.this, false);
                            OfflineRegion.this.fileSource.deactivate();
                            offlineRegionDeleteCallback.onError(string2);
                        }
                    });
                }
            });
        }
    }

    protected native void finalize();

    public OfflineRegionDefinition getDefinition() {
        return this.definition;
    }

    public long getID() {
        return this.id;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public void getStatus(final OfflineRegionStatusCallback offlineRegionStatusCallback) {
        this.fileSource.activate();
        this.getOfflineRegionStatus(new OfflineRegionStatusCallback(){

            @Override
            public void onError(final String string2) {
                OfflineRegion.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineRegion.this.fileSource.deactivate();
                        offlineRegionStatusCallback.onError(string2);
                    }
                });
            }

            @Override
            public void onStatus(final OfflineRegionStatus offlineRegionStatus) {
                OfflineRegion.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineRegion.this.fileSource.deactivate();
                        offlineRegionStatusCallback.onStatus(offlineRegionStatus);
                    }
                });
            }
        });
    }

    public void invalidate(final OfflineRegionInvalidateCallback offlineRegionInvalidateCallback) {
        this.fileSource.activate();
        this.invalidateOfflineRegion(new OfflineRegionInvalidateCallback(){

            @Override
            public void onError(final String string2) {
                OfflineRegion.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineRegion.this.fileSource.deactivate();
                        if (offlineRegionInvalidateCallback != null) {
                            offlineRegionInvalidateCallback.onError(string2);
                        }
                    }
                });
            }

            @Override
            public void onInvalidate() {
                OfflineRegion.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineRegion.this.fileSource.deactivate();
                        if (offlineRegionInvalidateCallback != null) {
                            offlineRegionInvalidateCallback.onInvalidate();
                        }
                    }
                });
            }
        });
    }

    public boolean isDeliveringInactiveMessages() {
        return this.deliverInactiveMessages;
    }

    public void setDeliverInactiveMessages(boolean bl) {
        this.deliverInactiveMessages = bl;
    }

    public void setDownloadState(int n) {
        if (this.state == n) {
            return;
        }
        if (n == 1) {
            ConnectivityReceiver.instance(this.context).activate();
            this.fileSource.activate();
        } else {
            this.fileSource.deactivate();
            ConnectivityReceiver.instance(this.context).deactivate();
        }
        this.state = n;
        this.setOfflineRegionDownloadState(n);
    }

    public void setObserver(final OfflineRegionObserver offlineRegionObserver) {
        this.setOfflineRegionObserver(new OfflineRegionObserver(){

            @Override
            public void mapboxTileCountLimitExceeded(final long l) {
                if (OfflineRegion.this.deliverMessages()) {
                    OfflineRegion.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (offlineRegionObserver != null) {
                                offlineRegionObserver.mapboxTileCountLimitExceeded(l);
                            }
                        }
                    });
                }
            }

            @Override
            public void onError(final OfflineRegionError offlineRegionError) {
                if (OfflineRegion.this.deliverMessages()) {
                    OfflineRegion.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (offlineRegionObserver != null) {
                                offlineRegionObserver.onError(offlineRegionError);
                            }
                        }
                    });
                }
            }

            @Override
            public void onStatusChanged(final OfflineRegionStatus offlineRegionStatus) {
                if (OfflineRegion.this.deliverMessages()) {
                    OfflineRegion.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (offlineRegionObserver != null) {
                                offlineRegionObserver.onStatusChanged(offlineRegionStatus);
                            }
                        }
                    });
                }
            }
        });
    }

    public void updateMetadata(byte[] byArray, final OfflineRegionUpdateMetadataCallback offlineRegionUpdateMetadataCallback) {
        this.updateOfflineRegionMetadata(byArray, new OfflineRegionUpdateMetadataCallback(){

            @Override
            public void onError(final String string2) {
                OfflineRegion.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        offlineRegionUpdateMetadataCallback.onError(string2);
                    }
                });
            }

            @Override
            public void onUpdate(final byte[] byArray) {
                OfflineRegion.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineRegion.access$402(OfflineRegion.this, byArray);
                        offlineRegionUpdateMetadataCallback.onUpdate(byArray);
                    }
                });
            }
        });
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DownloadState {
    }

    public static interface OfflineRegionDeleteCallback {
        public void onDelete();

        public void onError(String var1);
    }

    public static interface OfflineRegionInvalidateCallback {
        public void onError(String var1);

        public void onInvalidate();
    }

    public static interface OfflineRegionObserver {
        public void mapboxTileCountLimitExceeded(long var1);

        public void onError(OfflineRegionError var1);

        public void onStatusChanged(OfflineRegionStatus var1);
    }

    public static interface OfflineRegionStatusCallback {
        public void onError(String var1);

        public void onStatus(OfflineRegionStatus var1);
    }

    public static interface OfflineRegionUpdateMetadataCallback {
        public void onError(String var1);

        public void onUpdate(byte[] var1);
    }
}

