/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;

public class OfflineTilePyramidRegionDefinition
implements OfflineRegionDefinition {
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public OfflineTilePyramidRegionDefinition createFromParcel(Parcel parcel) {
            return new OfflineTilePyramidRegionDefinition(parcel);
        }

        public OfflineTilePyramidRegionDefinition[] newArray(int n) {
            return new OfflineTilePyramidRegionDefinition[n];
        }
    };
    private LatLngBounds bounds;
    private boolean includeIdeographs;
    private double maxZoom;
    private double minZoom;
    private float pixelRatio;
    private String styleURL;

    public OfflineTilePyramidRegionDefinition(Parcel parcel) {
        this.styleURL = parcel.readString();
        this.bounds = new LatLngBounds.Builder().include(new LatLng(parcel.readDouble(), parcel.readDouble())).include(new LatLng(parcel.readDouble(), parcel.readDouble())).build();
        this.minZoom = parcel.readDouble();
        this.maxZoom = parcel.readDouble();
        this.pixelRatio = parcel.readFloat();
        boolean bl = parcel.readByte() != 0;
        this.includeIdeographs = bl;
    }

    public OfflineTilePyramidRegionDefinition(String string2, LatLngBounds latLngBounds, double d, double d2, float f) {
        this(string2, latLngBounds, d, d2, f, false);
    }

    public OfflineTilePyramidRegionDefinition(String string2, LatLngBounds latLngBounds, double d, double d2, float f, boolean bl) {
        this.styleURL = string2;
        this.bounds = latLngBounds;
        this.minZoom = d;
        this.maxZoom = d2;
        this.pixelRatio = f;
        this.includeIdeographs = bl;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public LatLngBounds getBounds() {
        return this.bounds;
    }

    @Override
    public boolean getIncludeIdeographs() {
        return this.includeIdeographs;
    }

    @Override
    public double getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public double getMinZoom() {
        return this.minZoom;
    }

    @Override
    public float getPixelRatio() {
        return this.pixelRatio;
    }

    @Override
    public String getStyleURL() {
        return this.styleURL;
    }

    @Override
    public String getType() {
        return "tileregion";
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.styleURL);
        parcel.writeDouble(this.bounds.getLatNorth());
        parcel.writeDouble(this.bounds.getLonEast());
        parcel.writeDouble(this.bounds.getLatSouth());
        parcel.writeDouble(this.bounds.getLonWest());
        parcel.writeDouble(this.minZoom);
        parcel.writeDouble(this.maxZoom);
        parcel.writeFloat(this.pixelRatio);
        parcel.writeByte((byte)(this.includeIdeographs ? 1 : 0));
    }
}

