/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class Circle
extends Annotation<Point> {
    private final AnnotationManager<?, Circle, ?, ?, ?, ?> annotationManager;

    Circle(long l, AnnotationManager<?, Circle, ?, ?, ?, ?> annotationManager, JsonObject jsonObject, Point point) {
        super(l, jsonObject, point);
        this.annotationManager = annotationManager;
    }

    public Float getCircleBlur() {
        return Float.valueOf(this.jsonObject.get("circle-blur").getAsFloat());
    }

    public String getCircleColor() {
        return this.jsonObject.get("circle-color").getAsString();
    }

    public int getCircleColorAsInt() {
        return ColorUtils.rgbaToColor(this.jsonObject.get("circle-color").getAsString());
    }

    public Float getCircleOpacity() {
        return Float.valueOf(this.jsonObject.get("circle-opacity").getAsFloat());
    }

    public Float getCircleRadius() {
        return Float.valueOf(this.jsonObject.get("circle-radius").getAsFloat());
    }

    public String getCircleStrokeColor() {
        return this.jsonObject.get("circle-stroke-color").getAsString();
    }

    public int getCircleStrokeColorAsInt() {
        return ColorUtils.rgbaToColor(this.jsonObject.get("circle-stroke-color").getAsString());
    }

    public Float getCircleStrokeOpacity() {
        return Float.valueOf(this.jsonObject.get("circle-stroke-opacity").getAsFloat());
    }

    public Float getCircleStrokeWidth() {
        return Float.valueOf(this.jsonObject.get("circle-stroke-width").getAsFloat());
    }

    public LatLng getLatLng() {
        return new LatLng(((Point)this.geometry).latitude(), ((Point)this.geometry).longitude());
    }

    @Override
    String getName() {
        return "Circle";
    }

    @Override
    Geometry getOffsetGeometry(Projection object, MoveDistancesObject moveDistancesObject, float f, float f2) {
        if (!(((LatLng)(object = ((Projection)object).fromScreenLocation(new PointF(moveDistancesObject.getCurrentX() - f, moveDistancesObject.getCurrentY() - f2)))).getLatitude() > 85.05112877980659) && !(((LatLng)object).getLatitude() < -85.05112877980659)) {
            return Point.fromLngLat(((LatLng)object).getLongitude(), ((LatLng)object).getLatitude());
        }
        return null;
    }

    public void setCircleBlur(Float f) {
        this.jsonObject.addProperty("circle-blur", f);
    }

    public void setCircleColor(int n) {
        this.jsonObject.addProperty("circle-color", ColorUtils.colorToRgbaString(n));
    }

    public void setCircleColor(String string2) {
        this.jsonObject.addProperty("circle-color", string2);
    }

    public void setCircleOpacity(Float f) {
        this.jsonObject.addProperty("circle-opacity", f);
    }

    public void setCircleRadius(Float f) {
        this.jsonObject.addProperty("circle-radius", f);
    }

    public void setCircleStrokeColor(int n) {
        this.jsonObject.addProperty("circle-stroke-color", ColorUtils.colorToRgbaString(n));
    }

    public void setCircleStrokeColor(String string2) {
        this.jsonObject.addProperty("circle-stroke-color", string2);
    }

    public void setCircleStrokeOpacity(Float f) {
        this.jsonObject.addProperty("circle-stroke-opacity", f);
    }

    public void setCircleStrokeWidth(Float f) {
        this.jsonObject.addProperty("circle-stroke-width", f);
    }

    public void setLatLng(LatLng latLng) {
        this.geometry = Point.fromLngLat(latLng.getLongitude(), latLng.getLatitude());
    }

    @Override
    void setUsedDataDrivenProperties() {
        if (!(this.jsonObject.get("circle-radius") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-radius");
        }
        if (!(this.jsonObject.get("circle-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-color");
        }
        if (!(this.jsonObject.get("circle-blur") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-blur");
        }
        if (!(this.jsonObject.get("circle-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-opacity");
        }
        if (!(this.jsonObject.get("circle-stroke-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-stroke-width");
        }
        if (!(this.jsonObject.get("circle-stroke-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-stroke-color");
        }
        if (!(this.jsonObject.get("circle-stroke-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-stroke-opacity");
        }
    }
}

