/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Circle;
import com.mapbox.mapboxsdk.plugins.annotation.CircleElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.CircleOptions;
import com.mapbox.mapboxsdk.plugins.annotation.CoreElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.DraggableAnnotationController;
import com.mapbox.mapboxsdk.plugins.annotation.OnCircleClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnCircleDragListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnCircleLongClickListener;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.CircleLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CircleManager
extends AnnotationManager<CircleLayer, Circle, CircleOptions, OnCircleDragListener, OnCircleClickListener, OnCircleLongClickListener> {
    private static final String PROPERTY_CIRCLE_PITCH_ALIGNMENT = "circle-pitch-alignment";
    private static final String PROPERTY_CIRCLE_PITCH_SCALE = "circle-pitch-scale";
    private static final String PROPERTY_CIRCLE_TRANSLATE = "circle-translate";
    private static final String PROPERTY_CIRCLE_TRANSLATE_ANCHOR = "circle-translate-anchor";

    public CircleManager(MapView mapView, MapboxMap mapboxMap, Style style2) {
        this(mapView, mapboxMap, style2, null, null);
    }

    CircleManager(MapView mapView, MapboxMap mapboxMap, Style style2, CoreElementProvider<CircleLayer> coreElementProvider, String string2, GeoJsonOptions geoJsonOptions, DraggableAnnotationController draggableAnnotationController) {
        super(mapView, mapboxMap, style2, coreElementProvider, draggableAnnotationController, string2, geoJsonOptions);
    }

    public CircleManager(MapView mapView, MapboxMap mapboxMap, Style style2, String string2) {
        this(mapView, mapboxMap, style2, string2, null);
    }

    public CircleManager(MapView mapView, MapboxMap mapboxMap, Style style2, String string2, GeoJsonOptions geoJsonOptions) {
        this(mapView, mapboxMap, style2, new CircleElementProvider(), string2, geoJsonOptions, DraggableAnnotationController.getInstance(mapView, mapboxMap));
    }

    @Override
    public List<Circle> create(FeatureCollection serializable) {
        Object object = ((FeatureCollection)serializable).features();
        serializable = new ArrayList();
        if (object != null) {
            Iterator<Feature> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                object = CircleOptions.fromFeature(iterator2.next());
                if (object == null) continue;
                serializable.add(object);
            }
        }
        return this.create(serializable);
    }

    @Override
    public List<Circle> create(String string2) {
        return this.create(FeatureCollection.fromJson(string2));
    }

    @Override
    String getAnnotationIdKey() {
        return "id";
    }

    public String getCirclePitchAlignment() {
        return (String)((CircleLayer)this.layer).getCirclePitchAlignment().value;
    }

    public String getCirclePitchScale() {
        return (String)((CircleLayer)this.layer).getCirclePitchScale().value;
    }

    public Float[] getCircleTranslate() {
        return (Float[])((CircleLayer)this.layer).getCircleTranslate().value;
    }

    public String getCircleTranslateAnchor() {
        return (String)((CircleLayer)this.layer).getCircleTranslateAnchor().value;
    }

    public Expression getFilter() {
        return ((CircleLayer)this.layer).getFilter();
    }

    @Override
    void initializeDataDrivenPropertyMap() {
        Map map = this.dataDrivenPropertyUsageMap;
        Boolean bl = false;
        map.put("circle-radius", bl);
        this.dataDrivenPropertyUsageMap.put("circle-color", bl);
        this.dataDrivenPropertyUsageMap.put("circle-blur", bl);
        this.dataDrivenPropertyUsageMap.put("circle-opacity", bl);
        this.dataDrivenPropertyUsageMap.put("circle-stroke-width", bl);
        this.dataDrivenPropertyUsageMap.put("circle-stroke-color", bl);
        this.dataDrivenPropertyUsageMap.put("circle-stroke-opacity", bl);
    }

    public void setCirclePitchAlignment(String object) {
        object = PropertyFactory.circlePitchAlignment((String)object);
        this.constantPropertyUsageMap.put(PROPERTY_CIRCLE_PITCH_ALIGNMENT, object);
        ((CircleLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setCirclePitchScale(String object) {
        object = PropertyFactory.circlePitchScale((String)object);
        this.constantPropertyUsageMap.put(PROPERTY_CIRCLE_PITCH_SCALE, object);
        ((CircleLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setCircleTranslate(Float[] object) {
        object = PropertyFactory.circleTranslate(object);
        this.constantPropertyUsageMap.put(PROPERTY_CIRCLE_TRANSLATE, object);
        ((CircleLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setCircleTranslateAnchor(String object) {
        object = PropertyFactory.circleTranslateAnchor((String)object);
        this.constantPropertyUsageMap.put(PROPERTY_CIRCLE_TRANSLATE_ANCHOR, object);
        ((CircleLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    @Override
    protected void setDataDrivenPropertyIsUsed(String string2) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1671319571: {
                if (!string2.equals("circle-stroke-opacity")) break;
                n2 = 6;
                break;
            }
            case 787555366: {
                if (!string2.equals("circle-color")) break;
                n2 = 5;
                break;
            }
            case -113174716: {
                if (!string2.equals("circle-blur")) break;
                n2 = 4;
                break;
            }
            case -567613490: {
                if (!string2.equals("circle-stroke-width")) break;
                n2 = 3;
                break;
            }
            case -585897621: {
                if (!string2.equals("circle-stroke-color")) break;
                n2 = 2;
                break;
            }
            case -939323345: {
                if (!string2.equals("circle-radius")) break;
                n2 = 1;
                break;
            }
            case -1290287090: {
                if (!string2.equals("circle-opacity")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 6: {
                ((CircleLayer)this.layer).setProperties(PropertyFactory.circleStrokeOpacity(Expression.get("circle-stroke-opacity")));
                break;
            }
            case 5: {
                ((CircleLayer)this.layer).setProperties(PropertyFactory.circleColor(Expression.get("circle-color")));
                break;
            }
            case 4: {
                ((CircleLayer)this.layer).setProperties(PropertyFactory.circleBlur(Expression.get("circle-blur")));
                break;
            }
            case 3: {
                ((CircleLayer)this.layer).setProperties(PropertyFactory.circleStrokeWidth(Expression.get("circle-stroke-width")));
                break;
            }
            case 2: {
                ((CircleLayer)this.layer).setProperties(PropertyFactory.circleStrokeColor(Expression.get("circle-stroke-color")));
                break;
            }
            case 1: {
                ((CircleLayer)this.layer).setProperties(PropertyFactory.circleRadius(Expression.get("circle-radius")));
                break;
            }
            case 0: {
                ((CircleLayer)this.layer).setProperties(PropertyFactory.circleOpacity(Expression.get("circle-opacity")));
            }
        }
    }

    @Override
    public void setFilter(Expression expression) {
        this.layerFilter = expression;
        ((CircleLayer)this.layer).setFilter(this.layerFilter);
    }
}

