/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Circle;
import com.mapbox.mapboxsdk.plugins.annotation.Options;

public class CircleOptions
extends Options<Circle> {
    static final String PROPERTY_CIRCLE_BLUR = "circle-blur";
    static final String PROPERTY_CIRCLE_COLOR = "circle-color";
    static final String PROPERTY_CIRCLE_OPACITY = "circle-opacity";
    static final String PROPERTY_CIRCLE_RADIUS = "circle-radius";
    static final String PROPERTY_CIRCLE_STROKE_COLOR = "circle-stroke-color";
    static final String PROPERTY_CIRCLE_STROKE_OPACITY = "circle-stroke-opacity";
    static final String PROPERTY_CIRCLE_STROKE_WIDTH = "circle-stroke-width";
    private static final String PROPERTY_IS_DRAGGABLE = "is-draggable";
    private Float circleBlur;
    private String circleColor;
    private Float circleOpacity;
    private Float circleRadius;
    private String circleStrokeColor;
    private Float circleStrokeOpacity;
    private Float circleStrokeWidth;
    private JsonElement data;
    private Point geometry;
    private boolean isDraggable;

    static CircleOptions fromFeature(Feature feature) {
        if (feature.geometry() != null) {
            if (!(feature.geometry() instanceof Point)) {
                return null;
            }
            CircleOptions circleOptions = new CircleOptions();
            circleOptions.geometry = (Point)feature.geometry();
            if (feature.hasProperty(PROPERTY_CIRCLE_RADIUS)) {
                circleOptions.circleRadius = Float.valueOf(feature.getProperty(PROPERTY_CIRCLE_RADIUS).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_CIRCLE_COLOR)) {
                circleOptions.circleColor = feature.getProperty(PROPERTY_CIRCLE_COLOR).getAsString();
            }
            if (feature.hasProperty(PROPERTY_CIRCLE_BLUR)) {
                circleOptions.circleBlur = Float.valueOf(feature.getProperty(PROPERTY_CIRCLE_BLUR).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_CIRCLE_OPACITY)) {
                circleOptions.circleOpacity = Float.valueOf(feature.getProperty(PROPERTY_CIRCLE_OPACITY).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_CIRCLE_STROKE_WIDTH)) {
                circleOptions.circleStrokeWidth = Float.valueOf(feature.getProperty(PROPERTY_CIRCLE_STROKE_WIDTH).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_CIRCLE_STROKE_COLOR)) {
                circleOptions.circleStrokeColor = feature.getProperty(PROPERTY_CIRCLE_STROKE_COLOR).getAsString();
            }
            if (feature.hasProperty(PROPERTY_CIRCLE_STROKE_OPACITY)) {
                circleOptions.circleStrokeOpacity = Float.valueOf(feature.getProperty(PROPERTY_CIRCLE_STROKE_OPACITY).getAsFloat());
            }
            if (feature.hasProperty(PROPERTY_IS_DRAGGABLE)) {
                circleOptions.isDraggable = feature.getProperty(PROPERTY_IS_DRAGGABLE).getAsBoolean();
            }
            return circleOptions;
        }
        throw new RuntimeException("geometry field is required");
    }

    @Override
    Circle build(long l, AnnotationManager<?, Circle, ?, ?, ?, ?> object) {
        if (this.geometry != null) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(PROPERTY_CIRCLE_RADIUS, this.circleRadius);
            jsonObject.addProperty(PROPERTY_CIRCLE_COLOR, this.circleColor);
            jsonObject.addProperty(PROPERTY_CIRCLE_BLUR, this.circleBlur);
            jsonObject.addProperty(PROPERTY_CIRCLE_OPACITY, this.circleOpacity);
            jsonObject.addProperty(PROPERTY_CIRCLE_STROKE_WIDTH, this.circleStrokeWidth);
            jsonObject.addProperty(PROPERTY_CIRCLE_STROKE_COLOR, this.circleStrokeColor);
            jsonObject.addProperty(PROPERTY_CIRCLE_STROKE_OPACITY, this.circleStrokeOpacity);
            object = new Circle(l, (AnnotationManager<?, Circle, ?, ?, ?, ?>)object, jsonObject, this.geometry);
            ((Annotation)object).setDraggable(this.isDraggable);
            ((Annotation)object).setData(this.data);
            return object;
        }
        throw new RuntimeException("geometry field is required");
    }

    public Float getCircleBlur() {
        return this.circleBlur;
    }

    public String getCircleColor() {
        return this.circleColor;
    }

    public Float getCircleOpacity() {
        return this.circleOpacity;
    }

    public Float getCircleRadius() {
        return this.circleRadius;
    }

    public String getCircleStrokeColor() {
        return this.circleStrokeColor;
    }

    public Float getCircleStrokeOpacity() {
        return this.circleStrokeOpacity;
    }

    public Float getCircleStrokeWidth() {
        return this.circleStrokeWidth;
    }

    public JsonElement getData() {
        return this.data;
    }

    public boolean getDraggable() {
        return this.isDraggable;
    }

    public Point getGeometry() {
        return this.geometry;
    }

    public LatLng getLatLng() {
        if (this.geometry == null) {
            return null;
        }
        return new LatLng(this.geometry.latitude(), this.geometry.longitude());
    }

    public CircleOptions withCircleBlur(Float f) {
        this.circleBlur = f;
        return this;
    }

    public CircleOptions withCircleColor(String string2) {
        this.circleColor = string2;
        return this;
    }

    public CircleOptions withCircleOpacity(Float f) {
        this.circleOpacity = f;
        return this;
    }

    public CircleOptions withCircleRadius(Float f) {
        this.circleRadius = f;
        return this;
    }

    public CircleOptions withCircleStrokeColor(String string2) {
        this.circleStrokeColor = string2;
        return this;
    }

    public CircleOptions withCircleStrokeOpacity(Float f) {
        this.circleStrokeOpacity = f;
        return this;
    }

    public CircleOptions withCircleStrokeWidth(Float f) {
        this.circleStrokeWidth = f;
        return this;
    }

    public CircleOptions withData(JsonElement jsonElement) {
        this.data = jsonElement;
        return this;
    }

    public CircleOptions withDraggable(boolean bl) {
        this.isDraggable = bl;
        return this;
    }

    public CircleOptions withGeometry(Point point) {
        this.geometry = point;
        return this;
    }

    public CircleOptions withLatLng(LatLng latLng) {
        this.geometry = Point.fromLngLat(latLng.getLongitude(), latLng.getLatitude());
        return this;
    }
}

