/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.MultiFingerGesture;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.OnAnnotationDragListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class DraggableAnnotationController {
    private static DraggableAnnotationController INSTANCE;
    private List<AnnotationManager> annotationManagers = new ArrayList<AnnotationManager>();
    private Annotation draggedAnnotation;
    private AnnotationManager draggedAnnotationManager;
    private MapView mapView;
    private MapboxMap mapboxMap;
    private final int touchAreaMaxX;
    private final int touchAreaMaxY;
    private final int touchAreaShiftX;
    private final int touchAreaShiftY;

    DraggableAnnotationController(MapView mapView, MapboxMap mapboxMap) {
        this(mapView, mapboxMap, new AndroidGesturesManager(mapView.getContext(), false), mapView.getScrollX(), mapView.getScrollY(), mapView.getMeasuredWidth(), mapView.getMeasuredHeight());
    }

    public DraggableAnnotationController(MapView mapView, MapboxMap mapboxMap, final AndroidGesturesManager androidGesturesManager, int n, int n2, int n3, int n4) {
        this.mapView = mapView;
        this.mapboxMap = mapboxMap;
        this.touchAreaShiftX = n;
        this.touchAreaShiftY = n2;
        this.touchAreaMaxX = n3;
        this.touchAreaMaxY = n4;
        androidGesturesManager.setMoveGestureListener(new AnnotationMoveGestureListener());
        mapView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View object, MotionEvent motionEvent) {
                object = DraggableAnnotationController.this.draggedAnnotation;
                androidGesturesManager.onTouchEvent(motionEvent);
                boolean bl = DraggableAnnotationController.this.draggedAnnotation != null || object != null;
                return bl;
            }
        });
    }

    private static void clearInstance() {
        DraggableAnnotationController draggableAnnotationController = INSTANCE;
        if (draggableAnnotationController != null) {
            draggableAnnotationController.mapView = null;
            draggableAnnotationController.mapboxMap = null;
            INSTANCE = null;
        }
    }

    public static DraggableAnnotationController getInstance(MapView mapView, MapboxMap mapboxMap) {
        DraggableAnnotationController draggableAnnotationController = INSTANCE;
        if (draggableAnnotationController == null || draggableAnnotationController.mapView != mapView || draggableAnnotationController.mapboxMap != mapboxMap) {
            INSTANCE = new DraggableAnnotationController(mapView, mapboxMap);
        }
        return INSTANCE;
    }

    void addAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManagers.add(annotationManager);
    }

    boolean onMove(MoveGestureDetector object) {
        if (!(this.draggedAnnotation == null || ((MultiFingerGesture)object).getPointersCount() <= 1 && this.draggedAnnotation.isDraggable())) {
            this.stopDragging(this.draggedAnnotation, this.draggedAnnotationManager);
            return true;
        }
        if (this.draggedAnnotation != null) {
            object = ((MoveGestureDetector)object).getMoveObject(0);
            PointF pointF = new PointF(((MoveDistancesObject)object).getCurrentX() - (float)this.touchAreaShiftX, ((MoveDistancesObject)object).getCurrentY() - (float)this.touchAreaShiftY);
            if (!(pointF.x < 0.0f || pointF.y < 0.0f || pointF.x > (float)this.touchAreaMaxX || pointF.y > (float)this.touchAreaMaxY)) {
                object = this.draggedAnnotation.getOffsetGeometry(this.mapboxMap.getProjection(), (MoveDistancesObject)object, this.touchAreaShiftX, this.touchAreaShiftY);
                if (object != null) {
                    this.draggedAnnotation.setGeometry(object);
                    this.draggedAnnotationManager.internalUpdateSource();
                    object = this.draggedAnnotationManager.getDragListeners().iterator();
                    while (object.hasNext()) {
                        ((OnAnnotationDragListener)object.next()).onAnnotationDrag(this.draggedAnnotation);
                    }
                    return true;
                }
            } else {
                this.stopDragging(this.draggedAnnotation, this.draggedAnnotationManager);
                return true;
            }
        }
        return false;
    }

    boolean onMoveBegin(MoveGestureDetector moveGestureDetector) {
        for (AnnotationManager annotationManager : this.annotationManagers) {
            Object t;
            if (moveGestureDetector.getPointersCount() != 1 || (t = annotationManager.queryMapForFeatures(moveGestureDetector.getFocalPoint())) == null || !this.startDragging((Annotation)t, annotationManager)) continue;
            return true;
        }
        return false;
    }

    void onMoveEnd() {
        this.stopDragging(this.draggedAnnotation, this.draggedAnnotationManager);
    }

    void onSourceUpdated() {
        this.stopDragging(this.draggedAnnotation, this.draggedAnnotationManager);
    }

    void removeAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManagers.remove(annotationManager);
        if (this.annotationManagers.isEmpty()) {
            DraggableAnnotationController.clearInstance();
        }
    }

    boolean startDragging(Annotation annotation, AnnotationManager annotationManager) {
        if (annotation.isDraggable()) {
            Iterator iterator2 = annotationManager.getDragListeners().iterator();
            while (iterator2.hasNext()) {
                ((OnAnnotationDragListener)iterator2.next()).onAnnotationDragStarted(annotation);
            }
            this.draggedAnnotation = annotation;
            this.draggedAnnotationManager = annotationManager;
            return true;
        }
        return false;
    }

    void stopDragging(Annotation annotation, AnnotationManager object) {
        if (annotation != null && object != null) {
            object = ((AnnotationManager)object).getDragListeners().iterator();
            while (object.hasNext()) {
                ((OnAnnotationDragListener)object.next()).onAnnotationDragFinished(annotation);
            }
        }
        this.draggedAnnotation = null;
        this.draggedAnnotationManager = null;
    }

    private class AnnotationMoveGestureListener
    implements MoveGestureDetector.OnMoveGestureListener {
        private AnnotationMoveGestureListener() {
        }

        @Override
        public boolean onMove(MoveGestureDetector moveGestureDetector, float f, float f2) {
            return DraggableAnnotationController.this.onMove(moveGestureDetector);
        }

        @Override
        public boolean onMoveBegin(MoveGestureDetector moveGestureDetector) {
            return DraggableAnnotationController.this.onMoveBegin(moveGestureDetector);
        }

        @Override
        public void onMoveEnd(MoveGestureDetector moveGestureDetector, float f, float f2) {
            DraggableAnnotationController.this.onMoveEnd();
        }
    }
}

