/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Line
extends Annotation<LineString> {
    private final AnnotationManager<?, Line, ?, ?, ?, ?> annotationManager;

    Line(long l, AnnotationManager<?, Line, ?, ?, ?, ?> annotationManager, JsonObject jsonObject, LineString lineString) {
        super(l, jsonObject, lineString);
        this.annotationManager = annotationManager;
    }

    public List<LatLng> getLatLngs() {
        Object object = (LineString)this.geometry;
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        object = ((LineString)object).coordinates().iterator();
        while (object.hasNext()) {
            Point point = (Point)object.next();
            arrayList.add(new LatLng(point.latitude(), point.longitude()));
        }
        return arrayList;
    }

    public Float getLineBlur() {
        return Float.valueOf(this.jsonObject.get("line-blur").getAsFloat());
    }

    public String getLineColor() {
        return this.jsonObject.get("line-color").getAsString();
    }

    public int getLineColorAsInt() {
        return ColorUtils.rgbaToColor(this.jsonObject.get("line-color").getAsString());
    }

    public Float getLineGapWidth() {
        return Float.valueOf(this.jsonObject.get("line-gap-width").getAsFloat());
    }

    public String getLineJoin() {
        return this.jsonObject.get("line-join").getAsString();
    }

    public Float getLineOffset() {
        return Float.valueOf(this.jsonObject.get("line-offset").getAsFloat());
    }

    public Float getLineOpacity() {
        return Float.valueOf(this.jsonObject.get("line-opacity").getAsFloat());
    }

    public String getLinePattern() {
        return this.jsonObject.get("line-pattern").getAsString();
    }

    public Float getLineWidth() {
        return Float.valueOf(this.jsonObject.get("line-width").getAsFloat());
    }

    @Override
    String getName() {
        return "Line";
    }

    @Override
    Geometry getOffsetGeometry(Projection projection, MoveDistancesObject moveDistancesObject, float f, float f2) {
        Iterator iterator2 = ((LineString)this.geometry).coordinates();
        ArrayList<Point> arrayList = new ArrayList<Point>(iterator2.size());
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            Object object = (Point)iterator2.next();
            object = projection.toScreenLocation(new LatLng(((Point)object).latitude(), ((Point)object).longitude()));
            ((PointF)object).x -= moveDistancesObject.getDistanceXSinceLast();
            ((PointF)object).y -= moveDistancesObject.getDistanceYSinceLast();
            if (!(((LatLng)(object = projection.fromScreenLocation((PointF)object))).getLatitude() > 85.05112877980659) && !(((LatLng)object).getLatitude() < -85.05112877980659)) {
                arrayList.add(Point.fromLngLat(((LatLng)object).getLongitude(), ((LatLng)object).getLatitude()));
                continue;
            }
            return null;
        }
        return LineString.fromLngLats(arrayList);
    }

    public void setLatLngs(List<LatLng> object) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Iterator<LatLng> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            arrayList.add(Point.fromLngLat(((LatLng)object).getLongitude(), ((LatLng)object).getLatitude()));
        }
        this.geometry = LineString.fromLngLats(arrayList);
    }

    public void setLineBlur(Float f) {
        this.jsonObject.addProperty("line-blur", f);
    }

    public void setLineColor(int n) {
        this.jsonObject.addProperty("line-color", ColorUtils.colorToRgbaString(n));
    }

    public void setLineColor(String string2) {
        this.jsonObject.addProperty("line-color", string2);
    }

    public void setLineGapWidth(Float f) {
        this.jsonObject.addProperty("line-gap-width", f);
    }

    public void setLineJoin(String string2) {
        this.jsonObject.addProperty("line-join", string2);
    }

    public void setLineOffset(Float f) {
        this.jsonObject.addProperty("line-offset", f);
    }

    public void setLineOpacity(Float f) {
        this.jsonObject.addProperty("line-opacity", f);
    }

    public void setLinePattern(String string2) {
        this.jsonObject.addProperty("line-pattern", string2);
    }

    public void setLineWidth(Float f) {
        this.jsonObject.addProperty("line-width", f);
    }

    @Override
    void setUsedDataDrivenProperties() {
        if (!(this.jsonObject.get("line-join") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-join");
        }
        if (!(this.jsonObject.get("line-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-opacity");
        }
        if (!(this.jsonObject.get("line-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-color");
        }
        if (!(this.jsonObject.get("line-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-width");
        }
        if (!(this.jsonObject.get("line-gap-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-gap-width");
        }
        if (!(this.jsonObject.get("line-offset") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-offset");
        }
        if (!(this.jsonObject.get("line-blur") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-blur");
        }
        if (!(this.jsonObject.get("line-pattern") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-pattern");
        }
    }
}

