/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.CoreElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.DraggableAnnotationController;
import com.mapbox.mapboxsdk.plugins.annotation.Line;
import com.mapbox.mapboxsdk.plugins.annotation.LineElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.LineOptions;
import com.mapbox.mapboxsdk.plugins.annotation.OnLineClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnLineDragListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnLineLongClickListener;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LineManager
extends AnnotationManager<LineLayer, Line, LineOptions, OnLineDragListener, OnLineClickListener, OnLineLongClickListener> {
    private static final String PROPERTY_LINE_CAP = "line-cap";
    private static final String PROPERTY_LINE_DASHARRAY = "line-dasharray";
    private static final String PROPERTY_LINE_MITER_LIMIT = "line-miter-limit";
    private static final String PROPERTY_LINE_ROUND_LIMIT = "line-round-limit";
    private static final String PROPERTY_LINE_TRANSLATE = "line-translate";
    private static final String PROPERTY_LINE_TRANSLATE_ANCHOR = "line-translate-anchor";

    public LineManager(MapView mapView, MapboxMap mapboxMap, Style style2) {
        this(mapView, mapboxMap, style2, null, null);
    }

    LineManager(MapView mapView, MapboxMap mapboxMap, Style style2, CoreElementProvider<LineLayer> coreElementProvider, String string2, GeoJsonOptions geoJsonOptions, DraggableAnnotationController draggableAnnotationController) {
        super(mapView, mapboxMap, style2, coreElementProvider, draggableAnnotationController, string2, geoJsonOptions);
    }

    public LineManager(MapView mapView, MapboxMap mapboxMap, Style style2, String string2) {
        this(mapView, mapboxMap, style2, string2, null);
    }

    public LineManager(MapView mapView, MapboxMap mapboxMap, Style style2, String string2, GeoJsonOptions geoJsonOptions) {
        this(mapView, mapboxMap, style2, new LineElementProvider(), string2, geoJsonOptions, DraggableAnnotationController.getInstance(mapView, mapboxMap));
    }

    @Override
    public List<Line> create(FeatureCollection serializable) {
        Object object = ((FeatureCollection)serializable).features();
        serializable = new ArrayList();
        if (object != null) {
            Iterator<Feature> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                object = LineOptions.fromFeature(iterator2.next());
                if (object == null) continue;
                serializable.add(object);
            }
        }
        return this.create(serializable);
    }

    @Override
    public List<Line> create(String string2) {
        return this.create(FeatureCollection.fromJson(string2));
    }

    @Override
    String getAnnotationIdKey() {
        return "id";
    }

    public Expression getFilter() {
        return ((LineLayer)this.layer).getFilter();
    }

    public String getLineCap() {
        return (String)((LineLayer)this.layer).getLineCap().value;
    }

    public Float[] getLineDasharray() {
        return (Float[])((LineLayer)this.layer).getLineDasharray().value;
    }

    public Float getLineMiterLimit() {
        return (Float)((LineLayer)this.layer).getLineMiterLimit().value;
    }

    public Float getLineRoundLimit() {
        return (Float)((LineLayer)this.layer).getLineRoundLimit().value;
    }

    public Float[] getLineTranslate() {
        return (Float[])((LineLayer)this.layer).getLineTranslate().value;
    }

    public String getLineTranslateAnchor() {
        return (String)((LineLayer)this.layer).getLineTranslateAnchor().value;
    }

    @Override
    void initializeDataDrivenPropertyMap() {
        Map map = this.dataDrivenPropertyUsageMap;
        Boolean bl = false;
        map.put("line-join", bl);
        this.dataDrivenPropertyUsageMap.put("line-opacity", bl);
        this.dataDrivenPropertyUsageMap.put("line-color", bl);
        this.dataDrivenPropertyUsageMap.put("line-width", bl);
        this.dataDrivenPropertyUsageMap.put("line-gap-width", bl);
        this.dataDrivenPropertyUsageMap.put("line-offset", bl);
        this.dataDrivenPropertyUsageMap.put("line-blur", bl);
        this.dataDrivenPropertyUsageMap.put("line-pattern", bl);
    }

    @Override
    protected void setDataDrivenPropertyIsUsed(String string2) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case -625259849: {
                if (!string2.equals("line-pattern")) break;
                n2 = 7;
                break;
            }
            case -1014430580: {
                if (!string2.equals("line-offset")) break;
                n2 = 6;
                break;
            }
            case -1101375694: {
                if (!string2.equals("line-opacity")) break;
                n2 = 5;
                break;
            }
            case -1272173907: {
                if (!string2.equals("line-width")) break;
                n2 = 4;
                break;
            }
            case -1290458038: {
                if (!string2.equals("line-color")) break;
                n2 = 3;
                break;
            }
            case -1763440266: {
                if (!string2.equals("line-gap-width")) break;
                n2 = 2;
                break;
            }
            case -1842534557: {
                if (!string2.equals("line-join")) break;
                n2 = 1;
                break;
            }
            case -1842775392: {
                if (!string2.equals("line-blur")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 7: {
                ((LineLayer)this.layer).setProperties(PropertyFactory.linePattern(Expression.get("line-pattern")));
                break;
            }
            case 6: {
                ((LineLayer)this.layer).setProperties(PropertyFactory.lineOffset(Expression.get("line-offset")));
                break;
            }
            case 5: {
                ((LineLayer)this.layer).setProperties(PropertyFactory.lineOpacity(Expression.get("line-opacity")));
                break;
            }
            case 4: {
                ((LineLayer)this.layer).setProperties(PropertyFactory.lineWidth(Expression.get("line-width")));
                break;
            }
            case 3: {
                ((LineLayer)this.layer).setProperties(PropertyFactory.lineColor(Expression.get("line-color")));
                break;
            }
            case 2: {
                ((LineLayer)this.layer).setProperties(PropertyFactory.lineGapWidth(Expression.get("line-gap-width")));
                break;
            }
            case 1: {
                ((LineLayer)this.layer).setProperties(PropertyFactory.lineJoin(Expression.get("line-join")));
                break;
            }
            case 0: {
                ((LineLayer)this.layer).setProperties(PropertyFactory.lineBlur(Expression.get("line-blur")));
            }
        }
    }

    @Override
    public void setFilter(Expression expression) {
        this.layerFilter = expression;
        ((LineLayer)this.layer).setFilter(this.layerFilter);
    }

    public void setLineCap(String object) {
        object = PropertyFactory.lineCap((String)object);
        this.constantPropertyUsageMap.put(PROPERTY_LINE_CAP, object);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setLineDasharray(Float[] object) {
        object = PropertyFactory.lineDasharray(object);
        this.constantPropertyUsageMap.put(PROPERTY_LINE_DASHARRAY, object);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setLineMiterLimit(Float object) {
        object = PropertyFactory.lineMiterLimit((Float)object);
        this.constantPropertyUsageMap.put(PROPERTY_LINE_MITER_LIMIT, object);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setLineRoundLimit(Float object) {
        object = PropertyFactory.lineRoundLimit((Float)object);
        this.constantPropertyUsageMap.put(PROPERTY_LINE_ROUND_LIMIT, object);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setLineTranslate(Float[] object) {
        object = PropertyFactory.lineTranslate(object);
        this.constantPropertyUsageMap.put(PROPERTY_LINE_TRANSLATE, object);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{object});
    }

    public void setLineTranslateAnchor(String object) {
        object = PropertyFactory.lineTranslateAnchor((String)object);
        this.constantPropertyUsageMap.put(PROPERTY_LINE_TRANSLATE_ANCHOR, object);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{object});
    }
}

