/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.localization;

import android.os.Build;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class MapLocale {
    public static final String ARABIC = "name_ar";
    public static final MapLocale BRAZIL;
    static final LatLngBounds BRAZIL_BBOX;
    public static final MapLocale CANADA;
    static final LatLngBounds CANADA_BBOX;
    public static final MapLocale CANADA_FRENCH;
    public static final MapLocale CHINA;
    static final LatLngBounds CHINA_BBOX;
    public static final String CHINESE = "name_zh";
    public static final MapLocale CHINESE_HANS;
    public static final MapLocale CHINESE_HANT;
    public static final String ENGLISH = "name_en";
    public static final MapLocale FRANCE;
    static final LatLngBounds FRANCE_BBOX;
    public static final String FRENCH = "name_fr";
    public static final String GERMAN = "name_de";
    public static final MapLocale GERMANY;
    static final LatLngBounds GERMANY_BBOX;
    public static final MapLocale JAPAN;
    public static final String JAPANESE = "name_ja";
    static final LatLngBounds JAPAN_BBOX;
    public static final MapLocale KOREA;
    public static final String KOREAN = "name_ko";
    static final LatLngBounds KOREA_BBOX;
    private static final Map<Locale, MapLocale> LOCALE_SET;
    public static final String LOCAL_NAME = "name";
    public static final MapLocale PORTUGAL;
    static final LatLngBounds PORTUGAL_BBOX;
    public static final String PORTUGUESE = "name_pt";
    public static final MapLocale RUSSIA;
    public static final String RUSSIAN = "name_ru";
    static final LatLngBounds RUSSIA_BBOX;
    public static final String SIMPLIFIED_CHINESE = "name_zh-Hans";
    public static final MapLocale SPAIN;
    static final LatLngBounds SPAIN_BBOX;
    public static final String SPANISH = "name_es";
    public static final MapLocale TAIWAN;
    static final LatLngBounds TAIWAN_BBOX;
    static final String TRADITIONAL_CHINESE = "name_zh-Hant";
    public static final MapLocale UK;
    static final LatLngBounds UK_BBOX;
    public static final MapLocale US;
    static final LatLngBounds USA_BBOX;
    private final LatLngBounds countryBounds;
    private final String mapLanguage;

    static {
        MapLocale mapLocale;
        MapLocale mapLocale2;
        Object object = new LatLngBounds.Builder().include(new LatLng(49.388611, -124.733253)).include(new LatLng(24.544245, -66.954811)).build();
        USA_BBOX = object;
        Object object2 = new LatLngBounds.Builder().include(new LatLng(59.360249, -8.623555)).include(new LatLng(49.906193, 1.759)).build();
        UK_BBOX = object2;
        Object object3 = new LatLngBounds.Builder().include(new LatLng(83.110626, -141.0)).include(new LatLng(41.67598, -52.636291)).build();
        CANADA_BBOX = object3;
        Object object4 = new LatLngBounds.Builder().include(new LatLng(53.56086, 73.557693)).include(new LatLng(15.775416, 134.773911)).build();
        CHINA_BBOX = object4;
        Object object5 = new LatLngBounds.Builder().include(new LatLng(26.389444, 118.115255566105)).include(new LatLng(21.733333, 122.107778)).build();
        TAIWAN_BBOX = object5;
        Object object6 = new LatLngBounds.Builder().include(new LatLng(55.055637, 5.865639)).include(new LatLng(47.275776, 15.039889)).build();
        GERMANY_BBOX = object6;
        Object object7 = new LatLngBounds.Builder().include(new LatLng(38.612446, 125.887108)).include(new LatLng(33.190945, 129.584671)).build();
        KOREA_BBOX = object7;
        Object object8 = new LatLngBounds.Builder().include(new LatLng(45.52314, 122.93853)).include(new LatLng(24.249472, 145.820892)).build();
        JAPAN_BBOX = object8;
        Object object9 = new LatLngBounds.Builder().include(new LatLng(51.092804, -5.142222)).include(new LatLng(41.371582, 9.561556)).build();
        FRANCE_BBOX = object9;
        Object object10 = new LatLngBounds.Builder().include(new LatLng(81.856903, -168.997849)).include(new LatLng(41.185902, 19.638861)).build();
        RUSSIA_BBOX = object10;
        Object object11 = new LatLngBounds.Builder().include(new LatLng(27.4335426, -18.3936845)).include(new LatLng(43.9933088, 4.5918885)).build();
        SPAIN_BBOX = object11;
        Object object12 = new LatLngBounds.Builder().include(new LatLng(27.4335426, -18.3936845)).include(new LatLng(42.280468655, -6.3890876937)).build();
        PORTUGAL_BBOX = object12;
        Object object13 = new LatLngBounds.Builder().include(new LatLng(5.2842873, -33.8689056)).include(new LatLng(-28.6341164, -73.9830625)).build();
        BRAZIL_BBOX = object13;
        FRANCE = object9 = new MapLocale(FRENCH, (LatLngBounds)object9);
        GERMANY = object6 = new MapLocale(GERMAN, (LatLngBounds)object6);
        JAPAN = object8 = new MapLocale(JAPANESE, (LatLngBounds)object8);
        Object object14 = new MapLocale(KOREAN, (LatLngBounds)object7);
        KOREA = object14;
        CHINA = new MapLocale(SIMPLIFIED_CHINESE, (LatLngBounds)object4);
        TAIWAN = object7 = new MapLocale(TRADITIONAL_CHINESE, (LatLngBounds)object5);
        CHINESE_HANS = object5 = new MapLocale(SIMPLIFIED_CHINESE);
        CHINESE_HANT = object4 = new MapLocale(TRADITIONAL_CHINESE);
        UK = object2 = new MapLocale(ENGLISH, (LatLngBounds)object2);
        US = object = new MapLocale(ENGLISH, (LatLngBounds)object);
        CANADA = mapLocale2 = new MapLocale(ENGLISH, (LatLngBounds)object3);
        CANADA_FRENCH = object3 = new MapLocale(FRENCH, (LatLngBounds)object3);
        RUSSIA = object10 = new MapLocale(RUSSIAN, (LatLngBounds)object10);
        SPAIN = object11 = new MapLocale(SPANISH, (LatLngBounds)object11);
        PORTUGAL = object12 = new MapLocale(PORTUGUESE, (LatLngBounds)object12);
        BRAZIL = mapLocale = new MapLocale(PORTUGUESE, (LatLngBounds)object13);
        LOCALE_SET = object13 = new HashMap();
        object13.put(Locale.US, object);
        object13.put(Locale.CANADA_FRENCH, object3);
        object13.put(Locale.CANADA, mapLocale2);
        object13.put(Locale.CHINA, object5);
        object13.put(Locale.TAIWAN, object7);
        object13.put(Locale.UK, object2);
        object13.put(Locale.JAPAN, object8);
        object13.put(Locale.KOREA, object14);
        object13.put(Locale.GERMANY, object6);
        object13.put(Locale.FRANCE, object9);
        object13.put(new Locale("ru", "RU"), object10);
        object13.put(new Locale("es", "ES"), object11);
        object13.put(new Locale("pt", "PT"), object12);
        object13.put(new Locale("pt", "BR"), mapLocale);
        if (Build.VERSION.SDK_INT >= 21) {
            object8 = new Locale.Builder().setLanguage("zh").setRegion("CN").setScript("Hans").build();
            object9 = new Locale.Builder().setLanguage("zh").setRegion("HK").setScript("Hans").build();
            object10 = new Locale.Builder().setLanguage("zh").setRegion("MO").setScript("Hans").build();
            object11 = new Locale.Builder().setLanguage("zh").setRegion("SG").setScript("Hans").build();
            object14 = new Locale.Builder().setLanguage("zh").setRegion("TW").setScript("Hant").build();
            object6 = new Locale.Builder().setLanguage("zh").setRegion("HK").setScript("Hant").build();
            object12 = new Locale.Builder().setLanguage("zh").setRegion("MO").setScript("Hant").build();
            object13.put(object8, object5);
            object13.put(object9, object5);
            object13.put(object10, object5);
            object13.put(object11, object5);
            object13.put(object14, object7);
            object13.put(object6, object4);
            object13.put(object12, object4);
        }
    }

    public MapLocale(LatLngBounds latLngBounds) {
        this(LOCAL_NAME, latLngBounds);
    }

    public MapLocale(String string2) {
        this(string2, null);
    }

    public MapLocale(String string2, LatLngBounds latLngBounds) {
        this.countryBounds = latLngBounds;
        this.mapLanguage = string2;
    }

    public static void addMapLocale(Locale locale, MapLocale mapLocale) {
        LOCALE_SET.put(locale, mapLocale);
    }

    public static MapLocale getMapLocale(Locale locale) {
        return MapLocale.getMapLocale(locale, false);
    }

    public static MapLocale getMapLocale(Locale locale, boolean bl) {
        MapLocale mapLocale;
        MapLocale mapLocale2 = mapLocale = LOCALE_SET.get(locale);
        if (bl) {
            mapLocale2 = mapLocale;
            if (mapLocale == null) {
                mapLocale2 = MapLocale.getMapLocaleFallback(locale);
            }
        }
        return mapLocale2;
    }

    private static MapLocale getMapLocaleFallback(Locale object) {
        block1: {
            object = ((Locale)object).getLanguage().substring(0, 2);
            for (Locale locale : LOCALE_SET.keySet()) {
                if (!locale.getLanguage().equals(object)) continue;
                object = LOCALE_SET.get(locale);
                break block1;
            }
            object = null;
        }
        return object;
    }

    public LatLngBounds getCountryBounds() {
        return this.countryBounds;
    }

    public String getMapLanguage() {
        return this.mapLanguage;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Languages {
    }
}

