/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.markerview;

import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.plugins.markerview.MarkerView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MarkerViewManager
implements MapView.OnCameraDidChangeListener {
    private boolean initialised;
    private final MapView mapView;
    private final MapboxMap mapboxMap;
    private final List<MarkerView> markers = new ArrayList<MarkerView>();

    public MarkerViewManager(MapView mapView, MapboxMap mapboxMap) {
        this.mapView = mapView;
        this.mapboxMap = mapboxMap;
    }

    private void update() {
        Iterator<MarkerView> iterator2 = this.markers.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().update();
        }
    }

    public void addMarker(MarkerView markerView) {
        if (!this.mapView.isDestroyed() && !this.markers.contains(markerView)) {
            if (!this.initialised) {
                this.initialised = true;
                this.mapView.addOnCameraDidChangeListener(this);
            }
            markerView.setProjection(this.mapboxMap.getProjection());
            this.mapView.addView(markerView.getView());
            this.markers.add(markerView);
            markerView.update();
        }
    }

    @Override
    public void onCameraDidChange(boolean bl) {
        this.update();
    }

    public void onDestroy() {
        this.markers.clear();
        this.mapView.removeOnCameraDidChangeListener(this);
        this.initialised = false;
    }

    public void removeMarker(MarkerView markerView) {
        if (!this.mapView.isDestroyed() && this.markers.contains(markerView)) {
            this.mapView.removeView(markerView.getView());
            this.markers.remove(markerView);
        }
    }
}

