/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.expressions;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mapbox.geojson.GeoJson;
import com.mapbox.geojson.Polygon;
import com.mapbox.geojson.gson.GeometryGeoJson;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Expression {
    private final Expression[] arguments;
    private final String operator;

    Expression() {
        this.operator = null;
        this.arguments = null;
    }

    public Expression(String string2, Expression ... expressionArray) {
        this.operator = string2;
        this.arguments = expressionArray;
    }

    public static Expression abs(Expression expression) {
        return new Expression("abs", expression);
    }

    public static Expression abs(Number number) {
        return Expression.abs(Expression.literal(number));
    }

    public static Expression accumulated() {
        return new Expression("accumulated", new Expression[0]);
    }

    public static Expression acos(Expression expression) {
        return new Expression("acos", expression);
    }

    public static Expression acos(Number number) {
        return Expression.acos(Expression.literal(number));
    }

    public static Expression all(Expression ... expressionArray) {
        return new Expression("all", expressionArray);
    }

    public static Expression any(Expression ... expressionArray) {
        return new Expression("any", expressionArray);
    }

    public static Expression array(Expression expression) {
        return new Expression("array", expression);
    }

    public static Expression asin(Expression expression) {
        return new Expression("asin", expression);
    }

    public static Expression asin(Number number) {
        return Expression.asin(Expression.literal(number));
    }

    public static Expression at(Expression expression, Expression expression2) {
        return new Expression("at", expression, expression2);
    }

    public static Expression at(Number number, Expression expression) {
        return Expression.at(Expression.literal(number), expression);
    }

    public static Expression atan(Expression expression) {
        return new Expression("atan", expression);
    }

    public static Expression atan(Number number) {
        return Expression.atan(Expression.literal(number));
    }

    public static Expression bool(Expression ... expressionArray) {
        return new Expression("boolean", expressionArray);
    }

    public static Expression ceil(Expression expression) {
        return new Expression("ceil", expression);
    }

    public static Expression ceil(Number number) {
        return Expression.ceil(Expression.literal(number));
    }

    public static Expression coalesce(Expression ... expressionArray) {
        return new Expression("coalesce", expressionArray);
    }

    public static Expression collator(Expression expression, Expression expression2) {
        HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
        hashMap.put("case-sensitive", expression);
        hashMap.put("diacritic-sensitive", expression2);
        return new Expression("collator", new ExpressionMap(hashMap));
    }

    public static Expression collator(Expression expression, Expression expression2, Expression expression3) {
        HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
        hashMap.put("case-sensitive", expression);
        hashMap.put("diacritic-sensitive", expression2);
        hashMap.put("locale", expression3);
        return new Expression("collator", new ExpressionMap(hashMap));
    }

    public static Expression collator(boolean bl, boolean bl2) {
        HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
        hashMap.put("case-sensitive", Expression.literal(bl));
        hashMap.put("diacritic-sensitive", Expression.literal(bl2));
        return new Expression("collator", new ExpressionMap(hashMap));
    }

    public static Expression collator(boolean bl, boolean bl2, Locale object) {
        HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
        hashMap.put("case-sensitive", Expression.literal(bl));
        hashMap.put("diacritic-sensitive", Expression.literal(bl2));
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = ((Locale)object).getLanguage();
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append(string2);
        }
        if ((object = ((Locale)object).getCountry()) != null && !((String)object).isEmpty()) {
            stringBuilder.append("-");
            stringBuilder.append((String)object);
        }
        hashMap.put("locale", Expression.literal(stringBuilder.toString()));
        return new Expression("collator", new ExpressionMap(hashMap));
    }

    public static Expression color(int n) {
        float[] fArray = ColorUtils.colorToRgbaArray(n);
        return Expression.rgba(Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]));
    }

    public static Expression concat(Expression ... expressionArray) {
        return new Expression("concat", expressionArray);
    }

    public static Expression concat(String ... stringArray) {
        Expression[] expressionArray = new Expression[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            expressionArray[i] = Expression.literal(stringArray[i]);
        }
        return Expression.concat(expressionArray);
    }

    public static Expression cos(Expression expression) {
        return new Expression("cos", expression);
    }

    public static Expression cos(Number number) {
        return new Expression("cos", Expression.literal(number));
    }

    public static Interpolator cubicBezier(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        return new Interpolator("cubic-bezier", expression, expression2, expression3, expression4);
    }

    public static Interpolator cubicBezier(Number number, Number number2, Number number3, Number number4) {
        return Expression.cubicBezier(Expression.literal(number), Expression.literal(number2), Expression.literal(number3), Expression.literal(number4));
    }

    public static Expression distance(GeoJson geoJson) {
        HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
        hashMap.put("json", Expression.literal(geoJson.toJson()));
        return new Expression("distance", new ExpressionMap(hashMap));
    }

    public static Expression division(Expression expression, Expression expression2) {
        return new Expression("/", expression, expression2);
    }

    public static Expression division(Number number, Number number2) {
        return Expression.division(Expression.literal(number), Expression.literal(number2));
    }

    public static Expression downcase(Expression expression) {
        return new Expression("downcase", expression);
    }

    public static Expression downcase(String string2) {
        return Expression.downcase(Expression.literal(string2));
    }

    public static Expression e() {
        return new Expression("e", new Expression[0]);
    }

    public static Expression eq(Expression expression, Expression expression2) {
        return new Expression("==", expression, expression2);
    }

    public static Expression eq(Expression expression, Expression expression2, Expression expression3) {
        return new Expression("==", expression, expression2, expression3);
    }

    public static Expression eq(Expression expression, Number number) {
        return Expression.eq(expression, Expression.literal(number));
    }

    public static Expression eq(Expression expression, String string2) {
        return Expression.eq(expression, Expression.literal(string2));
    }

    public static Expression eq(Expression expression, String string2, Expression expression2) {
        return Expression.eq(expression, Expression.literal(string2), expression2);
    }

    public static Expression eq(Expression expression, boolean bl) {
        return Expression.eq(expression, Expression.literal(bl));
    }

    public static Interpolator exponential(Expression expression) {
        return new Interpolator("exponential", expression);
    }

    public static Interpolator exponential(Number number) {
        return Expression.exponential(Expression.literal(number));
    }

    public static Expression floor(Expression expression) {
        return new Expression("floor", expression);
    }

    public static Expression floor(Number number) {
        return Expression.floor(Expression.literal(number));
    }

    public static Expression format(FormatEntry ... formatEntryArray) {
        Expression[] expressionArray = new Expression[formatEntryArray.length * 2];
        int n = formatEntryArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            FormatEntry formatEntry = formatEntryArray[i];
            int n3 = n2 + 1;
            expressionArray[n2] = formatEntry.text;
            HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
            if (formatEntry.options != null) {
                for (FormatOption formatOption : formatEntry.options) {
                    hashMap.put(formatOption.type, formatOption.value);
                }
            }
            expressionArray[n3] = new ExpressionMap(hashMap);
            n2 = n3 + 1;
        }
        return new Expression("format", expressionArray);
    }

    public static FormatEntry formatEntry(Expression expression) {
        return new FormatEntry(expression, null);
    }

    public static FormatEntry formatEntry(Expression expression, FormatOption ... formatOptionArray) {
        return new FormatEntry(expression, formatOptionArray);
    }

    public static FormatEntry formatEntry(String string2) {
        return new FormatEntry(Expression.literal(string2), null);
    }

    public static FormatEntry formatEntry(String string2, FormatOption ... formatOptionArray) {
        return new FormatEntry(Expression.literal(string2), formatOptionArray);
    }

    public static Expression geometryType() {
        return new Expression("geometry-type", new Expression[0]);
    }

    public static Expression get(Expression expression) {
        return new Expression("get", expression);
    }

    public static Expression get(Expression expression, Expression expression2) {
        return new Expression("get", expression, expression2);
    }

    public static Expression get(String string2) {
        return Expression.get(Expression.literal(string2));
    }

    public static Expression get(String string2, Expression expression) {
        return Expression.get(Expression.literal(string2), expression);
    }

    public static Expression gt(Expression expression, Expression expression2) {
        return new Expression(">", expression, expression2);
    }

    public static Expression gt(Expression expression, Expression expression2, Expression expression3) {
        return new Expression(">", expression, expression2, expression3);
    }

    public static Expression gt(Expression expression, Number number) {
        return new Expression(">", expression, Expression.literal(number));
    }

    public static Expression gt(Expression expression, String string2) {
        return new Expression(">", expression, Expression.literal(string2));
    }

    public static Expression gt(Expression expression, String string2, Expression expression2) {
        return new Expression(">", expression, Expression.literal(string2), expression2);
    }

    public static Expression gte(Expression expression, Expression expression2) {
        return new Expression(">=", expression, expression2);
    }

    public static Expression gte(Expression expression, Expression expression2, Expression expression3) {
        return new Expression(">=", expression, expression2, expression3);
    }

    public static Expression gte(Expression expression, Number number) {
        return new Expression(">=", expression, Expression.literal(number));
    }

    public static Expression gte(Expression expression, String string2) {
        return new Expression(">=", expression, Expression.literal(string2));
    }

    public static Expression gte(Expression expression, String string2, Expression expression2) {
        return new Expression(">=", expression, Expression.literal(string2), expression2);
    }

    public static Expression has(Expression expression) {
        return new Expression("has", expression);
    }

    public static Expression has(Expression expression, Expression expression2) {
        return new Expression("has", expression, expression2);
    }

    public static Expression has(String string2) {
        return Expression.has(Expression.literal(string2));
    }

    public static Expression has(String string2, Expression expression) {
        return Expression.has(Expression.literal(string2), expression);
    }

    public static Expression heatmapDensity() {
        return new Expression("heatmap-density", new Expression[0]);
    }

    public static Expression id() {
        return new Expression("id", new Expression[0]);
    }

    public static Expression image(Expression expression) {
        return new Expression("image", expression);
    }

    public static Expression in(Expression expression, Expression expression2) {
        return new Expression("in", expression, expression2);
    }

    public static Expression in(Number number, Expression expression) {
        return new Expression("in", Expression.literal(number), expression);
    }

    public static Expression in(String string2, Expression expression) {
        return new Expression("in", Expression.literal(string2), expression);
    }

    public static Expression interpolate(Interpolator interpolator2, Expression expression, Stop ... stopArray) {
        return Expression.interpolate(interpolator2, expression, Stop.toExpressionArray(stopArray));
    }

    public static Expression interpolate(Interpolator interpolator2, Expression expression, Expression ... expressionArray) {
        return new Expression("interpolate", Expression.join(new Expression[]{interpolator2, expression}, expressionArray));
    }

    public static Expression isSupportedScript(Expression expression) {
        return new Expression("is-supported-script", expression);
    }

    public static Expression isSupportedScript(String string2) {
        return new Expression("is-supported-script", Expression.literal(string2));
    }

    private static Expression[] join(Expression[] expressionArray, Expression[] expressionArray2) {
        Expression[] expressionArray3 = new Expression[expressionArray.length + expressionArray2.length];
        System.arraycopy(expressionArray, 0, expressionArray3, 0, expressionArray.length);
        System.arraycopy(expressionArray2, 0, expressionArray3, expressionArray.length, expressionArray2.length);
        return expressionArray3;
    }

    public static Expression length(Expression expression) {
        return new Expression("length", expression);
    }

    public static Expression length(String string2) {
        return Expression.length(Expression.literal(string2));
    }

    public static Expression let(Expression ... expressionArray) {
        return new Expression("let", expressionArray);
    }

    public static Expression lineProgress() {
        return new Expression("line-progress", new Expression[0]);
    }

    public static Interpolator linear() {
        return new Interpolator("linear", new Expression[0]);
    }

    public static Expression literal(Number number) {
        return new ExpressionLiteral(number);
    }

    public static Expression literal(Object object) {
        if (object.getClass().isArray()) {
            return Expression.literal(Expression.toObjectArray(object));
        }
        if (!(object instanceof Expression)) {
            return new ExpressionLiteral(object);
        }
        throw new RuntimeException("Can't convert an expression to a literal");
    }

    public static Expression literal(String string2) {
        return new ExpressionLiteral(string2);
    }

    public static Expression literal(boolean bl) {
        return new ExpressionLiteral(bl);
    }

    public static Expression literal(Object[] objectArray) {
        return new Expression("literal", new ExpressionLiteralArray(objectArray));
    }

    public static Expression ln(Expression expression) {
        return new Expression("ln", expression);
    }

    public static Expression ln(Number number) {
        return Expression.ln(Expression.literal(number));
    }

    public static Expression ln2() {
        return new Expression("ln2", new Expression[0]);
    }

    public static Expression log10(Expression expression) {
        return new Expression("log10", expression);
    }

    public static Expression log10(Number number) {
        return Expression.log10(Expression.literal(number));
    }

    public static Expression log2(Expression expression) {
        return new Expression("log2", expression);
    }

    public static Expression log2(Number number) {
        return Expression.log2(Expression.literal(number));
    }

    public static Expression lt(Expression expression, Expression expression2) {
        return new Expression("<", expression, expression2);
    }

    public static Expression lt(Expression expression, Expression expression2, Expression expression3) {
        return new Expression("<", expression, expression2, expression3);
    }

    public static Expression lt(Expression expression, Number number) {
        return new Expression("<", expression, Expression.literal(number));
    }

    public static Expression lt(Expression expression, String string2) {
        return new Expression("<", expression, Expression.literal(string2));
    }

    public static Expression lt(Expression expression, String string2, Expression expression2) {
        return new Expression("<", expression, Expression.literal(string2), expression2);
    }

    public static Expression lte(Expression expression, Expression expression2) {
        return new Expression("<=", expression, expression2);
    }

    public static Expression lte(Expression expression, Expression expression2, Expression expression3) {
        return new Expression("<=", expression, expression2, expression3);
    }

    public static Expression lte(Expression expression, Number number) {
        return new Expression("<=", expression, Expression.literal(number));
    }

    public static Expression lte(Expression expression, String string2) {
        return new Expression("<=", expression, Expression.literal(string2));
    }

    public static Expression lte(Expression expression, String string2, Expression expression2) {
        return new Expression("<=", expression, Expression.literal(string2), expression2);
    }

    public static Expression match(Expression expression, Expression expression2, Stop ... objectArray) {
        objectArray = Stop.toExpressionArray((Stop[])objectArray);
        return Expression.match(Expression.join(Expression.join(new Expression[]{expression}, (Expression[])objectArray), new Expression[]{expression2}));
    }

    public static Expression match(Expression ... expressionArray) {
        return new Expression("match", expressionArray);
    }

    public static Expression max(Expression ... expressionArray) {
        return new Expression("max", expressionArray);
    }

    public static Expression max(Number ... numberArray) {
        Expression[] expressionArray = new Expression[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            expressionArray[i] = Expression.literal(numberArray[i]);
        }
        return Expression.max(expressionArray);
    }

    public static Expression min(Expression ... expressionArray) {
        return new Expression("min", expressionArray);
    }

    public static Expression min(Number ... numberArray) {
        Expression[] expressionArray = new Expression[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            expressionArray[i] = Expression.literal(numberArray[i]);
        }
        return Expression.min(expressionArray);
    }

    public static Expression mod(Expression expression, Expression expression2) {
        return new Expression("%", expression, expression2);
    }

    public static Expression mod(Number number, Number number2) {
        return Expression.mod(Expression.literal(number), Expression.literal(number2));
    }

    public static Expression neq(Expression expression, Expression expression2) {
        return new Expression("!=", expression, expression2);
    }

    public static Expression neq(Expression expression, Expression expression2, Expression expression3) {
        return new Expression("!=", expression, expression2, expression3);
    }

    public static Expression neq(Expression expression, Number number) {
        return new Expression("!=", expression, Expression.literal(number));
    }

    public static Expression neq(Expression expression, String string2) {
        return new Expression("!=", expression, Expression.literal(string2));
    }

    public static Expression neq(Expression expression, String string2, Expression expression2) {
        return new Expression("!=", expression, Expression.literal(string2), expression2);
    }

    public static Expression neq(Expression expression, boolean bl) {
        return new Expression("!=", expression, Expression.literal(bl));
    }

    public static Expression not(Expression expression) {
        return new Expression("!", expression);
    }

    public static Expression not(boolean bl) {
        return Expression.not(Expression.literal(bl));
    }

    public static Expression number(Expression ... expressionArray) {
        return new Expression("number", expressionArray);
    }

    public static Expression numberFormat(Expression expression, NumberFormatOption ... numberFormatOptionArray) {
        HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
        for (NumberFormatOption numberFormatOption : numberFormatOptionArray) {
            hashMap.put(numberFormatOption.type, numberFormatOption.value);
        }
        return new Expression("number-format", expression, new ExpressionMap(hashMap));
    }

    public static Expression numberFormat(Number number, NumberFormatOption ... numberFormatOptionArray) {
        return Expression.numberFormat(Expression.literal(number), numberFormatOptionArray);
    }

    public static Expression object(Expression expression) {
        return new Expression("object", expression);
    }

    public static Expression pi() {
        return new Expression("pi", new Expression[0]);
    }

    public static Expression pow(Expression expression, Expression expression2) {
        return new Expression("^", expression, expression2);
    }

    public static Expression pow(Number number, Number number2) {
        return Expression.pow(Expression.literal(number), Expression.literal(number2));
    }

    public static Expression product(Expression ... expressionArray) {
        return new Expression("*", expressionArray);
    }

    public static Expression product(Number ... numberArray) {
        Expression[] expressionArray = new Expression[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            expressionArray[i] = Expression.literal(numberArray[i]);
        }
        return Expression.product(expressionArray);
    }

    public static Expression properties() {
        return new Expression("properties", new Expression[0]);
    }

    public static Expression raw(String string2) {
        return Converter.convert(string2);
    }

    public static Expression resolvedLocale(Expression expression) {
        return new Expression("resolved-locale", expression);
    }

    public static Expression rgb(Expression expression, Expression expression2, Expression expression3) {
        return new Expression("rgb", expression, expression2, expression3);
    }

    public static Expression rgb(Number number, Number number2, Number number3) {
        return Expression.rgb(Expression.literal(number), Expression.literal(number2), Expression.literal(number3));
    }

    public static Expression rgba(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        return new Expression("rgba", expression, expression2, expression3, expression4);
    }

    public static Expression rgba(Number number, Number number2, Number number3, Number number4) {
        return Expression.rgba(Expression.literal(number), Expression.literal(number2), Expression.literal(number3), Expression.literal(number4));
    }

    public static Expression round(Expression expression) {
        return new Expression("round", expression);
    }

    public static Expression round(Number number) {
        return Expression.round(Expression.literal(number));
    }

    public static Expression sin(Expression expression) {
        return new Expression("sin", expression);
    }

    public static Expression sin(Number number) {
        return Expression.sin(Expression.literal(number));
    }

    public static Expression sqrt(Expression expression) {
        return new Expression("sqrt", expression);
    }

    public static Expression sqrt(Number number) {
        return Expression.sqrt(Expression.literal(number));
    }

    public static Expression step(Expression expression, Expression expression2, Stop ... stopArray) {
        return Expression.step(expression, expression2, Stop.toExpressionArray(stopArray));
    }

    public static Expression step(Expression expression, Expression expression2, Expression ... expressionArray) {
        return new Expression("step", Expression.join(new Expression[]{expression, expression2}, expressionArray));
    }

    public static Expression step(Expression expression, Number number, Stop ... stopArray) {
        return Expression.step(expression, number, Stop.toExpressionArray(stopArray));
    }

    public static Expression step(Expression expression, Number number, Expression ... expressionArray) {
        return Expression.step(expression, Expression.literal(number), expressionArray);
    }

    public static Expression step(Number number, Expression expression, Stop ... stopArray) {
        return Expression.step(Expression.literal(number), expression, Stop.toExpressionArray(stopArray));
    }

    public static Expression step(Number number, Expression expression, Expression ... expressionArray) {
        return Expression.step(Expression.literal(number), expression, expressionArray);
    }

    public static Expression step(Number number, Number number2, Stop ... stopArray) {
        return Expression.step(Expression.literal(number), number2, Stop.toExpressionArray(stopArray));
    }

    public static Expression step(Number number, Number number2, Expression ... expressionArray) {
        return Expression.step(Expression.literal(number), number2, expressionArray);
    }

    public static Stop stop(Object object, Object object2) {
        return new Stop(object, object2);
    }

    public static Expression string(Expression ... expressionArray) {
        return new Expression("string", expressionArray);
    }

    public static Expression subtract(Expression expression) {
        return new Expression("-", expression);
    }

    public static Expression subtract(Expression expression, Expression expression2) {
        return new Expression("-", expression, expression2);
    }

    public static Expression subtract(Number number) {
        return Expression.subtract(Expression.literal(number));
    }

    public static Expression subtract(Number number, Number number2) {
        return Expression.subtract(Expression.literal(number), Expression.literal(number2));
    }

    public static Expression sum(Expression ... expressionArray) {
        return new Expression("+", expressionArray);
    }

    public static Expression sum(Number ... numberArray) {
        Expression[] expressionArray = new Expression[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            expressionArray[i] = Expression.literal(numberArray[i]);
        }
        return Expression.sum(expressionArray);
    }

    public static Expression switchCase(Expression ... expressionArray) {
        return new Expression("case", expressionArray);
    }

    public static Expression tan(Expression expression) {
        return new Expression("tan", expression);
    }

    public static Expression tan(Number number) {
        return new Expression("tan", Expression.literal(number));
    }

    public static Expression toBool(Expression expression) {
        return new Expression("to-boolean", expression);
    }

    public static Expression toColor(Expression expression) {
        return new Expression("to-color", expression);
    }

    public static Expression toNumber(Expression expression) {
        return new Expression("to-number", expression);
    }

    private static Object[] toObjectArray(Object object) {
        int n = java.lang.reflect.Array.getLength(object);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = java.lang.reflect.Array.get(object, i);
        }
        return objectArray;
    }

    public static Expression toRgba(Expression expression) {
        return new Expression("to-rgba", expression);
    }

    public static Expression toString(Expression expression) {
        return new Expression("to-string", expression);
    }

    public static Expression typeOf(Expression expression) {
        return new Expression("typeof", expression);
    }

    public static Expression upcase(Expression expression) {
        return new Expression("upcase", expression);
    }

    public static Expression upcase(String string2) {
        return Expression.upcase(Expression.literal(string2));
    }

    public static Expression var(Expression expression) {
        return new Expression("var", expression);
    }

    public static Expression var(String string2) {
        return Expression.var(Expression.literal(string2));
    }

    public static Expression within(Polygon polygon) {
        HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
        hashMap.put("type", Expression.literal(polygon.type()));
        hashMap.put("json", Expression.literal(polygon.toJson()));
        return new Expression("within", new ExpressionMap(hashMap));
    }

    public static Expression zoom() {
        return new Expression("zoom", new Expression[0]);
    }

    public boolean equals(Object object) {
        super.equals(object);
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof Expression) {
            Expression expression = (Expression)object;
            object = this.operator;
            if (object != null ? !((String)object).equals(expression.operator) : expression.operator != null) {
                return false;
            }
            return Arrays.deepEquals(this.arguments, expression.arguments);
        }
        return false;
    }

    public int hashCode() {
        String string2 = this.operator;
        int n = string2 != null ? string2.hashCode() : 0;
        return n * 31 + Arrays.hashCode(this.arguments);
    }

    public Object[] toArray() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.operator);
        Expression[] expressionArray = this.arguments;
        if (expressionArray != null) {
            for (Expression expression : expressionArray) {
                if (expression instanceof ValueExpression) {
                    arrayList.add(((ValueExpression)((Object)expression)).toValue());
                    continue;
                }
                arrayList.add(expression.toArray());
            }
        }
        return arrayList.toArray();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\"");
        stringBuilder.append(this.operator);
        stringBuilder.append("\"");
        Expression[] expressionArray = this.arguments;
        if (expressionArray != null) {
            for (Expression expression : expressionArray) {
                stringBuilder.append(", ");
                stringBuilder.append(((Object)expression).toString());
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class Array {
    }

    public static final class Converter {
        private static final Gson gson = new Gson();

        public static Expression convert(JsonArray jsonArray) {
            if (jsonArray.size() != 0) {
                String string2 = jsonArray.get(0).getAsString();
                ArrayList<Expression> arrayList = new ArrayList<Expression>();
                boolean bl = string2.equals("within");
                if (bl) {
                    return Expression.within(Polygon.fromJson(jsonArray.get(1).toString()));
                }
                if (string2.equals("distance")) {
                    return Expression.distance(GeometryGeoJson.fromJson(jsonArray.get(1).toString()));
                }
                for (int i = 1; i < jsonArray.size(); ++i) {
                    Object[] objectArray = jsonArray.get(i);
                    if (string2.equals("literal") && objectArray instanceof JsonArray) {
                        JsonArray jsonArray2 = (JsonArray)objectArray;
                        objectArray = new Object[jsonArray2.size()];
                        for (int j = 0; j < jsonArray2.size(); ++j) {
                            JsonElement jsonElement = jsonArray2.get(j);
                            if (jsonElement instanceof JsonPrimitive) {
                                objectArray[j] = Converter.convertToValue((JsonPrimitive)jsonElement);
                                continue;
                            }
                            throw new IllegalArgumentException("Nested literal arrays are not supported.");
                        }
                        arrayList.add(new ExpressionLiteralArray(objectArray));
                        continue;
                    }
                    arrayList.add(Converter.convert((JsonElement)objectArray));
                }
                return new Expression(string2, arrayList.toArray(new Expression[arrayList.size()]));
            }
            throw new IllegalArgumentException("Can't convert empty jsonArray expressions");
        }

        public static Expression convert(JsonElement object) {
            if (object instanceof JsonArray) {
                return Converter.convert((JsonArray)object);
            }
            if (object instanceof JsonPrimitive) {
                return Converter.convert((JsonPrimitive)object);
            }
            if (object instanceof JsonNull) {
                return new ExpressionLiteral("");
            }
            if (object instanceof JsonObject) {
                HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
                JsonObject jsonObject = (JsonObject)object;
                for (String string2 : jsonObject.keySet()) {
                    hashMap.put(string2, Converter.convert(jsonObject.get(string2)));
                }
                return new ExpressionMap(hashMap);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unsupported expression conversion for ");
            stringBuilder.append(object.getClass());
            throw new RuntimeException(stringBuilder.toString());
        }

        private static Expression convert(JsonPrimitive jsonPrimitive) {
            return new ExpressionLiteral(Converter.convertToValue(jsonPrimitive));
        }

        public static Expression convert(String string2) {
            return Converter.convert(gson.fromJson(string2, JsonArray.class));
        }

        private static Object convertToValue(JsonPrimitive jsonPrimitive) {
            if (jsonPrimitive.isBoolean()) {
                return jsonPrimitive.getAsBoolean();
            }
            if (jsonPrimitive.isNumber()) {
                return Float.valueOf(jsonPrimitive.getAsFloat());
            }
            if (jsonPrimitive.isString()) {
                return jsonPrimitive.getAsString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unsupported literal expression conversion for ");
            stringBuilder.append(jsonPrimitive.getClass());
            throw new RuntimeException(stringBuilder.toString());
        }
    }

    public static class ExpressionLiteral
    extends Expression
    implements ValueExpression {
        protected Object literal;

        public ExpressionLiteral(Object object) {
            Object object2;
            if (object instanceof String) {
                object2 = ExpressionLiteral.unwrapStringLiteral((String)object);
            } else {
                object2 = object;
                if (object instanceof Number) {
                    object2 = Float.valueOf(((Number)object).floatValue());
                }
            }
            this.literal = object2;
        }

        private static String unwrapStringLiteral(String string2) {
            String string3 = string2;
            if (string2.length() > 1) {
                string3 = string2;
                if (string2.charAt(0) == '\"') {
                    string3 = string2;
                    if (string2.charAt(string2.length() - 1) == '\"') {
                        string3 = string2.substring(1, string2.length() - 1);
                    }
                }
            }
            return string3;
        }

        @Override
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                if (!super.equals(object)) {
                    return false;
                }
                Object object2 = (ExpressionLiteral)object;
                object = this.literal;
                object2 = ((ExpressionLiteral)object2).literal;
                if (object != null) {
                    bl = object.equals(object2);
                } else if (object2 != null) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            Object object = this.literal;
            int n2 = object != null ? object.hashCode() : 0;
            return n * 31 + n2;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{"literal", this.literal};
        }

        @Override
        public String toString() {
            Object object = this.literal;
            if (object instanceof String) {
                object = new StringBuilder();
                ((StringBuilder)object).append("\"");
                ((StringBuilder)object).append(this.literal);
                ((StringBuilder)object).append("\"");
                object = ((StringBuilder)object).toString();
            } else {
                object = object.toString();
            }
            return object;
        }

        @Override
        public Object toValue() {
            Object object = this.literal;
            if (!(object instanceof PropertyValue)) {
                Object object2 = object;
                if (object instanceof ExpressionLiteral) {
                    object2 = ((ExpressionLiteral)object).toValue();
                }
                return object2;
            }
            throw new IllegalArgumentException("PropertyValue are not allowed as an expression literal, use value instead.");
        }
    }

    private static class ExpressionLiteralArray
    extends ExpressionLiteral {
        ExpressionLiteralArray(Object[] objectArray) {
            super(objectArray);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (ExpressionLiteralArray)object;
                return Arrays.equals((Object[])this.literal, (Object[])((ExpressionLiteralArray)object).literal);
            }
            return false;
        }

        @Override
        public String toString() {
            Object[] objectArray = (Object[])this.literal;
            StringBuilder stringBuilder = new StringBuilder("[");
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof String) {
                    stringBuilder.append("\"");
                    stringBuilder.append(object);
                    stringBuilder.append("\"");
                } else {
                    stringBuilder.append(object);
                }
                if (i == objectArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    private static class ExpressionMap
    extends Expression
    implements ValueExpression {
        private Map<String, Expression> map;

        ExpressionMap(Map<String, Expression> map) {
            this.map = map;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                if (!super.equals(object)) {
                    return false;
                }
                object = (ExpressionMap)object;
                return this.map.equals(((ExpressionMap)object).map);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            Map<String, Expression> map = this.map;
            int n2 = map == null ? 0 : map.hashCode();
            return n * 31 + n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            for (String string2 : this.map.keySet()) {
                stringBuilder.append("\"");
                stringBuilder.append(string2);
                stringBuilder.append("\": ");
                stringBuilder.append(this.map.get(string2));
                stringBuilder.append(", ");
            }
            if (this.map.size() > 0) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public Object toValue() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string2 : this.map.keySet()) {
                Expression expression = this.map.get(string2);
                if (expression instanceof ValueExpression) {
                    hashMap.put(string2, ((ValueExpression)((Object)expression)).toValue());
                    continue;
                }
                hashMap.put(string2, expression.toArray());
            }
            return hashMap;
        }
    }

    public static class FormatEntry {
        private FormatOption[] options;
        private Expression text;

        FormatEntry(Expression expression, FormatOption[] formatOptionArray) {
            this.text = expression;
            this.options = formatOptionArray;
        }
    }

    public static class FormatOption
    extends Option {
        FormatOption(String string2, Expression expression) {
            super(string2, expression);
        }

        public static FormatOption formatFontScale(double d) {
            return new FormatOption("font-scale", Expression.literal(d));
        }

        public static FormatOption formatFontScale(Expression expression) {
            return new FormatOption("font-scale", expression);
        }

        public static FormatOption formatTextColor(int n) {
            return new FormatOption("text-color", Expression.color(n));
        }

        public static FormatOption formatTextColor(Expression expression) {
            return new FormatOption("text-color", expression);
        }

        public static FormatOption formatTextFont(Expression expression) {
            return new FormatOption("text-font", expression);
        }

        public static FormatOption formatTextFont(String[] stringArray) {
            return new FormatOption("text-font", Expression.literal(stringArray));
        }
    }

    public static class Interpolator
    extends Expression {
        Interpolator(String string2, Expression ... expressionArray) {
            super(string2, expressionArray);
        }
    }

    public static class NumberFormatOption
    extends Option {
        NumberFormatOption(String string2, Expression expression) {
            super(string2, expression);
        }

        public static NumberFormatOption currency(Expression expression) {
            return new NumberFormatOption("currency", expression);
        }

        public static NumberFormatOption currency(String string2) {
            return new NumberFormatOption("currency", Expression.literal(string2));
        }

        public static NumberFormatOption locale(Expression expression) {
            return new NumberFormatOption("locale", expression);
        }

        public static NumberFormatOption locale(String string2) {
            return new NumberFormatOption("locale", Expression.literal(string2));
        }

        public static NumberFormatOption maxFractionDigits(int n) {
            return new NumberFormatOption("max-fraction-digits", Expression.literal(n));
        }

        public static NumberFormatOption maxFractionDigits(Expression expression) {
            return new NumberFormatOption("max-fraction-digits", expression);
        }

        public static NumberFormatOption minFractionDigits(int n) {
            return new NumberFormatOption("min-fraction-digits", Expression.literal(n));
        }

        public static NumberFormatOption minFractionDigits(Expression expression) {
            return new NumberFormatOption("min-fraction-digits", expression);
        }
    }

    private static class Option {
        String type;
        Expression value;

        Option(String string2, Expression expression) {
            this.type = string2;
            this.value = expression;
        }
    }

    public static class Stop {
        private Object output;
        private Object value;

        Stop(Object object, Object object2) {
            this.value = object;
            this.output = object2;
        }

        static Expression[] toExpressionArray(Stop ... stopArray) {
            Expression[] expressionArray = new Expression[stopArray.length * 2];
            for (int i = 0; i < stopArray.length; ++i) {
                Object object = stopArray[i];
                Object object2 = ((Stop)object).value;
                Object object3 = ((Stop)object).output;
                object = object2;
                if (!(object2 instanceof Expression)) {
                    object = Expression.literal(object2);
                }
                object2 = object3;
                if (!(object3 instanceof Expression)) {
                    object2 = Expression.literal(object3);
                }
                int n = i * 2;
                expressionArray[n] = (Expression)object;
                expressionArray[n + 1] = (Expression)object2;
            }
            return expressionArray;
        }
    }

    private static interface ValueExpression {
        public Object toValue();
    }
}

