/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class BackgroundLayer
extends Layer {
    BackgroundLayer(long l) {
        super(l);
    }

    public BackgroundLayer(String string2) {
        this.initialize(string2);
    }

    private native Object nativeGetBackgroundColor();

    private native TransitionOptions nativeGetBackgroundColorTransition();

    private native Object nativeGetBackgroundOpacity();

    private native TransitionOptions nativeGetBackgroundOpacityTransition();

    private native Object nativeGetBackgroundPattern();

    private native TransitionOptions nativeGetBackgroundPatternTransition();

    private native void nativeSetBackgroundColorTransition(long var1, long var3);

    private native void nativeSetBackgroundOpacityTransition(long var1, long var3);

    private native void nativeSetBackgroundPatternTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;

    public PropertyValue<String> getBackgroundColor() {
        this.checkThread();
        return new PropertyValue<Object>("background-color", this.nativeGetBackgroundColor());
    }

    public int getBackgroundColorAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getBackgroundColor();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("background-color was set as a Function");
    }

    public TransitionOptions getBackgroundColorTransition() {
        this.checkThread();
        return this.nativeGetBackgroundColorTransition();
    }

    public PropertyValue<Float> getBackgroundOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("background-opacity", this.nativeGetBackgroundOpacity());
    }

    public TransitionOptions getBackgroundOpacityTransition() {
        this.checkThread();
        return this.nativeGetBackgroundOpacityTransition();
    }

    public PropertyValue<String> getBackgroundPattern() {
        this.checkThread();
        return new PropertyValue<Object>("background-pattern", this.nativeGetBackgroundPattern());
    }

    public TransitionOptions getBackgroundPatternTransition() {
        this.checkThread();
        return this.nativeGetBackgroundPatternTransition();
    }

    protected native void initialize(String var1);

    public void setBackgroundColorTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetBackgroundColorTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setBackgroundOpacityTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetBackgroundOpacityTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setBackgroundPatternTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetBackgroundPatternTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public BackgroundLayer withProperties(PropertyValue<?> ... propertyValueArray) {
        this.setProperties(propertyValueArray);
        return this;
    }
}

