/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class FillLayer
extends Layer {
    FillLayer(long l) {
        super(l);
    }

    public FillLayer(String string2, String string3) {
        this.initialize(string2, string3);
    }

    private native Object nativeGetFillAntialias();

    private native Object nativeGetFillColor();

    private native TransitionOptions nativeGetFillColorTransition();

    private native Object nativeGetFillOpacity();

    private native TransitionOptions nativeGetFillOpacityTransition();

    private native Object nativeGetFillOutlineColor();

    private native TransitionOptions nativeGetFillOutlineColorTransition();

    private native Object nativeGetFillPattern();

    private native TransitionOptions nativeGetFillPatternTransition();

    private native Object nativeGetFillSortKey();

    private native Object nativeGetFillTranslate();

    private native Object nativeGetFillTranslateAnchor();

    private native TransitionOptions nativeGetFillTranslateTransition();

    private native void nativeSetFillColorTransition(long var1, long var3);

    private native void nativeSetFillOpacityTransition(long var1, long var3);

    private native void nativeSetFillOutlineColorTransition(long var1, long var3);

    private native void nativeSetFillPatternTransition(long var1, long var3);

    private native void nativeSetFillTranslateTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;

    public PropertyValue<Boolean> getFillAntialias() {
        this.checkThread();
        return new PropertyValue<Object>("fill-antialias", this.nativeGetFillAntialias());
    }

    public PropertyValue<String> getFillColor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-color", this.nativeGetFillColor());
    }

    public int getFillColorAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getFillColor();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("fill-color was set as a Function");
    }

    public TransitionOptions getFillColorTransition() {
        this.checkThread();
        return this.nativeGetFillColorTransition();
    }

    public PropertyValue<Float> getFillOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("fill-opacity", this.nativeGetFillOpacity());
    }

    public TransitionOptions getFillOpacityTransition() {
        this.checkThread();
        return this.nativeGetFillOpacityTransition();
    }

    public PropertyValue<String> getFillOutlineColor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-outline-color", this.nativeGetFillOutlineColor());
    }

    public int getFillOutlineColorAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getFillOutlineColor();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("fill-outline-color was set as a Function");
    }

    public TransitionOptions getFillOutlineColorTransition() {
        this.checkThread();
        return this.nativeGetFillOutlineColorTransition();
    }

    public PropertyValue<String> getFillPattern() {
        this.checkThread();
        return new PropertyValue<Object>("fill-pattern", this.nativeGetFillPattern());
    }

    public TransitionOptions getFillPatternTransition() {
        this.checkThread();
        return this.nativeGetFillPatternTransition();
    }

    public PropertyValue<Float> getFillSortKey() {
        this.checkThread();
        return new PropertyValue<Object>("fill-sort-key", this.nativeGetFillSortKey());
    }

    public PropertyValue<Float[]> getFillTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("fill-translate", this.nativeGetFillTranslate());
    }

    public PropertyValue<String> getFillTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-translate-anchor", this.nativeGetFillTranslateAnchor());
    }

    public TransitionOptions getFillTranslateTransition() {
        this.checkThread();
        return this.nativeGetFillTranslateTransition();
    }

    public Expression getFilter() {
        this.checkThread();
        JsonElement jsonElement = this.nativeGetFilter();
        if (jsonElement != null) {
            return Expression.Converter.convert(jsonElement);
        }
        return null;
    }

    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    protected native void initialize(String var1, String var2);

    public void setFillColorTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetFillColorTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setFillOpacityTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetFillOpacityTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setFillOutlineColorTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetFillOutlineColorTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setFillPatternTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetFillPatternTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setFillTranslateTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetFillTranslateTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setFilter(Expression expression) {
        this.checkThread();
        this.nativeSetFilter(expression.toArray());
    }

    public void setSourceLayer(String string2) {
        this.checkThread();
        this.nativeSetSourceLayer(string2);
    }

    public FillLayer withFilter(Expression expression) {
        this.setFilter(expression);
        return this;
    }

    public FillLayer withProperties(PropertyValue<?> ... propertyValueArray) {
        this.setProperties(propertyValueArray);
        return this;
    }

    public FillLayer withSourceLayer(String string2) {
        this.setSourceLayer(string2);
        return this;
    }
}

