/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.PaintPropertyValue;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.types.Formatted;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

public abstract class Layer {
    private static final String TAG = "Mbgl-Layer";
    private boolean detached;
    private boolean invalidated;
    private long nativePtr;

    static {
        LibraryLoader.load();
    }

    public Layer() {
        this.checkThread();
    }

    protected Layer(long l) {
        this.checkThread();
        this.nativePtr = l;
    }

    private Object convertValue(Object objectArray) {
        if (objectArray instanceof Expression) {
            return ((Expression)objectArray).toArray();
        }
        Object[] objectArray2 = objectArray;
        if (objectArray instanceof Formatted) {
            objectArray2 = ((Formatted)objectArray).toArray();
        }
        return objectArray2;
    }

    protected void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    protected native void finalize() throws Throwable;

    public String getId() {
        this.checkThread();
        return this.nativeGetId();
    }

    public float getMaxZoom() {
        this.checkThread();
        return this.nativeGetMaxZoom();
    }

    public float getMinZoom() {
        this.checkThread();
        return this.nativeGetMinZoom();
    }

    public long getNativePtr() {
        return this.nativePtr;
    }

    public PropertyValue<String> getVisibility() {
        this.checkThread();
        return new PaintPropertyValue<String>("visibility", (String)this.nativeGetVisibility());
    }

    public boolean isDetached() {
        return this.detached;
    }

    protected native JsonElement nativeGetFilter();

    protected native String nativeGetId();

    protected native float nativeGetMaxZoom();

    protected native float nativeGetMinZoom();

    protected native String nativeGetSourceId();

    protected native String nativeGetSourceLayer();

    protected native Object nativeGetVisibility();

    protected native void nativeSetFilter(Object[] var1);

    protected native void nativeSetLayoutProperty(String var1, Object var2);

    protected native void nativeSetMaxZoom(float var1);

    protected native void nativeSetMinZoom(float var1);

    protected native void nativeSetPaintProperty(String var1, Object var2);

    protected native void nativeSetSourceLayer(String var1);

    public void setDetached() {
        this.detached = true;
    }

    public void setMaxZoom(float f) {
        this.checkThread();
        this.nativeSetMaxZoom(f);
    }

    public void setMinZoom(float f) {
        this.checkThread();
        this.nativeSetMinZoom(f);
    }

    public void setProperties(PropertyValue<?> ... propertyValueArray) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        if (propertyValueArray.length == 0) {
            return;
        }
        for (PropertyValue<?> propertyValue : propertyValueArray) {
            Object object = this.convertValue(propertyValue.value);
            if (propertyValue instanceof PaintPropertyValue) {
                this.nativeSetPaintProperty(propertyValue.name, object);
                continue;
            }
            this.nativeSetLayoutProperty(propertyValue.name, object);
        }
    }
}

