/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class LineLayer
extends Layer {
    LineLayer(long l) {
        super(l);
    }

    public LineLayer(String string2, String string3) {
        this.initialize(string2, string3);
    }

    private native Object nativeGetLineBlur();

    private native TransitionOptions nativeGetLineBlurTransition();

    private native Object nativeGetLineCap();

    private native Object nativeGetLineColor();

    private native TransitionOptions nativeGetLineColorTransition();

    private native Object nativeGetLineDasharray();

    private native TransitionOptions nativeGetLineDasharrayTransition();

    private native Object nativeGetLineGapWidth();

    private native TransitionOptions nativeGetLineGapWidthTransition();

    private native Object nativeGetLineGradient();

    private native Object nativeGetLineJoin();

    private native Object nativeGetLineMiterLimit();

    private native Object nativeGetLineOffset();

    private native TransitionOptions nativeGetLineOffsetTransition();

    private native Object nativeGetLineOpacity();

    private native TransitionOptions nativeGetLineOpacityTransition();

    private native Object nativeGetLinePattern();

    private native TransitionOptions nativeGetLinePatternTransition();

    private native Object nativeGetLineRoundLimit();

    private native Object nativeGetLineSortKey();

    private native Object nativeGetLineTranslate();

    private native Object nativeGetLineTranslateAnchor();

    private native TransitionOptions nativeGetLineTranslateTransition();

    private native Object nativeGetLineWidth();

    private native TransitionOptions nativeGetLineWidthTransition();

    private native void nativeSetLineBlurTransition(long var1, long var3);

    private native void nativeSetLineColorTransition(long var1, long var3);

    private native void nativeSetLineDasharrayTransition(long var1, long var3);

    private native void nativeSetLineGapWidthTransition(long var1, long var3);

    private native void nativeSetLineOffsetTransition(long var1, long var3);

    private native void nativeSetLineOpacityTransition(long var1, long var3);

    private native void nativeSetLinePatternTransition(long var1, long var3);

    private native void nativeSetLineTranslateTransition(long var1, long var3);

    private native void nativeSetLineWidthTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;

    public Expression getFilter() {
        this.checkThread();
        JsonElement jsonElement = this.nativeGetFilter();
        if (jsonElement != null) {
            return Expression.Converter.convert(jsonElement);
        }
        return null;
    }

    public PropertyValue<Float> getLineBlur() {
        this.checkThread();
        return new PropertyValue<Object>("line-blur", this.nativeGetLineBlur());
    }

    public TransitionOptions getLineBlurTransition() {
        this.checkThread();
        return this.nativeGetLineBlurTransition();
    }

    public PropertyValue<String> getLineCap() {
        this.checkThread();
        return new PropertyValue<Object>("line-cap", this.nativeGetLineCap());
    }

    public PropertyValue<String> getLineColor() {
        this.checkThread();
        return new PropertyValue<Object>("line-color", this.nativeGetLineColor());
    }

    public int getLineColorAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getLineColor();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("line-color was set as a Function");
    }

    public TransitionOptions getLineColorTransition() {
        this.checkThread();
        return this.nativeGetLineColorTransition();
    }

    public PropertyValue<Float[]> getLineDasharray() {
        this.checkThread();
        return new PropertyValue<Object>("line-dasharray", this.nativeGetLineDasharray());
    }

    public TransitionOptions getLineDasharrayTransition() {
        this.checkThread();
        return this.nativeGetLineDasharrayTransition();
    }

    public PropertyValue<Float> getLineGapWidth() {
        this.checkThread();
        return new PropertyValue<Object>("line-gap-width", this.nativeGetLineGapWidth());
    }

    public TransitionOptions getLineGapWidthTransition() {
        this.checkThread();
        return this.nativeGetLineGapWidthTransition();
    }

    public PropertyValue<String> getLineGradient() {
        this.checkThread();
        return new PropertyValue<Object>("line-gradient", this.nativeGetLineGradient());
    }

    public int getLineGradientAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getLineGradient();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("line-gradient was set as a Function");
    }

    public PropertyValue<String> getLineJoin() {
        this.checkThread();
        return new PropertyValue<Object>("line-join", this.nativeGetLineJoin());
    }

    public PropertyValue<Float> getLineMiterLimit() {
        this.checkThread();
        return new PropertyValue<Object>("line-miter-limit", this.nativeGetLineMiterLimit());
    }

    public PropertyValue<Float> getLineOffset() {
        this.checkThread();
        return new PropertyValue<Object>("line-offset", this.nativeGetLineOffset());
    }

    public TransitionOptions getLineOffsetTransition() {
        this.checkThread();
        return this.nativeGetLineOffsetTransition();
    }

    public PropertyValue<Float> getLineOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("line-opacity", this.nativeGetLineOpacity());
    }

    public TransitionOptions getLineOpacityTransition() {
        this.checkThread();
        return this.nativeGetLineOpacityTransition();
    }

    public PropertyValue<String> getLinePattern() {
        this.checkThread();
        return new PropertyValue<Object>("line-pattern", this.nativeGetLinePattern());
    }

    public TransitionOptions getLinePatternTransition() {
        this.checkThread();
        return this.nativeGetLinePatternTransition();
    }

    public PropertyValue<Float> getLineRoundLimit() {
        this.checkThread();
        return new PropertyValue<Object>("line-round-limit", this.nativeGetLineRoundLimit());
    }

    public PropertyValue<Float> getLineSortKey() {
        this.checkThread();
        return new PropertyValue<Object>("line-sort-key", this.nativeGetLineSortKey());
    }

    public PropertyValue<Float[]> getLineTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("line-translate", this.nativeGetLineTranslate());
    }

    public PropertyValue<String> getLineTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("line-translate-anchor", this.nativeGetLineTranslateAnchor());
    }

    public TransitionOptions getLineTranslateTransition() {
        this.checkThread();
        return this.nativeGetLineTranslateTransition();
    }

    public PropertyValue<Float> getLineWidth() {
        this.checkThread();
        return new PropertyValue<Object>("line-width", this.nativeGetLineWidth());
    }

    public TransitionOptions getLineWidthTransition() {
        this.checkThread();
        return this.nativeGetLineWidthTransition();
    }

    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    protected native void initialize(String var1, String var2);

    public void setFilter(Expression expression) {
        this.checkThread();
        this.nativeSetFilter(expression.toArray());
    }

    public void setLineBlurTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLineBlurTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setLineColorTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLineColorTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setLineDasharrayTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLineDasharrayTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setLineGapWidthTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLineGapWidthTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setLineOffsetTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLineOffsetTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setLineOpacityTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLineOpacityTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setLinePatternTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLinePatternTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setLineTranslateTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLineTranslateTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setLineWidthTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLineWidthTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setSourceLayer(String string2) {
        this.checkThread();
        this.nativeSetSourceLayer(string2);
    }

    public LineLayer withFilter(Expression expression) {
        this.setFilter(expression);
        return this;
    }

    public LineLayer withProperties(PropertyValue<?> ... propertyValueArray) {
        this.setProperties(propertyValueArray);
        return this;
    }

    public LineLayer withSourceLayer(String string2) {
        this.setSourceLayer(string2);
        return this;
    }
}

