/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.light;

import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.light.Position;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

public class Light {
    private static final String TAG = "Mbgl-Light";
    private long nativePtr;

    Light(long l) {
        this.checkThread();
        this.nativePtr = l;
    }

    private void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    private native String nativeGetAnchor();

    private native String nativeGetColor();

    private native TransitionOptions nativeGetColorTransition();

    private native float nativeGetIntensity();

    private native TransitionOptions nativeGetIntensityTransition();

    private native Position nativeGetPosition();

    private native TransitionOptions nativeGetPositionTransition();

    private native void nativeSetAnchor(String var1);

    private native void nativeSetColor(String var1);

    private native void nativeSetColorTransition(long var1, long var3);

    private native void nativeSetIntensity(float var1);

    private native void nativeSetIntensityTransition(long var1, long var3);

    private native void nativeSetPosition(Position var1);

    private native void nativeSetPositionTransition(long var1, long var3);

    public String getAnchor() {
        this.checkThread();
        return this.nativeGetAnchor();
    }

    public String getColor() {
        this.checkThread();
        return this.nativeGetColor();
    }

    public TransitionOptions getColorTransition() {
        this.checkThread();
        return this.nativeGetColorTransition();
    }

    public float getIntensity() {
        this.checkThread();
        return this.nativeGetIntensity();
    }

    public TransitionOptions getIntensityTransition() {
        this.checkThread();
        return this.nativeGetIntensityTransition();
    }

    public Position getPosition() {
        this.checkThread();
        return this.nativeGetPosition();
    }

    public TransitionOptions getPositionTransition() {
        this.checkThread();
        return this.nativeGetPositionTransition();
    }

    public void setAnchor(String string2) {
        this.checkThread();
        this.nativeSetAnchor(string2);
    }

    public void setColor(int n) {
        this.checkThread();
        this.nativeSetColor(ColorUtils.colorToRgbaString(n));
    }

    public void setColor(String string2) {
        this.checkThread();
        this.nativeSetColor(string2);
    }

    public void setColorTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetColorTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setIntensity(float f) {
        this.checkThread();
        this.nativeSetIntensity(f);
    }

    public void setIntensityTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetIntensityTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setPosition(Position position) {
        this.checkThread();
        this.nativeSetPosition(position);
    }

    public void setPositionTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetPositionTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }
}

