/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.Property;
import android.view.View;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;

public class AnimatorUtils {
    public static void alpha(View view, float f) {
        AnimatorUtils.alpha(view, f, null);
    }

    public static void alpha(final View view, float f, final OnAnimationEndListener onAnimationEndListener) {
        view.setLayerType(2, null);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (Property)View.ALPHA, (float[])new float[]{view.getAlpha(), f});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator object) {
                super.onAnimationEnd((Animator)object);
                view.setLayerType(0, null);
                object = onAnimationEndListener;
                if (object != null) {
                    object.onAnimationEnd();
                }
            }

            public void onAnimationStart(Animator animator2) {
                super.onAnimationStart(animator2);
                view.setVisibility(0);
            }
        });
        objectAnimator.start();
    }

    public static void animate(View view, int n) {
        AnimatorUtils.animate(view, n, -1);
    }

    public static void animate(View view, int n, int n2) {
        AnimatorUtils.animate(view, n, n2, null);
    }

    public static void animate(final View view, int n, int n2, final OnAnimationEndListener onAnimationEndListener) {
        if (view == null) {
            return;
        }
        view.setLayerType(2, null);
        Animator animator2 = AnimatorInflater.loadAnimator((Context)view.getContext(), (int)n);
        if (n2 != -1) {
            animator2.setDuration((long)n2);
        }
        animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator object) {
                super.onAnimationEnd((Animator)object);
                view.setLayerType(0, null);
                object = onAnimationEndListener;
                if (object != null) {
                    object.onAnimationEnd();
                }
            }
        });
        animator2.setTarget((Object)view);
        animator2.start();
    }

    public static void animate(View view, int n, OnAnimationEndListener onAnimationEndListener) {
        AnimatorUtils.animate(view, n, -1, onAnimationEndListener);
    }

    public static void rotate(final View view, float f) {
        view.setLayerType(2, null);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (Property)View.ROTATION, (float[])new float[]{view.getRotation(), f});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                super.onAnimationEnd(animator2);
                view.setLayerType(0, null);
            }
        });
        objectAnimator.start();
    }

    public static void rotateBy(final View view, float f) {
        view.setLayerType(2, null);
        view.animate().rotationBy(f).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                super.onAnimationEnd(animator2);
                view.setLayerType(0, null);
            }
        });
    }

    public static interface OnAnimationEndListener {
        public void onAnimationEnd();
    }
}

