/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.graphics.Typeface;
import android.os.Build;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.log.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FontUtils {
    private static final List<String> DEFAULT_FONT_STACKS;
    private static final String TAG = "Mbgl-FontUtils";
    private static final String TYPEFACE_FONTMAP_FIELD_NAME = "sSystemFontMap";

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        DEFAULT_FONT_STACKS = arrayList;
        arrayList.add("sans-serif");
        arrayList.add("serif");
        arrayList.add("monospace");
    }

    private FontUtils() {
    }

    public static String extractValidFont(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        List<String> list = Build.VERSION.SDK_INT >= 21 ? FontUtils.getDeviceFonts() : DEFAULT_FONT_STACKS;
        for (String string2 : stringArray) {
            if (!list.contains(string2)) continue;
            return string2;
        }
        Logger.i(TAG, String.format("Couldn't map font family for local ideograph, using %s instead", "sans-serif"));
        return "sans-serif";
    }

    private static List<String> getDeviceFonts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Typeface typeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
            Field field = Typeface.class.getDeclaredField(TYPEFACE_FONTMAP_FIELD_NAME);
            field.setAccessible(true);
            arrayList.addAll(((Map)field.get(typeface)).keySet());
        }
        catch (Exception exception) {
            Logger.e(TAG, "Couldn't load fonts from Typeface", exception);
            MapStrictMode.strictModeViolation("Couldn't load fonts from Typeface", exception);
        }
        return arrayList;
    }
}

