/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.MultiLineString;
import com.mapbox.geojson.MultiPoint;
import com.mapbox.geojson.MultiPolygon;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.turf.TurfException;
import com.mapbox.turf.TurfMeta;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class TurfConversion {
    private static final Map<String, Double> FACTORS;

    static {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        FACTORS = hashMap;
        hashMap.put("miles", 3960.0);
        hashMap.put("nauticalmiles", 3441.145);
        hashMap.put("degrees", 57.2957795);
        hashMap.put("radians", 1.0);
        hashMap.put("inches", 2.509056E8);
        hashMap.put("yards", 6969600.0);
        Double d = 6373000.0;
        hashMap.put("meters", d);
        Double d2 = 6.373E8;
        hashMap.put("centimeters", d2);
        Double d3 = 6373.0;
        hashMap.put("kilometers", d3);
        hashMap.put("feet", 2.090879265E7);
        hashMap.put("centimetres", d2);
        hashMap.put("metres", d);
        hashMap.put("kilometres", d3);
    }

    private TurfConversion() {
    }

    public static FeatureCollection combine(FeatureCollection featureCollection) {
        if (featureCollection.features() != null) {
            if (featureCollection.features().size() != 0) {
                Serializable serializable;
                ArrayList<Point> arrayList = new ArrayList<Point>(0);
                ArrayList<LineString> arrayList2 = new ArrayList<LineString>(0);
                ArrayList<Polygon> arrayList3 = new ArrayList<Polygon>(0);
                Iterator<Feature> iterator2 = featureCollection.features().iterator();
                while (iterator2.hasNext()) {
                    serializable = iterator2.next().geometry();
                    boolean bl = serializable instanceof Point;
                    if (!bl && !(serializable instanceof MultiPoint)) {
                        bl = serializable instanceof LineString;
                        if (!bl && !(serializable instanceof MultiLineString)) {
                            bl = serializable instanceof Polygon;
                            if (!bl && !(serializable instanceof MultiPolygon)) continue;
                            if (bl) {
                                arrayList3.add((Polygon)serializable);
                                continue;
                            }
                            arrayList3.addAll(((MultiPolygon)serializable).polygons());
                            continue;
                        }
                        if (bl) {
                            arrayList2.add((LineString)serializable);
                            continue;
                        }
                        arrayList2.addAll(((MultiLineString)serializable).lineStrings());
                        continue;
                    }
                    if (bl) {
                        arrayList.add((Point)serializable);
                        continue;
                    }
                    arrayList.addAll((Collection<Point>)((MultiPoint)serializable).coordinates());
                }
                serializable = new ArrayList(0);
                if (!arrayList.isEmpty()) {
                    serializable.add(Feature.fromGeometry(MultiPoint.fromLngLats(arrayList)));
                }
                if (!arrayList2.isEmpty()) {
                    serializable.add(Feature.fromGeometry(MultiLineString.fromLineStrings(arrayList2)));
                }
                if (!arrayList3.isEmpty()) {
                    serializable.add(Feature.fromGeometry(MultiPolygon.fromPolygons(arrayList3)));
                }
                if (!serializable.isEmpty()) {
                    featureCollection = FeatureCollection.fromFeatures((List<Feature>)((Object)serializable));
                }
                return featureCollection;
            }
            throw new TurfException("Your FeatureCollection doesn't have any Feature objects in it.");
        }
        throw new TurfException("Your FeatureCollection is null.");
    }

    public static double convertLength(double d, String string2) {
        return TurfConversion.convertLength(d, string2, "kilometers");
    }

    public static double convertLength(double d, String string2, String string3) {
        String string4 = string3;
        if (string3 == null) {
            string4 = "kilometers";
        }
        return TurfConversion.radiansToLength(TurfConversion.lengthToRadians(d, string2), string4);
    }

    private static Feature coordsToLine(List<List<Point>> list, JsonObject jsonObject) {
        if (list.size() > 1) {
            return Feature.fromGeometry((Geometry)MultiLineString.fromLngLats(list), jsonObject);
        }
        if (list.size() == 1) {
            return Feature.fromGeometry((Geometry)LineString.fromLngLats(list.get(0)), jsonObject);
        }
        return null;
    }

    public static double degreesToRadians(double d) {
        return d % 360.0 * Math.PI / 180.0;
    }

    public static FeatureCollection explode(Feature object) {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        object = TurfMeta.coordAll((Feature)object, true).iterator();
        while (object.hasNext()) {
            arrayList.add(Feature.fromGeometry((Point)object.next()));
        }
        return FeatureCollection.fromFeatures(arrayList);
    }

    public static FeatureCollection explode(FeatureCollection object) {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        object = TurfMeta.coordAll((FeatureCollection)object, true).iterator();
        while (object.hasNext()) {
            arrayList.add(Feature.fromGeometry((Point)object.next()));
        }
        return FeatureCollection.fromFeatures(arrayList);
    }

    public static double lengthToDegrees(double d, String string2) {
        return TurfConversion.radiansToDegrees(TurfConversion.lengthToRadians(d, string2));
    }

    public static double lengthToRadians(double d) {
        return TurfConversion.lengthToRadians(d, "kilometers");
    }

    public static double lengthToRadians(double d, String string2) {
        return d / FACTORS.get(string2);
    }

    public static FeatureCollection multiPolygonToLine(Feature feature) {
        return TurfConversion.multiPolygonToLine(feature, null);
    }

    public static FeatureCollection multiPolygonToLine(Feature feature, JsonObject jsonObject) {
        Geometry geometry = feature.geometry();
        if (geometry instanceof MultiPolygon) {
            geometry = (MultiPolygon)geometry;
            if (jsonObject == null) {
                jsonObject = feature.type().equals("Feature") ? feature.properties() : new JsonObject();
            }
            return TurfConversion.polygonToLine((MultiPolygon)geometry, jsonObject);
        }
        throw new TurfException("Feature's geometry must be MultiPolygon");
    }

    public static Feature polygonToLine(Feature feature) {
        return TurfConversion.polygonToLine(feature, null);
    }

    public static Feature polygonToLine(Feature feature, JsonObject jsonObject) {
        Geometry geometry = feature.geometry();
        if (geometry instanceof Polygon) {
            geometry = (Polygon)geometry;
            if (jsonObject == null) {
                jsonObject = feature.type().equals("Feature") ? feature.properties() : new JsonObject();
            }
            return TurfConversion.polygonToLine((Polygon)geometry, jsonObject);
        }
        throw new TurfException("Feature's geometry must be Polygon");
    }

    public static Feature polygonToLine(Polygon polygon) {
        return TurfConversion.polygonToLine(polygon, null);
    }

    public static Feature polygonToLine(Polygon polygon, JsonObject jsonObject) {
        return TurfConversion.coordsToLine((List<List<Point>>)polygon.coordinates(), jsonObject);
    }

    public static FeatureCollection polygonToLine(MultiPolygon multiPolygon) {
        return TurfConversion.polygonToLine(multiPolygon, null);
    }

    public static FeatureCollection polygonToLine(MultiPolygon serializable, JsonObject jsonObject) {
        Iterator iterator2 = ((MultiPolygon)serializable).coordinates();
        serializable = new ArrayList();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            serializable.add(TurfConversion.coordsToLine((List)iterator2.next(), jsonObject));
        }
        return FeatureCollection.fromFeatures((List<Feature>)((Object)serializable));
    }

    public static double radiansToDegrees(double d) {
        return d % (Math.PI * 2) * 180.0 / Math.PI;
    }

    public static double radiansToLength(double d) {
        return TurfConversion.radiansToLength(d, "kilometers");
    }

    public static double radiansToLength(double d, String string2) {
        return d * FACTORS.get(string2);
    }
}

