/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import com.google.gson.JsonObject;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.GeoJson;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.GeometryCollection;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.MultiLineString;
import com.mapbox.geojson.MultiPoint;
import com.mapbox.geojson.MultiPolygon;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.turf.TurfConversion;
import com.mapbox.turf.TurfMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class TurfMeasurement {
    public static double EARTH_RADIUS = 6378137.0;

    private TurfMeasurement() {
        throw new AssertionError((Object)"No Instances.");
    }

    public static Point along(LineString lineString, double d, String string2) {
        return TurfMeasurement.along((List<Point>)lineString.coordinates(), d, string2);
    }

    public static Point along(List<Point> list, double d, String string2) {
        Point point;
        int n = 0;
        for (double d2 = 0.0; !(n >= list.size() || d >= d2 && n == list.size() - 1); d2 += TurfMeasurement.distance(point, list.get(++n), string2)) {
            if (d2 >= d) {
                if ((d -= d2) == 0.0) {
                    return list.get(n);
                }
                d2 = TurfMeasurement.bearing(list.get(n), list.get(n - 1));
                return TurfMeasurement.destination(list.get(n), d, d2 - 180.0, string2);
            }
            point = list.get(n);
        }
        return list.get(list.size() - 1);
    }

    public static double area(Feature feature) {
        double d = feature.geometry() != null ? TurfMeasurement.area(feature.geometry()) : 0.0;
        return d;
    }

    public static double area(FeatureCollection iterator2) {
        double d;
        iterator2 = ((FeatureCollection)((Object)iterator2)).features();
        double d2 = d = 0.0;
        if (iterator2 != null) {
            iterator2 = iterator2.iterator();
            while (true) {
                d2 = d;
                if (!iterator2.hasNext()) break;
                d += TurfMeasurement.area((Feature)iterator2.next());
            }
        }
        return d2;
    }

    public static double area(Geometry geometry) {
        return TurfMeasurement.calculateArea(geometry);
    }

    public static double[] bbox(Feature feature) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(feature, false));
    }

    public static double[] bbox(FeatureCollection featureCollection) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(featureCollection, false));
    }

    public static double[] bbox(GeoJson geoJson) {
        BoundingBox boundingBox = geoJson.bbox();
        if (boundingBox != null) {
            return new double[]{boundingBox.west(), boundingBox.south(), boundingBox.east(), boundingBox.north()};
        }
        if (geoJson instanceof Geometry) {
            return TurfMeasurement.bbox((Geometry)geoJson);
        }
        if (geoJson instanceof FeatureCollection) {
            return TurfMeasurement.bbox((FeatureCollection)geoJson);
        }
        if (geoJson instanceof Feature) {
            return TurfMeasurement.bbox((Feature)geoJson);
        }
        throw new UnsupportedOperationException("bbox type not supported for GeoJson instance");
    }

    public static double[] bbox(Geometry object) {
        if (object instanceof Point) {
            return TurfMeasurement.bbox((Point)object);
        }
        if (object instanceof MultiPoint) {
            return TurfMeasurement.bbox((MultiPoint)object);
        }
        if (object instanceof LineString) {
            return TurfMeasurement.bbox((LineString)object);
        }
        if (object instanceof MultiLineString) {
            return TurfMeasurement.bbox((MultiLineString)object);
        }
        if (object instanceof Polygon) {
            return TurfMeasurement.bbox((Polygon)object);
        }
        if (object instanceof MultiPolygon) {
            return TurfMeasurement.bbox((MultiPolygon)object);
        }
        if (object instanceof GeometryCollection) {
            ArrayList<Point> arrayList = new ArrayList<Point>();
            object = ((GeometryCollection)object).geometries().iterator();
            while (object.hasNext()) {
                double[] dArray = TurfMeasurement.bbox((Geometry)object.next());
                arrayList.add(Point.fromLngLat(dArray[0], dArray[1]));
                arrayList.add(Point.fromLngLat(dArray[2], dArray[1]));
                arrayList.add(Point.fromLngLat(dArray[2], dArray[3]));
                arrayList.add(Point.fromLngLat(dArray[0], dArray[3]));
            }
            return TurfMeasurement.bbox(MultiPoint.fromLngLats(arrayList));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown geometry class: ");
        stringBuilder.append(object.getClass());
        throw new RuntimeException(stringBuilder.toString());
    }

    public static double[] bbox(LineString lineString) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(lineString));
    }

    public static double[] bbox(MultiLineString multiLineString) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(multiLineString));
    }

    public static double[] bbox(MultiPoint multiPoint) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(multiPoint));
    }

    public static double[] bbox(MultiPolygon multiPolygon) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(multiPolygon, false));
    }

    public static double[] bbox(Point point) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(point));
    }

    public static double[] bbox(Polygon polygon) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(polygon, false));
    }

    private static double[] bboxCalculator(List<Point> object) {
        double[] dArray;
        double[] dArray2 = dArray = new double[4];
        dArray[0] = Double.POSITIVE_INFINITY;
        dArray2[1] = Double.POSITIVE_INFINITY;
        dArray2[2] = Double.NEGATIVE_INFINITY;
        dArray2[3] = Double.NEGATIVE_INFINITY;
        object = object.iterator();
        while (object.hasNext()) {
            Point point = (Point)object.next();
            if (dArray[0] > point.longitude()) {
                dArray[0] = point.longitude();
            }
            if (dArray[1] > point.latitude()) {
                dArray[1] = point.latitude();
            }
            if (dArray[2] < point.longitude()) {
                dArray[2] = point.longitude();
            }
            if (!(dArray[3] < point.latitude())) continue;
            dArray[3] = point.latitude();
        }
        return dArray;
    }

    public static Feature bboxPolygon(BoundingBox boundingBox) {
        return TurfMeasurement.bboxPolygon(boundingBox, null, null);
    }

    public static Feature bboxPolygon(BoundingBox boundingBox, JsonObject jsonObject, String string2) {
        return Feature.fromGeometry((Geometry)Polygon.fromLngLats(Collections.singletonList(Arrays.asList(Point.fromLngLat(boundingBox.west(), boundingBox.south()), Point.fromLngLat(boundingBox.east(), boundingBox.south()), Point.fromLngLat(boundingBox.east(), boundingBox.north()), Point.fromLngLat(boundingBox.west(), boundingBox.north()), Point.fromLngLat(boundingBox.west(), boundingBox.south())))), jsonObject, string2);
    }

    public static Feature bboxPolygon(double[] dArray) {
        return TurfMeasurement.bboxPolygon(dArray, null, null);
    }

    public static Feature bboxPolygon(double[] dArray, JsonObject jsonObject, String string2) {
        return Feature.fromGeometry((Geometry)Polygon.fromLngLats(Collections.singletonList(Arrays.asList(Point.fromLngLat(dArray[0], dArray[1]), Point.fromLngLat(dArray[2], dArray[1]), Point.fromLngLat(dArray[2], dArray[3]), Point.fromLngLat(dArray[0], dArray[3]), Point.fromLngLat(dArray[0], dArray[1])))), jsonObject, string2);
    }

    public static double bearing(Point point, Point point2) {
        double d = TurfConversion.degreesToRadians(point.longitude());
        double d2 = TurfConversion.degreesToRadians(point2.longitude());
        double d3 = TurfConversion.degreesToRadians(point.latitude());
        double d4 = TurfConversion.degreesToRadians(point2.latitude());
        d = d2 - d;
        return TurfConversion.radiansToDegrees(Math.atan2(Math.sin(d) * Math.cos(d4), Math.cos(d3) * Math.sin(d4) - Math.sin(d3) * Math.cos(d4) * Math.cos(d)));
    }

    private static double calculateArea(Geometry object) {
        double d;
        if (object instanceof Polygon) {
            return TurfMeasurement.polygonArea((List<List<Point>>)((Polygon)object).coordinates());
        }
        boolean bl = object instanceof MultiPolygon;
        double d2 = d = 0.0;
        if (bl) {
            object = ((MultiPolygon)object).coordinates();
            int n = 0;
            while (true) {
                d2 = d;
                if (n >= object.size()) break;
                d += TurfMeasurement.polygonArea((List)object.get(n));
                ++n;
            }
        }
        return d2;
    }

    public static Feature center(Feature feature) {
        return TurfMeasurement.center(FeatureCollection.fromFeature(feature), null, null);
    }

    public static Feature center(Feature feature, JsonObject jsonObject, String string2) {
        return TurfMeasurement.center(FeatureCollection.fromFeature(feature), jsonObject, string2);
    }

    public static Feature center(FeatureCollection featureCollection) {
        return TurfMeasurement.center(featureCollection, null, null);
    }

    public static Feature center(FeatureCollection object, JsonObject jsonObject, String string2) {
        object = TurfMeasurement.bbox((FeatureCollection)object);
        return Feature.fromGeometry((Geometry)Point.fromLngLat((double)((object[0] + object[2]) / 2.0), (double)((object[1] + object[3]) / 2.0)), jsonObject, string2);
    }

    public static Point destination(Point point, double d, double d2, String string2) {
        double d3 = TurfConversion.degreesToRadians(point.longitude());
        double d4 = TurfConversion.degreesToRadians(point.latitude());
        d2 = TurfConversion.degreesToRadians(d2);
        double d5 = TurfConversion.lengthToRadians(d, string2);
        d = Math.asin(Math.sin(d4) * Math.cos(d5) + Math.cos(d4) * Math.sin(d5) * Math.cos(d2));
        return Point.fromLngLat(TurfConversion.radiansToDegrees(d3 + Math.atan2(Math.sin(d2) * Math.sin(d5) * Math.cos(d4), Math.cos(d5) - Math.sin(d4) * Math.sin(d))), TurfConversion.radiansToDegrees(d));
    }

    public static double distance(Point point, Point point2) {
        return TurfMeasurement.distance(point, point2, "kilometers");
    }

    public static double distance(Point point, Point point2, String string2) {
        double d = TurfConversion.degreesToRadians(point2.latitude() - point.latitude());
        double d2 = TurfConversion.degreesToRadians(point2.longitude() - point.longitude());
        double d3 = TurfConversion.degreesToRadians(point.latitude());
        double d4 = TurfConversion.degreesToRadians(point2.latitude());
        d2 = Math.pow(Math.sin(d / 2.0), 2.0) + Math.pow(Math.sin(d2 / 2.0), 2.0) * Math.cos(d3) * Math.cos(d4);
        return TurfConversion.radiansToLength(Math.atan2(Math.sqrt(d2), Math.sqrt(1.0 - d2)) * 2.0, string2);
    }

    public static Polygon envelope(GeoJson geoJson) {
        return (Polygon)TurfMeasurement.bboxPolygon(TurfMeasurement.bbox(geoJson)).geometry();
    }

    public static double length(LineString lineString, String string2) {
        return TurfMeasurement.length((List<Point>)lineString.coordinates(), string2);
    }

    public static double length(MultiLineString object, String string2) {
        object = ((MultiLineString)object).coordinates().iterator();
        double d = 0.0;
        while (object.hasNext()) {
            d += TurfMeasurement.length((List)object.next(), string2);
        }
        return d;
    }

    public static double length(MultiPolygon object, String string2) {
        Iterator iterator2 = ((MultiPolygon)object).coordinates().iterator();
        double d = 0.0;
        block0: while (iterator2.hasNext()) {
            object = ((List)iterator2.next()).iterator();
            double d2 = d;
            while (true) {
                d = d2;
                if (!object.hasNext()) continue block0;
                d2 += TurfMeasurement.length((List)object.next(), string2);
            }
        }
        return d;
    }

    public static double length(Polygon object, String string2) {
        object = ((Polygon)object).coordinates().iterator();
        double d = 0.0;
        while (object.hasNext()) {
            d += TurfMeasurement.length((List)object.next(), string2);
        }
        return d;
    }

    public static double length(List<Point> list, String string2) {
        Point point = list.get(0);
        double d = 0.0;
        for (int i = 1; i < list.size(); ++i) {
            Point point2 = list.get(i);
            d += TurfMeasurement.distance(point, point2, string2);
            point = point2;
        }
        return d;
    }

    public static Point midpoint(Point point, Point point2) {
        double d = TurfMeasurement.distance(point, point2, "miles");
        double d2 = TurfMeasurement.bearing(point, point2);
        return TurfMeasurement.destination(point, d / 2.0, d2, "miles");
    }

    private static double polygonArea(List<List<Point>> list) {
        int n = list.size();
        double d = 0.0;
        if (n > 0) {
            double d2 = Math.abs(TurfMeasurement.ringArea(list.get(0)));
            n = 1;
            d2 += 0.0;
            while (true) {
                d = d2;
                if (n >= list.size()) break;
                d2 -= Math.abs(TurfMeasurement.ringArea(list.get(n)));
                ++n;
            }
        }
        return d;
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    private static double ringArea(List<Point> list) {
        double d;
        int n = list.size();
        double d2 = d = 0.0;
        if (n > 2) {
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                int n4 = n - 2;
                if (i == n4) {
                    n3 = n - 1;
                    n2 = 0;
                } else {
                    n4 = n - 1;
                    if (i == n4) {
                        n3 = 0;
                        n2 = 1;
                    } else {
                        n3 = i + 1;
                        n2 = i + 2;
                        n4 = i;
                    }
                }
                Point point = list.get(n4);
                Point point2 = list.get(n3);
                d += (TurfMeasurement.rad(list.get(n2).longitude()) - TurfMeasurement.rad(point.longitude())) * Math.sin(TurfMeasurement.rad(point2.latitude()));
            }
            d2 = EARTH_RADIUS;
            d2 = d * d2 * d2 / 2.0;
        }
        return d2;
    }

    public static BoundingBox square(BoundingBox boundingBox) {
        if (TurfMeasurement.distance(boundingBox.southwest(), Point.fromLngLat(boundingBox.east(), boundingBox.south())) >= TurfMeasurement.distance(Point.fromLngLat(boundingBox.west(), boundingBox.south()), Point.fromLngLat(boundingBox.west(), boundingBox.north()))) {
            double d = (boundingBox.south() + boundingBox.north()) / 2.0;
            return BoundingBox.fromLngLats(boundingBox.west(), d - (boundingBox.east() - boundingBox.west()) / 2.0, boundingBox.east(), d + (boundingBox.east() - boundingBox.west()) / 2.0);
        }
        double d = (boundingBox.west() + boundingBox.east()) / 2.0;
        return BoundingBox.fromLngLats(d - (boundingBox.north() - boundingBox.south()) / 2.0, boundingBox.south(), d + (boundingBox.north() - boundingBox.south()) / 2.0, boundingBox.north());
    }
}

