/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.turf.TurfMeasurement;
import java.util.ArrayList;
import java.util.List;

public final class TurfTransformation {
    private static final int DEFAULT_STEPS = 64;

    private TurfTransformation() {
    }

    public static Polygon circle(Point point, double d) {
        return TurfTransformation.circle(point, d, 64, "kilometers");
    }

    public static Polygon circle(Point serializable, double d, int n, String string2) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(TurfMeasurement.destination((Point)serializable, d, (double)i * 360.0 / (double)n, string2));
        }
        if (arrayList.size() > 0) {
            arrayList.add((Point)arrayList.get(0));
        }
        serializable = new ArrayList();
        serializable.add(arrayList);
        return Polygon.fromLngLats((List<List<Point>>)((Object)serializable));
    }

    public static Polygon circle(Point point, double d, String string2) {
        return TurfTransformation.circle(point, d, 64, string2);
    }
}

