/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson;

import com.qb.gson.Gson;
import com.qb.gson.JsonDeserializer;
import com.qb.gson.JsonElement;
import com.qb.gson.JsonSerializer;
import com.qb.gson.TypeAdapter;
import com.qb.gson.TypeAdapterFactory;
import com.qb.gson.internal.$Gson$Preconditions;
import com.qb.gson.internal.Streams;
import com.qb.gson.reflect.TypeToken;
import com.qb.gson.stream.JsonReader;
import com.qb.gson.stream.JsonWriter;
import java.io.IOException;

final class TreeTypeAdapter<T>
extends TypeAdapter<T> {
    private TypeAdapter<T> delegate;
    private final JsonDeserializer<T> deserializer;
    private final Gson gson;
    private final JsonSerializer<T> serializer;
    private final TypeAdapterFactory skipPast;
    private final TypeToken<T> typeToken;

    private TreeTypeAdapter(JsonSerializer<T> jsonSerializer, JsonDeserializer<T> jsonDeserializer, Gson gson, TypeToken<T> typeToken, TypeAdapterFactory typeAdapterFactory) {
        this.serializer = jsonSerializer;
        this.deserializer = jsonDeserializer;
        this.gson = gson;
        this.typeToken = typeToken;
        this.skipPast = typeAdapterFactory;
    }

    private TypeAdapter<T> delegate() {
        TypeAdapter<T> typeAdapter = this.delegate;
        if (typeAdapter == null) {
            this.delegate = typeAdapter = this.gson.getDelegateAdapter(this.skipPast, this.typeToken);
        }
        return typeAdapter;
    }

    public static TypeAdapterFactory newFactory(TypeToken<?> typeToken, Object object) {
        return new SingleTypeFactory(object, typeToken, false, null);
    }

    public static TypeAdapterFactory newFactoryWithMatchRawType(TypeToken<?> typeToken, Object object) {
        boolean bl = typeToken.getType() == typeToken.getRawType();
        return new SingleTypeFactory(object, typeToken, bl, null);
    }

    public static TypeAdapterFactory newTypeHierarchyFactory(Class<?> clazz, Object object) {
        return new SingleTypeFactory(object, null, false, clazz);
    }

    @Override
    public T read(JsonReader object) throws IOException {
        if (this.deserializer == null) {
            return this.delegate().read((JsonReader)object);
        }
        if (((JsonElement)(object = Streams.parse((JsonReader)object))).isJsonNull()) {
            return null;
        }
        return this.deserializer.deserialize((JsonElement)object, this.typeToken.getType(), this.gson.deserializationContext);
    }

    @Override
    public void write(JsonWriter jsonWriter, T t) throws IOException {
        JsonSerializer<T> jsonSerializer = this.serializer;
        if (jsonSerializer == null) {
            this.delegate().write(jsonWriter, t);
            return;
        }
        if (t == null) {
            jsonWriter.nullValue();
            return;
        }
        Streams.write(jsonSerializer.serialize(t, this.typeToken.getType(), this.gson.serializationContext), jsonWriter);
    }

    private static class SingleTypeFactory
    implements TypeAdapterFactory {
        private final JsonDeserializer<?> deserializer;
        private final TypeToken<?> exactType;
        private final Class<?> hierarchyType;
        private final boolean matchRawType;
        private final JsonSerializer<?> serializer;

        private SingleTypeFactory(Object object, TypeToken<?> typeToken, boolean bl, Class<?> clazz) {
            boolean bl2 = object instanceof JsonSerializer;
            JsonDeserializer jsonDeserializer = null;
            JsonSerializer jsonSerializer = bl2 ? (JsonSerializer)object : null;
            this.serializer = jsonSerializer;
            if (object instanceof JsonDeserializer) {
                jsonDeserializer = (JsonDeserializer)object;
            }
            this.deserializer = jsonDeserializer;
            bl2 = jsonSerializer != null || jsonDeserializer != null;
            $Gson$Preconditions.checkArgument(bl2);
            this.exactType = typeToken;
            this.matchRawType = bl;
            this.hierarchyType = clazz;
        }

        @Override
        public <T> TypeAdapter<T> create(Gson treeTypeAdapter, TypeToken<T> typeToken) {
            TypeToken<?> typeToken2 = this.exactType;
            boolean bl = typeToken2 != null ? typeToken2.equals(typeToken) || this.matchRawType && this.exactType.getType() == typeToken.getRawType() : this.hierarchyType.isAssignableFrom(typeToken.getRawType());
            treeTypeAdapter = bl ? new TreeTypeAdapter(this.serializer, this.deserializer, (Gson)((Object)treeTypeAdapter), typeToken, this) : null;
            return treeTypeAdapter;
        }
    }
}

